/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.Rights;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.NDSObjectAttribute;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.JobData;
import com.novell.emframe.dev.Move;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.TargetObjects;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.nps.gadgetManager.GadgetInstance;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.ArrayList;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;

public class MoveObjectTask
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String HTMLPARAM_FORMNAME = "MoveObjectForm";
    public static final String HTMLPARAM_NEWCONTEXT = "MoveObjectContext";
    public static final String HTMLPARAM_SRCOBJECT = "MoveObjectName";
    public static final String HTMLPARAM_ENABLECREATEALIAS = "EnableCreateAlias";
    public static final String STR_TARGETOBJECT = "objectTypeName";
    public static final String STR_TARGETOBJECTDISPNAME = "objectTypeNameForDisplay";
    public static final String STR_TARGETOBJECTGIFNAME = "objectTypeNameForGif";
    public static final String HTMLPARAM_GIFNAME = "GifName";
    public static final String HTMLPARAM_TRANSLATEDCLASS = "TranslatedClass";
    private static final String ALIAS_CLASS_NAME = "Alias";
    private static final String OBJECT_CLASS_ATTR_NAME = "Object Class";
    private static final String ALIAS_ATTR_NAME = "Aliased Object Name";
    ArrayList m_errors = new ArrayList();
    private String m_srcObject = null;
    private String m_newContext = null;
    private String m_createAlias = null;
    private boolean m_createAliasFailed = false;
    private int m_totalObjects = 0;
    private MoveThread thread;
    private boolean stopThread;
    private boolean threadDone;
    private boolean m_err = false;
    private String mainProgressMessage = "";
    private String alreadyMessage = "";
    private String abortMessage = "";
    String m_targetObjectDispName = null;
    String m_targetObjectGifName = null;
    Vector m_objectVector = null;
    TaskContext context;
    Properties resultStrings;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        D.log("MoveObjectTask::execute start");
        HttpServletRequest req = context.getRequest();
        String nextState = req.getParameter("nextState");
        D.log("nextState = " + nextState);
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            this.m_objectVector = this.getTargetObjects(req, context, resultStrings);
            String[] targetObjArray = this.m_objectVector.toArray(new String[this.m_objectVector.size()]);
            eMFrameUtils.setupTargetChooser(targetObjArray, context);
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doMoveObject")) {
            D.log("doMoveObject");
            this.m_srcObject = req.getParameter(HTMLPARAM_SRCOBJECT);
            this.m_newContext = req.getParameter(HTMLPARAM_NEWCONTEXT);
            this.m_createAlias = req.getParameter(HTMLPARAM_ENABLECREATEALIAS);
            this.setupProgress(context, resultStrings);
            return true;
        }
        if (nextState.equalsIgnoreCase("refresh")) {
            return this.refresh(context, resultStrings);
        }
        if (nextState.equalsIgnoreCase("cancel")) {
            return this.cancel(context, resultStrings);
        }
        if (nextState.equalsIgnoreCase("error")) {
            return this.error(context, resultStrings);
        }
        D.log("Task received invalid state " + nextState);
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        try {
            AuthenticationBroker broker = this.context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            AdminNamespace namespace = treeOE.getAdminNamespace();
            if (namespace.isSupported("NVDS")) {
                this.resultStrings.put("aliasCreation", "false");
            }
        }
        catch (AuthBrokerException e) {
            D.log(e.getMessage());
        }
        catch (SPIException e) {
            D.log(e.getMessage());
        }
        catch (NamespaceException e) {
            D.log(e.getMessage());
        }
        return true;
    }

    private boolean doMoveObject(TaskContext context, Properties resultStrings, String strContext, String strObjectName, String enableCreateAlias) {
        boolean err = false;
        boolean success = false;
        ObjectEntry srcObjectOE = null;
        AdminNamespace adminns = null;
        ObjectEntryEnumeration objEnum = null;
        this.m_errors.clear();
        this.m_totalObjects = 0;
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace namespace = treeOE.getAdminNamespace();
        D.log("MoveObjectTask: Moving: Name: " + strObjectName + ", To Context: " + strContext);
        ObjectEntry destOE = null;
        try {
            destOE = namespace.getObjectEntry(treeOE, strContext);
            context.addToHistory(destOE);
            Rights objRights = namespace.getObjectEffectiveRights(destOE, namespace.getAuthenticatedIdentity(treeOE));
            if (!objRights.hasAddRights()) {
                String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", context);
                String strBody = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.InsufficientRights", context), new String[]{strContext});
                this.m_errors.add(new String[]{strContext, strTitle, strBody, ""});
                eMFrameUtils.setMooErrorMessage(resultStrings, strTitle, strBody, this.m_errors);
                return false;
            }
            TargetObjects objTargets = new TargetObjects(strObjectName, context);
            Exception[] errors = objTargets.getErrors();
            String[] badObjects = objTargets.getBadObjectNames();
            if (badObjects != null && errors != null) {
                for (int badcount = 0; badcount < badObjects.length; ++badcount) {
                    if (errors == null || errors.length <= 0) continue;
                    D.log(errors[badcount]);
                    err = true;
                    String errUrl = null;
                    if (errors[badcount] instanceof UniqueSPIException) {
                        errUrl = FwUtils.getUniqueSPIMessage((UniqueSPIException)errors[badcount]) + ".htm";
                    }
                    this.m_errors.add(new String[]{badObjects[badcount], eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.NotFound", context), new String[]{badObjects[badcount]}), errUrl});
                }
            }
            if (objTargets.getCount() > 0) {
                if (objTargets.isMultiple()) {
                    objEnum = objTargets.getObjectEntryEnumeration();
                    if (objEnum.hasMoreElements()) {
                        srcObjectOE = (ObjectEntry)objEnum.nextElement();
                    }
                } else {
                    srcObjectOE = objTargets.getObjectEntry();
                }
            } else {
                err = true;
            }
        }
        catch (SPIException e) {
            D.log(e);
            String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", context);
            String strBody = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.ContainerNotFound", context), new String[]{strContext});
            String errUrl = "";
            if (e instanceof UniqueSPIException) {
                errUrl = FwUtils.getUniqueSPIMessage((UniqueSPIException)e) + ".htm";
            }
            this.m_errors.add(new String[]{strContext, strTitle, strBody, errUrl});
            eMFrameUtils.setMooErrorMessage(resultStrings, strTitle, strBody, this.m_errors);
            return false;
        }
        catch (PluginException je) {
            D.log(je);
            return false;
        }
        catch (Exception je) {
            D.log(je);
            return false;
        }
        while (srcObjectOE != null && !this.stopThread) {
            ObjectEntry nextObjectOE;
            block30: {
                String strException;
                String fullObjectName = srcObjectOE.getFullName();
                nextObjectOE = this.getNextEntry(objEnum);
                try {
                    adminns = (AdminNamespace)srcObjectOE.getObjectType().getNamespace();
                    ClassDefinition cd = adminns.getClassDefinition(srcObjectOE, srcObjectOE.getObjectType().getName());
                    if (!cd.canBeContainedBy(destOE.getObjectType().getName())) {
                        err = true;
                        this.m_errors.add(new String[]{fullObjectName, eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.NotContainment", context), new String[]{fullObjectName}), ""});
                        srcObjectOE = nextObjectOE;
                        continue;
                    }
                    if (srcObjectOE.getObjectType().isContainer()) {
                        err = true;
                        this.m_errors.add(new String[]{fullObjectName, eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.CannotMovePartition", context), new String[]{fullObjectName}), ""});
                        srcObjectOE = nextObjectOE;
                        continue;
                    }
                    success = this.moveIfRegistered(context, srcObjectOE, destOE);
                    if (success) break block30;
                    success = DirUtils.MoveObject(srcObjectOE, destOE, false);
                }
                catch (NamespaceException e) {
                    err = true;
                    D.log(e);
                    strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), context);
                    this.m_errors.add(new String[]{fullObjectName, eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", context), strException, ""});
                    srcObjectOE = nextObjectOE;
                    continue;
                }
                catch (SPIException e) {
                    err = true;
                    strException = null;
                    String errUrl = "";
                    if (e instanceof UniqueSPIException) {
                        strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), context);
                        errUrl = FwUtils.getUniqueSPIMessage((UniqueSPIException)e) + ".htm";
                    } else {
                        strException = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.InvalidTargetObject", context);
                    }
                    this.m_errors.add(new String[]{fullObjectName, eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", context), strException, errUrl});
                    srcObjectOE = nextObjectOE;
                    continue;
                }
                catch (SnapinVetoException e) {
                    err = true;
                    D.log(e);
                    strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), context);
                    this.m_errors.add(new String[]{fullObjectName, eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", context), strException, ""});
                    srcObjectOE = nextObjectOE;
                    continue;
                }
                catch (ClassNotFoundException e) {
                    err = true;
                    D.log(e);
                    strException = "Wrong package name is being used in move.xml!!!";
                    this.m_errors.add(new String[]{fullObjectName, eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", context), strException, ""});
                    srcObjectOE = nextObjectOE;
                    continue;
                }
                catch (PluginException e) {
                    err = true;
                    D.log(e);
                    strException = e.getHeader() + ":" + e.getBody();
                    this.m_errors.add(new String[]{fullObjectName, eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", context), strException, ""});
                    srcObjectOE = nextObjectOE;
                    continue;
                }
            }
            String strNewObject = srcObjectOE.getName() + "." + destOE.getFullName();
            ++this.m_totalObjects;
            context.addToHistory(srcObjectOE.getObjectType().getName(), srcObjectOE.getName() + "." + namespace.getUnrootedName(destOE));
            context.removeFromHistory(namespace.getUnrootedName(srcObjectOE));
            JobData data = JobData.getJobData((GadgetInstance)this);
            if (null != data) {
                data.setObjectNames(new String[]{srcObjectOE.getName() + "." + namespace.getUnrootedName(destOE)});
            }
            if (null != enableCreateAlias && !this.createAlias(context, strNewObject, srcObjectOE, adminns)) {
                this.m_createAliasFailed = true;
            }
            srcObjectOE = nextObjectOE;
        }
        if (err || !success) {
            return false;
        }
        D.log("MoveObjectTask::Move Object succeeded");
        return true;
    }

    private ObjectEntry getNextEntry(ObjectEntryEnumeration objEnum) {
        ObjectEntry oeNext = null;
        if (objEnum != null) {
            try {
                oeNext = (ObjectEntry)objEnum.nextElement();
            }
            catch (Throwable e) {
                oeNext = null;
            }
        }
        return oeNext;
    }

    private boolean moveIfRegistered(TaskContext context, ObjectEntry srcOE, ObjectEntry destOE) throws ClassNotFoundException, PluginException {
        String objectClass = srcOE.getObjectType().getName();
        String oeFullName = srcOE.getFullName();
        try {
            Document moveDoc = GlobalRegistry.getMoveDoc(objectClass);
            if (moveDoc != null) {
                String moveClass = eMFrameUtils.getClassName(moveDoc);
                Move newMove = new Move();
                Class<?> c = Class.forName(moveClass);
                newMove = (Move)c.newInstance();
                newMove.doMove(srcOE, destOE, context);
                D.log("This object type is registered in move.xml : " + oeFullName + "(" + srcOE.getObjectType().getName() + ")");
                return true;
            }
            D.log("No registration found for moving the selected object type: " + srcOE.getObjectType().getName());
            return false;
        }
        catch (InstantiationException e) {
            D.log(e);
            return false;
        }
        catch (IllegalAccessException e) {
            D.log(e);
            return false;
        }
    }

    private boolean createAlias(TaskContext context, String newObjectName, ObjectEntry oldOE, AdminNamespace adminns) {
        ObjectEntry newOE = null;
        NDSNamespace ns = null;
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
            ns = (NDSNamespace)treeOE.getNamespace();
            this.moveSetAccessConfidence(ns, 2);
            newOE = ns.getObjectEntry(newObjectName);
            ValueComponent aliasNameVal = NDSSyntax.SYN_CLASS_NAME.createValueComponent((Object)ALIAS_CLASS_NAME);
            ValueComponent[] aliasNameVals = new ValueComponent[]{aliasNameVal};
            NDSObjectAttribute objClassAttr = new NDSObjectAttribute(ns.getAttributeDefinition(newOE, OBJECT_CLASS_ATTR_NAME), aliasNameVals);
            ValueComponent distNameVal = NDSSyntax.SYN_DIST_NAME.createValueComponent((Object)ns.getUnrootedName(newOE));
            ValueComponent[] distNameVals = new ValueComponent[]{distNameVal};
            NDSObjectAttribute aliasNameAttr = new NDSObjectAttribute(ns.getAttributeDefinition(newOE, ALIAS_ATTR_NAME), distNameVals);
            Vector<NDSObjectAttribute> attrNDSOV = new Vector<NDSObjectAttribute>();
            attrNDSOV.addElement(aliasNameAttr);
            attrNDSOV.addElement(objClassAttr);
            ObjectEntry aliasObjectEntry = ns.createObjectEntry(oldOE.getParent(), oldOE.getName(), ALIAS_CLASS_NAME);
            NSObject aliasObj = adminns.createNSObject(aliasObjectEntry, attrNDSOV);
            ns.create(aliasObj);
            this.moveSetAccessConfidence(ns, 1);
        }
        catch (SPIException e) {
            this.moveSetAccessConfidence(ns, 1);
            D.log(e);
            return false;
        }
        catch (SnapinVetoException e) {
            this.moveSetAccessConfidence(ns, 1);
            D.log(e);
            return false;
        }
        catch (ComponentCreationException e) {
            this.moveSetAccessConfidence(ns, 1);
            D.log(e);
            return false;
        }
        catch (NamespaceException e) {
            this.moveSetAccessConfidence(ns, 1);
            D.log(e);
            return false;
        }
        return true;
    }

    public Vector getTargetObjects(HttpServletRequest req, TaskContext context, Properties resultStrings) {
        Vector<String> validObjects = new Vector<String>(5);
        String targetObjects = req.getParameter(STR_TARGETOBJECT);
        this.m_targetObjectDispName = req.getParameter(STR_TARGETOBJECTDISPNAME);
        this.m_targetObjectGifName = req.getParameter(STR_TARGETOBJECTGIFNAME);
        D.log("Moving-------------" + targetObjects);
        if (targetObjects != null) {
            StringTokenizer st = new StringTokenizer(targetObjects, ",");
            String strObject = null;
            while (st.hasMoreTokens()) {
                strObject = st.nextToken();
                validObjects.addElement(strObject);
            }
        }
        String gifName = "object16.gif";
        String translatedClass = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Objects", context);
        if (validObjects.size() == 1 && !validObjects.firstElement().equals("*")) {
            gifName = context.getDirUtils().getObjectTypeImageName((String)validObjects.firstElement());
            translatedClass = context.getDirUtils().getObjectTypeDisplayName((String)validObjects.firstElement(), context);
        } else if (validObjects.contains("Group")) {
            gifName = context.getDirUtils().getObjectTypeImageName((String)validObjects.firstElement());
            translatedClass = context.getDirUtils().getObjectTypeDisplayName((String)validObjects.firstElement(), context);
        }
        resultStrings.put(HTMLPARAM_TRANSLATEDCLASS, translatedClass);
        resultStrings.put(HTMLPARAM_GIFNAME, gifName);
        return validObjects;
    }

    private void moveSetAccessConfidence(NDSNamespace ns, int flag) {
        try {
            ns.setAccessConfidence(flag);
        }
        catch (SPIException e) {
            D.log("##### Move Object has set the access level to Master.  you may need to relogin!");
            D.log(e);
        }
        catch (NamespaceException e) {
            D.log("##### Move Object has set the access level to Master.  you may need to relogin!");
            D.log(e);
        }
    }

    private void setupProgress(TaskContext context, Properties resultStrings) {
        HttpServletRequest req = context.getRequest();
        this.mainProgressMessage = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.MovingObjects", context);
        this.abortMessage = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.ToStop", context);
        this.alreadyMessage = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.ObjectsMoved", context);
        String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(req.getParameter("taskId"), context) + "&merge=fw.GenericProgress&User.context=" + req.getParameter("User.context") + "&nextState=refresh&progressCount=" + this.m_totalObjects + "&mainProgressMessage=" + this.mainProgressMessage + "&alreadyMessage=" + this.alreadyMessage + "&abortMessage=" + this.abortMessage);
        resultStrings.put("UrlTask.url", url);
        ((I18NServletRequest)req).setParameter("merge", "fw.UrlTask");
        this.stopThread = false;
        this.threadDone = false;
        this.thread = new MoveThread(context, resultStrings);
        this.thread.start();
    }

    private boolean refresh(TaskContext context, Properties resultStrings) {
        HttpServletRequest req = context.getRequest();
        String taskId = req.getParameter("taskId");
        String userContext = req.getParameter("User.context");
        D.log("refresh state");
        if (!this.threadDone) {
            resultStrings.put("progressCount", new Long(this.m_totalObjects).toString());
            resultStrings.put("mainProgressMessage", this.mainProgressMessage);
            resultStrings.put("alreadyMessage", this.alreadyMessage);
            resultStrings.put("abortMessage", this.abortMessage);
        } else {
            String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, context) + "&User.context=" + userContext + "&nextState=error");
            url = this.m_err ? (this.m_totalObjects == 0 && this.m_errors.isEmpty() ? url + "&merge=dev.GenErr&GeneralMsg.Mode=error" : url + "&merge=dev.MooGenErr&GeneralMsg.Mode=error") : url + "&merge=dev.GenMsg&GeneralMsg.Mode=success&dev.refreshOV=true";
            if (this.m_totalObjects + this.m_errors.size() >= 7000) {
                url = url + "&GeneralMsg.countWarning=true";
            }
            resultStrings.put("UrlTask.url", url);
            ((I18NServletRequest)req).setParameter("merge", "fw.UrlTask");
        }
        return true;
    }

    private boolean cancel(TaskContext context, Properties resultStrings) {
        HttpServletRequest req = context.getRequest();
        D.log("cancel state");
        String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(req.getParameter("taskId"), context) + "&merge=fw.MoveObject&User.context=" + req.getParameter("User.context") + "&nextState=" + "initialState");
        resultStrings.put("UrlTask.url", url);
        ((I18NServletRequest)req).setParameter("merge", "fw.UrlTask");
        this.stopThread = true;
        return true;
    }

    private boolean error(TaskContext context, Properties resultStrings) {
        D.log("error state");
        if (this.m_err) {
            String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Failure", context);
            String strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.ErrorForObject", context);
            if (this.m_createAliasFailed) {
                strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.ErrorForObjectAliasErr", context);
            }
            if (this.m_totalObjects == 0 && this.m_errors.isEmpty()) {
                eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.ErrorNoObjectsFound", context), context);
            } else {
                eMFrameUtils.setMooErrorMessage(resultStrings, strTitle, eMFrameUtils.formatMessage(strBody, new String[]{Integer.toString(this.m_totalObjects)}), this.m_errors);
            }
        } else {
            String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.Success", context);
            String strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.SuccessForObject", context);
            if (this.m_createAliasFailed) {
                strBody = eMFrameUtils.getLocalizedString("BaseResources", "MoveObject.SuccessForObjectAliasErr", context);
            }
            eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{Integer.toString(this.m_totalObjects)}), context);
        }
        return true;
    }

    private void startMoving(TaskContext context, Properties resultStrings) {
        if (!this.stopThread) {
            this.m_err = !this.doMoveObject(context, resultStrings, this.m_newContext, this.m_srcObject, this.m_createAlias);
        }
    }

    class MoveThread
    extends Thread {
        TaskContext m_context;
        Properties m_resultStrings;

        public MoveThread(TaskContext context, Properties resultStrings) {
            this.m_context = context;
            this.m_resultStrings = resultStrings;
            this.setPriority(4);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            MoveObjectTask.this.startMoving(this.m_context, this.m_resultStrings);
            MoveObjectTask.this.threadDone = true;
        }
    }
}

