/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AdvSelTypeInfo;
import com.novell.emframe.dev.AdvSelTypeInfoCallback;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.fw.FwConsts;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Hashtable;

public class NDSTypeInfoCallback
extends AdvSelTypeInfoCallback {
    private HashSet m_attribSyntaxPairs = null;
    private Hashtable m_syntaxOps = new Hashtable();
    private boolean m_bIsKepler = false;
    private static final String[] m_NDSdefaultOps = FwConsts.AS_NDS_defaultOps;
    private static final String[] m_NDSintegerOps = FwConsts.AS_NDS_integerOps;
    private static final String[] m_NDSbooleanOps = FwConsts.AS_NDS_booleanOps;
    private static final String[] m_NDSpresentOps = FwConsts.AS_NDS_presentOps;
    private static final String[] m_NVDSdefaultOps = FwConsts.AS_NVDS_defaultOps;
    private static final String[] m_NVDSintegerOps = FwConsts.AS_NVDS_integerOps;
    private static final String[] m_NVDSbooleanOps = FwConsts.AS_NVDS_booleanOps;
    private static final String[] m_useDefaultOps = new String[0];
    private static final String[] m_booleanValues = new String[]{"True", "False"};

    public NDSTypeInfoCallback() {
        this.m_syntaxOps.put(NDSSyntax.SYN_CE_STRING.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_CI_STRING.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_CLASS_NAME.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_DIST_NAME.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_NU_STRING.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_PR_STRING.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_COUNTER.getName(), m_NDSintegerOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_INTEGER.getName(), m_NDSintegerOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_INTERVAL.getName(), m_NDSintegerOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_BOOLEAN.getName(), m_NDSbooleanOps);
        this.m_syntaxOps.put(NDSSyntax.SYN_PATH.getName(), m_NDSpresentOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_CI_STRING.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_CLASS_NAME.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_COUNTRY_STRING.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_DN.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_DIRECTORY_STRING.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_DSE_CLASS_NAME.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_IA5_STRING.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_NUMERIC_STRING.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_OID.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_PRINTABLE_STRING.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_TELEPHONE_NUMBER.getName(), m_useDefaultOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_COUNTER.getName(), m_NVDSintegerOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_INTEGER.getName(), m_NVDSintegerOps);
        this.m_syntaxOps.put(LDAPSyntax.SYN_BOOLEAN.getName(), m_NVDSbooleanOps);
    }

    @Override
    public AdvSelTypeInfo getInfo(TaskContext context, String[] types, String[] auxTypes) {
        AdvSelTypeInfo typeInfo = new AdvSelTypeInfo(m_NDSdefaultOps);
        try {
            int i;
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry oeRoot = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            AdminNamespace ns = (AdminNamespace)oeRoot.getNamespace();
            this.m_bIsKepler = ns instanceof LDAPNamespace;
            if (this.m_bIsKepler) {
                typeInfo = new AdvSelTypeInfo(m_NVDSdefaultOps);
            }
            this.m_attribSyntaxPairs = null;
            for (i = 0; i < types.length; ++i) {
                if (types[i].equals("*")) {
                    AttributeDefinition[] ad = ns.getSchemaDefinition(oeRoot).getAttributeDefinitions();
                    this.getAllAttributes(ad);
                    continue;
                }
                this.getTypeAttributes(ns.getClassDefinition(oeRoot, types[i]));
            }
            if (auxTypes != null) {
                for (i = 0; i < auxTypes.length; ++i) {
                    if (auxTypes[i] == null || auxTypes[i].length() <= 0) continue;
                    this.getAuxTypeAttributes(ns.getClassDefinition(oeRoot, auxTypes[i]));
                }
            }
            SchemaDefinition schemaDef = ns.getSchemaDefinition(oeRoot);
            String[] auxClasses = this.getAuxClasses(schemaDef);
            typeInfo.addAuxClasses(auxClasses);
        }
        catch (Exception e) {
            D.log("NDSTypeInfoCallback.getInfo: exception getting schema class definitions. e = " + e.toString());
            return null;
        }
        if (this.m_attribSyntaxPairs != null && this.m_syntaxOps != null) {
            AttribInfo ai2 = null;
            String attribId = null;
            String attribSyntaxId = this.m_bIsKepler ? LDAPSyntax.SYN_UNKNOWN.getName() : NDSSyntax.SYN_UNKNOWN.getName();
            String booleanSyntaxId = this.m_bIsKepler ? LDAPSyntax.SYN_BOOLEAN.getName() : NDSSyntax.SYN_BOOLEAN.getName();
            for (AttribInfo ai2 : this.m_attribSyntaxPairs) {
                if (ai2 == null) continue;
                attribId = ai2.getId();
                attribSyntaxId = ai2.getSyntaxId();
                if (attribSyntaxId != null) {
                    String[] ops = (String[])this.m_syntaxOps.get(attribSyntaxId);
                    if (ops != null && ops.length == 0) {
                        ops = null;
                    }
                    if (attribSyntaxId.equalsIgnoreCase(booleanSyntaxId)) {
                        typeInfo.addAttribute(attribId, ops, m_booleanValues);
                        continue;
                    }
                    typeInfo.addAttribute(attribId, ops);
                    continue;
                }
                D.log("getInfo:  skipping attrib=" + attribId + ". syntax is null...");
            }
        }
        return typeInfo;
    }

    private String[] getAuxClasses(SchemaDefinition sd) {
        ArrayList<String> auxClasses = new ArrayList<String>();
        ClassDefinition[] auxClassDefs = sd.getClassDefinitions();
        for (int i = 0; i < auxClassDefs.length; ++i) {
            if (!auxClassDefs[i].isAuxiliary()) continue;
            auxClasses.add(auxClassDefs[i].getName());
        }
        Collections.sort(auxClasses);
        return auxClasses.toArray(new String[auxClasses.size()]);
    }

    private void getAllAttributes(AttributeDefinition[] ad) {
        if (ad != null) {
            HashSet hsTmp = new HashSet();
            this.getNameSyntaxPairs(ad, hsTmp);
            if (this.m_attribSyntaxPairs == null) {
                this.m_attribSyntaxPairs = hsTmp;
            } else {
                this.m_attribSyntaxPairs.addAll(hsTmp);
            }
        }
    }

    private void getTypeAttributes(ClassDefinition cd) {
        HashSet hsTmp = new HashSet();
        this.getNameSyntaxPairs(cd.getMandatoryAttributes(), hsTmp);
        this.getNameSyntaxPairs(cd.getNamingAttributes(), hsTmp);
        this.getNameSyntaxPairs(cd.getOptionalAttributes(), hsTmp);
        if (this.m_attribSyntaxPairs == null) {
            this.m_attribSyntaxPairs = hsTmp;
        } else {
            this.m_attribSyntaxPairs.retainAll(hsTmp);
        }
    }

    private void getAuxTypeAttributes(ClassDefinition cd) {
        this.getNameSyntaxPairs(cd.getMandatoryAttributes(), this.m_attribSyntaxPairs);
        this.getNameSyntaxPairs(cd.getNamingAttributes(), this.m_attribSyntaxPairs);
        this.getNameSyntaxPairs(cd.getOptionalAttributes(), this.m_attribSyntaxPairs);
    }

    private void getNameSyntaxPairs(AttributeDefinition[] ad, HashSet hsAttribPairs) {
        if (ad != null && hsAttribPairs != null) {
            String attrib = null;
            String syntaxId = this.m_bIsKepler ? LDAPSyntax.SYN_UNKNOWN.getName() : NDSSyntax.SYN_UNKNOWN.getName();
            for (int i = 0; i < ad.length; ++i) {
                try {
                    attrib = ad[i].getName();
                    if (attrib == null || attrib.length() <= 0 || (syntaxId = ad[i].getSyntax().getName()) == null || this.m_syntaxOps.get(syntaxId) == null) continue;
                    hsAttribPairs.add(new AttribInfo(attrib, syntaxId));
                    continue;
                }
                catch (Exception e) {
                    D.log("NDSTypeInfoCallback.getNameSyntaxPairs: exception getting attribute name/syntax. e = " + e.toString());
                }
            }
        }
    }

    private class AttribInfo {
        private String m_attribId;
        private String m_attribSyntaxId;

        public AttribInfo(String attribName, String attribSyntaxId) {
            this.m_attribId = attribName == null ? "" : attribName;
            this.m_attribSyntaxId = attribSyntaxId == null ? "" : attribSyntaxId;
        }

        public String getId() {
            return this.m_attribId;
        }

        public String getSyntaxId() {
            return this.m_attribSyntaxId;
        }

        public int hashCode() {
            return this.m_attribId.hashCode();
        }

        public boolean equals(Object obj) {
            return obj != null && obj instanceof AttribInfo && this.m_attribId.equalsIgnoreCase(((AttribInfo)obj).m_attribId) && this.m_attribSyntaxId.equalsIgnoreCase(((AttribInfo)obj).m_attribSyntaxId);
        }
    }
}

