/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RoleList;
import com.novell.emframe.fw.util.infos.CategoryInfo;
import com.novell.emframe.fw.util.infos.RoleInfo;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;

public class NavTask
extends MTask {
    @Override
    public void execute(MContext context) {
        HttpServletRequest req = context.getRequest();
        String view = req.getParameter("view");
        if (view != null && view.equals("Tasks")) {
            this.doBuildCategoryList(context);
        }
    }

    private boolean doBuildCategoryList(MContext context) {
        Map mapCategories = this.getSortedCategoriesFromRBS(context);
        HttpServletRequest req = context.getRequest();
        ArrayList<CategoryInfo> categories = new ArrayList<CategoryInfo>();
        if (mapCategories.size() > 0) {
            CategoryInfo category = new CategoryInfo("All", eMFrameUtils.getLocalizedString("FwResources", "CRT.Launch.AllCategories", context));
            categories.add(category);
        }
        for (String sCatId : mapCategories.keySet()) {
            String sDisplayName = (String)mapCategories.get(sCatId);
            CategoryInfo category = new CategoryInfo(sCatId, sDisplayName);
            categories.add(category);
            D.log("Found category <" + sCatId + ">");
        }
        req.setAttribute("CRTCategories", categories);
        req.setAttribute("categoryCount", (Object)new Integer(categories.size()));
        return true;
    }

    private Map getSortedCategoriesFromRBS(MContext context) {
        LinkedHashMap lhmCategories = new LinkedHashMap();
        RoleList roleList = RoleList.getInstance(context);
        if (roleList != null) {
            Iterator iterRoleInfos = roleList.getRoles();
            while (iterRoleInfos.hasNext()) {
                RoleInfo roleInfo = (RoleInfo)iterRoleInfos.next();
                lhmCategories.putAll(roleInfo.getCategoryDisplayNamesByIdMap());
            }
        }
        FwUtils.sortLinkedHashMapByValue(lhmCategories, null);
        return lhmCategories;
    }
}

