/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.nps.gadgetManager.BaseGadgetInstance;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.nps.gadgetManager.ResourceSetMap;
import com.novell.nps.gadgetManager.StylesheetSet;
import com.novell.nps.gadgetManager.StylesheetSetMap;
import java.io.BufferedWriter;
import java.io.IOException;
import java.util.List;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class NetWareServiceLauncher
extends BaseGadgetInstance {
    private static final long serialVersionUID = 1L;
    private static final String ROOT_CLASS_TAG = "com.novell.emframe.fw.NetWareServiceLauncher";
    private static final String DT = "NetWareServiceLauncher";
    private Document doc = null;
    private String serverAddress = null;

    public void getData(HttpServletRequest req, BufferedWriter out, org.w3c.dom.Document domTree) throws GadgetInstanceException {
        if (this.doc == null) {
            MContext m_context = FwUtils.getMContext(req);
            String taskId = this.getGadgetInstanceID();
            this.doc = FwUtils.getTaskDocument(m_context, taskId);
        }
        try {
            XmlUtils.writeStartTag(ROOT_CLASS_TAG, out);
            if (this.doc != null) {
                Element baseEl = this.doc.getRootElement().getChild("rbs-xml-info").getChild("SERVICE");
                Element taskEl = baseEl.getChild("ProductInfo");
                if (taskEl != null) {
                    XmlUtils.writeCDataTag("ProductName", taskEl.getChildText("Name"), out);
                    XmlUtils.writeCDataTag("serviceInfoLink", taskEl.getChildText("InformationLink"), out);
                    XmlUtils.writeCDataTag("serviceIcon", taskEl.getChildText("Icon"), out);
                }
                taskEl = null;
                taskEl = baseEl.getChild("WebLink");
                if (taskEl != null) {
                    String CustomFormParams;
                    String formMethod;
                    int slashPos;
                    XmlUtils.writeCDataTag("wlUrlDesc", taskEl.getChildText("URLDescriptor"), out);
                    String isBasicAuth = taskEl.getChildText("RequestType");
                    XmlUtils.writeTag("RequestType", isBasicAuth, out);
                    this.serverAddress = taskEl.getChildText("ServerAddress");
                    String URLStr = taskEl.getChildText("URL");
                    if (URLStr != null && URLStr.substring(0, 1).equalsIgnoreCase("/")) {
                        URLStr = "https://%*serverip%:2200" + URLStr;
                    }
                    if (isBasicAuth != null && (isBasicAuth.equalsIgnoreCase("true") || isBasicAuth.equalsIgnoreCase("1")) && (slashPos = URLStr.indexOf("//")) > 0) {
                        URLStr = URLStr.substring(0, slashPos + 2) + "%portaluser%:%portalpass%@" + URLStr.substring(slashPos + 2);
                    }
                    if ((formMethod = taskEl.getChildText("Method")) == null || formMethod.equalsIgnoreCase("1")) {
                        XmlUtils.writeTag("formMethod", "post", out);
                    } else {
                        XmlUtils.writeTag("formMethod", "get", out);
                    }
                    XmlUtils.writeCDataTag("wlLoginUrl", this.parseMacros(URLStr, req), out);
                    Element FormParamsEl = taskEl.getChild("FormParams");
                    if (FormParamsEl != null && FormParamsEl.getChildren() != null && FormParamsEl.getChildren().size() > 0) {
                        XmlUtils.writeStartTag("FormParams", out);
                        List List2 = FormParamsEl.getChildren();
                        for (int i = List2.size(); i > 0; --i) {
                            Element paramEl = (Element)List2.get(i - 1);
                            XmlUtils.writeStartTag("Param", out);
                            XmlUtils.writeTag("Name", paramEl.getChildText("Name"), out);
                            XmlUtils.writeTag("Value", this.parseMacros(paramEl.getChildText("Value"), req), out);
                            XmlUtils.writeEndTag("Param", out);
                        }
                        XmlUtils.writeEndTag("FormParams", out);
                    }
                    if ((CustomFormParams = taskEl.getChildText("CustomFormParams")) != null && CustomFormParams.length() != 0) {
                        XmlUtils.writeCDataTag("CustomFormParams", this.parseMacros(CustomFormParams, req), out);
                    }
                }
            }
            XmlUtils.writeEndTag(ROOT_CLASS_TAG, out);
        }
        catch (IOException e) {
            D.log(e);
        }
    }

    public void getStylesheetAndResourceSets(HttpServletRequest req, StylesheetSetMap ssMap, ResourceSetMap rsMap) {
        StylesheetSet ssSet = new StylesheetSet("fw");
        ssSet.add((Object)"NetWareServiceLauncher.xsl");
        ssSet.add((Object)"NetWareServiceLauncher_lang.xsl");
        ssMap.put(ssSet);
    }

    private String parseMacros(String macroString, HttpServletRequest req) {
        String result = macroString;
        int index = result.indexOf("%");
        while (index > -1) {
            if (index > -1) {
                int endIndex = result.indexOf("%", index + 1);
                if (endIndex > -1) {
                    String sMacroValue = result.substring(index + 1, endIndex);
                    String newValue = this.getMacroTrans(sMacroValue, req);
                    if (newValue == null) {
                        newValue = sMacroValue;
                    }
                    result = endIndex < result.length() ? result.substring(0, index) + newValue + result.substring(endIndex + 1) : result.substring(0, index) + newValue;
                } else {
                    result = result.substring(0, index) + result.substring(index + 1);
                }
            }
            index = result.indexOf("%");
        }
        return result;
    }

    private String getMacroTrans(String macroValue, HttpServletRequest req) {
        String result = null;
        if (macroValue.indexOf("*") == 0) {
            macroValue = macroValue.substring(1);
        }
        if (macroValue.equalsIgnoreCase("serverdns") || macroValue.equalsIgnoreCase("serverIP") || macroValue.equalsIgnoreCase("reqservername")) {
            result = this.serverAddress != null ? this.serverAddress : macroValue;
            return result;
        }
        AuthenticationBroker ab = DirAuthenticator.getDirAuth(req).getAuthenticationBroker();
        if (macroValue.equalsIgnoreCase("treename")) {
            result = ab.getAuthTreeName();
            return result;
        }
        if (macroValue.equalsIgnoreCase("portaluser")) {
            try {
                result = DirUtils.getLeftMostName(ab.getAuthLdapName());
            }
            catch (AuthBrokerException e) {
                D.log(e);
            }
        } else if (macroValue.equalsIgnoreCase("portalpass")) {
            result = ab.getAuthPIdentity();
        } else if (macroValue.equalsIgnoreCase("userdn")) {
            try {
                result = ab.getAuthLdapName();
            }
            catch (AuthBrokerException e) {
                D.log(e);
            }
        } else if (macroValue.equalsIgnoreCase("fullndsuserdn")) {
            try {
                result = ab.getAuthNdapName();
            }
            catch (AuthBrokerException e) {
                D.log(e);
            }
        } else if (macroValue.equalsIgnoreCase("ndsuserdn")) {
            try {
                result = this.usernameLdaptoNdap(ab.getAuthLdapName());
            }
            catch (AuthBrokerException e) {
                D.log(e);
            }
        } else if (macroValue.equalsIgnoreCase("ldapuserdn")) {
            try {
                result = ab.getAuthLdapName();
            }
            catch (AuthBrokerException e) {
                D.log(e);
            }
        } else if (macroValue.equalsIgnoreCase("ldapctx")) {
            try {
                String fullName = ab.getAuthLdapName();
                result = fullName.substring(fullName.indexOf(",") + 1);
            }
            catch (AuthBrokerException e) {
                D.log(e);
            }
        } else if (macroValue.equalsIgnoreCase("ndsctx")) {
            try {
                String fullName = ab.getAuthLdapName();
                result = fullName.substring(fullName.indexOf(",") + 1);
                result = result.replaceAll(",", ".");
            }
            catch (AuthBrokerException e) {
                D.log(e);
            }
        }
        return result;
    }

    private String usernameLdaptoNdap(String usernameContext) {
        StringBuffer strBuff = new StringBuffer(usernameContext);
        int begPos = 0;
        int endPos = strBuff.length();
        int equalPos = 0;
        try {
            equalPos = strBuff.indexOf("=", begPos);
            if (equalPos > 0) {
                strBuff.delete(begPos, equalPos + 1);
                equalPos = endPos - (equalPos + 1 - begPos);
                strBuff.setLength(equalPos);
                endPos = strBuff.length();
            }
            while (begPos < endPos) {
                if (strBuff.charAt(begPos) == ',' && begPos > 0 && strBuff.charAt(begPos - 1) != '\\') {
                    strBuff.setCharAt(begPos, '.');
                    equalPos = strBuff.indexOf("=", begPos);
                    if (equalPos > 0) {
                        strBuff.delete(begPos + 1, equalPos + 1);
                        strBuff.setLength(endPos - (equalPos - begPos));
                        endPos = strBuff.length();
                    }
                }
                ++begPos;
            }
            usernameContext = strBuff.toString();
        }
        catch (Exception exception) {
            // empty catch block
        }
        return usernameContext;
    }
}

