/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.fw.FileSystemResourceBundle;
import java.io.File;
import java.io.IOException;
import java.util.MissingResourceException;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.jdom.Element;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;

public class NetwareServiceUtil {
    private static final String DT = "CreateServerAdminTask";
    private static final String WEBLINKTYPE_ADMIN = "1";
    private static final String WEBLINKTYPE_USER = "0";

    public static void parseServiceDocument(String theFilePath, Vector webLinkElements, TaskContext context) {
        DocumentBuilderFactory docFactory = null;
        docFactory = DocumentBuilderFactory.newInstance();
        docFactory.setNamespaceAware(true);
        docFactory.setValidating(true);
        File fxmlFile = new File(theFilePath);
        Document doc = null;
        try {
            doc = docFactory.newDocumentBuilder().parse(fxmlFile);
        }
        catch (SAXException e) {
            D.log(e);
        }
        catch (IOException e) {
            D.log(e);
        }
        catch (ParserConfigurationException e) {
            D.log(e);
        }
        org.w3c.dom.Element el = null;
        if (doc != null) {
            el = doc.getDocumentElement();
        }
        if (el != null && el.getNodeName().equalsIgnoreCase("ProductInformation")) {
            String productName = null;
            String icon = null;
            String infoLink = null;
            productName = NetwareServiceUtil.getElementValue(el, "Name", null);
            icon = NetwareServiceUtil.getElementValue(el, "Icon", "images/web.gif");
            infoLink = NetwareServiceUtil.getElementValue(el, "InformationLink", null);
            NodeList webLinkIter = el.getElementsByTagName("WebLink");
            for (int j = 0; j < webLinkIter.getLength(); ++j) {
                String wlType = null;
                org.w3c.dom.Element webLinkElement = (org.w3c.dom.Element)webLinkIter.item(j);
                wlType = NetwareServiceUtil.getElementValue(webLinkElement, "WebLinkType", WEBLINKTYPE_USER);
                if (!wlType.equalsIgnoreCase(WEBLINKTYPE_ADMIN)) continue;
                String URLDescriptor = null;
                String unlocURLDescriptor = null;
                String theURL = null;
                unlocURLDescriptor = NetwareServiceUtil.getElementValue(webLinkElement, "URLDescriptor", null);
                try {
                    String temp = theFilePath.substring(0, theFilePath.indexOf(".xml"));
                    temp = temp.replace('\\', '/');
                    FileSystemResourceBundle res = FileSystemResourceBundle.getFileSystemResourceBundle(temp, context.getLocale());
                    URLDescriptor = res.getProperty(unlocURLDescriptor.replace(' ', '_'));
                    if (URLDescriptor == null) {
                        URLDescriptor = unlocURLDescriptor;
                    }
                }
                catch (MissingResourceException e) {
                    URLDescriptor = unlocURLDescriptor;
                }
                catch (NullPointerException e) {
                    URLDescriptor = unlocURLDescriptor;
                }
                NodeList loginList = webLinkElement.getElementsByTagName("Login");
                if (loginList.getLength() <= 0) continue;
                org.w3c.dom.Element loginEl = (org.w3c.dom.Element)loginList.item(0);
                theURL = NetwareServiceUtil.getElementValue(loginEl, "URL", null);
                Element newServiceEl = null;
                newServiceEl = new Element("SERVICE");
                Element ProdInfoEl = new Element("ProductInfo");
                newServiceEl.addContent(ProdInfoEl);
                Element tempEl = null;
                tempEl = new Element("Name");
                tempEl.addContent(productName);
                ProdInfoEl.addContent(tempEl);
                tempEl = new Element("Icon");
                tempEl.addContent(icon);
                ProdInfoEl.addContent(tempEl);
                tempEl = new Element("InformationLink");
                tempEl.addContent(infoLink);
                ProdInfoEl.addContent(tempEl);
                Element webLinkEl = new Element("WebLink");
                newServiceEl.addContent(webLinkEl);
                tempEl = new Element("URLDescriptor");
                tempEl.addContent(URLDescriptor);
                webLinkEl.addContent(tempEl);
                tempEl = new Element("URL");
                tempEl.addContent(theURL);
                webLinkEl.addContent(tempEl);
                Element formParamsEl = new Element("FormParams");
                webLinkEl.addContent(formParamsEl);
                Element tempParamEl = null;
                Element tempNameEl = null;
                Element tempValueEl = null;
                NodeList authInfoList = loginEl.getElementsByTagName("AuthenticationInfo");
                if (authInfoList.getLength() > 0) {
                    org.w3c.dom.Element AuthInfoEl = (org.w3c.dom.Element)authInfoList.item(0);
                    Element RequestType = new Element("RequestType");
                    RequestType.addContent(NetwareServiceUtil.getElementValue(AuthInfoEl, "RequestType", WEBLINKTYPE_ADMIN));
                    webLinkEl.addContent(RequestType);
                    Element MethodType = new Element("Method");
                    MethodType.addContent(NetwareServiceUtil.getElementValue(AuthInfoEl, "Method", WEBLINKTYPE_ADMIN));
                    webLinkEl.addContent(MethodType);
                    NodeList formParamsList = AuthInfoEl.getElementsByTagName("FormParams");
                    if (formParamsList.getLength() > 0) {
                        org.w3c.dom.Element formPEl = (org.w3c.dom.Element)formParamsList.item(0);
                        NodeList paramList = formPEl.getElementsByTagName("Param");
                        for (int k = 0; k < paramList.getLength(); ++k) {
                            org.w3c.dom.Element paramElement = (org.w3c.dom.Element)paramList.item(k);
                            String NameOfParam = NetwareServiceUtil.getElementValue(paramElement, "Name", null);
                            String ValueOfParam = NetwareServiceUtil.getElementValue(paramElement, "Value", null);
                            tempParamEl = new Element("Param");
                            tempNameEl = new Element("Name");
                            tempValueEl = new Element("Value");
                            tempNameEl.addContent(NameOfParam);
                            tempValueEl.addContent(ValueOfParam);
                            tempParamEl.addContent(tempNameEl);
                            tempParamEl.addContent(tempValueEl);
                            formParamsEl.addContent(tempParamEl);
                        }
                    }
                } else {
                    Element MethodType = new Element("Method");
                    MethodType.addContent(WEBLINKTYPE_USER);
                    webLinkEl.addContent(MethodType);
                }
                webLinkElements.add(newServiceEl);
            }
        }
    }

    private static String getElementValue(org.w3c.dom.Element parent, String elementName, String DefaultValue) {
        NodeList cList = null;
        Node nameNode = null;
        Node valueNode = null;
        String result = null;
        cList = parent.getElementsByTagName(elementName);
        nameNode = cList.item(0);
        if (nameNode != null) {
            valueNode = nameNode.getFirstChild();
            result = valueNode != null ? valueNode.getNodeValue() : DefaultValue;
        }
        return result;
    }
}

