/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.util.PluginDocComparator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;

public class OVTaskList
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_taskContext;
    private Properties m_resultStrings;
    private HttpServletRequest m_req;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        boolean bRet = false;
        try {
            if (context == null || resultStrings == null) {
                D.log("TaskList: context or resultString == null");
                boolean bl = bRet;
                return bl;
            }
            this.m_resultStrings = resultStrings;
            this.m_taskContext = context;
            this.m_req = this.m_taskContext.getRequest();
            if (this.m_req == null) {
                D.log("TaskList:  Http request == null");
                boolean bl = bRet;
                return bl;
            }
            String strNames = this.m_req.getParameter("OVSelectedObjects");
            if (strNames == null || strNames.length() < 1) {
                D.log("TaskList:  Object names not found.");
                boolean bl = bRet;
                return bl;
            }
            String[] aNames = eMFrameUtils.unpack(strNames, this.m_taskContext);
            ArrayList taskDocs = FwUtils.getOVTasksForObjects(aNames, this.m_taskContext);
            if (taskDocs == null || taskDocs.size() < 1) {
                D.log("TaskList:  No tasks found.");
                this.m_resultStrings.put("OVTaskList.cnt", "0");
            } else {
                Collections.sort(taskDocs, new PluginDocComparator(context));
                int cnt = taskDocs.size();
                for (int i = 0; i < cnt; ++i) {
                    Document taskDoc = (Document)taskDocs.get(i);
                    String name = eMFrameUtils.getDisplayName(taskDoc, (MContext)this.m_taskContext);
                    String id = taskDoc.getRootElement().getChildTextTrim("id");
                    this.m_resultStrings.put("OVTaskList." + i + ".taskDisplayName", name);
                    this.m_resultStrings.put("OVTaskList." + i + ".taskId", id);
                }
                D.log("TaskList:  " + cnt + " tasks found.");
                String strTmp = "" + cnt;
                this.m_resultStrings.put("OVTaskList.cnt", strTmp);
            }
            bRet = true;
            boolean bl = true;
            return bl;
        }
        catch (Exception e) {
            String errMsgTitle = null;
            String errMsgDesc = null;
            errMsgTitle = eMFrameUtils.getLocalizedString("FwResources", "OV.InternalErrorTitle", context);
            errMsgDesc = eMFrameUtils.getExceptionMessage(e, context);
            this.m_resultStrings.setProperty("GeneralMsg.suppressButtons", "true");
            this.setUIPage("fw/Empty.jsp");
            eMFrameUtils.setMessage("error", errMsgTitle, errMsgDesc, context);
            boolean bl = bRet;
            return bl;
        }
        finally {
            D.log("TaskList:  return = " + bRet);
            this.m_resultStrings = null;
            this.m_taskContext = null;
        }
    }
}

