/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerEvent;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthBrokerListener;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.HistoryNode;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.config.UserConfig;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Set;
import java.util.Vector;

public class ObjectNameHistory
implements AuthBrokerListener {
    int max = 10;
    ArrayList history = new ArrayList();
    DirUtils m_dirUtils = null;
    boolean persist = true;
    UserConfig m_uc = null;

    public ObjectNameHistory(MContext context) {
        String s_historyPersistence;
        SystemConfig sc = SystemConfig.getSystemConfig(context);
        String s_historySize = sc.getSetting("Provider.eMFrame.History.size");
        if (s_historySize != null) {
            try {
                this.max = Integer.parseInt(s_historySize);
                this.max = Math.max(0, this.max);
                this.max = Math.min(100, this.max);
            }
            catch (Exception e) {
                D.log(e);
            }
        }
        this.persist = (s_historyPersistence = sc.getSetting("Provider.eMFrame.History.persistIneDir")) == null || s_historyPersistence.equals("true");
        this.m_dirUtils = context.getDirUtils();
        if (this.persist) {
            AuthenticationBroker ab = context.getAuthenticationBroker();
            ObjectEntry oe = null;
            try {
                oe = (ObjectEntry)ab.getProtocolObject("AdminNamespace");
            }
            catch (AuthBrokerException e) {
                D.log(e);
            }
            String sTreeName = oe.getName();
            if (sTreeName == null || sTreeName.length() == 0) {
                AdminNamespace ns = oe.getAdminNamespace();
                if (ns instanceof LDAPNamespace) {
                    sTreeName = ab.getAuthLdapAccessDomain();
                } else if (ns instanceof NDSNamespace) {
                    sTreeName = ab.getAuthNdapAccessDomain();
                }
            }
            this.m_uc = UserConfig.getUserConfig("fwHistory-" + sTreeName.toLowerCase(), context);
            try {
                context.getAuthenticationBroker().addAuthBrokerListener(this);
                this.directoryRead(this.m_uc);
            }
            catch (AuthBrokerException abe) {
                D.log(abe);
            }
            catch (Exception e) {
                D.log(e);
            }
        }
    }

    @Override
    public void loginEvent(AuthBrokerEvent abEvent) {
    }

    @Override
    public void preLogoutEvent(AuthBrokerEvent abEvent) {
        if (this.persist) {
            this.directoryWrite(this.m_uc);
        }
    }

    public void add(String objectType, String objectName) {
        try {
            objectType = objectType.toLowerCase();
            if (objectType != null && objectName != null && objectType.length() > 0 && objectName.length() > 0) {
                this.history.add(new HistoryNode(objectType, objectName));
                int typeCount = 0;
                for (int i = this.history.size() - 1; i >= 0; --i) {
                    HistoryNode node = (HistoryNode)this.history.get(i);
                    if (!node.getObjectType().equals(objectType)) continue;
                    if (typeCount == this.max || i != this.history.size() - 1 && node.getObjectName().equalsIgnoreCase(objectName)) {
                        this.history.remove(i);
                        continue;
                    }
                    ++typeCount;
                }
            }
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    public void add(ObjectEntry entry) {
        try {
            D.assrt(entry != null, "entry==null");
            if (entry != null) {
                String name;
                if (entry.getObjectType().getName().equalsIgnoreCase("top")) {
                    name = entry.getAdminNamespace().getUnrootedName(entry);
                    this.add("[root]", name);
                } else {
                    name = entry.getAdminNamespace().getUnrootedName(entry);
                    this.add(entry.getObjectType().getName(), name);
                }
                if (ObjectFlags.isPartition((long)entry.getObjectFlags())) {
                    this.add("[partitions]", name);
                }
            }
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    public void remove(String objectName) {
        try {
            objectName = objectName.toLowerCase();
            for (int i = this.history.size() - 1; i >= 0; --i) {
                HistoryNode node = (HistoryNode)this.history.get(i);
                if (!node.getObjectName().toLowerCase().equals(objectName)) continue;
                this.history.remove(i);
            }
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    public void clear() {
        if (this.persist) {
            this.directoryClear(this.m_uc);
        }
        this.history.clear();
    }

    public HistoryNode[] getHistory(String[] origObjectTypes) {
        int i;
        if (this.history.size() == 0) {
            return new HistoryNode[0];
        }
        String[] objectTypes = new String[origObjectTypes.length];
        for (int i2 = 0; i2 < objectTypes.length; ++i2) {
            objectTypes[i2] = origObjectTypes[i2].toLowerCase();
        }
        if (objectTypes == null) {
            objectTypes = new String[]{"*"};
        }
        ArrayList<HistoryNode> toReturn = new ArrayList<HistoryNode>();
        int count = 0;
        boolean containers = false;
        boolean all = false;
        boolean root = false;
        for (i = 0; i < objectTypes.length; ++i) {
            if (objectTypes[i].equals("[containers]") || objectTypes[i].equals("[non-partitions]")) {
                containers = true;
                continue;
            }
            if (objectTypes[i].equals("*")) {
                all = true;
                continue;
            }
            if (objectTypes[i].equals("") && objectTypes.length == 1) {
                all = true;
                continue;
            }
            if (!objectTypes[i].equalsIgnoreCase("[root]")) continue;
            root = true;
        }
        block2: for (i = this.history.size() - 1; i >= 0 && count < this.max; --i) {
            HashSet checkedObjectClasses = new HashSet();
            HistoryNode node = (HistoryNode)this.history.get(i);
            if (all || containers && this.m_dirUtils.isContainer(node.getObjectType())) {
                if (node.getObjectType().equals("[partitions]")) continue;
                if (node.getObjectType().equalsIgnoreCase("top")) {
                    if (!root) continue;
                    toReturn.add(node);
                    continue;
                }
                if (node.getObjectType().equalsIgnoreCase("file") || node.getObjectType().equalsIgnoreCase("directory")) continue;
                toReturn.add(node);
                continue;
            }
            for (int j = 0; j < objectTypes.length; ++j) {
                if (this.checkObjectClass(checkedObjectClasses, node.getObjectType(), objectTypes[j])) {
                    toReturn.add(node);
                    continue block2;
                }
                boolean found = false;
                ArrayList subclasses = this.m_dirUtils.getAllSubClasses(new String[]{origObjectTypes[j]});
                if (subclasses == null) continue;
                for (int k = 0; k < subclasses.size(); ++k) {
                    if (!this.checkObjectClass(checkedObjectClasses, node.getObjectType(), ((String)subclasses.get(k)).toLowerCase())) continue;
                    toReturn.add(node);
                    found = true;
                    break;
                }
                if (found) continue block2;
            }
        }
        while (toReturn.size() > this.max) {
            toReturn.remove(toReturn.size() - 1);
        }
        block6: for (i = toReturn.size() - 1; i >= 1; --i) {
            String nameToCheck = ((HistoryNode)toReturn.get(i)).getObjectName();
            for (int j = i - 1; j >= 0; --j) {
                String s = ((HistoryNode)toReturn.get(j)).getObjectName();
                if (!s.equals(nameToCheck)) continue;
                toReturn.remove(i);
                continue block6;
            }
        }
        return toReturn.toArray(new HistoryNode[toReturn.size()]);
    }

    private boolean checkObjectClass(Set checkedObjectClasses, String origObjectType, String objectTypeToCheck) {
        if (!checkedObjectClasses.contains(objectTypeToCheck)) {
            checkedObjectClasses.add(objectTypeToCheck);
            if (objectTypeToCheck.equals(origObjectType)) {
                return true;
            }
        }
        return false;
    }

    private void directoryRead(UserConfig uc) {
        String[] saTypes = uc.getSettingNames();
        String[] saNames = null;
        for (int i = 0; saTypes != null && i < saTypes.length; ++i) {
            saNames = uc.getSettings(saTypes[i]);
            for (int j = 0; saNames != null && j < saNames.length; ++j) {
                this.add(saTypes[i], saNames[j]);
            }
        }
    }

    private void directoryClear(UserConfig uc) {
        Hashtable<String, String> ht = new Hashtable<String, String>();
        for (HistoryNode node : this.history) {
            ht.put(node.getObjectType(), node.getObjectType());
        }
        Enumeration en = ht.keys();
        String sType = null;
        while (en.hasMoreElements()) {
            sType = (String)en.nextElement();
            try {
                uc.removeSetting(sType);
            }
            catch (ConfigException e) {
                D.log(e);
            }
        }
        try {
            uc.writeSettings();
        }
        catch (ConfigException e) {
            D.log(e);
        }
    }

    private void directoryWrite(UserConfig uc) {
        Hashtable<String, Vector> ht = new Hashtable<String, Vector>();
        Vector vTemp = null;
        for (HistoryNode node : this.history) {
            vTemp = (Vector)ht.get(node.getObjectType());
            if (vTemp == null) {
                vTemp = new Vector();
                ht.put(node.getObjectType(), vTemp);
            }
            vTemp.add(node.getObjectName());
        }
        String sType = null;
        String[] saNames = null;
        Enumeration en = ht.keys();
        while (en.hasMoreElements()) {
            sType = (String)en.nextElement();
            vTemp = (Vector)ht.get(sType);
            saNames = new String[vTemp.size()];
            vTemp.toArray(saNames);
            try {
                uc.setSetting(sType, saNames);
            }
            catch (ConfigException e) {
                D.log(e);
            }
        }
        try {
            uc.writeSettings();
        }
        catch (ConfigException e) {
            D.log(e);
        }
    }
}

