/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.Anchor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ObjectSelectorFinish
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String SEARCH_CMD_CONTEXTID = "Search.ContextId";
    private HttpServletRequest m_req;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        D.log("--->>> OSFinish: entering execute....");
        boolean bRet = false;
        try {
            this.m_req = context.getRequest();
            if (context.getAuthenticator().getAuthContext() == null) {
                D.log("OSFinish: ERROR -- Session cache could not be found!");
                boolean bl = bRet;
                return bl;
            }
            D.log("OSFinish: Cache size = " + context.getAuthenticator().getAuthContext().size());
            String strContextId = this.m_req.getParameter(SEARCH_CMD_CONTEXTID);
            if (strContextId != null && strContextId.length() > 0) {
                if (context.getAuthAttribute(strContextId) != null) {
                    context.removeAuthAttribute(strContextId);
                    D.log("OSFinish: Removed from session cache searchContext = " + strContextId);
                } else {
                    D.log("OSFinish: Nothing removed from cache, Search.ContextId = " + strContextId + " not found in cache!");
                }
            } else {
                D.log("OSFinish: Nothing removed from cache, no Search.ContextId specified.");
            }
            Anchor osAnchor = (Anchor)context.getAuthAttribute("OS.Anchor");
            if (osAnchor != null) {
                Enumeration parms;
                String osAnchorURI = osAnchor.getUri();
                Hashtable osAnchorQueryParms = osAnchor.getQueryParms();
                String osControl = osAnchor.isInitialized() ? osAnchor.getActionControl() : "OS-FINISH-ERROR: Control name not retrievable; anchor uninitialized or reinitialized.";
                String osCallBack = osAnchor.getCallBack();
                String osCustomProcessing = osAnchor.getCustomProcessing();
                String osDocState = osAnchor.getDocState();
                String osResults = this.m_req.getParameter("OS.Results");
                if (osResults != null && osResults.length() > 0) {
                    ArrayList names = eMFrameUtils.commaSplit(osResults);
                    if (names.size() <= 10) {
                        for (int i = 0; i < names.size(); ++i) {
                            String name = eMFrameUtils.urlDecode((String)names.get(i), context);
                            context.addToHistory(name);
                            D.log("OSFinish: '" + name + "' saved in history list");
                        }
                    } else {
                        D.log("OSFinish: more than 10 selected; none stored in history.");
                    }
                }
                this.setPropObject(resultStrings, "OS.AnchorURI", osAnchorURI);
                D.log("OSFinish: osAnchorURI = " + osAnchorURI);
                if (osAnchorQueryParms != null && (parms = osAnchorQueryParms.keys()) != null) {
                    int i = 0;
                    while (parms.hasMoreElements()) {
                        String parmName = (String)parms.nextElement();
                        this.setPropObject(resultStrings, "OS.AnchorURLParmName." + i, parmName);
                        String parmValue = (String)osAnchorQueryParms.get(parmName);
                        this.setPropObject(resultStrings, "OS.AnchorURLParmValue." + i, parmValue);
                        D.log("OSFinish: osAnchorURLParm[" + i + "] = " + parmName + "=" + parmValue);
                        ++i;
                    }
                    this.setPropObject(resultStrings, "OS.AnchorURLParm.Count", Integer.toString(i));
                }
                D.log("OSFinish: osControl = " + osControl);
                D.log("OSFinish: osCallBack = " + osCallBack);
                D.log("OSFinish: osCustomProcessing = " + osCustomProcessing);
                D.log("OSFinish: osResult = " + osResults);
                D.log("OSFinish: osDocState = " + osDocState);
                D.log("");
                this.setPropObject(resultStrings, "OS.Control", osControl);
                this.setPropObject(resultStrings, "OS.CallBack", osCallBack);
                this.setPropObject(resultStrings, "OS.CustomProcessing", osCustomProcessing);
                this.setPropObject(resultStrings, "OS.Results", osResults);
                this.setPropObject(resultStrings, "OS.AnchorDocState", osDocState);
                this.setPropObject(resultStrings, "OS.ReturningToAnchor", "true");
                osAnchor.setInitialized(false);
                bRet = true;
                boolean bl = true;
                return bl;
            }
            D.log("OSFinish: OS Anchor not found.");
            boolean bl = bRet;
            return bl;
        }
        finally {
            D.log("<<<--- ObjectSelectorFinish: exiting execute, cache size = " + context.getAuthenticator().getAuthContext().size() + ", returning " + bRet + "\n");
        }
    }

    private void setPropObject(Properties p, String key, String value) {
        if (p != null && key != null && key.length() > 0) {
            if (value == null) {
                value = "";
            }
            p.put(key, value);
        }
    }
}

