/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ObjectSelectorPrefs
extends Task {
    private static final long serialVersionUID = 1L;
    private static final String WINDOW_WIDTH = "OS.WindowWidth";
    private static final String WINDOW_HEIGHT = "OS.WindowHeight";
    private static final String QUERY_COLUMN_WIDTH = "OS.QueryColumnWidth";
    private static final String SS_RPP = "OS.SSResultsPerPage";
    private static final String SU_MODE = "OS.StartupMode";
    private static final String SU_SEARCH = "OS.StartupSearch";
    private static final String STARTING_CONTEXT = "OS.StartingContext";
    private static final String ALWAYS_CONTEXT = "OS.AlwaysContext";
    private static final String SHOW_SUBORDINATE_COUNT = "OS.ShowSubordinateCount";
    private HttpServletRequest m_req = null;
    private TaskContext m_context = null;
    private Properties m_properties = null;
    private String m_strCmdToken = null;
    static boolean bIsDebugEnabled = D.isDebugEnabled();

    private void dOut(String s) {
        if (bIsDebugEnabled) {
            D.log("OSPrefs: " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        D.log("\n--->>> ObjectSelectorPrefs: entering execute....");
        boolean bRet = false;
        this.m_context = context;
        if (this.m_context == null) {
            this.dOut("ERROR!  Context not found (m_context==null).");
            return bRet;
        }
        this.m_req = context.getRequest();
        if (this.m_req == null) {
            this.dOut("ERROR!  HttpServletRequest not found (m_req==null).");
            return bRet;
        }
        this.m_properties = resultStrings;
        if (this.m_properties == null) {
            this.dOut("ERROR!  ResultStrings not found (m_properties==null).");
            return bRet;
        }
        this.m_strCmdToken = this.m_req.getParameter("nextState");
        Exception e = null;
        try {
            if (this.m_strCmdToken.compareTo("doSetPrefs") == 0) {
                bRet = this.setPrefs(context, e);
                if (bRet) {
                    eMFrameUtils.setMessage("success", eMFrameUtils.getLocalizedString("FwResources", "OS.PrefsTitle", context), eMFrameUtils.getLocalizedString("FwResources", "OS.PrefsSuccessMsg", context), context);
                }
            } else {
                bRet = this.m_strCmdToken.compareTo("doResetPrefs") == 0 ? this.resetPrefs(context, e) : this.getPrefs(context, e);
            }
            if (!bRet) {
                eMFrameUtils.setErrorMessage(e, context);
            }
            boolean bl = bRet;
            return bl;
        }
        finally {
            D.log("<<<--- ObjectSelectorPrefs: exiting execute... returning " + bRet + "\n");
        }
    }

    private void getPref(String parmName, String defaultVal) {
        String sTmp = this.m_context.getPersistentData("OSPrefs", parmName);
        if (sTmp == null) {
            this.m_properties.setProperty(parmName, defaultVal);
            this.dOut("Retrieved " + parmName + " = <" + defaultVal + "> (default)");
        } else {
            this.m_properties.setProperty(parmName, sTmp);
            this.dOut("Retrieved " + parmName + " = <" + sTmp + ">");
        }
    }

    private boolean getPrefs(TaskContext context, Exception exc) {
        boolean bRet = true;
        exc = null;
        try {
            this.getPref(WINDOW_WIDTH, eMFrameUtils.getLocalizedString("DevResources", "OS.Browser.WindowWidth", context));
            this.getPref(WINDOW_HEIGHT, eMFrameUtils.getLocalizedString("DevResources", "OS.Browser.WindowHeight", context));
            this.getPref(QUERY_COLUMN_WIDTH, eMFrameUtils.getLocalizedString("DevResources", "OS.Browser.QueryColumnWidth", context));
            this.getPref(SS_RPP, "22");
            this.getPref(SU_MODE, "browse");
            this.getPref(SU_SEARCH, "false");
            this.getPref(STARTING_CONTEXT, "");
            this.getPref(ALWAYS_CONTEXT, "");
            this.getPref(SHOW_SUBORDINATE_COUNT, "true");
        }
        catch (Exception e) {
            D.log(e);
            exc = e;
            bRet = false;
        }
        return bRet;
    }

    private void setPref(String parmName, String defaultVal) {
        String sTmp = this.m_req.getParameter(parmName);
        if (sTmp == null) {
            this.m_context.setPersistentData("OSPrefs", parmName, defaultVal);
            this.dOut("Saved " + parmName + " = <" + defaultVal + "> (default)");
        } else {
            this.m_context.setPersistentData("OSPrefs", parmName, sTmp);
            this.dOut("Saved " + parmName + " = <" + sTmp + ">");
        }
    }

    private boolean setPrefs(TaskContext context, Exception exc) {
        boolean bRet = true;
        exc = null;
        try {
            this.setPref(WINDOW_WIDTH, eMFrameUtils.getLocalizedString("DevResources", "OS.Browser.WindowWidth", context));
            this.setPref(WINDOW_HEIGHT, eMFrameUtils.getLocalizedString("DevResources", "OS.Browser.WindowHeight", context));
            this.setPref(QUERY_COLUMN_WIDTH, eMFrameUtils.getLocalizedString("DevResources", "OS.Browser.QueryColumnWidth", context));
            this.setPref(SS_RPP, "22");
            this.setPref(SU_MODE, "browse");
            this.setPref(SU_SEARCH, "false");
            this.setPref(STARTING_CONTEXT, "");
            this.setPref(ALWAYS_CONTEXT, "");
            this.setPref(SHOW_SUBORDINATE_COUNT, "true");
        }
        catch (Exception e) {
            D.log(e);
            exc = e;
            bRet = false;
        }
        return bRet;
    }

    private void resetPref(String parmName, String val) {
        try {
            this.m_context.setPersistentData("OSPrefs", parmName, val);
            this.dOut("Reset " + parmName + " = <" + val + "> (default)");
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    private boolean resetPrefs(TaskContext context, Exception exc) {
        boolean bRet = true;
        exc = null;
        try {
            this.resetPref(WINDOW_WIDTH, eMFrameUtils.getLocalizedString("DevResources", "OS.Browser.WindowWidth", context));
            this.resetPref(WINDOW_HEIGHT, eMFrameUtils.getLocalizedString("DevResources", "OS.Browser.WindowHeight", context));
            this.resetPref(QUERY_COLUMN_WIDTH, eMFrameUtils.getLocalizedString("DevResources", "OS.Browser.QueryColumnWidth", context));
            this.resetPref(SS_RPP, "22");
            this.resetPref(SU_MODE, "browse");
            this.resetPref(SU_SEARCH, "false");
            this.resetPref(STARTING_CONTEXT, "");
            this.resetPref(ALWAYS_CONTEXT, "");
        }
        catch (Exception e) {
            D.log(e);
            exc = e;
            bRet = false;
        }
        return bRet;
    }
}

