/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;

public class ObjectViewPrefs
extends Task {
    private static final long serialVersionUID = 1L;
    private static final String COLUMN_WIDTH = "OV.ColumnWidth";
    private static final String SELECTION_MODE = "OV.SelectionMode";
    private static final String SS_RPP = "OV.SSResultsPerPage";
    private static final String SU_MODE = "OV.StartupMode";
    private static final String SU_SEARCH = "OV.StartupSearch";
    private static final String STARTING_CONTEXT = "OV.StartingContext";
    private static final String ALWAYS_CONTEXT = "OV.AlwaysContext";
    private static final String SHOW_SUBORDINATE_COUNT = "OV.ShowSubordinateCount";
    private static final String TVC_RESULTS_PER_PAGE = "TVC.ResultsPerPage";
    private HttpServletRequest m_req = null;
    private TaskContext m_context = null;
    private Properties m_properties = null;
    private String m_strCmdToken = null;
    static boolean bIsDebugEnabled = D.isDebugEnabled();

    private void dOut(String s) {
        if (bIsDebugEnabled) {
            D.log("OVPrefs: " + s);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        D.log("\n--->>> ObjectViewPrefs: entering execute....");
        boolean bRet = false;
        this.m_context = context;
        if (this.m_context == null) {
            this.dOut("ERROR!  Context not found (m_context==null).");
            return bRet;
        }
        this.m_req = context.getRequest();
        if (this.m_req == null) {
            this.dOut("ERROR!  HttpServletRequest not found (m_req==null).");
            return bRet;
        }
        this.m_properties = resultStrings;
        if (this.m_properties == null) {
            this.dOut("ERROR!  ResultStrings not found (m_properties==null).");
            return bRet;
        }
        this.m_strCmdToken = this.m_req.getParameter("nextState");
        Exception e = null;
        try {
            if (this.m_strCmdToken.equals("doSetPrefs")) {
                bRet = this.setPrefs(context, e);
                if (bRet) {
                    eMFrameUtils.setMessage("success", eMFrameUtils.getLocalizedString("FwResources", "OV.PrefsTitle", context), eMFrameUtils.getLocalizedString("FwResources", "OV.PrefsSuccessMsg", context), context);
                }
            } else {
                bRet = this.m_strCmdToken.equals("doResetPrefs") ? this.resetPrefs(context, e) : this.getPrefs(context, e);
            }
            if (!bRet) {
                eMFrameUtils.setErrorMessage(e, context);
            }
            boolean bl = bRet;
            return bl;
        }
        finally {
            D.log("<<<--- ObjectViewPrefs: exiting execute... returning " + bRet + "\n");
        }
    }

    private void getPref(String parmName, String defaultVal) {
        String sTmp = this.m_context.getPersistentData("OVPrefs", parmName);
        if (sTmp == null) {
            this.m_properties.setProperty(parmName, defaultVal);
            this.dOut("Retrieved " + parmName + " = <" + defaultVal + "> (default)");
        } else {
            this.m_properties.setProperty(parmName, sTmp);
            this.dOut("Retrieved " + parmName + " = <" + sTmp + ">");
        }
    }

    private boolean getPrefs(TaskContext context, Exception exc) {
        boolean bRet = true;
        exc = null;
        try {
            this.getPref(COLUMN_WIDTH, eMFrameUtils.getLocalizedString("DevResources", "OV.Browser.ColumnWidth", context));
            this.getPref(SELECTION_MODE, "single");
            this.getPref(SS_RPP, "100");
            this.getPref(SU_MODE, "tree");
            this.getPref(SU_SEARCH, "false");
            this.getPref(STARTING_CONTEXT, "");
            this.getPref(ALWAYS_CONTEXT, "");
            this.getPref(SHOW_SUBORDINATE_COUNT, "true");
            this.getPref(TVC_RESULTS_PER_PAGE, "100");
        }
        catch (Exception e) {
            D.log(e);
            exc = e;
            bRet = false;
        }
        return bRet;
    }

    private void setPref(String parmName, String defaultVal) {
        String sTmp = this.m_req.getParameter(parmName);
        if (sTmp == null) {
            this.m_context.setPersistentData("OVPrefs", parmName, defaultVal);
            this.dOut("Saved " + parmName + " = <" + defaultVal + "> (default)");
        } else {
            this.m_context.setPersistentData("OVPrefs", parmName, sTmp);
            this.dOut("Saved " + parmName + " = <" + sTmp + ">");
        }
    }

    private boolean setPrefs(TaskContext context, Exception exc) {
        boolean bRet = true;
        exc = null;
        try {
            this.setPref(COLUMN_WIDTH, eMFrameUtils.getLocalizedString("DevResources", "OV.Browser.ColumnWidth", context));
            this.setPref(SELECTION_MODE, "single");
            this.setPref(SS_RPP, "100");
            this.setPref(SU_MODE, "tree");
            this.setPref(SU_SEARCH, "false");
            this.setPref(STARTING_CONTEXT, "");
            this.setPref(ALWAYS_CONTEXT, "");
            this.setPref(SHOW_SUBORDINATE_COUNT, "true");
            this.setPref(TVC_RESULTS_PER_PAGE, "100");
        }
        catch (Exception e) {
            D.log(e);
            exc = e;
            bRet = false;
        }
        return bRet;
    }

    private void resetPref(String parmName, String val) {
        try {
            this.m_context.setPersistentData("OVPrefs", parmName, val);
            this.dOut("Reset " + parmName + " = <" + val + "> (default)");
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    private boolean resetPrefs(TaskContext context, Exception exc) {
        boolean bRet = true;
        exc = null;
        try {
            this.resetPref(COLUMN_WIDTH, eMFrameUtils.getLocalizedString("DevResources", "OV.Browser.ColumnWidth", context));
            this.resetPref(SELECTION_MODE, "single");
            this.resetPref(SS_RPP, "100");
            this.resetPref(SU_MODE, "tree");
            this.resetPref(SU_SEARCH, "false");
            this.resetPref(STARTING_CONTEXT, "");
            this.resetPref(ALWAYS_CONTEXT, "");
            this.resetPref(TVC_RESULTS_PER_PAGE, "100");
        }
        catch (Exception e) {
            D.log(e);
            exc = e;
            bRet = false;
        }
        return bRet;
    }
}

