/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.AuthBrokerAuthenticator;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.ManagementServiceSet;
import com.novell.nps.authentication.PortalConnection;

public final class PortalConnectionAuthenticator
extends AuthBrokerAuthenticator {
    private static final String DEF_CLEARPORT = ":389";
    private static final String DEF_SSLPORT = ":636";

    @Override
    public Object login(String ldapName, String password, String ldapAccessDomain, ManagementServiceSet manageSS) throws AuthBrokerException {
        try {
            AuthenticationBroker broker = manageSS.getAuthenticationBroker();
            boolean ssl = broker.getAuthUseLdapSSL();
            String portedAccessDomain = ldapAccessDomain.indexOf(58) >= 0 ? ldapAccessDomain : ldapAccessDomain + (ssl ? DEF_SSLPORT : DEF_CLEARPORT);
            PortalConnection pc = new PortalConnection(portedAccessDomain, ldapName, password, ssl);
            pc.login();
            return pc;
        }
        catch (Throwable te) {
            D.log(te);
            throw new AuthBrokerException("Could not login to PortalConnection - " + te.getLocalizedMessage());
        }
    }

    @Override
    public void logout(Object inApiObject) {
        try {
            PortalConnection pc = (PortalConnection)inApiObject;
            pc.logout();
        }
        catch (Throwable te) {
            D.log("Failed logout of PortalConnection - " + te.getLocalizedMessage());
            D.log(te);
        }
    }
}

