/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.StringValue;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.DirRoleList;
import com.novell.emframe.fw.FwDirUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSCollection;
import java.util.Enumeration;
import java.util.Properties;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;

public class RBSCollectionOwnerTask
extends Task {
    private static final long serialVersionUID = 1L;
    private HttpServletRequest req;
    private TaskContext context;
    private Properties resultStrings;
    private ObjectEntry[] oldOwnerListOE;
    private ObjectEntry m_treeOE;
    private AdminNamespace m_ns;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        this.m_treeOE = RBSUtil.getTreeOE(context);
        this.m_ns = this.m_treeOE.getAdminNamespace();
        String nextState = this.req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("showCollectionList")) {
            return this.showCollectionList();
        }
        if (nextState.equalsIgnoreCase("deleteOwner")) {
            return this.deleteOwner();
        }
        if (nextState.equalsIgnoreCase("addOwner")) {
            return this.addOwner();
        }
        if (nextState.equalsIgnoreCase("saveOwner")) {
            return this.saveOwner();
        }
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        return true;
    }

    private boolean showCollectionList() {
        String selectedContext = this.req.getParameter("RBSCollectionName");
        String[] strings = eMFrameUtils.unpack(selectedContext, this.context);
        selectedContext = strings[0];
        ObjectEntry collectionOE = null;
        RBSCollection rbsCollection = null;
        Vector<String> ownerVector = new Vector<String>();
        String updateNeeded = new String("false");
        try {
            collectionOE = this.m_ns.getObjectEntry(this.m_treeOE, selectedContext);
            String objectType = collectionOE.getObjectType().getName();
            if (!objectType.equals("rbsCollection2")) {
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "Error", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "RBSCollectionName.WrongClass", this.context));
                return false;
            }
            this.context.addToHistory(collectionOE);
            rbsCollection = new RBSCollection(collectionOE);
            this.oldOwnerListOE = rbsCollection.getOwners();
        }
        catch (SPIException e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.context);
            return false;
        }
        if (this.oldOwnerListOE != null) {
            for (int i = 0; i < this.oldOwnerListOE.length; ++i) {
                String strGroup = this.m_ns.getUnrootedName(this.oldOwnerListOE[i]);
                ownerVector.addElement(strGroup);
            }
        }
        try {
            this.resultStrings.put("MemberTypeFilter", RBSUtil.getCollectionOwnerObjectTypes(this.context, this.m_ns));
        }
        catch (Exception exc) {
            D.log(exc.toString());
        }
        this.context.setAuthAttribute("ownerVector", ownerVector);
        this.context.setAuthAttribute("rbsCollection", rbsCollection);
        this.context.setAuthAttribute("selectedContext", selectedContext);
        this.context.setAuthAttribute("updateNeeded", updateNeeded);
        this.putOwners(ownerVector);
        return true;
    }

    private boolean addOwner() {
        Vector ownerVector = (Vector)this.context.getAuthAttribute("ownerVector");
        String updateNeeded = (String)this.context.getAuthAttribute("updateNeeded");
        String selectedItem = this.req.getParameter("Selected_Item");
        boolean add = true;
        for (int i = 0; i < ownerVector.size(); ++i) {
            String list = (String)ownerVector.elementAt(i);
            if (!selectedItem.equalsIgnoreCase(list)) continue;
            add = false;
            break;
        }
        try {
            if (add) {
                ObjectEntry memberOE = null;
                memberOE = this.m_ns.getObjectEntry(this.m_treeOE, selectedItem);
                if (DirUtils.isOfType(memberOE.getObjectType(), "Group", true)) {
                    Enumeration staticMembersEnum;
                    ObjectAttribute[] objAttributes = this.m_ns.getAttributes(memberOE, new String[]{"Member"}, 1, null);
                    Enumeration enumeration = staticMembersEnum = objAttributes != null && objAttributes[0] != null ? objAttributes[0].getValueComponents() : null;
                    if (staticMembersEnum != null) {
                        Vector<String> ownerGroupMembersVector = new Vector<String>();
                        while (staticMembersEnum.hasMoreElements()) {
                            String strGroupMemberOE = ((StringValue)staticMembersEnum.nextElement()).toString();
                            ObjectEntry groupMemberOE = this.m_ns.getObjectEntry(this.m_treeOE, strGroupMemberOE);
                            if (!DirUtils.isOfType(groupMemberOE.getObjectType(), "User", true)) continue;
                            boolean addUser = true;
                            for (int i = 0; i < ownerVector.size(); ++i) {
                                String list = (String)ownerVector.elementAt(i);
                                if (!strGroupMemberOE.equalsIgnoreCase(list)) continue;
                                addUser = false;
                                break;
                            }
                            if (!addUser) continue;
                            ownerGroupMembersVector.addElement(strGroupMemberOE);
                        }
                        if (ownerGroupMembersVector != null && ownerGroupMembersVector.size() > 0) {
                            Enumeration ownerGroupMembersEnum = ownerGroupMembersVector.elements();
                            while (ownerGroupMembersEnum.hasMoreElements()) {
                                ownerVector.add(ownerGroupMembersEnum.nextElement());
                            }
                        }
                    }
                }
                ownerVector.addElement(selectedItem);
                updateNeeded = "true";
                this.context.setAuthAttribute("updateNeeded", updateNeeded);
            }
            this.putOwners(ownerVector);
        }
        catch (Throwable t) {
            D.log(t);
            eMFrameUtils.setErrorMessage(t, this.context);
            return false;
        }
        return true;
    }

    private boolean saveOwner() {
        this.resultStrings.put("TaskAfterGenConf", "fw.HomePage");
        this.resultStrings.put("MergeAfterGenConf", "fw.HomePage");
        String updateNeeded = (String)this.context.getAuthAttribute("updateNeeded");
        if (updateNeeded.equals("true")) {
            Vector ownerVector = (Vector)this.context.getAuthAttribute("ownerVector");
            RBSCollection rbsCollection = (RBSCollection)this.context.getAuthAttribute("rbsCollection");
            ObjectEntry[] newOwnerListOE = null;
            if (ownerVector != null && ownerVector.size() > 0) {
                newOwnerListOE = new ObjectEntry[ownerVector.size()];
                for (int i = 0; i < ownerVector.size(); ++i) {
                    String owner = (String)ownerVector.elementAt(i);
                    try {
                        newOwnerListOE[i] = this.m_ns.getObjectEntry(this.m_treeOE, owner);
                        continue;
                    }
                    catch (SPIException e) {
                        D.log(e);
                        eMFrameUtils.setErrorMessage(e, this.context);
                        return false;
                    }
                }
            }
            try {
                rbsCollection.setOwners(newOwnerListOE);
                rbsCollection.update();
                ObjectEntry whoami = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
                RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(whoami);
                RBSCollection[] rbsCollections = rbsAssociatedObject.getOwnedCollections2();
                if (rbsCollections == null) {
                    DirRoleList roleList = RBSUtil.getDirRoleList(this.context);
                    roleList.setCollectionOwner(false);
                    FwDirUtils.updateAccessMode(this.context);
                } else {
                    DirRoleList roleList = RBSUtil.getDirRoleList(this.context);
                    roleList.setCollectionOwner(true);
                    FwDirUtils.updateAccessMode(this.context);
                }
                this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "RBSCollectionName.ADD_OWNER_RBSCOLLECTION_SUCCESS", this.context));
                this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "RBSCollectionName.ADD_OWNER_RBSCOLLECTION", this.context));
            }
            catch (Exception e) {
                D.log(e);
                eMFrameUtils.setErrorMessage(e, this.context);
                return false;
            }
        } else {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "RBSCollectionName.ADD_OWNER_RBSCOLLECTION_SUCCESS", this.context));
            this.resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "RBSCollectionName.NO_UPDATE_OWNER_RBSCOLLECTION", this.context));
        }
        return true;
    }

    private boolean deleteOwner() {
        Vector ownerVector = (Vector)this.context.getAuthAttribute("ownerVector");
        String selectedItem = this.req.getParameter("Selected_Item");
        try {
            ObjectEntry memberOE = null;
            memberOE = this.m_ns.getObjectEntry(this.m_treeOE, selectedItem);
            if (DirUtils.isOfType(memberOE.getObjectType(), "Group", true)) {
                Enumeration staticMembersEnum;
                ObjectAttribute[] objAttributes = this.m_ns.getAttributes(memberOE, new String[]{"Member"}, 1, null);
                Enumeration enumeration = staticMembersEnum = objAttributes != null && objAttributes[0] != null ? objAttributes[0].getValueComponents() : null;
                if (staticMembersEnum != null) {
                    Vector<String> ownerGroupMemberDeletedList = new Vector<String>();
                    block2: while (staticMembersEnum.hasMoreElements()) {
                        String strGroupMemberOE = ((StringValue)staticMembersEnum.nextElement()).toString();
                        ObjectEntry groupMemberOE = this.m_ns.getObjectEntry(this.m_treeOE, strGroupMemberOE);
                        if (!DirUtils.isOfType(groupMemberOE.getObjectType(), "User", true)) continue;
                        ObjectAttribute[] userGrpMembershipAttrs = this.m_ns.getAttributes(groupMemberOE, new String[]{"Group Membership"}, 1, null);
                        int count = 0;
                        Enumeration userGrpMembershipEnum = userGrpMembershipAttrs[0].getValueComponents();
                        block3: while (userGrpMembershipEnum.hasMoreElements()) {
                            String grpOE = ((StringValue)userGrpMembershipEnum.nextElement()).toString();
                            for (int i = 0; i < ownerVector.size(); ++i) {
                                String list = (String)ownerVector.elementAt(i);
                                if (!list.equalsIgnoreCase(grpOE)) continue;
                                ++count;
                                continue block3;
                            }
                        }
                        for (int i = 0; i < ownerVector.size(); ++i) {
                            String list = (String)ownerVector.elementAt(i);
                            if (!list.equalsIgnoreCase(strGroupMemberOE) || count > true) continue;
                            ownerGroupMemberDeletedList.add(strGroupMemberOE);
                            continue block2;
                        }
                    }
                    if (ownerGroupMemberDeletedList != null && ownerGroupMemberDeletedList.size() > 0) {
                        ownerVector.removeAll(ownerGroupMemberDeletedList);
                    }
                }
            }
            for (int i = 0; i < ownerVector.size(); ++i) {
                String list = (String)ownerVector.elementAt(i);
                if (!list.equalsIgnoreCase(selectedItem)) continue;
                ownerVector.removeElementAt(i);
                break;
            }
            this.putOwners(ownerVector);
            this.context.setAuthAttribute("ownerVector", ownerVector);
            String updateNeeded = (String)this.context.getAuthAttribute("updateNeeded");
            updateNeeded = "true";
            this.context.setAuthAttribute("updateNeeded", updateNeeded);
        }
        catch (Throwable t) {
            D.log(t);
            eMFrameUtils.setErrorMessage(t, this.context);
            return false;
        }
        return true;
    }

    private void putOwners(Vector owners) {
        for (int i = 0; i < owners.size(); ++i) {
            String ownerStr = (String)owners.elementAt(i);
            this.resultStrings.put("Task.CollectionList." + i, ownerStr);
        }
        this.resultStrings.put("Task.CollectionList.Count", Integer.toString(owners.size()));
        String selectedContext = (String)this.context.getAuthAttribute("selectedContext");
        this.resultStrings.put("RBSCollectionContext", selectedContext);
    }
}

