/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.rbs.RBSCategory;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSTask;
import java.util.Properties;

public class RBSReportUtil {
    public static String isDynamicGroupEnabled(TaskContext context) {
        String dynamicGroupEnabled = null;
        dynamicGroupEnabled = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.DynamicGroup.enable");
        if (dynamicGroupEnabled == null || !dynamicGroupEnabled.equalsIgnoreCase("false") && !dynamicGroupEnabled.equalsIgnoreCase("true")) {
            dynamicGroupEnabled = "false";
        }
        return dynamicGroupEnabled;
    }

    public static String getRoleDiscoveryDomain(TaskContext context) {
        String roleDiscoveryDomain = null;
        roleDiscoveryDomain = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.Role.discoveryDomain");
        if (roleDiscoveryDomain == null || !roleDiscoveryDomain.equalsIgnoreCase("parent") && !roleDiscoveryDomain.equalsIgnoreCase("partition") && !roleDiscoveryDomain.equalsIgnoreCase("root")) {
            roleDiscoveryDomain = "parent";
        }
        return roleDiscoveryDomain;
    }

    public static String getDynamicGroupDiscoveryDomain(TaskContext context) {
        String dynamicGroupDiscoveryDomain = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.DynamicGroup.discoveryDomain");
        if (dynamicGroupDiscoveryDomain == null || !dynamicGroupDiscoveryDomain.equalsIgnoreCase("parent") && !dynamicGroupDiscoveryDomain.equalsIgnoreCase("partition") && !dynamicGroupDiscoveryDomain.equalsIgnoreCase("root")) {
            dynamicGroupDiscoveryDomain = "parent";
        }
        return dynamicGroupDiscoveryDomain;
    }

    public static String getDynamicGroupSearchType(TaskContext context) {
        String dynamicGroupSearchType = SystemConfig.getSystemConfig(context).getSetting("Provider.eMFrame.DynamicGroup.Searchtype");
        if (dynamicGroupSearchType == null || !dynamicGroupSearchType.equalsIgnoreCase("DynamicGroupObjectsOnly") && !dynamicGroupSearchType.equalsIgnoreCase("DynamicGroupObjects&AuxClasses")) {
            dynamicGroupSearchType = "DynamicGroupObjectsOnly";
        }
        return dynamicGroupSearchType;
    }

    public static String getRoleDisplayName(TaskContext context, ObjectEntry treeOE, String roleFDN) throws SPIException {
        AdminNamespace ns = treeOE.getAdminNamespace();
        ObjectEntry taskOE = ns.getObjectEntry(treeOE, roleFDN);
        String displayName = RBSUtil.getLocalizedDisplayName(context, taskOE);
        return displayName;
    }

    public static String getRoleDisplayName(TaskContext context, ObjectEntry roleOE) {
        String displayName = RBSUtil.getLocalizedDisplayName(context, roleOE);
        return displayName;
    }

    public static String getRoleDisplayName(TaskContext context, RBSRole rbsRole) {
        String displayName = RBSUtil.getLocalizedDisplayName(context, rbsRole.getObjectEntry());
        return displayName;
    }

    public static String getTaskDisplayName(TaskContext context, ObjectEntry treeOE, String taskFDN) throws SPIException {
        AdminNamespace ns = treeOE.getAdminNamespace();
        ObjectEntry taskOE = ns.getObjectEntry(treeOE, taskFDN);
        String displayName = RBSUtil.getLocalizedDisplayName(context, taskOE);
        return displayName;
    }

    public static String getTaskDisplayName(TaskContext context, RBSTask rbsTask) throws SPIException {
        String displayName = RBSUtil.getLocalizedDisplayName(context, rbsTask.getObjectEntry());
        return displayName;
    }

    public static String getCategoryDisplayName(TaskContext context, ObjectEntry treeOE, String taskFDN) throws SPIException {
        AdminNamespace ns = treeOE.getAdminNamespace();
        ObjectEntry taskOE = ns.getObjectEntry(treeOE, taskFDN);
        String displayName = RBSUtil.getLocalizedDisplayName(context, taskOE);
        return displayName;
    }

    public static String getCategoryDisplayName(TaskContext context, RBSCategory rbsCategory) {
        String displayName = RBSUtil.getLocalizedDisplayName(context, rbsCategory.getObjectEntry());
        return displayName;
    }

    public static String getResourceBundleFromParameters(String paramStr) {
        Properties parameters = eMFrameUtils.parseParameters(paramStr, ";");
        return (String)parameters.get("resource-properties-file");
    }

    public static String getDisplayNameKeyFromParameters(String paramStr) {
        Properties parameters = eMFrameUtils.parseParameters(paramStr, ";");
        return (String)parameters.get("display-name-key");
    }

    public static String convertLongToPrivilegeDisplayString(TaskContext context, String attrName, long priv) {
        int count = 0;
        String displayString = "";
        if (attrName.equalsIgnoreCase("[Entry Rights]")) {
            if ((priv & 0x10L) == 16L) {
                if (count > 0) {
                    displayString = displayString + ", ";
                }
                displayString = displayString + eMFrameUtils.getLocalizedString("FwResources", "RBSReport.Rights.Supervisor", context);
                ++count;
            }
            if ((priv & 1L) == 1L) {
                if (count > 0) {
                    displayString = displayString + ", ";
                }
                displayString = displayString + eMFrameUtils.getLocalizedString("FwResources", "RBSReport.Rights.Browse", context);
                ++count;
            }
            if ((priv & 2L) == 2L) {
                if (count > 0) {
                    displayString = displayString + ", ";
                }
                displayString = displayString + eMFrameUtils.getLocalizedString("FwResources", "RBSReport.Rights.Create", context);
                ++count;
            }
            if ((priv & 4L) == 4L) {
                if (count > 0) {
                    displayString = displayString + ", ";
                }
                displayString = displayString + eMFrameUtils.getLocalizedString("FwResources", "RBSReport.Rights.Delete", context);
                ++count;
            }
            if ((priv & 8L) == 8L) {
                if (count > 0) {
                    displayString = displayString + ", ";
                }
                displayString = displayString + eMFrameUtils.getLocalizedString("FwResources", "RBSReport.Rights.Rename", context);
                ++count;
            }
        } else {
            if ((priv & 0x20L) == 32L) {
                if (count > 0) {
                    displayString = displayString + ", ";
                }
                displayString = displayString + eMFrameUtils.getLocalizedString("FwResources", "RBSReport.Rights.Supervisor", context);
                ++count;
            }
            if ((priv & 1L) == 1L) {
                if (count > 0) {
                    displayString = displayString + ", ";
                }
                displayString = displayString + eMFrameUtils.getLocalizedString("FwResources", "RBSReport.Rights.Compare", context);
                ++count;
            }
            if ((priv & 2L) == 2L) {
                if (count > 0) {
                    displayString = displayString + ", ";
                }
                displayString = displayString + eMFrameUtils.getLocalizedString("FwResources", "RBSReport.Rights.Read", context);
                ++count;
            }
            if ((priv & 4L) == 4L) {
                if (count > 0) {
                    displayString = displayString + ", ";
                }
                displayString = displayString + eMFrameUtils.getLocalizedString("FwResources", "RBSReport.Rights.Write", context);
                ++count;
            }
            if ((priv & 8L) == 8L) {
                if (count > 0) {
                    displayString = displayString + ", ";
                }
                displayString = displayString + eMFrameUtils.getLocalizedString("FwResources", "RBSReport.Rights.AddSelf", context);
                ++count;
            }
            if ((priv & Integer.MIN_VALUE) == Integer.MIN_VALUE) {
                if (count > 0) {
                    displayString = displayString + ", ";
                }
                displayString = displayString + eMFrameUtils.getLocalizedString("FwResources", "RBSReport.Rights.Self", context);
                ++count;
            }
        }
        return displayString;
    }
}

