/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.Rights;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.Debug;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.BookInfo;
import com.novell.emframe.fw.BookRoleInfo;
import com.novell.emframe.fw.DirRoleList;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.GenerateDMITaskDocument;
import com.novell.emframe.fw.InstallXMLInfo;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.VersionInfo;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.util.iManagerJDOMFactory;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSException;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSTask;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class RBSUtil {
    private static final String FRAMEWORK_STARTUP_RBSINSTALLED = "Framework.Startup.RBSInstalled";
    public static final Comparator stringCompare = new Comparator(){

        public int compare(Object o1, Object o2) {
            String s1 = (String)o1;
            String s2 = (String)o2;
            int len1 = s1.length();
            int len2 = s2.length();
            int n = Math.min(len1, len2);
            for (int i = 0; i < n; ++i) {
                char c2;
                char c1 = s1.charAt(i);
                if (c1 == (c2 = s2.charAt(i))) continue;
                return c1 - c2;
            }
            return len1 - len2;
        }
    };

    public static void getAssignedObjectTypes(BookInfo bookInfo, HttpServletRequest req) {
        String assignedObjectTypes = req.getParameter("AssignedObjectTypesString");
        StringTokenizer assignedTokenizer = new StringTokenizer(assignedObjectTypes, ";");
        String[] assignedTypes = null;
        if (assignedTokenizer.countTokens() > 0) {
            assignedTypes = new String[assignedTokenizer.countTokens()];
            int count = 0;
            while (assignedTokenizer.hasMoreTokens()) {
                assignedTypes[count] = eMFrameUtils.urlDecode(assignedTokenizer.nextToken(), req.getCharacterEncoding());
                ++count;
            }
        }
        bookInfo.setAssignedObjectTypes(assignedTypes);
    }

    public static void getAssignedPages(BookInfo bookInfo, HttpServletRequest req) {
        String assignedPages = req.getParameter("AssignedPagesString");
        StringTokenizer assignedTokenizer = new StringTokenizer(assignedPages, ";");
        String[] assignedPageIds = null;
        if (assignedTokenizer.countTokens() > 0) {
            assignedPageIds = new String[assignedTokenizer.countTokens()];
            int count = 0;
            while (assignedTokenizer.hasMoreTokens()) {
                assignedPageIds[count] = eMFrameUtils.urlDecode(assignedTokenizer.nextToken(), req.getCharacterEncoding());
                ++count;
            }
        }
        bookInfo.setAssignedPages(assignedPageIds);
    }

    public static void getAssignedRoles(BookInfo bookInfo, HttpServletRequest req) {
        String assignedRoleFullName = req.getParameter("AssignedRoleFullName");
        String assignedRoleShortName = req.getParameter("AssignedRoleShortName");
        String assignedRoleDescription = req.getParameter("AssignedRoleDescription");
        StringTokenizer fullNameTokenizer = new StringTokenizer(assignedRoleFullName, ";");
        StringTokenizer shortNameTokenizer = new StringTokenizer(assignedRoleShortName, ";");
        StringTokenizer descriptionTokenizer = new StringTokenizer(assignedRoleDescription, ";");
        BookRoleInfo[] bookRoleInfo = null;
        if (fullNameTokenizer.countTokens() == shortNameTokenizer.countTokens() && fullNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() > 0) {
            bookRoleInfo = new BookRoleInfo[shortNameTokenizer.countTokens()];
            int count = 0;
            while (shortNameTokenizer.hasMoreTokens()) {
                bookRoleInfo[count] = new BookRoleInfo();
                bookRoleInfo[count].setShortName(eMFrameUtils.urlDecode(shortNameTokenizer.nextToken(), req.getCharacterEncoding()));
                bookRoleInfo[count].setFullName(eMFrameUtils.urlDecode(fullNameTokenizer.nextToken(), req.getCharacterEncoding()));
                bookRoleInfo[count].setDescription(eMFrameUtils.urlDecode(descriptionTokenizer.nextToken(), req.getCharacterEncoding()));
                ++count;
            }
        }
        bookInfo.setAssignedRoles(bookRoleInfo);
    }

    public static void getAvailableObjectTypes(BookInfo bookInfo, HttpServletRequest req) {
        String availableObjectTypes = req.getParameter("AvailableObjectTypesString");
        StringTokenizer availableTokenizer = new StringTokenizer(availableObjectTypes, ";");
        String[] availableTypes = null;
        if (availableTokenizer.countTokens() > 0) {
            availableTypes = new String[availableTokenizer.countTokens()];
            int count = 0;
            while (availableTokenizer.hasMoreTokens()) {
                availableTypes[count] = eMFrameUtils.urlDecode(availableTokenizer.nextToken(), req.getCharacterEncoding());
                ++count;
            }
        }
        bookInfo.setAvailableObjectTypes(availableTypes);
    }

    public static void getAvailablePages(BookInfo bookInfo, HttpServletRequest req) {
        String availablePages = req.getParameter("AvailablePagesString");
        StringTokenizer availableTokenizer = new StringTokenizer(availablePages, ";");
        String[] availablePageIds = null;
        if (availableTokenizer.countTokens() > 0) {
            availablePageIds = new String[availableTokenizer.countTokens()];
            int count = 0;
            while (availableTokenizer.hasMoreTokens()) {
                availablePageIds[count] = eMFrameUtils.urlDecode(availableTokenizer.nextToken(), req.getCharacterEncoding());
                ++count;
            }
        }
        bookInfo.setAvailablePages(availablePageIds);
    }

    public static void getAvailableRoles(BookInfo bookInfo, HttpServletRequest req) {
        String availableRoleFullName = req.getParameter("AvailableRoleFullName");
        String availableRoleShortName = req.getParameter("AvailableRoleShortName");
        String availableRoleDescription = req.getParameter("AvailableRoleDescription");
        StringTokenizer fullNameTokenizer = new StringTokenizer(availableRoleFullName, ";");
        StringTokenizer shortNameTokenizer = new StringTokenizer(availableRoleShortName, ";");
        StringTokenizer descriptionTokenizer = new StringTokenizer(availableRoleDescription, ";");
        BookRoleInfo[] bookRoleInfo = null;
        if (fullNameTokenizer.countTokens() == shortNameTokenizer.countTokens() && fullNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() > 0) {
            bookRoleInfo = new BookRoleInfo[shortNameTokenizer.countTokens()];
            int count = 0;
            while (shortNameTokenizer.hasMoreTokens()) {
                bookRoleInfo[count] = new BookRoleInfo();
                bookRoleInfo[count].setShortName(eMFrameUtils.urlDecode(shortNameTokenizer.nextToken(), req.getCharacterEncoding()));
                bookRoleInfo[count].setFullName(eMFrameUtils.urlDecode(fullNameTokenizer.nextToken(), req.getCharacterEncoding()));
                bookRoleInfo[count].setDescription(eMFrameUtils.urlDecode(descriptionTokenizer.nextToken(), req.getCharacterEncoding()));
                ++count;
            }
        }
        bookInfo.setAvailableRoles(bookRoleInfo);
    }

    public static String getDescriptionKeyFromParameters(String paramStr) {
        Properties parameters = eMFrameUtils.parseParameters(paramStr, ";");
        return (String)parameters.get("description-key");
    }

    public static String getPageDescription(String pageId, MContext context) {
        String desc = null;
        Document doc = GlobalRegistry.getPluginDocument(pageId);
        if (doc == null) {
            desc = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NO_DESCRIPTION", context);
        } else {
            desc = doc.getRootElement().getChildTextTrim("description");
            if (desc == null || desc.length() == 0) {
                desc = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NO_DESCRIPTION", context);
            }
        }
        return desc;
    }

    public static String getResourceBundleFromParameters(String paramStr) {
        Properties parameters = eMFrameUtils.parseParameters(paramStr, ";");
        return (String)parameters.get("resource-properties-file");
    }

    public static String getTypeFromParameters(String paramStr) {
        Properties parameters = eMFrameUtils.parseParameters(paramStr, ";");
        return (String)parameters.get("type");
    }

    public static void putAssignedObjectTypes(BookInfo bookInfo, Properties resultStrings) {
        String[] assignedObjectTypes = bookInfo.getAssignedObjectTypes();
        if (assignedObjectTypes == null) {
            resultStrings.put("AssignedObjectType.Count", Integer.toString(0));
        } else {
            resultStrings.put("AssignedObjectType.Count", Integer.toString(assignedObjectTypes.length));
            for (int i = 0; i < assignedObjectTypes.length; ++i) {
                resultStrings.put("AssignedObjectType.Element." + i, assignedObjectTypes[i]);
            }
        }
    }

    public static void putAssignedPages(BookInfo bookInfo, Properties resultStrings, MContext context) {
        String[] assignedPages = bookInfo.getAssignedPages();
        if (assignedPages == null || assignedPages.length == 1 && assignedPages[0] == "") {
            resultStrings.put("AssignedPage.Count", Integer.toString(0));
        } else {
            resultStrings.put("AssignedPage.Count", Integer.toString(assignedPages.length));
            Hashtable<String, String> chapters = new Hashtable<String, String>();
            int chapterCount = 0;
            for (int i = 0; i < assignedPages.length; ++i) {
                String pageId;
                String[] keyBundle;
                String pageDisplayName = RBSUtil.getPageDisplayName(assignedPages[i], context);
                String chapter = GlobalRegistry.getChapter(assignedPages[i]);
                String chapterName = eMFrameUtils.getLocalizedString("FwResources", "UnNamedChapterDisplayName", context);
                if (chapter != null && (keyBundle = chapter.split(",")) != null && keyBundle.length == 2 && ((chapterName = eMFrameUtils.getLocalizedString(keyBundle[0], keyBundle[1], context.getLocale())) == null || chapterName.length() == 0)) {
                    chapterName = keyBundle[1];
                }
                if (chapters.containsKey(chapterName)) {
                    pageId = (String)chapters.get(chapterName);
                    String[] pages = pageId.split(",");
                    int pageCount = pages.length - 1;
                    try {
                        int chapNum = new Integer(pages[0]);
                        resultStrings.put("ChapterName." + chapNum, chapterName);
                        resultStrings.put("ChapterName." + chapNum + "AssignedPage.Element." + pageCount, assignedPages[i]);
                        resultStrings.put("ChapterName." + chapNum + "AssignedPage.TranslatedElement." + pageCount, pageDisplayName);
                        resultStrings.put("ChapterName." + chapNum + "AssignedPage.Description." + pageCount, RBSUtil.getPageDescription(assignedPages[i], context));
                        pageId = pageId + "," + assignedPages[i];
                        chapters.put(chapterName, pageId);
                        resultStrings.put("ChapterName." + chapNum + "PageCount", String.valueOf(++pageCount));
                    }
                    catch (NumberFormatException e) {
                        D.log(e);
                    }
                } else {
                    pageId = chapterCount + "," + assignedPages[i];
                    chapters.put(chapterName, pageId);
                    resultStrings.put("ChapterName." + chapterCount, chapterName);
                    resultStrings.put("ChapterName." + chapterCount + "PageCount", "1");
                    resultStrings.put("ChapterName." + chapterCount + "AssignedPage.Element." + 0, assignedPages[i]);
                    resultStrings.put("ChapterName." + chapterCount + "AssignedPage.TranslatedElement." + 0, pageDisplayName);
                    resultStrings.put("ChapterName." + chapterCount + "AssignedPage.Description." + 0, RBSUtil.getPageDescription(assignedPages[i], context));
                    ++chapterCount;
                }
                resultStrings.put("AssignedPage.TranslatedElement." + i, pageDisplayName);
                resultStrings.put("AssignedPage.Element." + i, assignedPages[i]);
                resultStrings.put("AssignedPage.Description." + i, RBSUtil.getPageDescription(assignedPages[i], context));
            }
            resultStrings.put("ChapterCount", String.valueOf(chapterCount));
        }
    }

    public static void putAssignedRoles(BookInfo bookInfo, Properties resultStrings) {
        BookRoleInfo[] roles = bookInfo.getAssignedRoles();
        if (roles != null) {
            resultStrings.put("AssignedRole.Count", Integer.toString(roles.length));
            for (int i = 0; i < roles.length; ++i) {
                resultStrings.put("AssignedRoles." + i + ".ShortName", roles[i].getShortName());
                resultStrings.put("AssignedRoles." + i + ".FullName", roles[i].getFullName());
                resultStrings.put("AssignedRoles." + i + ".Description", roles[i].getDescription());
            }
        } else {
            resultStrings.put("AssignedRole.Count", Integer.toString(0));
        }
    }

    public static BookRoleInfo[] readAssignedRoleInfo(RBSRole[] rbsRoles, AdminNamespace namespace, MContext context) {
        BookRoleInfo[] bookRoleInfo = null;
        if (rbsRoles != null) {
            bookRoleInfo = new BookRoleInfo[rbsRoles.length];
            for (int i = 0; i < rbsRoles.length; ++i) {
                String fullName = namespace.getUnrootedName(rbsRoles[i].getObjectEntry());
                String shortName = RBSUtil.getLocalizedDisplayName(context, rbsRoles[i].getObjectEntry());
                String description = RBSUtil.getLocalizedDescriptionName(context, rbsRoles[i].getObjectEntry());
                bookRoleInfo[i] = new BookRoleInfo(shortName, fullName, description);
            }
        }
        return bookRoleInfo;
    }

    public static void putAvailableObjectTypes(BookInfo bookInfo, Properties resultStrings) {
        String[] availableObjectTypes = bookInfo.getAvailableObjectTypes();
        if (availableObjectTypes == null) {
            resultStrings.put("AvailableObjectType.Count", Integer.toString(0));
        } else {
            resultStrings.put("AvailableObjectType.Count", Integer.toString(availableObjectTypes.length));
            for (int i = 0; i < availableObjectTypes.length; ++i) {
                resultStrings.put("AvailableObjectType.Element." + i, availableObjectTypes[i]);
            }
        }
    }

    public static void putAvailablePages(BookInfo bookInfo, Properties resultStrings, MContext context) {
        String[] availablePages = bookInfo.getAvailablePages();
        if (availablePages == null) {
            resultStrings.put("AvailablePage.Count", Integer.toString(0));
        } else {
            resultStrings.put("AvailablePage.Count", Integer.toString(availablePages.length));
            for (int i = 0; i < availablePages.length; ++i) {
                String[] keyBundle;
                String pageDisplayName = RBSUtil.getPageDisplayName(availablePages[i], context);
                String chapter = GlobalRegistry.getChapter(availablePages[i]);
                String chapterName = eMFrameUtils.getLocalizedString("FwResources", "UnNamedChapterDisplayName", context);
                if (chapter != null && (keyBundle = chapter.split(",")) != null && keyBundle.length == 2 && ((chapterName = eMFrameUtils.getLocalizedString(keyBundle[0], keyBundle[1], context.getLocale())) == null || chapterName.length() == 0)) {
                    chapterName = keyBundle[1];
                }
                resultStrings.put("AvailablePage.TranslatedElement." + i, pageDisplayName);
                resultStrings.put("AvailablePage.Element." + i, availablePages[i]);
                resultStrings.put("AvailablePage.Description." + i, RBSUtil.getPageDescription(availablePages[i], context));
                resultStrings.put("AvailablePage.Chapter." + i, chapterName);
            }
        }
    }

    public static void putAvailableRoles(BookInfo bookInfo, Properties resultStrings) {
        BookRoleInfo[] roles = bookInfo.getAvailableRoles();
        if (roles != null) {
            resultStrings.put("AvailableRole.Count", Integer.toString(roles.length));
            for (int i = 0; i < roles.length; ++i) {
                resultStrings.put("AvailableRoles." + i + ".ShortName", roles[i].getShortName());
                resultStrings.put("AvailableRoles." + i + ".FullName", roles[i].getFullName());
                resultStrings.put("AvailableRoles." + i + ".Description", roles[i].getDescription());
            }
        } else {
            resultStrings.put("AvailableRole.Count", Integer.toString(0));
        }
    }

    public static BookRoleInfo[] readAvailableRoles(BookInfo bookInfo, ObjectEntry treeOE, MContext context) throws SPIException {
        AdminNamespace namespace = treeOE.getAdminNamespace();
        Object[] bookRoleInfo = null;
        ObjectEntry moduleOE = null;
        boolean flag = true;
        String path = bookInfo.getContext();
        while (flag) {
            moduleOE = namespace.getObjectEntry(treeOE, path);
            String objectType = moduleOE.getObjectType().getName();
            if (objectType.equals("rbsModule2") || objectType.equals("rbsModule")) {
                flag = false;
                continue;
            }
            ObjectEntry oe = moduleOE.getParent();
            path = namespace.getUnrootedName(oe);
        }
        ObjectEntry collectionOE = moduleOE.getParent();
        RBSCollection rbsCollection = new RBSCollection(collectionOE);
        RBSRole[] rbsRoles = null;
        String m_sBookType = bookInfo.getBookType();
        if (m_sBookType == null) {
            rbsRoles = rbsCollection.getSpecifiedRoles(null);
        } else {
            String[] m_arrayBookTypes = new String[]{bookInfo.getBookType()};
            rbsRoles = rbsCollection.getSpecifiedRoles(m_arrayBookTypes);
        }
        Vector<BookRoleInfo> bookListV = new Vector<BookRoleInfo>();
        if (rbsRoles != null) {
            for (int i = 0; i < rbsRoles.length; ++i) {
                VersionInfo iManagerVersionInfo;
                VersionInfo expiredVersionInfo;
                String expiredVersion;
                String fullName = namespace.getUnrootedName(rbsRoles[i].getObjectEntry());
                String shortName = RBSUtil.getLocalizedDisplayName(context, rbsRoles[i].getObjectEntry());
                String description = RBSUtil.getDescFromAttr(rbsRoles[i].getObjectEntry(), context);
                String parameters = rbsRoles[i].getParameters();
                if (parameters != null && (expiredVersion = RBSUtil.getKeyFromParameters(parameters, "expired-version")) != null && (expiredVersionInfo = new VersionInfo(expiredVersion)).compareTo(iManagerVersionInfo = new VersionInfo(iManager.getVersionString())) <= 0) continue;
                bookListV.add(new BookRoleInfo(shortName, fullName, description));
            }
        }
        if (bookListV.size() > 0) {
            bookRoleInfo = new BookRoleInfo[bookListV.size()];
            bookListV.copyInto(bookRoleInfo);
        }
        return bookRoleInfo;
    }

    public static String[] readAttributes(ObjectEntry oe) throws SPIException {
        AdminNamespace namespace = oe.getAdminNamespace();
        SchemaDefinition schemaDef = namespace.getSchemaDefinition(oe);
        AttributeDefinition[] attrDef = schemaDef.getAttributeDefinitions();
        Vector<String> availableAttributesV = new Vector<String>();
        for (int i = 0; i < attrDef.length; ++i) {
            availableAttributesV.addElement(new String(attrDef[i].getName()));
        }
        String[] attributesTypes = null;
        if (availableAttributesV.size() > 0) {
            attributesTypes = availableAttributesV.toArray(new String[availableAttributesV.size()]);
        }
        return attributesTypes;
    }

    public static String[] readObjectClassTypes(ObjectEntry oe, MContext context) throws SPIException, NamespaceException {
        AdminNamespace namespace = oe.getAdminNamespace();
        SchemaDefinition schemaDef = namespace.getSchemaDefinition(oe);
        ClassDefinition[] classDef = schemaDef.getClassDefinitions();
        Vector<String> availableObjectTypesV = new Vector<String>();
        if (FwUtils.doesPageIdsExistForType(context, "[containers]")) {
            availableObjectTypesV.addElement(new String("[containers]"));
        }
        for (int i = 0; i < classDef.length; ++i) {
            if (!classDef[i].isEffective() || !FwUtils.doesPageIdsExistForType(context, classDef[i].getName())) continue;
            availableObjectTypesV.addElement(new String(classDef[i].getName()));
        }
        String[] availableObjectTypes = null;
        if (availableObjectTypesV.size() > 0) {
            availableObjectTypes = availableObjectTypesV.toArray(new String[availableObjectTypesV.size()]);
        }
        return availableObjectTypes;
    }

    public static String[] readPageIds(MContext context, BookInfo bookInfo, ObjectEntry oe) throws NamespaceException, SPIException {
        String[] availablePages = null;
        String[] pageIds = FwUtils.getAllPageIds(context, bookInfo.getAssignedObjectTypes());
        if (pageIds != null) {
            AdminNamespace namespace = oe.getAdminNamespace();
            SchemaDefinition schemaDef = namespace.getSchemaDefinition(oe);
            Vector<String> availablePagesV = new Vector<String>();
            for (int i = 0; i < pageIds.length; ++i) {
                boolean add = true;
                RBSRights[] rights = FwUtils.getPagesRights(new String[]{pageIds[i]}, oe);
                if (rights != null) {
                    for (int j = 0; j < rights.length; ++j) {
                        if (rights[j].getProtectedAttrName().equalsIgnoreCase("[Entry Rights]") || rights[j].getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]") || rights[j].getProtectedAttrName().equalsIgnoreCase("[No Self Rights Assignment]") || schemaDef.isAttributeDefined(rights[j].getProtectedAttrName())) continue;
                        D.log("--  Discarding page: " + pageIds[i] + " attribute undefined: " + rights[j].getProtectedAttrName());
                        add = false;
                        break;
                    }
                }
                if (!add) continue;
                availablePagesV.addElement(pageIds[i]);
            }
            if (availablePagesV.size() > 0) {
                availablePages = availablePagesV.toArray(new String[availablePagesV.size()]);
            }
        }
        return availablePages;
    }

    public static String[] removeAssignedFromAvailable(String[] available, String[] assigned) {
        if (assigned == null) {
            return available;
        }
        if (available == null) {
            return null;
        }
        Vector<String> vector = new Vector<String>();
        for (int i = 0; i < available.length; ++i) {
            boolean found = false;
            for (int j = 0; j < assigned.length; ++j) {
                if (!available[i].equalsIgnoreCase(assigned[j])) continue;
                found = true;
                break;
            }
            if (found) continue;
            vector.add(available[i]);
        }
        String[] array = null;
        if (vector.size() > 0) {
            array = vector.toArray(new String[vector.size()]);
        }
        return array;
    }

    public static BookRoleInfo[] removeAssignedRolesFromAvailableRoles(BookRoleInfo[] availableRoles, BookRoleInfo[] assignedRoles) {
        Vector<BookRoleInfo> roles = new Vector<BookRoleInfo>();
        if (availableRoles == null || assignedRoles == null) {
            return availableRoles;
        }
        for (int i = 0; i < availableRoles.length; ++i) {
            BookRoleInfo availableRole = availableRoles[i];
            boolean found = false;
            for (int j = 0; j < assignedRoles.length; ++j) {
                BookRoleInfo assignedRole = assignedRoles[j];
                if (!availableRole.getFullName().equalsIgnoreCase(assignedRole.getFullName())) continue;
                found = true;
                break;
            }
            if (found) continue;
            roles.add(availableRole);
        }
        BookRoleInfo[] retRoles = null;
        if (roles.size() > 0) {
            retRoles = roles.toArray(new BookRoleInfo[roles.size()]);
        }
        return retRoles;
    }

    public static String[] removePagesThatDontExist(String[] availablePages, String[] assignedPages) {
        int i;
        if (availablePages == null || assignedPages == null) {
            return null;
        }
        Vector<String> assigned = new Vector<String>(assignedPages.length);
        Vector<String> newAssigned = new Vector<String>();
        for (i = 0; i < assignedPages.length; ++i) {
            assigned.add(assignedPages[i]);
        }
        for (i = 0; i < availablePages.length; ++i) {
            if (!assigned.contains(availablePages[i])) continue;
            newAssigned.add(availablePages[i]);
        }
        String[] retAssigned = null;
        if (newAssigned.size() > 0) {
            retAssigned = newAssigned.toArray(new String[newAssigned.size()]);
        }
        return retAssigned;
    }

    public static String getVersionFromElement(Element el) {
        String retStr = null;
        if (el != null) {
            retStr = el.getTextTrim();
        }
        return retStr;
    }

    public static String[] getSubClassesOfObject(String objectClass, ObjectEntry treeOE) throws SPIException {
        AdminNamespace namespace = treeOE.getAdminNamespace();
        SchemaDefinition schemaDef = null;
        ClassDefinition[] objectClassDefs = null;
        String[] objectSubClassTypes = null;
        int count = 0;
        if (treeOE != null) {
            schemaDef = namespace.getSchemaDefinition(treeOE);
        }
        if (schemaDef != null && objectClass != null) {
            objectClassDefs = schemaDef.getSubClasses(objectClass);
        }
        if (objectClassDefs != null) {
            objectSubClassTypes = new String[objectClassDefs.length];
            for (int i = 0; i < objectClassDefs.length; ++i) {
                objectSubClassTypes[count++] = objectClassDefs[i].getName();
            }
        }
        return objectSubClassTypes;
    }

    public static boolean isUpdateNeeded(String oldVersion, String newVersion) {
        boolean updateFlag = false;
        VersionInfo newVersionInfo = new VersionInfo(newVersion);
        VersionInfo oldVersionInfo = new VersionInfo(oldVersion);
        if (newVersionInfo.compareTo(oldVersionInfo) >= 0) {
            updateFlag = true;
        }
        return updateFlag;
    }

    public static boolean isModuleUpdateNeeded(String oldVersion, String newVersion) {
        boolean updateFlag = false;
        VersionInfo newVersionInfo = new VersionInfo(newVersion);
        VersionInfo oldVersionInfo = new VersionInfo(oldVersion);
        if (newVersionInfo.compareTo(oldVersionInfo) > 0) {
            updateFlag = true;
        }
        return updateFlag;
    }

    public static InstallXMLInfo[] getAllPlugins(MContext context, AdminNamespace ns) throws SPIException, NamespaceException {
        String systemID = RBSUtil.getSystemID(ns);
        Object[] installXMLInfo = null;
        File categoryXMLFile = null;
        DirAuthenticator dirAuth = DirAuthenticator.getDirAuth(context);
        ArrayList fileList = Registry.getXmlFiles("install");
        if (fileList != null) {
            for (int i = 0; i < fileList.size(); ++i) {
                File file = (File)fileList.get(i);
                if (!file.getName().equalsIgnoreCase("category.xml")) continue;
                categoryXMLFile = file;
                fileList.remove(i);
                break;
            }
            Vector<InstallXMLInfo> infoVector = new Vector<InstallXMLInfo>(fileList.size());
            boolean dmiTask = false;
            for (int i = 0; i < fileList.size(); ++i) {
                dmiTask = false;
                File currentFile = (File)fileList.get(i);
                if (!currentFile.getName().toLowerCase().endsWith("xml")) continue;
                try {
                    Element module;
                    Element root;
                    String strType;
                    SAXBuilder saxBuilder = new SAXBuilder(false);
                    saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
                    saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
                    saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
                    saxBuilder.setFactory((JDOMFactory)iManagerJDOMFactory.getInstance());
                    Document doc = saxBuilder.build(currentFile);
                    Element rootE = doc.getRootElement();
                    Element moduleE = rootE.getChild("module");
                    if (moduleE == null) {
                        D.log("Unable to install file " + currentFile.getName() + " due to missing module, ignoring file.");
                        continue;
                    }
                    Element idE = moduleE.getChild("id");
                    String id = idE.getTextTrim();
                    System.out.println("==============================");
                    System.out.println("module id: " + id);
                    System.out.println("system id: " + systemID);
                    if (!dirAuth.docSupportsSystem(doc, systemID)) {
                        System.out.println("result: not supported");
                        System.out.println("==============================");
                        continue;
                    }
                    System.out.println("result: supported");
                    System.out.println("==============================");
                    if (currentFile.getName().toLowerCase().endsWith("servermgmt.xml")) {
                        File xmlFile;
                        dmiTask = true;
                        if ((doc = new GenerateDMITaskDocument(context, ns, doc).getDocument()) == null) continue;
                        XMLOutputter xmlOutputter = new XMLOutputter();
                        String docString = xmlOutputter.outputString(doc);
                        String tempDir = context.getWebappHome().getAbsolutePath() + "\\temp";
                        File tempDirFile = new File(tempDir);
                        if (!tempDirFile.exists()) {
                            tempDirFile.mkdir();
                        }
                        if ((xmlFile = new File(tempDirFile, "dynamicDMITask.xml")).exists()) {
                            xmlFile.delete();
                        }
                        try {
                            FileWriter out = new FileWriter(xmlFile);
                            out.write(docString);
                            out.close();
                        }
                        catch (IOException out) {
                            // empty catch block
                        }
                    }
                    if (!(strType = (root = doc.getRootElement()).getName()).equals("install") || (module = root.getChild("module")) == null || module.getChild("non-ds") != null) continue;
                    boolean found = false;
                    String moduleName = module.getChild("id").getTextTrim();
                    String rbsDisplayName = null;
                    String versionNumber = null;
                    if (module.getChild("resource-properties-file") != null && module.getChild("display-name-key") != null) {
                        rbsDisplayName = eMFrameUtils.getLocalizedString(module.getChild("resource-properties-file").getTextTrim(), module.getChild("display-name-key").getTextTrim(), context.getLocale());
                    }
                    if (rbsDisplayName == null) {
                        rbsDisplayName = moduleName;
                    }
                    if (module.getChild("version") != null) {
                        versionNumber = module.getChild("version").getTextTrim();
                    }
                    if (versionNumber == null) {
                        versionNumber = "0.0.0";
                        System.out.println("");
                        System.out.println("-----------------------------------");
                        System.out.println("Module version for " + currentFile.getAbsolutePath() + " has not been set.");
                        System.out.println("-----------------------------------");
                        System.out.println("");
                    }
                    if (module.getChild("check-for-update") != null && module.getChild("check-for-update").getTextTrim().equalsIgnoreCase("yes")) {
                        VersionInfo versionInfo = new VersionInfo(versionNumber);
                        versionInfo.setBuild(new Integer(1));
                        versionNumber = versionInfo.getVersionString();
                    }
                    for (int j = 0; j < infoVector.size(); ++j) {
                        InstallXMLInfo currentXMLInfo = (InstallXMLInfo)infoVector.elementAt(j);
                        if (!rbsDisplayName.equalsIgnoreCase(currentXMLInfo.getDisplayName())) continue;
                        currentXMLInfo.setFile(currentFile);
                        if (RBSUtil.isModuleUpdateNeeded(currentXMLInfo.getVersion(), versionNumber)) {
                            currentXMLInfo.setVersion(versionNumber);
                        }
                        if (currentXMLInfo.getModuleName().equalsIgnoreCase(currentXMLInfo.getDisplayName()) && !rbsDisplayName.equalsIgnoreCase(currentXMLInfo.getDisplayName())) {
                            currentXMLInfo.setDisplayName(rbsDisplayName);
                        }
                        found = true;
                        break;
                    }
                    if (found) continue;
                    InstallXMLInfo installInfo = new InstallXMLInfo();
                    installInfo.setModuleName(moduleName);
                    installInfo.setDisplayName(rbsDisplayName);
                    installInfo.setVersion(versionNumber);
                    installInfo.setFile(0, categoryXMLFile);
                    if (!dmiTask) {
                        installInfo.setFile(currentFile);
                    } else {
                        installInfo.setDocument(doc);
                    }
                    if (moduleName.equalsIgnoreCase("base")) {
                        infoVector.add(0, installInfo);
                        continue;
                    }
                    infoVector.add(installInfo);
                    continue;
                }
                catch (Exception e) {
                    D.log(e);
                    D.log("Error processing file: " + currentFile.getName() + ", ignoring file");
                }
            }
            if (infoVector.size() > 0) {
                installXMLInfo = new InstallXMLInfo[infoVector.size()];
                infoVector.copyInto(installXMLInfo);
            }
        }
        return installXMLInfo;
    }

    public static String getLeafObjectSupportType(RBSObject[] rbsObjects) {
        String returnSupportType = null;
        if (rbsObjects != null) {
            for (int j = 0; j < rbsObjects.length; ++j) {
                try {
                    String currentSupportType;
                    String parameters = ((RBSTask)rbsObjects[j]).getParameters();
                    if (parameters == null || (currentSupportType = RBSUtil.getLeafObjectSupportParameter(parameters)) == null) continue;
                    if (returnSupportType == null) {
                        returnSupportType = currentSupportType;
                        if (!returnSupportType.equals("overwritable")) continue;
                        break;
                    }
                    if (!currentSupportType.equals("overwritable") || !returnSupportType.equals("cumulative")) continue;
                    returnSupportType = currentSupportType;
                    break;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        return returnSupportType;
    }

    public static String[] getLeafObjectTypes(RBSObject[] rbsObjects) {
        Vector<String> elementV = new Vector<String>();
        Object[] returnObjectTypes = null;
        if (rbsObjects != null) {
            Hashtable<String, String> hTable = new Hashtable<String, String>();
            for (int j = 0; j < rbsObjects.length; ++j) {
                try {
                    Vector tokenV;
                    String currentObjectTypes;
                    String leafObjectSupport;
                    String parameters = ((RBSTask)rbsObjects[j]).getParameters();
                    if (parameters == null || (leafObjectSupport = RBSUtil.getLeafObjectSupportParameter(parameters)) == null || (currentObjectTypes = RBSUtil.getMultipleObjectTypeNamesParameter(parameters)) == null || (tokenV = eMFrameUtils.tokenize(currentObjectTypes, ",")).size() <= 0) continue;
                    for (int i = 0; i < tokenV.size(); ++i) {
                        String element = (String)tokenV.elementAt(i);
                        if (hTable.get(element) != null) continue;
                        hTable.put(element, element);
                        elementV.add(element);
                    }
                    continue;
                }
                catch (Exception e) {
                    // empty catch block
                }
            }
        }
        if (elementV.size() > 0) {
            returnObjectTypes = new String[elementV.size()];
            elementV.copyInto(returnObjectTypes);
        }
        return returnObjectTypes;
    }

    public static String getLeafObjectSupportParameter(String paramStr) {
        Properties parameters = eMFrameUtils.parseParameters(paramStr, ";");
        return (String)parameters.get("leaf-object-support");
    }

    public static String getObjectTypeNamesParameter(String paramStr) {
        Properties parameters = eMFrameUtils.parseParameters(paramStr, ";");
        return (String)parameters.get("object-type-name");
    }

    public static String getMultipleObjectTypeNamesParameter(String paramStr) {
        StringBuffer sbObjectTypeNames = new StringBuffer();
        HashMap hmParameters = eMFrameUtils.parseParameters2(paramStr);
        ArrayList alObjectTypes = (ArrayList)hmParameters.get("object-type-name");
        alObjectTypes.trimToSize();
        for (int i = 0; i < alObjectTypes.size(); ++i) {
            if (i > 0) {
                sbObjectTypeNames.append(",");
            }
            sbObjectTypeNames.append((String)alObjectTypes.get(i));
        }
        return sbObjectTypeNames.toString();
    }

    public static String getVersionFromParameters(String paramStr) {
        Properties parameters = eMFrameUtils.parseParameters(paramStr, ";");
        return (String)parameters.get("version");
    }

    public boolean hasRBSInstalledBeenDetermined(MContext context) {
        return FwAttr.getFwAuthAttr(FRAMEWORK_STARTUP_RBSINSTALLED, context) != null;
    }

    public static boolean isRBSInstalled(MContext context) {
        Boolean bRBSInstalled = (Boolean)FwAttr.getFwAuthAttr(FRAMEWORK_STARTUP_RBSINSTALLED, context);
        if (bRBSInstalled != null) {
            return bRBSInstalled;
        }
        SystemConfig config = SystemConfig.getSystemConfig(context);
        String forceUnrestricted = config.getSetting("RBS.forceUnrestricted");
        if (forceUnrestricted != null && forceUnrestricted.equalsIgnoreCase("true")) {
            return false;
        }
        boolean flag = false;
        ObjectEntry treeOE = null;
        try {
            DirAuthenticator dirAuth = DirAuthenticator.getDirAuth(context);
            if (dirAuth == null || !dirAuth.isAuthenticated(context.getRequest()) && !dirAuth.isAuthenticatedButNotComplete()) {
                return false;
            }
            treeOE = (ObjectEntry)dirAuth.getAuthenticationBroker().getProtocolObject("AdminNamespace");
        }
        catch (Throwable t) {
            D.log(t);
            return false;
        }
        String sTreeName = treeOE.getName();
        if (sTreeName == null || sTreeName.length() == 0) {
            AdminNamespace ns = treeOE.getAdminNamespace();
            if (ns instanceof LDAPNamespace) {
                sTreeName = context.getAuthenticationBroker().getAuthLdapAccessDomain();
            } else if (ns instanceof NDSNamespace) {
                sTreeName = context.getAuthenticationBroker().getAuthNdapAccessDomain();
            }
        }
        String str = FRAMEWORK_STARTUP_RBSINSTALLED + sTreeName;
        String setting = (String)context.getAuthAttribute(str);
        flag = RBSUtil.isRBSInstalledImpl(context);
        context.setAuthAttribute(str, flag ? "true" : "false");
        FwAttr.setFwAuthAttr(FRAMEWORK_STARTUP_RBSINSTALLED, (Object)flag, context);
        return flag;
    }

    private static boolean isRBSInstalledImpl(MContext context) {
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        String currentTreeName = treeOE.getName();
        AdminNamespace ns = treeOE.getAdminNamespace();
        if (currentTreeName == null || currentTreeName.length() == 0) {
            if (ns instanceof LDAPNamespace) {
                currentTreeName = context.getAuthenticationBroker().getAuthLdapAccessDomain();
            } else if (ns instanceof NDSNamespace) {
                currentTreeName = context.getAuthenticationBroker().getAuthNdapAccessDomain();
            }
        }
        ObjectEntry whoamiOE = null;
        SystemConfig systemConfig = SystemConfig.getSystemConfig(context);
        String[] treeNameList = systemConfig.getSettings("RBS.Installed.Trees.List");
        if (treeNameList != null) {
            for (int count = 0; count < treeNameList.length; ++count) {
                if (!currentTreeName.equalsIgnoreCase(treeNameList[count])) continue;
                return true;
            }
        }
        try {
            whoamiOE = ns.getAuthenticatedIdentity(treeOE);
            RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(whoamiOE);
            RBSCollection[] rbsCollection = rbsAssociatedObject.getAllOwnedCollections2();
            if (rbsCollection != null) {
                RBSUtil.setTreeNameInConfig(context, currentTreeName);
                return true;
            }
        }
        catch (Exception exc) {
            D.log(exc);
            return false;
        }
        if (DirAuthenticator.getDirAuth(context).hasRolesInDirectory((FwTaskContext)context)) {
            RBSUtil.setTreeNameInConfig(context, currentTreeName);
            return true;
        }
        return false;
    }

    public static void setTreeNameInConfig(MContext context, String currentTreeName) {
        SystemConfig systemConfig = SystemConfig.getSystemConfig(context);
        String[] treeNameList = systemConfig.getSettings("RBS.Installed.Trees.List");
        if (treeNameList != null) {
            for (int count = 0; count < treeNameList.length; ++count) {
                if (!currentTreeName.equalsIgnoreCase(treeNameList[count])) continue;
                return;
            }
        }
        try {
            systemConfig.addSettingValue("RBS.Installed.Trees.List", currentTreeName);
            systemConfig.writeSettings();
        }
        catch (ConfigException exc) {
            D.log(exc);
        }
    }

    public static boolean preCheckCreateCollection(MContext context, Properties resultStrings, ObjectEntry treeOE, String containerDN, String collectionName) {
        AdminNamespace ns = treeOE.getObjectType().getAdminNamespace();
        try {
            boolean exists = ns.doesExist(treeOE, containerDN);
            if (!exists) {
                String errStr = eMFrameUtils.getLocalizedString("BaseResources", "Common.ContainerNotFound", context);
                resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CREATE_RBSCOLLECTION_FAILURE", context));
                resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage(errStr, new String[]{containerDN}));
                return false;
            }
            ObjectEntry containerOE = ns.getObjectEntry(treeOE, containerDN);
            if (!containerOE.getObjectType().isContainer()) {
                String errStr = eMFrameUtils.getLocalizedString("BaseResources", "Common.NotAContainer", context);
                resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CREATE_RBSCOLLECTION_FAILURE", context));
                resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage(errStr, new String[]{containerDN}));
                return false;
            }
            ObjectEntry whoamiOE = ns.getAuthenticatedIdentity(treeOE);
            Rights objRights = ns.getObjectEffectiveRights(containerOE, whoamiOE);
            if (!objRights.hasAddRights()) {
                resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CREATE_RBSCOLLECTION_FAILURE", context));
                resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("BaseResources", "User.InsufficientRights", context));
                return false;
            }
            Rights[] propRights = ns.getPropertyEffectiveRights(whoamiOE, whoamiOE, new String[]{"rbsOwnedCollections2"});
            if (!(propRights[0].hasReadRights() && propRights[0].hasWriteRights())) {
                resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CREATE_RBSCOLLECTION_FAILURE", context));
                resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("BaseResources", "User.InsufficientRights", context));
                return false;
            }
            exists = ns.doesExist(treeOE, collectionName + "." + containerDN);
            if (exists) {
                String errStr = eMFrameUtils.getLocalizedString("BaseResources", "CreateClass.CollectionExists", context);
                resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CREATE_RBSCOLLECTION_FAILURE", context));
                resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage(errStr, new String[]{collectionName + "." + containerDN}));
                return false;
            }
            String strParentType = containerOE.getObjectType().getName();
            SchemaDefinition schDef = ns.getSchemaDefinition(containerOE);
            boolean canContain = schDef.canContain(strParentType, "rbsCollection2");
            if (!canContain) {
                String str = eMFrameUtils.getLocalizedString("FwResources", "FwConsts.RES_INVALID_OBJECTTYPE", context);
                resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CREATE_RBSCOLLECTION_FAILURE", context));
                resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.formatMessage(str, new String[]{"rbsCollection2"}));
                return false;
            }
        }
        catch (Exception exc) {
            resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CREATE_RBSCOLLECTION_FAILURE", context));
            resultStrings.put("GeneralMsg.MsgBody", exc.toString());
            return false;
        }
        return true;
    }

    public static boolean preCheckScopeRights(ObjectEntry authenticatedUserOE, ObjectEntry scopeOE) {
        AdminNamespace ns = scopeOE.getObjectType().getAdminNamespace();
        try {
            Rights[] aclRights = ns.getPropertyEffectiveRights(scopeOE, authenticatedUserOE, new String[]{"ACL"});
            if (!(aclRights[0].hasReadRights() && aclRights[0].hasWriteRights())) {
                return false;
            }
        }
        catch (Exception exc) {
            return false;
        }
        return true;
    }

    public static boolean preCheckMemberRights(ObjectEntry authenticatedUserOE, ObjectEntry memberOE, String dynamicGroupSearchType) {
        boolean isDynamicAuxClass = false;
        AdminNamespace ns = memberOE.getObjectType().getAdminNamespace();
        ObjectType objectType = memberOE.getObjectType();
        try {
            Rights[] rbsAssignedRolesRights;
            if (dynamicGroupSearchType.equalsIgnoreCase("DynamicGroupObjects&AuxClasses")) {
                Enumeration myenum;
                Rights[] objectClassRights = ns.getPropertyEffectiveRights(memberOE, authenticatedUserOE, new String[]{"Object Class"});
                if (!objectClassRights[0].hasReadRights()) {
                    return false;
                }
                ObjectAttribute oa = ns.getAttribute(memberOE, "Object Class");
                if (oa != null && (myenum = oa.getValueComponents()) != null) {
                    while (myenum.hasMoreElements()) {
                        String value = myenum.nextElement().toString();
                        if (!value.equals("dynamicGroupAux")) continue;
                        isDynamicAuxClass = true;
                        break;
                    }
                }
            }
            if (!((rbsAssignedRolesRights = ns.getPropertyEffectiveRights(memberOE, authenticatedUserOE, new String[]{"rbsAssignedRoles2"}))[0].hasReadRights() && rbsAssignedRolesRights[0].hasWriteRights())) {
                return false;
            }
            if (!isDynamicAuxClass && objectType.getName().equalsIgnoreCase("User")) {
                Rights[] groupMembershipRights = ns.getPropertyEffectiveRights(memberOE, authenticatedUserOE, new String[]{"Group Membership"});
                if (!(groupMembershipRights[0].hasReadRights() && groupMembershipRights[0].hasWriteRights())) {
                    return false;
                }
                Rights[] securityEqualsRights = ns.getPropertyEffectiveRights(memberOE, authenticatedUserOE, new String[]{"Security Equals"});
                if (!(securityEqualsRights[0].hasReadRights() && securityEqualsRights[0].hasWriteRights())) {
                    return false;
                }
            } else {
                Rights[] aclRights = ns.getPropertyEffectiveRights(memberOE, authenticatedUserOE, new String[]{"ACL"});
                if (!(aclRights[0].hasReadRights() && aclRights[0].hasWriteRights())) {
                    return false;
                }
            }
        }
        catch (Exception exc) {
            return false;
        }
        return true;
    }

    public static String preCheckSecondaryRights(MContext context, ObjectEntry authenticatedUserOE, RBSObject[] tasks) {
        int i;
        String noRights = null;
        Hashtable<String, String> objectTable = new Hashtable<String, String>();
        Vector<String> oeV = new Vector<String>();
        AdminNamespace ns = authenticatedUserOE.getObjectType().getAdminNamespace();
        try {
            Element[] secondarySetElements = com.novell.rbs.RBSUtil.getSecondarySetElements((RBSObject[])tasks);
            if (secondarySetElements != null) {
                for (i = 0; i < secondarySetElements.length; ++i) {
                    String contextPath;
                    List rightsAssignmentChildren;
                    Element currentSetElement = secondarySetElements[i];
                    Element contextPathElement = currentSetElement.getChild("context-path");
                    if (contextPathElement == null || (rightsAssignmentChildren = currentSetElement.getChildren("rights-assignment")) == null || (contextPath = contextPathElement.getTextTrim()).length() <= 0) continue;
                    ObjectEntry contextOE = null;
                    if (contextPath.equalsIgnoreCase("[root]")) {
                        contextOE = authenticatedUserOE.getRoot();
                    } else if (ns.doesExist(authenticatedUserOE.getRoot(), contextPath)) {
                        contextOE = ns.getObjectEntry(contextPath);
                    } else {
                        D.log("Unable to check rights for the secondary object " + contextPath + ". Object not found in the tree.");
                        continue;
                    }
                    Element objectTypeElement = currentSetElement.getChild("object-class-type");
                    if (objectTypeElement == null) continue;
                    String objectType = null;
                    objectType = objectTypeElement.getTextTrim();
                    if (objectType.length() <= 0) continue;
                    ResultModifier rm = new ResultModifier("");
                    rm.addFilter(new ResultModifierFilterEntry("*", new String[]{objectType}));
                    ObjectEntryEnumeration children = ns.getChildren(contextOE, rm);
                    while (children.hasMoreElements()) {
                        String child;
                        ObjectEntry childOE = (ObjectEntry)children.nextElement();
                        Rights[] aclRights = ns.getPropertyEffectiveRights(childOE, authenticatedUserOE, new String[]{"ACL"});
                        if (aclRights[0].hasReadRights() && aclRights[0].hasWriteRights() || objectTable.get(child = ns.getUnrootedName(childOE)) != null) continue;
                        objectTable.put(child, child);
                        oeV.add(child);
                    }
                }
            }
        }
        catch (Exception exc) {
            return eMFrameUtils.getExceptionMessage(exc, context);
        }
        if (oeV.size() > 0) {
            StringBuffer sb = new StringBuffer();
            for (i = 0; i < oeV.size(); ++i) {
                if (i == 0) {
                    sb.append(oeV.elementAt(i));
                    continue;
                }
                sb.append(", ");
                sb.append(oeV.elementAt(i));
            }
            noRights = sb.toString();
        }
        return noRights;
    }

    public static void setRBSInstalledGlobalFlag(MContext context, String currentTreeName) {
        boolean needToSet = true;
        String str = FRAMEWORK_STARTUP_RBSINSTALLED + currentTreeName;
        String setting = (String)context.getAuthAttribute(str);
        if (setting != null && setting.equalsIgnoreCase("true")) {
            needToSet = false;
        }
        if (needToSet) {
            context.setAuthAttribute(str, "true");
        }
    }

    public static String getKeyFromParameters(String paramStr, String key) {
        if (paramStr == null || paramStr.length() == 0 || key == null || key.length() == 0) {
            return null;
        }
        Properties parameters = eMFrameUtils.parseParameters(paramStr, ";");
        if (parameters == null) {
            return null;
        }
        return (String)parameters.get(key);
    }

    public static ArrayList checkMemberScopeRightsForRole(MContext context, RBSRole rbsRole) throws SPIException, RBSException, NamespaceException {
        ArrayList<String[]> alErrors = new ArrayList<String[]>();
        String dynamicGroupSearchType = FwUtils.getDynamicSearchType(context);
        ObjectEntry treeOE = rbsRole.getObjectEntry().getRoot();
        AdminNamespace ns = treeOE.getAdminNamespace();
        ObjectEntry whoamiOE = ns.getAuthenticatedIdentity(treeOE);
        RBSAssociation[] rbsAssociation = rbsRole.getMembers();
        if (rbsAssociation != null) {
            String roleName = ns.getUnrootedName(rbsRole.getObjectEntry());
            for (int i = 0; i < rbsAssociation.length; ++i) {
                ObjectEntry scopeOE;
                ObjectEntry memberOE = rbsAssociation[i].getMember();
                boolean error = RBSUtil.preCheckMemberRights(whoamiOE, memberOE, dynamicGroupSearchType);
                if (!error) {
                    String memberName = ns.getUnrootedName(memberOE);
                    alErrors.add(new String[]{memberName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RoleUpdateMember.InsufficientRights", context), new String[]{memberName, roleName}), ""});
                }
                if (error = RBSUtil.preCheckScopeRights(whoamiOE, scopeOE = rbsAssociation[i].getScope())) continue;
                String scopeName = ns.getUnrootedName(scopeOE);
                alErrors.add(new String[]{scopeName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RoleUpdateScope.InsufficientRights", context), new String[]{scopeName, roleName}), ""});
            }
        }
        if (alErrors.size() == 0) {
            alErrors = null;
        }
        return alErrors;
    }

    public static String concatStr(AdminNamespace ns, String str1, String str2) {
        boolean isLDAP = ns.getUniqueID().equalsIgnoreCase("LDAP");
        if (isLDAP) {
            return str1 + "," + str2;
        }
        return str1 + "." + str2;
    }

    public static ObjectEntry getTreeOE(MContext context) {
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        return treeOE;
    }

    public static DirRoleList getDirRoleList(MContext context) {
        DirRoleList dirRoleList = null;
        DirAuthenticator da = DirAuthenticator.getDirAuth(context.getRequest());
        if (da != null) {
            dirRoleList = da.getDirRoleList((FwTaskContext)context);
        }
        return dirRoleList;
    }

    public static String getSystemID(AdminNamespace ns) throws SPIException, NamespaceException {
        if (ns.isSupported("NVDS")) {
            return "NVDS";
        }
        return "eDir";
    }

    public static String getCollectionOwnerObjectTypes(MContext context, AdminNamespace ns) throws NamespaceException, SPIException {
        String collectionOwnerObjectTypes = (String)context.getAuthAttribute("CollectionOwnerObjectTypes");
        if (collectionOwnerObjectTypes == null) {
            StringBuffer collectionOwnerObjectTypesSB = new StringBuffer();
            if (ns.isSupported("NVDS")) {
                ObjectEntry treeOE = RBSUtil.getTreeOE(context);
                SchemaDefinition schemaDef = ns.getSchemaDefinition(treeOE);
                ClassDefinition[] classDef = schemaDef.getClassDefinitions();
                if (classDef != null) {
                    block0: for (int iCount = 0; iCount < classDef.length; ++iCount) {
                        String[] auxClasses = classDef[iCount].getValidAuxClasses();
                        if (auxClasses == null) continue;
                        for (int jCount = 0; jCount < auxClasses.length; ++jCount) {
                            if (!auxClasses[jCount].equalsIgnoreCase("rbsAuxCollectionInfo2")) continue;
                            collectionOwnerObjectTypesSB.append(classDef[iCount].getName());
                            continue block0;
                        }
                    }
                }
            } else {
                collectionOwnerObjectTypesSB.append("User");
                collectionOwnerObjectTypesSB.append(",");
                collectionOwnerObjectTypesSB.append("Group");
            }
            collectionOwnerObjectTypes = collectionOwnerObjectTypesSB.toString();
            context.setAuthAttribute("CollectionOwnerObjectTypes", collectionOwnerObjectTypes);
        }
        return collectionOwnerObjectTypes;
    }

    public static String[] tokenizeObjectTypes(String roleMemberObjectType) {
        String[] roleMemberObjectTypes = null;
        if (roleMemberObjectType != null) {
            StringTokenizer st = new StringTokenizer(roleMemberObjectType, ",");
            roleMemberObjectTypes = new String[st.countTokens()];
            int iCount = 0;
            while (st.hasMoreTokens()) {
                roleMemberObjectTypes[iCount++] = st.nextToken();
            }
        }
        return roleMemberObjectTypes;
    }

    public static String getRoleMemberObjectTypes(MContext context, AdminNamespace ns, boolean selfProvisioningRole) throws NamespaceException, SPIException {
        String roleMemberObjectTypes = null;
        if (selfProvisioningRole) {
            roleMemberObjectTypes = (String)context.getAuthAttribute("SelfProvisioningRoleMemberObjectTypes");
            if (roleMemberObjectTypes == null) {
                StringBuffer roleMemberObjectTypesSB = new StringBuffer();
                roleMemberObjectTypesSB.append("Organization");
                roleMemberObjectTypesSB.append(",");
                roleMemberObjectTypesSB.append("Organizational Unit");
                roleMemberObjectTypesSB.append(",");
                roleMemberObjectTypesSB.append("domain");
                roleMemberObjectTypes = roleMemberObjectTypesSB.toString();
                context.setAuthAttribute("SelfProvisioningRoleMemberObjectTypes", roleMemberObjectTypes);
            }
        } else {
            roleMemberObjectTypes = (String)context.getAuthAttribute("RoleMemberObjectTypes");
            if (roleMemberObjectTypes == null) {
                StringBuffer roleMemberObjectTypesSB = new StringBuffer();
                if (ns.isSupported("NVDS")) {
                    ObjectEntry treeOE = RBSUtil.getTreeOE(context);
                    SchemaDefinition schemaDef = ns.getSchemaDefinition(treeOE);
                    ClassDefinition[] classDef = schemaDef.getClassDefinitions();
                    if (classDef != null) {
                        block0: for (int iCount = 0; iCount < classDef.length; ++iCount) {
                            String[] auxClasses = classDef[iCount].getValidAuxClasses();
                            if (auxClasses == null) continue;
                            for (int jCount = 0; jCount < auxClasses.length; ++jCount) {
                                if (!auxClasses[jCount].equalsIgnoreCase("rbsAuxRoleInfo2")) continue;
                                roleMemberObjectTypesSB.append(classDef[iCount].getName());
                                continue block0;
                            }
                        }
                    }
                } else {
                    roleMemberObjectTypesSB.append("Organization");
                    roleMemberObjectTypesSB.append(",");
                    roleMemberObjectTypesSB.append("Organizational Unit");
                    roleMemberObjectTypesSB.append(",");
                    roleMemberObjectTypesSB.append("domain");
                    roleMemberObjectTypesSB.append(",");
                    roleMemberObjectTypesSB.append("User");
                    roleMemberObjectTypesSB.append(",");
                    roleMemberObjectTypesSB.append("Group");
                    roleMemberObjectTypesSB.append(",");
                    roleMemberObjectTypesSB.append("Organizational Role");
                    SystemConfig systemConfig = SystemConfig.getSystemConfig(context);
                    String dynamicGroupEnabled = systemConfig.getSetting("Provider.eMFrame.DynamicGroup.enable");
                    if (dynamicGroupEnabled != null) {
                        roleMemberObjectTypesSB.append(",");
                        roleMemberObjectTypesSB.append("dynamicGroup");
                        String dynamicGroupSearchType = systemConfig.getSetting("Provider.eMFrame.DynamicGroup.Searchtype");
                        if (dynamicGroupSearchType != null && dynamicGroupSearchType.equalsIgnoreCase("DynamicGroupObjects&AuxClasses")) {
                            roleMemberObjectTypesSB.append(",");
                            roleMemberObjectTypesSB.append("dynamicGroupAux");
                        }
                    }
                }
                roleMemberObjectTypes = roleMemberObjectTypesSB.toString();
                context.setAuthAttribute("RoleMemberObjectTypes", roleMemberObjectTypes);
            }
        }
        return roleMemberObjectTypes;
    }

    public static String getCollectionContainmentTypes(MContext context, ObjectEntry oe) throws SPIException, NamespaceException {
        String collectionContainmentTypes = (String)context.getAuthAttribute("collectionContainmentTypes");
        if (collectionContainmentTypes == null) {
            AdminNamespace ns = oe.getAdminNamespace();
            SchemaDefinition schemaDef = ns.getSchemaDefinition(oe);
            ClassDefinition classDef = schemaDef.getClassDefinition("rbsCollection2");
            String[] containment = classDef.getContainmentClasses();
            if (containment != null) {
                // empty if block
            }
            StringBuffer collectionContainmentTypesSB = new StringBuffer();
            for (int iCount = 0; iCount < containment.length; ++iCount) {
                if (iCount != 0) {
                    collectionContainmentTypesSB.append(",");
                }
                collectionContainmentTypesSB.append(containment[iCount]);
            }
            collectionContainmentTypes = collectionContainmentTypesSB.toString();
            context.setAuthAttribute("collectionContainmentTypes", collectionContainmentTypes);
        }
        return collectionContainmentTypes;
    }

    static boolean setAliasControl(AdminNamespace ns) {
        boolean controlPreviouslySet = true;
        try {
            if (ns.isSupported("NVDS")) {
                controlPreviouslySet = ((LDAPNamespace)ns).setControl("2.16.840.1.113719.1.27.101.19");
            }
        }
        catch (Exception exc) {
            Debug.out((String)exc.getMessage());
        }
        return controlPreviouslySet;
    }

    static void clearAliasControl(AdminNamespace ns, boolean controlPreviouslySet) {
        try {
            if (ns.isSupported("NVDS") && !controlPreviouslySet) {
                ((LDAPNamespace)ns).clearControl("2.16.840.1.113719.1.27.101.19");
            }
        }
        catch (Exception exc) {
            Debug.out((String)exc.getMessage());
        }
    }

    static String getModuleDisplayName(MContext context, ObjectEntry oe) {
        String objectType;
        int index;
        boolean isLDAP = oe.getAdminNamespace().getUniqueID().equalsIgnoreCase("LDAP");
        String id = oe.getName();
        if (isLDAP && (index = id.indexOf("=")) != -1) {
            id = id.substring(index + 1);
        }
        if ((objectType = oe.getObjectType().getName()).equalsIgnoreCase("rbsBook2") || objectType.equalsIgnoreCase("rbsTask2")) {
            int index2;
            String name = oe.getParent().getName();
            if (isLDAP && (index2 = name.indexOf("=")) != -1) {
                name = name.substring(index2 + 1);
            }
            id = name + "." + id;
        }
        return id;
    }

    static String getLocalizedDisplayName(MContext context, ObjectEntry oe) {
        String roleDisplayName;
        String resourceBundle;
        String objectType;
        int index;
        String id;
        boolean isLDAP = oe.getAdminNamespace().getUniqueID().equalsIgnoreCase("LDAP");
        String displayName = id = oe.getName();
        Registry reg = Registry.getRegistry("Install");
        if (isLDAP && (index = id.indexOf("=")) != -1) {
            id = id.substring(index + 1);
        }
        if ((objectType = oe.getObjectType().getName()).equalsIgnoreCase("rbsBook2") || objectType.equalsIgnoreCase("rbsTask2")) {
            int index2;
            String name = oe.getParent().getName();
            if (isLDAP && (index2 = name.indexOf("=")) != -1) {
                name = name.substring(index2 + 1);
            }
            id = name + "." + id;
        }
        if ((resourceBundle = reg.getPluginSettingFromDoc(id, "resource-properties-file")) != null && (roleDisplayName = reg.getPluginSettingFromDoc(id, "display-name-key")) != null && (displayName = eMFrameUtils.getLocalizedString(resourceBundle, roleDisplayName, context.getLocale())) == null) {
            displayName = id;
        }
        return displayName;
    }

    static String getLocalizedModuleDisplayName(MContext context, String id) {
        String roleDisplayName;
        Registry reg;
        String resourceBundle;
        String displayName = id;
        if (id.startsWith("cn=")) {
            id = id.substring(3);
        }
        if ((resourceBundle = (reg = Registry.getRegistry("Install")).getModuleSettingFromDoc(id, "resource-properties-file")) != null && (roleDisplayName = reg.getModuleSettingFromDoc(id, "display-name-key")) != null && (displayName = eMFrameUtils.getLocalizedString(resourceBundle, roleDisplayName, context.getLocale())) == null) {
            displayName = id;
        }
        return displayName;
    }

    static String getLocalizedDescriptionName(MContext context, ObjectEntry oe) {
        String roleDescriptionKey;
        String resourceBundle;
        String objectType;
        int index;
        boolean isLDAP = oe.getAdminNamespace().getUniqueID().equalsIgnoreCase("LDAP");
        String id = oe.getName();
        String description = null;
        Registry reg = Registry.getRegistry("Install");
        if (isLDAP && (index = id.indexOf("=")) != -1) {
            id = id.substring(index + 1);
        }
        if ((objectType = oe.getObjectType().getName()).equalsIgnoreCase("rbsBook2") || objectType.equalsIgnoreCase("rbsTask2")) {
            int index2;
            String name = oe.getParent().getName();
            if (isLDAP && (index2 = name.indexOf("=")) != -1) {
                name = name.substring(index2 + 1);
            }
            id = name + "." + id;
        }
        if ((resourceBundle = reg.getPluginSettingFromDoc(id, "resource-properties-file")) != null && (roleDescriptionKey = reg.getPluginSettingFromDoc(id, "description-key")) != null && (description = eMFrameUtils.getLocalizedString(resourceBundle, roleDescriptionKey, context.getLocale())) == null) {
            description = id;
        }
        if (description == null) {
            description = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NO_DESCRIPTION", context);
        }
        return description;
    }

    static String formatLDAPString(String oldStr) {
        if (oldStr.toLowerCase().startsWith("cn=")) {
            oldStr = oldStr.substring(3);
        }
        oldStr = "cn=".concat(oldStr);
        return oldStr;
    }

    static String getDescFromAttr(ObjectEntry objectEntry, MContext context) throws SPIException {
        String categoryDescription = null;
        AdminNamespace namespace = objectEntry.getAdminNamespace();
        ObjectAttribute categoryDescAttr = namespace.getAttribute(objectEntry, SchemaUtil.translateNDAPAttr((ObjectEntry)objectEntry, (String)"Description"));
        categoryDescription = categoryDescAttr != null ? categoryDescAttr.toString() : RBSUtil.getLocalizedDescriptionName(context, objectEntry);
        return categoryDescription;
    }

    public static String getPageDisplayName(String pageId, MContext context) {
        String displayName = pageId;
        Document doc = GlobalRegistry.getPluginDocument(pageId);
        if (doc != null) {
            String resFile = doc.getRootElement().getChildTextTrim("resource-properties-file");
            String resKey = doc.getRootElement().getChildTextTrim("display-name-key");
            if (resFile != null && resKey != null && ((displayName = eMFrameUtils.getLocalizedString(resFile, resKey, context)) == null || displayName.length() == 0)) {
                displayName = pageId;
            }
        }
        return displayName;
    }

    public static String urlEncodePack(String str, MContext context) {
        String[] list = new String[]{eMFrameUtils.urlEncode(str, context)};
        return eMFrameUtils.pack(list, context);
    }
}

