/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.eMFrameUtils;
import java.io.ByteArrayInputStream;
import java.util.ArrayList;
import java.util.Vector;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;

public class ReadXml {
    public static final String RECORD_CHAR_SET = "UTF-8";
    public static final String ROOT_CONFIG_ELEMENT = "info";
    public static final String MISC_CONFIG_ELEMENT = "miscellaneous";
    public static final String PLATFORMS_CONFIG_ELEMENT = "supported_platforms";
    public static final String VERSIONS_CONFIG_ELEMENT = "recommended_versions";
    public static final String CHANGELOG_CONFIG_ELEMENT = "change_log";
    public static final String BUILDNUMBER_CONFIG_ELEMENT = "build_number";
    public static final String ENTRY_CONFIG_ELEMENT = "entry";
    public static final String INSTRUCTIONS_CONFIG_ELEMENT = "special_instruction";
    public static final String DEPENDENCIES_CONFIG_ELEMENT = "dependencies";
    public static final String MODULEID_CONFIG_ELEMENT = "moduleId";
    private ArrayList misc = new ArrayList();
    private ArrayList supportedplatforms = new ArrayList();
    private ArrayList recommendedversions = new ArrayList();
    private ArrayList specialinstructions = new ArrayList();
    private ArrayList changelog = new ArrayList();
    private ArrayList buildnumber = new ArrayList();
    private ArrayList entry = new ArrayList();
    private ArrayList moduleid = new ArrayList();
    private ArrayList dependencies = new ArrayList();
    private Document mdocument = null;
    private MContext mcontext;

    public String[] getMisc() {
        try {
            int len = this.misc.size();
            String[] miStrings = new String[len];
            for (int i = 0; i < len; ++i) {
                miStrings[i] = this.misc.get(i).toString();
            }
            return miStrings;
        }
        catch (Exception e) {
            D.log("Caught Exception" + e);
            return null;
        }
    }

    public String[] getSpecialInstructions() {
        try {
            int len = this.specialinstructions.size();
            String[] spStrings = new String[len];
            for (int i = 0; i < len; ++i) {
                spStrings[i] = this.specialinstructions.get(i).toString();
            }
            return spStrings;
        }
        catch (Exception e) {
            D.log("Caught Exception" + e);
            return null;
        }
    }

    public String[] getSupportedPlatforms() {
        try {
            int len = this.supportedplatforms.size();
            String[] suStrings = new String[len];
            for (int i = 0; i < len; ++i) {
                suStrings[i] = this.supportedplatforms.get(i).toString();
            }
            return suStrings;
        }
        catch (Exception e) {
            D.log("Caught Exception" + e);
            return null;
        }
    }

    public String[] getRecommendedVersions() {
        try {
            int len = this.recommendedversions.size();
            String[] reStrings = new String[len];
            for (int i = 0; i < len; ++i) {
                reStrings[i] = this.recommendedversions.get(i).toString();
            }
            return reStrings;
        }
        catch (Exception e) {
            D.log("Caught Exception" + e);
            return null;
        }
    }

    public String[] getChangeLog() {
        try {
            int len = this.changelog.size();
            String[] chStrings = new String[len];
            for (int i = 0; i < len; ++i) {
                chStrings[i] = this.changelog.get(i).toString();
            }
            return chStrings;
        }
        catch (Exception e) {
            D.log("Caught Exception" + e);
            return null;
        }
    }

    public String[] getBuildNumber() {
        try {
            int len = this.buildnumber.size();
            String[] buStrings = new String[len];
            for (int i = 0; i < len; ++i) {
                buStrings[i] = this.buildnumber.get(i).toString();
            }
            return buStrings;
        }
        catch (Exception e) {
            D.log("Caught Exception" + e);
            return null;
        }
    }

    public String[] getEntry() {
        try {
            int len = this.entry.size();
            String[] enStrings = new String[len];
            for (int i = 0; i < len; ++i) {
                enStrings[i] = this.entry.get(i).toString();
            }
            return enStrings;
        }
        catch (Exception e) {
            D.log("Caught Exception" + e);
            return null;
        }
    }

    public String[] getModuleId() {
        try {
            int len = this.moduleid.size();
            String[] moStrings = new String[len];
            for (int i = 0; i < len; ++i) {
                moStrings[i] = this.moduleid.get(i).toString();
            }
            return moStrings;
        }
        catch (Exception e) {
            D.log("Caught Exception" + e);
            return null;
        }
    }

    public String[] getDependencies() {
        try {
            int len = this.dependencies.size();
            String[] deStrings = new String[len];
            for (int i = 0; i < len; ++i) {
                deStrings[i] = this.dependencies.get(i).toString();
            }
            return deStrings;
        }
        catch (Exception e) {
            D.log("Caught Exception" + e);
            return null;
        }
    }

    public void setSetting(String setting, String[] values) {
        try {
            if (setting.equalsIgnoreCase(MISC_CONFIG_ELEMENT)) {
                this.misc.add(values[0]);
            }
            if (setting.equalsIgnoreCase(PLATFORMS_CONFIG_ELEMENT)) {
                this.supportedplatforms.add(values[0]);
            }
            if (setting.equalsIgnoreCase(INSTRUCTIONS_CONFIG_ELEMENT)) {
                this.specialinstructions.add(values[0]);
            }
            if (setting.equalsIgnoreCase(VERSIONS_CONFIG_ELEMENT)) {
                this.recommendedversions.add(values[0]);
            }
            if (setting.equalsIgnoreCase(DEPENDENCIES_CONFIG_ELEMENT)) {
                this.dependencies.add(values[0]);
            }
            if (setting.equalsIgnoreCase(MODULEID_CONFIG_ELEMENT)) {
                this.moduleid.add(values[0]);
            }
            if (setting.equalsIgnoreCase(CHANGELOG_CONFIG_ELEMENT)) {
                String[] changelog = (String[])values.clone();
                for (int i = 0; i < changelog.length; ++i) {
                    this.changelog.add(changelog[i]);
                }
            }
        }
        catch (Exception e) {
            D.log("Caught Exception" + e);
        }
    }

    private void buildDom(String data) {
        if (data == null) {
            return;
        }
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            ByteArrayInputStream ba = new ByteArrayInputStream(data.getBytes(RECORD_CHAR_SET));
            this.mdocument = builder.parse(ba);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void readDom() {
        try {
            if (this.mdocument == null) {
                return;
            }
            Document root = this.mdocument;
            NodeList nl = root.getChildNodes();
            if (nl.getLength() == 0) {
                return;
            }
            Node rootElement = nl.item(0);
            if (!rootElement.getNodeName().equals(ROOT_CONFIG_ELEMENT)) {
                return;
            }
            NodeList infoSetting = rootElement.getChildNodes();
            for (int i = 0; i < infoSetting.getLength(); ++i) {
                Node valueData;
                Node infoElement = infoSetting.item(i);
                if (infoElement.getNodeType() != 1 || !infoElement.getNodeName().equals(PLATFORMS_CONFIG_ELEMENT) && !infoElement.getNodeName().equals(VERSIONS_CONFIG_ELEMENT) && !infoElement.getNodeName().equals(MISC_CONFIG_ELEMENT) && !infoElement.getNodeName().equals(CHANGELOG_CONFIG_ELEMENT) && !infoElement.getNodeName().equals(BUILDNUMBER_CONFIG_ELEMENT) && !infoElement.getNodeName().equals(ENTRY_CONFIG_ELEMENT) && !infoElement.getNodeName().equals(DEPENDENCIES_CONFIG_ELEMENT) && !infoElement.getNodeName().equals(MODULEID_CONFIG_ELEMENT) && !infoElement.getNodeName().equals(INSTRUCTIONS_CONFIG_ELEMENT)) continue;
                Vector<String> vValues = new Vector<String>();
                if (infoElement.getNodeName().equals(MISC_CONFIG_ELEMENT)) {
                    valueData = infoElement.getFirstChild();
                    if (valueData != null && (valueData.getNodeType() == 4 || valueData.getNodeType() == 3)) {
                        vValues.add(XmlUtils.xmlDecode(valueData.getNodeValue()));
                    }
                } else if (infoElement.getNodeName().equals(PLATFORMS_CONFIG_ELEMENT)) {
                    valueData = infoElement.getFirstChild();
                    if (valueData != null && (valueData.getNodeType() == 4 || valueData.getNodeType() == 3)) {
                        vValues.add(XmlUtils.xmlDecode(valueData.getNodeValue()));
                    }
                } else if (infoElement.getNodeName().equals(VERSIONS_CONFIG_ELEMENT)) {
                    valueData = infoElement.getFirstChild();
                    if (valueData != null && (valueData.getNodeType() == 4 || valueData.getNodeType() == 3)) {
                        vValues.add(XmlUtils.xmlDecode(valueData.getNodeValue()));
                    }
                } else if (infoElement.getNodeName().equals(CHANGELOG_CONFIG_ELEMENT)) {
                    NodeList Childs = infoElement.getChildNodes();
                    vValues.add("<br>");
                    for (int j = 0; j < Childs.getLength(); ++j) {
                        Node valueData2;
                        Node childElement = Childs.item(j);
                        if (childElement.getNodeType() != 1) continue;
                        if (childElement.getNodeName().equals(BUILDNUMBER_CONFIG_ELEMENT)) {
                            valueData2 = childElement.getFirstChild();
                            if (valueData2 == null || valueData2.getNodeType() != 4 && valueData2.getNodeType() != 3) continue;
                            vValues.add(" <font size='2'><b>" + eMFrameUtils.getLocalizedString("FwResources", "PluginInfo.BuildNumber", this.mcontext.getLocale()) + ":</b></font>");
                            vValues.add(XmlUtils.xmlDecode(valueData2.getNodeValue()));
                            vValues.add("<br>");
                            continue;
                        }
                        if (!childElement.getNodeName().equals(ENTRY_CONFIG_ELEMENT) || (valueData2 = childElement.getFirstChild()) == null || valueData2.getNodeType() != 4 && valueData2.getNodeType() != 3) continue;
                        vValues.add(eMFrameUtils.getLocalizedString("FwResources", "PluginInfo.Entry", this.mcontext.getLocale()) + ":");
                        vValues.add(XmlUtils.xmlDecode(valueData2.getNodeValue()));
                        vValues.add("<br>");
                    }
                } else if (infoElement.getNodeName().equals(DEPENDENCIES_CONFIG_ELEMENT)) {
                    valueData = infoElement.getFirstChild();
                    if (valueData != null && (valueData.getNodeType() == 4 || valueData.getNodeType() == 3)) {
                        vValues.add(XmlUtils.xmlDecode(valueData.getNodeValue()));
                    }
                } else if (infoElement.getNodeName().equals(INSTRUCTIONS_CONFIG_ELEMENT) && (valueData = infoElement.getFirstChild()) != null && (valueData.getNodeType() == 4 || valueData.getNodeType() == 3)) {
                    vValues.add(XmlUtils.xmlDecode(valueData.getNodeValue()));
                }
                if (infoElement.getNodeName() == null || vValues.size() <= 0) continue;
                String[] saTemp = new String[vValues.size()];
                vValues.toArray(saTemp);
                this.setSetting(infoElement.getNodeName(), saTemp);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void read(String is) {
        try {
            int iSize = is.length();
            byte[] ba = new byte[iSize];
            ba = is.getBytes();
            String sTemp = new String(ba, 0, iSize, RECORD_CHAR_SET);
            this.buildDom(sTemp);
            this.readDom();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void setcontext(MContext m_context) {
        this.mcontext = m_context;
    }
}

