/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.HandlerComparator;
import com.novell.emframe.fw.PluginDocNode;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.util.PluginDocComparator;
import com.novell.emframe.fw.util.iManagerJDOMFactory;
import com.novell.emframe.fw.util.infos.Info;
import com.novell.nps.serviceProviders.ShellCommand;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import java.util.Properties;
import java.util.Set;
import java.util.TreeSet;
import java.util.Vector;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;

public class Registry {
    public static final String IMANAGER_REGISTRATION_KEY = "iManager";
    private static final List defaultDevices = Arrays.asList("browser", "default", "mozilla");
    private HashMap m_runnableTasks = new HashMap();
    private Hashtable m_infoReg = new Hashtable();
    private Hashtable m_reg = new Hashtable();
    private Hashtable m_attrHandlerReg = new Hashtable();
    private Hashtable m_syntaxHandlerReg = new Hashtable();
    private ArrayList m_gatewayConfigPlugins = new ArrayList();
    private ArrayList m_printerControlPlugins = new ArrayList();
    private Hashtable m_tasksByRole = new Hashtable();
    private Hashtable m_rolesByView = new Hashtable();
    private Hashtable m_privatePageReg = new Hashtable();
    private Hashtable m_pageReg = new Hashtable();
    private List m_allPages = new ArrayList();
    private HashMap m_pagesChapter = new HashMap();
    private Hashtable m_pageBlockerReg = new Hashtable();
    private Hashtable m_creatorReg = new Hashtable();
    private Hashtable m_deletorReg = new Hashtable();
    private Hashtable m_moveReg = new Hashtable();
    private Hashtable m_renameReg = new Hashtable();
    private ArrayList m_bookAddons = new ArrayList();
    private Hashtable m_classLoaders = new Hashtable();
    private Hashtable m_chainingTable = new Hashtable();
    private Hashtable m_realServiceNames = new Hashtable();
    private Hashtable m_objectTranslator = new Hashtable();
    private Hashtable m_attributeTranslator = new Hashtable();
    private Hashtable m_directoryEventListenerReg = new Hashtable();
    Hashtable m_tasksByType = new Hashtable();
    private ArrayList m_views = new ArrayList();
    private Hashtable m_creatorSilentChainingPlugins = new Hashtable();
    private Hashtable m_eMailEventPlugins = new Hashtable();
    private HashMap m_hmCategory = new HashMap();
    private Hashtable m_authenticators = new Hashtable();
    private HashMap m_authenticatorRunnables = new HashMap();
    private static boolean isOES = false;
    private boolean m_bGlobal;
    private static Registry sm_metaInstallReg = new Registry("Install");
    private static Registry sm_metaGlobalReg = new Registry("Global");
    private HashMap m_hmModules = new HashMap();
    private static Map m_participantOpsByTypes = new HashMap();
    private Hashtable m_uiAttrHandleDocs = new Hashtable();
    private Hashtable m_uiSyntaxHandleDocs = new Hashtable();
    private Hashtable m_uiAttrClassHandleDocs = new Hashtable();
    private Hashtable m_uiExclusiveAttrClassHandleDocs = new Hashtable();
    private Hashtable m_uiExclusiveAttrHandleDocs = new Hashtable();
    private HandlerComparator handlerComparator = new HandlerComparator();

    public static Registry getRegistry(String reg) {
        D.assrt(reg.equals("Global") || reg.equals("Install"), "Invalid Registry type");
        if (reg.startsWith("G")) {
            return sm_metaGlobalReg;
        }
        if (reg.startsWith("I")) {
            return sm_metaInstallReg;
        }
        return null;
    }

    public Registry(String name) {
        this.m_bGlobal = name.equals("Global");
    }

    public Info getPluginInfo(String id) {
        return (Info)this.m_infoReg.get(id);
    }

    public Document getPluginDocument(String id) {
        return (Document)this.m_reg.get(id);
    }

    public String getPluginSettingFromDoc(String id, String settingName) {
        Document doc = this.getPluginDocument(id);
        String value = null;
        if (doc != null) {
            value = doc.getRootElement().getChildTextTrim(settingName);
        }
        return value;
    }

    public Document getModuleDocument(String id) {
        return (Document)this.m_hmModules.get(id);
    }

    public String getModuleSettingFromDoc(String id, String settingName) {
        Document doc = this.getModuleDocument(id);
        String value = null;
        if (doc != null) {
            value = doc.getRootElement().getChildTextTrim(settingName);
        }
        return value;
    }

    public static void refreshGlobalRegistry() {
        sm_metaGlobalReg = new Registry("Global");
        sm_metaGlobalReg.populateTables();
        GlobalRegistry.reg = sm_metaGlobalReg;
    }

    public static void refreshInstallRegistry() {
        sm_metaInstallReg = new Registry("Install");
        sm_metaInstallReg.populateTables();
        FwUtils.checkShowDeveloperWarnings();
    }

    public void populateTables() {
        String type = null;
        boolean installXml = false;
        if (this.m_bGlobal) {
            type = "plugins";
        } else {
            type = "install";
            installXml = true;
        }
        ArrayList xmlFiles = Registry.getXmlFiles(type);
        for (int i = 0; i < xmlFiles.size(); ++i) {
            File file = (File)xmlFiles.get(i);
            this.registerFile(file, installXml);
        }
        this.resolveBookAddons();
    }

    public void resolveBookAddons() {
        for (int i = 0; i < this.m_bookAddons.size(); ++i) {
            try {
                Document doc = (Document)this.m_bookAddons.get(i);
                Element root = doc.getRootElement();
                String bookId = root.getChildTextTrim("book-id");
                Document bookDoc = (Document)this.m_reg.get(bookId);
                if (bookDoc == null) {
                    D.log("Registry::resolveBookAddons Could not find book to add pages to.  Book id:" + bookId);
                    continue;
                }
                Element bookRoot = bookDoc.getRootElement();
                List list = root.getChildren("page-assignment");
                ListIterator iterator = list.listIterator();
                while (iterator.hasNext()) {
                    Element page = (Element)iterator.next();
                    bookRoot.addContent(new Element("page-assignment").setText(page.getTextTrim()));
                }
                continue;
            }
            catch (Exception e) {
                D.log(e);
            }
        }
    }

    public static ArrayList getXmlFiles(String type) {
        File[] moduleDirectories;
        ArrayList xmlFiles = new ArrayList();
        File modulesParentDirectory = new File(eMFrameUtils.getModulesBasePath());
        if (modulesParentDirectory != null && modulesParentDirectory.isDirectory() && (moduleDirectories = modulesParentDirectory.listFiles()) != null) {
            for (int i = 0; i < moduleDirectories.length; ++i) {
                File moduleDirectory = moduleDirectories[i];
                if (!moduleDirectory.isDirectory()) continue;
                File pluginDirectory = new File(moduleDirectory, type);
                Registry.processDirectoryStructure(pluginDirectory, xmlFiles);
            }
        }
        return xmlFiles;
    }

    private static void processDirectoryStructure(File dir, ArrayList xmlFiles) {
        File[] children;
        if (dir.exists() && (children = dir.listFiles()) != null) {
            for (int j = 0; j < children.length; ++j) {
                File f = children[j];
                if (f.isFile() && f.getName().toLowerCase().endsWith("xml")) {
                    xmlFiles.add(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                Registry.processDirectoryStructure(f, xmlFiles);
            }
        }
    }

    private void registerFile(File file, boolean installXml) {
        try {
            String module = file.getParent();
            Document doc = Registry.parseXMLFile(file);
            Element root = doc.getRootElement();
            String strType = root.getName();
            String moduleId = null;
            Element moduleEl = root.getChild("module");
            if (moduleEl != null) {
                moduleId = moduleEl.getChildTextTrim("id");
            }
            if (strType.equals("plugins") || strType.equals("install")) {
                boolean nonds = false;
                if (moduleEl != null && moduleEl.getChild("non-ds") != null) {
                    nonds = true;
                }
                List list = root.getChildren();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    try {
                        Element element = (Element)iterator.next();
                        Document newDoc = new Document((Element)element.clone());
                        this.addNode(module, newDoc, file, moduleId, installXml, nonds);
                    }
                    catch (Throwable t) {
                        D.log(t);
                    }
                }
            } else {
                this.addNode(module, doc, file);
            }
        }
        catch (Exception e) {
            D.log(e);
            D.log("GlobalRegistry::Error processing file: " + file.getName() + ", ignoring file");
        }
    }

    public static Document parseXMLFile(File file) throws JDOMException, IOException {
        Document docRet = null;
        SAXBuilder saxBuilder = new SAXBuilder(false);
        saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        saxBuilder.setFactory((JDOMFactory)iManagerJDOMFactory.getInstance());
        docRet = saxBuilder.build(file);
        return docRet;
    }

    public String getRealServiceName(String serviceName) {
        String realServiceName = null;
        realServiceName = (String)this.m_realServiceNames.get(serviceName);
        if (realServiceName == null) {
            realServiceName = serviceName;
        }
        return realServiceName;
    }

    public void addNode(String module, Document doc, File file) {
        this.addNode(module, doc, file, null, false, false);
    }

    public void addOrReplaceNode(String module, Document doc, File file, boolean installXml) {
        this.removeNode(doc);
        this.addNode(module, doc, file, module, installXml, false);
    }

    public void addNode(String module, Document doc, File file, String moduleId, boolean installXml, boolean nonds) {
        String registerInNPS;
        Element root = doc.getRootElement();
        String id = root.getChildTextTrim("id");
        String strNodeType = root.getName();
        if (strNodeType.equals("module")) {
            this.m_hmModules.put(id, doc);
            return;
        }
        if (id != null) {
            Registry oppReg = null;
            oppReg = this.m_bGlobal ? Registry.getRegistry("Install") : Registry.getRegistry("Global");
            if (!(this.m_reg.get(id) == null && oppReg.m_reg.get(id) == null || strNodeType.equals("role") || strNodeType.equals("module"))) {
                D.assrt(false, "GlobalRegistry::More than one plug-in trying to register with the same id, ignoring all but the first one. id=" + id);
                return;
            }
        }
        if (strNodeType.equals("page") || strNodeType.equals("task") || strNodeType.equals("book") || strNodeType.equals("chained-task")) {
            root.addContent(new Element("descriptor-dir").addContent(module));
        }
        if (id != null) {
            this.m_reg.put(id, doc);
            this.m_infoReg.put(id, new Info(doc, file));
        }
        if ((registerInNPS = root.getChildTextTrim("register-gadget")) != null && registerInNPS.equals("true")) {
            this.addToRunnableList(doc);
        }
        if (strNodeType.equals("page")) {
            this.registerPage(doc);
        } else if (strNodeType.equals("category")) {
            this.m_hmCategory.put(id, doc);
        } else if (strNodeType.equals("private-page")) {
            this.registerPrivatePage(doc);
        } else if (strNodeType.equals("page-blocker")) {
            this.registerPageBlocker(doc);
        } else if (strNodeType.equals("view")) {
            this.registerView(doc);
        } else if (strNodeType.equals("dir-translator")) {
            this.registerDirTranslator(doc);
        } else if (strNodeType.equals("data-attribute-handler")) {
            this.registerAttrHandler(doc);
        } else if (strNodeType.equals("data-syntax-handler")) {
            this.registerSyntaxHandler(doc);
        } else if (strNodeType.equals("ui-attribute-handler")) {
            this.registerUiAttrHandler(doc);
        } else if (strNodeType.equals("ui-syntax-handler")) {
            this.registerUiSyntaxHandler(doc);
        } else if (strNodeType.equalsIgnoreCase("object-creator")) {
            this.registerCreator(doc);
        } else if (strNodeType.equalsIgnoreCase("object-deletor")) {
            this.registerDeletor(doc);
        } else if (strNodeType.equalsIgnoreCase("object-move")) {
            this.registerMove(doc);
        } else if (strNodeType.equalsIgnoreCase("object-rename")) {
            this.registerRename(doc);
        } else if (strNodeType.equalsIgnoreCase("base-operation-participant")) {
            this.registerParticipant(doc);
        } else if (strNodeType.equals("printer-control-plugin")) {
            this.registerPrinterControlPlugin(doc);
        } else if (strNodeType.equals("gateway-config")) {
            this.registerGatewayConfigPlugin(doc);
        } else if (strNodeType.equals("task") || strNodeType.equals("book")) {
            this.registerTask(doc);
            this.addToRealServiceNameTable(moduleId, installXml, id);
        } else if (strNodeType.equals("role")) {
            this.registerRole(doc, nonds);
        } else if (strNodeType.equals("class-loader")) {
            this.registerClassLoader(doc);
        } else if (strNodeType.equals("creator-silent-chaining")) {
            this.registerCreatorSilentChainingPlugins(doc);
        } else if (strNodeType.equals("book-addon")) {
            this.registerBookAddonPlugin(doc);
        } else if (strNodeType.equals("chained-task")) {
            this.registerChainedTask(doc);
            this.addToRealServiceNameTable(moduleId, installXml, id);
        } else if (strNodeType.equals("email-event")) {
            this.registerEmailEventPlugin(doc);
        } else if (strNodeType.equals("authenticator")) {
            this.m_authenticators.put(id, doc);
        } else if (strNodeType.equalsIgnoreCase("directory-event-listener")) {
            this.registerDirectoryListener(doc);
        }
    }

    private void registerParticipant(Document doc) {
        Element root = doc.getRootElement();
        List listTypes = root.getChildren("object-type-name");
        List listOperations = root.getChildren("operation-type");
        ListIterator iterTypes = listTypes.listIterator();
        while (iterTypes.hasNext()) {
            Element currentType = (Element)iterTypes.next();
            String strCurrentType = currentType.getTextTrim();
            HashMap<String, ArrayList<Document>> hmParticipantDocsByOperationForType = (HashMap<String, ArrayList<Document>>)m_participantOpsByTypes.get(strCurrentType);
            if (hmParticipantDocsByOperationForType == null) {
                hmParticipantDocsByOperationForType = new HashMap<String, ArrayList<Document>>();
                m_participantOpsByTypes.put(strCurrentType, hmParticipantDocsByOperationForType);
            }
            ListIterator iterOps = listOperations.listIterator();
            while (iterOps.hasNext()) {
                Element currentOp = (Element)iterOps.next();
                String strCurrentOp = currentOp.getTextTrim();
                ArrayList<Document> participantDocsForOpAndType = (ArrayList<Document>)hmParticipantDocsByOperationForType.get(strCurrentOp);
                if (participantDocsForOpAndType == null) {
                    participantDocsForOpAndType = new ArrayList<Document>();
                    hmParticipantDocsByOperationForType.put(strCurrentOp, participantDocsForOpAndType);
                }
                participantDocsForOpAndType.add(doc);
            }
        }
    }

    public Document getAuthenticator(String id) {
        return (Document)this.m_authenticators.get(id);
    }

    public Hashtable getAuthenticators() {
        return this.m_authenticators;
    }

    private void registerEmailEventPlugin(Document doc) {
        String id = doc.getRootElement().getChildTextTrim("id");
        if (id != null) {
            this.m_eMailEventPlugins.put(id, doc);
        }
    }

    public Document getEmailEventPlugin(String id) {
        return (Document)this.m_eMailEventPlugins.get(id);
    }

    public Hashtable getAllEmailEventPlugins() {
        return this.m_eMailEventPlugins;
    }

    private void addToRealServiceNameTable(String moduleId, boolean installXml, String id) {
        try {
            int dot;
            String id1;
            if (moduleId != null && installXml && !(id1 = (dot = id.indexOf(46)) >= 0 ? moduleId + id.substring(dot) : moduleId + "." + id).equals(id)) {
                this.m_realServiceNames.put(id1, id);
            }
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    public void removeNodeByPluginID(String pluginID) {
        this.removeNode(this.getPluginDocument(pluginID));
    }

    public void removeNode(Document doc) {
        Element root = doc.getRootElement();
        String id = root.getChildTextTrim("id");
        this.m_reg.remove(id);
        if (root.getName().equals("object-creator")) {
            this.removeCreator(doc);
        }
    }

    public void removeCreator(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("object-type-name");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            Element currentType = (Element)iterator.next();
            String strCurrentType = currentType.getTextTrim().toLowerCase();
            D.log("Removing Creator document.  Type: " + currentType + "   strType: " + strCurrentType);
            HashMap creatorsForTypeBySystem = (HashMap)this.m_creatorReg.get(strCurrentType);
            if (creatorsForTypeBySystem == null) continue;
            Set systems = FwAuthUtils.getAuthSettingForPlugin(null, doc, "dir", "system");
            if (systems.isEmpty()) {
                creatorsForTypeBySystem.remove("eDir");
                continue;
            }
            for (String systemId : systems) {
                creatorsForTypeBySystem.remove(systemId);
            }
        }
    }

    private void registerCreatorSilentChainingPlugins(Document doc) {
        List list = doc.getRootElement().getChildren("object-type-name");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            String otn = ((Element)iterator.next()).getTextTrim();
            if (otn == null || otn.equals("")) continue;
            ArrayList<Document> array = (ArrayList<Document>)this.m_creatorSilentChainingPlugins.get(otn);
            if (array == null) {
                array = new ArrayList<Document>();
                this.m_creatorSilentChainingPlugins.put(otn, array);
            }
            array.add(doc);
        }
    }

    public ArrayList getCreatorSilentChainingPlugins(String objectTypeName) {
        ArrayList array = (ArrayList)this.m_creatorSilentChainingPlugins.get(objectTypeName);
        if (array == null) {
            array = new ArrayList();
        }
        return array;
    }

    public static List getParticipantDocs(Set objectTypes, String operation) {
        Set partDocsForOpAndType = Collections.EMPTY_SET;
        for (String objectTypeName : objectTypes) {
            Map participantsByOperationForType = (Map)m_participantOpsByTypes.get(objectTypeName);
            if (participantsByOperationForType != null && !participantsByOperationForType.isEmpty()) {
                partDocsForOpAndType.addAll((List)participantsByOperationForType.get(operation));
            }
            if (partDocsForOpAndType != null) continue;
            partDocsForOpAndType = Collections.EMPTY_SET;
        }
        return new ArrayList(partDocsForOpAndType);
    }

    private void registerBookAddonPlugin(Document doc) {
        this.m_bookAddons.add(doc);
    }

    public ArrayList getPrinterControlPlugins() {
        return this.m_printerControlPlugins;
    }

    private void registerPrinterControlPlugin(Document doc) {
        this.m_printerControlPlugins.add(doc);
    }

    private void registerGatewayConfigPlugin(Document doc) {
        this.m_gatewayConfigPlugins.add(doc);
    }

    public ArrayList getGatewayConfigPlugins() {
        return this.m_gatewayConfigPlugins;
    }

    private void registerView(Document doc) {
        this.m_views.add(doc);
    }

    public ArrayList getViews() {
        return this.m_views;
    }

    private void registerTask(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("role-assignment");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            String role = ((Element)iterator.next()).getTextTrim();
            if (role == null || role.equals("")) continue;
            PluginDocNode tasks = (PluginDocNode)this.m_tasksByRole.get(role);
            if (tasks == null) {
                tasks = new PluginDocNode();
                this.m_tasksByRole.put(role, tasks);
            }
            tasks.add(doc);
        }
        this.addTaskToTasksByTypeTable(doc);
        this.addToChainingTable(doc);
        this.addToRunnableList(doc);
    }

    private void registerChainedTask(Document doc) {
        this.addToChainingTable(doc);
        this.addToRunnableList(doc);
    }

    private void addToChainingTable(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("chaining-initial-task-id");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            String initialTask = ((Element)iterator.next()).getTextTrim();
            if (initialTask == null || initialTask.equals("")) continue;
            PluginDocNode tasks = (PluginDocNode)this.m_chainingTable.get(initialTask);
            if (tasks == null) {
                tasks = new PluginDocNode();
                this.m_chainingTable.put(initialTask, tasks);
            }
            tasks.add(doc);
        }
    }

    private void addTaskToTasksByTypeTable(Document doc) {
        List list = doc.getRootElement().getChildren("object-type-name");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            String otn = ((Element)iterator.next()).getTextTrim();
            if (otn == null || otn.equals("")) continue;
            HashMap<String, Document> tasksForTypeById = (HashMap<String, Document>)this.m_tasksByType.get(otn);
            if (tasksForTypeById == null) {
                tasksForTypeById = new HashMap<String, Document>();
                this.m_tasksByType.put(otn, tasksForTypeById);
            }
            tasksForTypeById.put(doc.getRootElement().getChildTextTrim("id"), doc);
        }
    }

    protected void addToRunnableList(Document doc) {
        String serviceName = doc.getRootElement().getChildTextTrim("id");
        serviceName = this.getRealServiceName(serviceName);
        this.m_runnableTasks.put(serviceName, doc);
        ArrayList saAuthIds = FwAuthUtils.getSupportedAuthenticatorNamesForPlugin(doc);
        for (String sAuthName : saAuthIds) {
            HashMap<String, Document> runnables = (HashMap<String, Document>)this.m_authenticatorRunnables.get(sAuthName);
            if (runnables == null) {
                runnables = new HashMap<String, Document>();
                this.m_authenticatorRunnables.put(sAuthName, runnables);
            }
            runnables.put(serviceName, doc);
        }
    }

    private ArrayList getChainedTaskIds(String serviceName) {
        PluginDocNode chainedTasks = (PluginDocNode)this.m_chainingTable.get(serviceName);
        ArrayList chainedTaskIds = null;
        if (chainedTasks != null) {
            chainedTaskIds = new ArrayList(chainedTasks.getHashMap().keySet());
        }
        return chainedTaskIds;
    }

    public static ArrayList getGlobalChainedTaskIds(String taskId) {
        return sm_metaGlobalReg.getChainedTaskIds(taskId);
    }

    private void registerRole(Document doc, boolean nonds) {
        Element root = doc.getRootElement();
        List list = root.getChildren("view-assignment");
        ListIterator iterator = list.listIterator();
        boolean noCategories = false;
        String view = null;
        if (!iterator.hasNext()) {
            view = "AllTasks";
            noCategories = true;
        }
        if (!nonds && root.getChild("non-ds") != null) {
            nonds = true;
        }
        while (noCategories || iterator.hasNext()) {
            if (!noCategories) {
                view = ((Element)iterator.next()).getTextTrim();
            }
            noCategories = false;
            PluginDocNode roles = (PluginDocNode)this.m_rolesByView.get(view);
            if (roles == null) {
                roles = new PluginDocNode();
                this.m_rolesByView.put(view, roles);
            }
            if (roles.contains(doc) || view.equals("AllTasks") && (this.iseGuideRole(doc) || nonds)) continue;
            roles.add(doc);
        }
    }

    private boolean iseGuideRole(Document doc) {
        Properties urlParams = eMFrameUtils.getUrlParamsAsProperties(doc);
        String type = urlParams.getProperty("type");
        return type != null && type.equals("eGuide");
    }

    public ArrayList getRolesInView(String view) {
        PluginDocNode node = (PluginDocNode)this.m_rolesByView.get(view);
        if (node == null) {
            return new ArrayList();
        }
        return node.getArray();
    }

    public ArrayList getSortedRolesInView(String view, MContext context) {
        PluginDocNode node = (PluginDocNode)this.m_rolesByView.get(view);
        if (node != null) {
            return node.getSortedArray(context, new PluginDocComparator(context));
        }
        return new ArrayList();
    }

    public ArrayList getTasksInRole(String role) {
        ArrayList ret = new ArrayList();
        PluginDocNode node = (PluginDocNode)this.m_tasksByRole.get(role);
        if (node != null) {
            ret = node.getArray();
        }
        return ret;
    }

    public ArrayList getSortedTasksInRole(String role, MContext context) {
        PluginDocNode node = (PluginDocNode)this.m_tasksByRole.get(role);
        if (node != null) {
            PluginDocComparator pdc = new PluginDocComparator(context);
            return node.getSortedArray(context, pdc);
        }
        return new ArrayList();
    }

    public Map getTasksInRoleById(String role) {
        PluginDocNode node = (PluginDocNode)this.m_tasksByRole.get(role);
        if (node == null) {
            return new LinkedHashMap();
        }
        return node.getHashMap();
    }

    private void registerPage(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("object-type-name");
        ListIterator iterator = list.listIterator();
        this.m_allPages.add(doc);
        while (iterator.hasNext()) {
            Element currentType = (Element)iterator.next();
            String strCurrentType = currentType.getTextTrim();
            Vector<Document> v = (Vector<Document>)this.m_pageReg.get(strCurrentType);
            if (v == null) {
                v = new Vector<Document>();
                this.m_pageReg.put(strCurrentType, v);
            }
            v.addElement(doc);
        }
        try {
            Element chapter = root.getChild("chapter");
            String chapterId = chapter.getChildTextTrim("id");
            String resourceKey = chapter.getChildTextTrim("display-name-key");
            String resourceBundle = chapter.getChildTextTrim("resource-properties-file");
            String chapterName = resourceBundle + "," + resourceKey;
            Element id = root.getChild("id");
            String pageId = id.getTextTrim();
            this.m_pagesChapter.put(pageId, chapterName);
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    public String getChapter(String pageId) {
        return (String)this.m_pagesChapter.get(pageId);
    }

    public Vector getPageDocs(String strType) {
        return (Vector)this.m_pageReg.get(strType);
    }

    private void registerPrivatePage(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("object-type-name");
        ListIterator iterator = list.listIterator();
        this.m_allPages.add(doc);
        while (iterator.hasNext()) {
            Element currentType = (Element)iterator.next();
            String strCurrentType = currentType.getTextTrim();
            Vector<Document> v = (Vector<Document>)this.m_privatePageReg.get(strCurrentType);
            if (v == null) {
                v = new Vector<Document>();
                this.m_privatePageReg.put(strCurrentType, v);
            }
            v.addElement(doc);
        }
        try {
            Element chapter = root.getChild("chapter");
            String chapterId = chapter.getChildTextTrim("id");
            String resourceKey = chapter.getChildTextTrim("display-name-key");
            String resourceBundle = chapter.getChildTextTrim("resource-properties-file");
            String chapterName = resourceBundle + "," + resourceKey;
            Element id = root.getChild("id");
            String pageId = id.getTextTrim();
            this.m_pagesChapter.put(pageId, chapterName);
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    public Vector getPrivatePageDocs(String strType) {
        return (Vector)this.m_privatePageReg.get(strType);
    }

    private void registerPageBlocker(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("object-type-name");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            Element currentType = (Element)iterator.next();
            String strCurrentType = currentType.getTextTrim();
            Vector<String> v = (Vector<String>)this.m_pageBlockerReg.get(strCurrentType);
            if (v == null) {
                v = new Vector<String>();
                this.m_pageBlockerReg.put(strCurrentType, v);
            }
            String pageId = doc.getRootElement().getChildTextTrim("page-id");
            v.addElement(pageId);
        }
    }

    public Vector getBlockedPageIds(String strType) {
        return (Vector)this.m_pageBlockerReg.get(strType);
    }

    public Document getAttributeHandlerDoc(String attributeName) {
        Vector v = (Vector)this.m_attrHandlerReg.get(attributeName);
        if (v == null || v.size() == 0) {
            return null;
        }
        return (Document)v.elementAt(0);
    }

    public Document getSyntaxHandlerDoc(String syntaxName) {
        Vector v = (Vector)this.m_syntaxHandlerReg.get(syntaxName);
        if (v == null || v.size() == 0) {
            return null;
        }
        return (Document)v.elementAt(0);
    }

    private void registerAttrHandler(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("attribute-name");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            String attr = ((Element)iterator.next()).getTextTrim();
            Vector<Document> v = (Vector<Document>)this.m_attrHandlerReg.get(attr);
            if (v == null) {
                v = new Vector<Document>();
                this.m_attrHandlerReg.put(attr, v);
            }
            v.addElement(doc);
        }
    }

    private void registerSyntaxHandler(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("syntax-name");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            String syntax = ((Element)iterator.next()).getTextTrim();
            Vector<Document> v = (Vector<Document>)this.m_syntaxHandlerReg.get(syntax);
            if (v == null) {
                v = new Vector<Document>();
                this.m_syntaxHandlerReg.put(syntax, v);
            }
            v.addElement(doc);
        }
    }

    private final boolean matches(Document d, boolean multivalued, boolean readOnly, String client) {
        Element temp;
        Element root = d.getRootElement();
        if (!multivalued && (temp = root.getChild("single-valued-enabled")) == null) {
            return false;
        }
        if (readOnly && (temp = root.getChild("read-only-enabled")) == null) {
            return false;
        }
        boolean test = false;
        ListIterator iter = root.getChildren("supported-device-type").listIterator();
        while (iter.hasNext()) {
            if (!client.equals(((Element)iter.next()).getTextTrim())) continue;
            test = true;
            break;
        }
        return test;
    }

    private final void addMatching(Collection collection, Collection toAdd, boolean multivalued, boolean readOnlyEnabled, String client) {
        if (toAdd != null) {
            for (Document doc : toAdd) {
                if (!this.matches(doc, multivalued, readOnlyEnabled, client)) continue;
                collection.add(doc);
            }
        }
    }

    public Document getDefaultUiHandlerDoc(String syntaxName, String attributeName, String objectTypeName, String[] objectSuperClasses, boolean multivalued, boolean readOnlyEnabled, String client) {
        Document[] docs = this.getUiHandlerDocs(syntaxName, attributeName, objectTypeName, objectSuperClasses, multivalued, readOnlyEnabled, client);
        if (docs != null) {
            return docs[0];
        }
        return null;
    }

    public Document[] getUiHandlerDocs(String syntaxName, String attributeName, String objectTypeName, String[] objectSuperClasses, boolean multivalued, boolean readOnlyEnabled, String client) {
        Document d;
        int i;
        Vector<Document> returnValues = new Vector<Document>();
        Vector exclusiveVector = (Vector)this.m_uiExclusiveAttrClassHandleDocs.get(attributeName + ":" + objectTypeName);
        if (exclusiveVector != null) {
            for (i = 0; i < exclusiveVector.size(); ++i) {
                d = (Document)exclusiveVector.get(i);
                if (!this.matches(d, multivalued, readOnlyEnabled, client)) continue;
                returnValues.add(d);
            }
        }
        if (returnValues.size() == 0 && (exclusiveVector = (Vector)this.m_uiExclusiveAttrHandleDocs.get(attributeName)) != null) {
            for (i = 0; i < exclusiveVector.size(); ++i) {
                d = (Document)exclusiveVector.get(i);
                if (!this.matches(d, multivalued, readOnlyEnabled, client)) continue;
                returnValues.add(d);
            }
        }
        if (returnValues.size() == 0) {
            Vector<String> classes = new Vector<String>();
            classes.add(objectTypeName);
            if (objectSuperClasses != null) {
                for (int i2 = 0; i2 < objectSuperClasses.length; ++i2) {
                    classes.add(objectSuperClasses[i2]);
                }
            }
            TreeSet sortedSet = null;
            for (int i3 = 0; i3 < classes.size(); ++i3) {
                sortedSet = (TreeSet)this.m_uiAttrClassHandleDocs.get(attributeName + ":" + (String)classes.get(i3));
                if (sortedSet == null) continue;
                this.addMatching(returnValues, sortedSet, multivalued, readOnlyEnabled, client);
            }
            sortedSet = (TreeSet)this.m_uiSyntaxHandleDocs.get(syntaxName);
            if (sortedSet != null) {
                this.addMatching(returnValues, sortedSet, multivalued, readOnlyEnabled, client);
            }
            if ((sortedSet = (TreeSet)this.m_uiAttrHandleDocs.get(attributeName)) != null) {
                this.addMatching(returnValues, sortedSet, multivalued, readOnlyEnabled, client);
            }
        }
        Document[] ret = null;
        if (returnValues.size() > 0) {
            ret = returnValues.toArray(new Document[returnValues.size()]);
        }
        return ret;
    }

    private void registerUiAttrHandler(Document doc) {
        Element root = doc.getRootElement();
        List attributes = root.getChildren("attribute-name");
        ListIterator iterator = attributes.listIterator();
        while (iterator.hasNext()) {
            int index;
            String objectName;
            Element temp;
            String attributeName = ((Element)iterator.next()).getTextTrim();
            Element isExclusive = root.getChild("exclusive");
            List list = root.getChildren("object-type-name");
            int listSize = list.size();
            if (listSize > 0 && isExclusive != null) {
                temp = null;
                objectName = null;
                for (index = 0; index < listSize; ++index) {
                    temp = (Element)list.get(index);
                    objectName = temp.getTextTrim();
                    String attrClass = attributeName + ":" + objectName;
                    Vector<Document> v = (Vector<Document>)this.m_uiExclusiveAttrClassHandleDocs.get(attrClass);
                    if (v == null) {
                        v = new Vector<Document>();
                        this.m_uiExclusiveAttrClassHandleDocs.put(attrClass, v);
                    }
                    v.add(doc);
                }
                continue;
            }
            if (isExclusive != null) {
                Vector<Document> v = (Vector<Document>)this.m_uiExclusiveAttrHandleDocs.get(attributeName);
                if (v == null) {
                    v = new Vector<Document>();
                    this.m_uiExclusiveAttrHandleDocs.put(attributeName, v);
                }
                v.add(doc);
                continue;
            }
            if (listSize > 0) {
                temp = null;
                objectName = null;
                for (index = 0; index < listSize; ++index) {
                    temp = (Element)list.get(index);
                    objectName = temp.getTextTrim();
                    TreeSet<Document> collection = (TreeSet<Document>)this.m_uiAttrClassHandleDocs.get(attributeName + ":" + objectName);
                    if (collection == null) {
                        collection = new TreeSet<Document>(this.handlerComparator);
                        this.m_uiAttrClassHandleDocs.put(attributeName + ":" + objectName, collection);
                    }
                    collection.add(doc);
                }
                continue;
            }
            TreeSet<Document> collection = (TreeSet<Document>)this.m_uiAttrHandleDocs.get(attributeName);
            if (collection == null) {
                collection = new TreeSet<Document>(this.handlerComparator);
                this.m_uiAttrHandleDocs.put(attributeName, collection);
            }
            collection.add(doc);
        }
    }

    private void registerUiSyntaxHandler(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("syntax-name");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            String syntaxName = ((Element)iterator.next()).getTextTrim();
            if (syntaxName == null || syntaxName.length() < 1) {
                D.log("Error during registration:  Could not add register syntax handler");
                continue;
            }
            TreeSet<Document> collection = (TreeSet<Document>)this.m_uiSyntaxHandleDocs.get(syntaxName);
            if (collection == null) {
                collection = new TreeSet<Document>(this.handlerComparator);
                this.m_uiSyntaxHandleDocs.put(syntaxName, collection);
            }
            collection.add(doc);
        }
    }

    public Document getClassLoaderDoc(String descriptorDir) {
        return (Document)this.m_classLoaders.get(descriptorDir);
    }

    private void registerClassLoader(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("descriptor-dir");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            String dir = ((Element)iterator.next()).getTextTrim();
            if ((dir = dir.substring(0, dir.indexOf("/"))) == null || dir.equals("")) continue;
            this.m_classLoaders.put(dir, doc);
        }
    }

    private void registerDirTranslator(Document doc) {
        Element root = doc.getRootElement();
        String resource = root.getChildTextTrim("resource-properties-file");
        List list = root.getChildren("object-type-name");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            String name = ((Element)iterator.next()).getTextTrim();
            this.m_objectTranslator.put(name, resource);
        }
        list = root.getChildren("attribute-name");
        iterator = list.listIterator();
        String sFirstIn = null;
        while (iterator.hasNext()) {
            String name = ((Element)iterator.next()).getTextTrim();
            sFirstIn = (String)this.m_attributeTranslator.get(name);
            if (sFirstIn != null) {
                D.log("Failed to register " + resource + " as the translator resource for the attribute \"" + name + "\".");
                D.log("(\"" + sFirstIn + "\" is already registered as the translator for \"" + name + "\")");
                continue;
            }
            this.m_attributeTranslator.put(name, resource);
        }
    }

    public void registerCreator(Document doc) {
        Element root = doc.getRootElement();
        Element id = root.getChild("id");
        List listTypes = root.getChildren("object-type-name");
        ListIterator iterTypes = listTypes.listIterator();
        while (iterTypes.hasNext()) {
            Set systems;
            Element currentType = (Element)iterTypes.next();
            String strCurrentType = currentType.getTextTrim().toLowerCase();
            D.log("Registering '" + strCurrentType + "' creator \t'" + (id != null ? id.getText() : "NoID") + "'");
            HashMap<String, Document> creatorsForTypeBySystem = (HashMap<String, Document>)this.m_creatorReg.get(strCurrentType);
            if (creatorsForTypeBySystem == null) {
                creatorsForTypeBySystem = new HashMap<String, Document>();
                this.m_creatorReg.put(strCurrentType, creatorsForTypeBySystem);
            }
            if ((systems = FwAuthUtils.getAuthSettingForPlugin(null, doc, "dir", "system")).isEmpty()) {
                creatorsForTypeBySystem.put("eDir", doc);
                continue;
            }
            for (String systemId : systems) {
                creatorsForTypeBySystem.put(systemId, doc);
            }
        }
        this.addToRunnableList(doc);
    }

    public Document getCreatorDoc(String sType, MContext context) {
        String sDirSystem = DirAuthenticator.getDirAuth(context).getSystem();
        return this.getCreatorDoc(sType.toLowerCase(), sDirSystem);
    }

    public Document getCreatorDoc(String sType, String sDirSystem) {
        HashMap creatorsForTypeBySystem = (HashMap)this.m_creatorReg.get(sType);
        if (creatorsForTypeBySystem != null) {
            return (Document)creatorsForTypeBySystem.get(sDirSystem);
        }
        return null;
    }

    public ArrayList getCategories() {
        return new ArrayList(this.m_hmCategory.entrySet());
    }

    public Document getCategoryDoc(String id) {
        return (Document)this.m_hmCategory.get(id);
    }

    private void registerDeletor(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("object-type-name");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            Element currentType = (Element)iterator.next();
            String strCurrentType = currentType.getTextTrim();
            this.m_deletorReg.put(strCurrentType, doc);
        }
    }

    public Document getDeletorDoc(String strType) {
        return (Document)this.m_deletorReg.get(strType);
    }

    private void registerMove(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("object-type-name");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            Element currentType = (Element)iterator.next();
            String strCurrentType = currentType.getTextTrim();
            this.m_moveReg.put(strCurrentType, doc);
        }
    }

    public Document getMoveDoc(String strType) {
        return (Document)this.m_moveReg.get(strType);
    }

    public Document getDirectoryEventListenerDoc(String strType) {
        return (Document)this.m_directoryEventListenerReg.get(strType);
    }

    public Hashtable getDirectoryEventListenerRegistry() {
        return this.m_directoryEventListenerReg;
    }

    private void registerDirectoryListener(Document doc) {
        Element root = doc.getRootElement();
        Element idElement = root.getChild("id");
        String id = idElement.getTextTrim();
        this.m_directoryEventListenerReg.put(id, doc);
    }

    private void registerRename(Document doc) {
        Element root = doc.getRootElement();
        List list = root.getChildren("object-type-name");
        ListIterator iterator = list.listIterator();
        while (iterator.hasNext()) {
            Element currentType = (Element)iterator.next();
            String strCurrentType = currentType.getTextTrim();
            this.m_renameReg.put(strCurrentType, doc);
        }
    }

    public Document getRenameDoc(String strType) {
        return (Document)this.m_renameReg.get(strType);
    }

    public Document[] getRenameDocs(String strType) {
        ArrayList arr = (ArrayList)this.m_renameReg.get(strType);
        if (null != arr) {
            Document[] docArray = (Document[])arr.toArray();
            return docArray;
        }
        return null;
    }

    public String getObjectTypeResourceFile(String objectTypeName) {
        return (String)this.m_objectTranslator.get(objectTypeName);
    }

    public String getAttributeResourceFile(String attributeName) {
        return (String)this.m_attributeTranslator.get(attributeName);
    }

    public HashMap getRunnables() {
        return this.m_runnableTasks;
    }

    public HashMap getRunnablesForAuthenticator(String AuthId) {
        HashMap hmResult = new HashMap();
        HashMap hmTemp = (HashMap)this.m_authenticatorRunnables.get("any");
        if (hmTemp != null) {
            hmResult.putAll(hmTemp);
        }
        if ((hmTemp = (HashMap)this.m_authenticatorRunnables.get(AuthId)) != null) {
            hmResult.putAll(hmTemp);
        }
        return hmResult;
    }

    public static List getDefaultDevices() {
        return defaultDevices;
    }

    public List getAllPages() {
        return this.m_allPages;
    }

    public boolean isOES() {
        return isOES;
    }

    public static void checkOES() {
        if (System.getProperty("os.name").toLowerCase().indexOf("linux") != -1) {
            File testFile = new File("/etc/novell-release");
            isOES = testFile.exists() ? Registry.isInstalled("oes-release") : Registry.isInstalled("novell-oes-install");
        }
    }

    private static boolean isInstalled(String packageName) {
        return Registry.runCommand("rpm -q " + packageName);
    }

    private static boolean runCommand(String command) {
        try {
            ShellCommand cmd = new ShellCommand("sh");
            cmd.feedInput(command);
            cmd.stdin.close();
            cmd.waitFor();
            if (cmd.exitValue() != 0) {
                return false;
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return true;
    }

    public Hashtable get_realServiceNames() {
        return this.m_realServiceNames;
    }
}

