/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.SimpleSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ldap.LDAPNamespace;
import com.novell.admin.ns.ldap.LDAPSyntax;
import com.novell.admin.ns.nds.NDSClassDefinition;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.admin.ns.nds.ObjectFlags;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.JobData;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.Rename;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.nps.gadgetManager.GadgetInstance;
import java.util.Enumeration;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;

public class RenameObjectTask
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String HTMLPARAM_FORMNAME = "RenameObjectForm";
    public static final String HTMLPARAM_NEWNAME = "RenameNewName";
    public static final String HTMLPARAM_SRCOBJECT = "RenameObjectName";
    public static final String HTMLPARAM_ENABLEOLDNAME = "EnableOldName";
    public static final String HTMLPARAM_ENABLECREATEALIAS = "EnableCreateAlias";
    public static final String STR_TARGETOBJECT = "objectTypeName";
    public static final String HTMLPARAM_GIFNAME = "GifName";
    public static final String HTMLPARAM_TRANSLATEDCLASS = "TranslatedClass";
    private static final String L = "L";
    private static final String S = "S";
    private static final String ALIAS_CLASS_NAME = "Alias";
    private static final String OBJECT_CLASS_ATTR_NAME = "Object Class";
    private static final String ALIAS_ATTR_NAME = "Aliased Object Name";
    HttpServletRequest req;
    TaskContext context;
    Properties resultStrings;
    String m_targetNames = null;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        D.log("RenameObjectTask::execute start", 3);
        this.context = context;
        this.resultStrings = resultStrings;
        this.req = context.getRequest();
        String scripting = this.req.getParameter("scripting");
        if (scripting != null && scripting.equalsIgnoreCase("true")) {
            String srcObject = this.req.getParameter("scriptParam1");
            String newObject = this.req.getParameter("scriptParam2");
            String saveOldName = this.req.getParameter("scriptParam3");
            return this.doRenameObject(srcObject, newObject, saveOldName, null);
        }
        String nextState = this.req.getParameter("nextState");
        D.log("nextState = " + nextState, 3);
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase("doRenameObject")) {
            try {
                D.log("doRenameObject", 3);
                String[] srcunpacked = new String[1];
                String srcObject = this.req.getParameter(HTMLPARAM_SRCOBJECT);
                String newObject = this.req.getParameter(HTMLPARAM_NEWNAME);
                String saveOldName = this.req.getParameter(HTMLPARAM_ENABLEOLDNAME);
                String createAlias = this.req.getParameter(HTMLPARAM_ENABLECREATEALIAS);
                srcunpacked = eMFrameUtils.unpack(srcObject, context);
                return this.doRenameObject(srcunpacked[0], newObject, saveOldName, createAlias);
            }
            catch (Exception e) {
                D.log(e);
                return false;
            }
        }
        D.log("Task received invalid state " + nextState, 3);
        return this.showInitialForm();
    }

    private boolean showInitialForm() {
        String[] ovSelectedObject = null;
        String ovTargets = this.req.getParameter("targetNames");
        String target = this.getTargetObjects(this.req);
        int i = 0;
        if (null != ovTargets && ovTargets.length() > 0) {
            ovSelectedObject = eMFrameUtils.unpack(ovTargets, this.context);
            this.resultStrings.put("targetNames", ovSelectedObject[0]);
        }
        this.resultStrings.put("OSSearchFilter", this.getTargetObjects(this.req));
        StringTokenizer st = new StringTokenizer(target, ",");
        String[] targets = new String[st.countTokens()];
        while (st.hasMoreTokens()) {
            targets[i] = st.nextToken();
            ++i;
        }
        eMFrameUtils.setupTargetChooser(targets, this.context);
        try {
            AuthenticationBroker broker = this.context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            AdminNamespace namespace = treeOE.getAdminNamespace();
            if (namespace.isSupported("NVDS")) {
                this.resultStrings.put("aliasCreation", "false");
            }
        }
        catch (AuthBrokerException e) {
            D.log(e.getMessage());
        }
        catch (SPIException e) {
            D.log(e.getMessage());
        }
        catch (NamespaceException e) {
            D.log(e.getMessage());
        }
        return true;
    }

    private boolean doRenameObject(String strObjectName, String newName, String saveOldName, String enableCreateAlias) {
        String strBody;
        String strException = null;
        AuthenticationBroker broker = this.context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace namespace = treeOE.getAdminNamespace();
        if (treeOE.getName().equalsIgnoreCase(strObjectName)) {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RenameObject.Failure", this.context);
            String strBody2 = eMFrameUtils.getLocalizedString("FwResources", "RenameObject.CannotRenameTree", this.context);
            eMFrameUtils.setMessage("error", strTitle, strBody2, this.context);
            return false;
        }
        ObjectEntry srcObjectOE = null;
        try {
            srcObjectOE = namespace.getObjectEntry(treeOE, strObjectName);
        }
        catch (SPIException e) {
            D.log(e);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RenameObject.Failure", this.context);
            String strBody3 = eMFrameUtils.getLocalizedString("FwResources", "RenameObject.NotFound", this.context);
            eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.formatMessage(strBody3, new String[]{strObjectName}), this.context);
            return false;
        }
        AdminNamespace adminns = (AdminNamespace)srcObjectOE.getObjectType().getNamespace();
        String newObjectName = newName;
        String oldName = srcObjectOE.getName();
        boolean success = false;
        ObjectEntry newOE = srcObjectOE;
        try {
            success = this.renameIfRegistered(srcObjectOE, newObjectName);
            if (!success) {
                newOE = adminns.rename(srcObjectOE, newObjectName);
                success = true;
                eMFrameUtils.refreshOV(this.context);
            }
        }
        catch (SPIException e) {
            if (e instanceof SimpleSPIException) {
                SimpleSPIException sx = (SimpleSPIException)e;
                if (sx != null) {
                    if (sx.getErrorId() != null && sx.getErrorId().equals("spi1")) {
                        D.log(e);
                        String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RenameObject.Failure", this.context);
                        String strBody4 = eMFrameUtils.getLocalizedString("FwResources", "RenameObject.NotFound", this.context);
                        eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.formatMessage(strBody4, new String[]{strObjectName}), this.context);
                        return false;
                    }
                    D.log(e);
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RenameObject.Failure", this.context);
                    String strBody5 = eMFrameUtils.getLocalizedString("FwResources", "RenameObject.InvalidTargetObject", this.context);
                    eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.formatMessage(strBody5, new String[]{strObjectName}), this.context);
                    return false;
                }
            }
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.context);
            return false;
        }
        catch (SnapinVetoException e) {
            D.log(e);
            strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.context);
        }
        catch (ClassNotFoundException cx) {
            D.log("Wrong package name is being used in rename.xml!!!", 3);
            D.log(cx);
            strBody = eMFrameUtils.getLocalizedString("BaseResources", "RenameObject.ClassNotFound", this.context);
            strException = eMFrameUtils.formatMessage(strBody, new String[]{"rename.xml"});
        }
        catch (PluginException pe) {
            D.log(pe);
            strException = pe.getHeader() + " : " + pe.getBody();
        }
        if (null != strException || !success) {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RenameObject.Failure", this.context);
            strBody = eMFrameUtils.getLocalizedString("BaseResources", "Common.FailureExplain", this.context);
            eMFrameUtils.setMessage("error", strTitle, eMFrameUtils.formatMessage(strBody, new String[]{strException}), this.context);
            return false;
        }
        boolean createAliasFailed = this.doPostRename(adminns, newOE, saveOldName, oldName, enableCreateAlias);
        this.context.addToHistory(newOE);
        this.context.removeFromHistory(namespace.getUnrootedName(srcObjectOE));
        JobData data = JobData.getJobData((GadgetInstance)this);
        if (null != data) {
            data.setObjectNames(new String[]{namespace.getUnrootedName(newOE)});
        }
        String objName = newOE.getFullName();
        String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RenameObject.Success", this.context);
        String strBody6 = createAliasFailed ? eMFrameUtils.getLocalizedString("FwResources", "RenameObject.SuccessRenameErrorAlias", this.context) : eMFrameUtils.getLocalizedString("FwResources", "RenameObject.SuccessForObject", this.context);
        eMFrameUtils.setMessage("success", strTitle, eMFrameUtils.formatMessage(strBody6, new String[]{objName}), this.context);
        D.log("RenameObjectTask::Rename Object succeeded: " + objName, 3);
        return true;
    }

    private boolean doPostRename(AdminNamespace adminns, ObjectEntry newOE, String saveOldName, String oldName, String enableCreateAlias) {
        boolean createAliasFailed = false;
        NSObject nsObject = null;
        try {
            nsObject = adminns.getDetails(newOE);
            this.saveUniqueID(oldName, newOE, nsObject, saveOldName);
            this.saveName(oldName, newOE, nsObject, saveOldName);
            if (null != enableCreateAlias && !newOE.getObjectType().getName().equals(ALIAS_CLASS_NAME) && !this.createAlias(newOE, oldName, adminns)) {
                createAliasFailed = true;
            }
            AdminNamespace ns = adminns;
            ns.update(nsObject);
        }
        catch (Exception e) {
            D.log(e);
        }
        return createAliasFailed;
    }

    private void saveUniqueID(String oldName, ObjectEntry newOE, NSObject nsObj, String saveOldName) throws NamespaceException, ComponentCreationException, SPIException {
        ObjectAttribute uniqueIDAttrib = nsObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)newOE, (String)"uniqueID"));
        String tmp = newOE.getName();
        tmp = eMFrameUtils.replaceWith(tmp, "\\.", ".");
        tmp = eMFrameUtils.replaceWith(tmp, "\\=", "=");
        boolean foundOldUID = false;
        boolean isSupported = false;
        AdminNamespace ns = (AdminNamespace)newOE.getObjectType().getNamespace();
        ClassDefinition cDef = ns.getClassDefinition(newOE, newOE.getObjectType().getName());
        isSupported = cDef.isClassUsingAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)newOE, (String)"uniqueID"));
        if (isSupported) {
            if (null != uniqueIDAttrib) {
                ValueComponent newValue = uniqueIDAttrib.getAttributeDefinition().getSyntax().createValueComponent((Object)tmp);
                if (null != saveOldName) {
                    uniqueIDAttrib.addComponent(newValue);
                    foundOldUID = true;
                } else {
                    String oldTmp = eMFrameUtils.replaceWith(oldName, "\\.", ".");
                    oldTmp = eMFrameUtils.replaceWith(oldTmp, "\\=", "=");
                    ValueComponent oldNameVc = uniqueIDAttrib.getAttributeDefinition().getSyntax().createValueComponent((Object)oldTmp);
                    Enumeration valueSet = uniqueIDAttrib.getValueComponents();
                    while (valueSet.hasMoreElements()) {
                        ValueComponent oldValue = (ValueComponent)valueSet.nextElement();
                        String oldUID = oldValue.toString();
                        oldUID = eMFrameUtils.replaceWith(oldUID, "\\.", ".");
                        oldUID = eMFrameUtils.replaceWith(oldUID, "\\=", "=");
                        ValueComponent oldUIDvc = uniqueIDAttrib.getAttributeDefinition().getSyntax().createValueComponent((Object)oldUID);
                        if (!oldUIDvc.equals((Object)oldNameVc)) continue;
                        uniqueIDAttrib.replaceComponent(oldValue, newValue);
                        foundOldUID = true;
                    }
                    if (!foundOldUID) {
                        uniqueIDAttrib.addComponent(newValue);
                    }
                }
            } else {
                AttributeDefinition def = ns.getAttributeDefinition(newOE, SchemaUtil.translateNDAPAttr((ObjectEntry)newOE, (String)"uniqueID"));
                uniqueIDAttrib = new ObjectAttribute(def);
                ValueComponent vc = uniqueIDAttrib.getAttributeDefinition().getSyntax().createValueComponent((Object)tmp);
                uniqueIDAttrib.addComponent(vc);
                nsObj.addAttribute(uniqueIDAttrib);
            }
        }
    }

    private void saveName(String oldName, ObjectEntry newOE, NSObject nsObj, String saveOldName) throws NamespaceException {
        String objectTypeName = null;
        boolean mandatoryAttrFlag = false;
        boolean foundLocalityFlag = false;
        String classType = newOE.getObjectType().getName();
        if (null != saveOldName && !classType.equals("Country") && !classType.equals(ALIAS_CLASS_NAME)) {
            int i;
            NDSClassDefinition cd = (NDSClassDefinition)nsObj.getClassDefinitions()[0];
            AttributeDefinition[] namingAttrs = cd.getNamingAttributes();
            for (i = 0; i < namingAttrs.length; ++i) {
                if (!nsObj.isAttributeMandatory(namingAttrs[i].getName())) continue;
                objectTypeName = namingAttrs[i].getName();
                mandatoryAttrFlag = true;
                break;
            }
            if (!mandatoryAttrFlag) {
                block1: for (i = 0; i < namingAttrs.length; ++i) {
                    if (newOE.getObjectType().getName().equals("Locality")) {
                        if (foundLocalityFlag) continue;
                        ObjectAttribute localityNameAttrib = nsObj.getAttribute(L);
                        if (localityNameAttrib != null) {
                            Enumeration e = localityNameAttrib.getValueComponents();
                            if (e == null) continue;
                            while (e.hasMoreElements()) {
                                String s = e.nextElement().toString();
                                if (!s.equals(newOE.getName())) continue;
                                objectTypeName = L;
                                foundLocalityFlag = true;
                                continue block1;
                            }
                            continue;
                        }
                        objectTypeName = S;
                        foundLocalityFlag = true;
                        continue;
                    }
                    objectTypeName = namingAttrs[0].getName();
                }
            }
            ObjectAttribute otherNameAttrib = nsObj.getAttribute(objectTypeName);
            StringValue sv = new StringValue((Syntax)NDSSyntax.SYN_CI_STRING, oldName);
            otherNameAttrib.addComponent((ValueComponent)sv);
        }
    }

    private boolean createAlias(ObjectEntry newOE, String oldObjName, AdminNamespace adminns) {
        try {
            AdminNamespace ns = (AdminNamespace)newOE.getObjectType().getNamespace();
            ValueComponent[] l_aliasNameVals = new ValueComponent[1];
            ValueComponent l_aliasNameVal = null;
            ValueComponent l_distNameVal = null;
            l_aliasNameVal = ns instanceof LDAPNamespace ? LDAPSyntax.SYN_CLASS_NAME.createValueComponent((Object)SchemaUtil.translateNDAPClass((ObjectEntry)newOE, (String)ALIAS_CLASS_NAME)) : NDSSyntax.SYN_CLASS_NAME.createValueComponent((Object)SchemaUtil.translateNDAPClass((ObjectEntry)newOE, (String)ALIAS_CLASS_NAME));
            l_aliasNameVals[0] = l_aliasNameVal;
            ObjectAttribute l_objClassAttr = new ObjectAttribute(ns.getAttributeDefinition(newOE, SchemaUtil.translateNDAPAttr((ObjectEntry)newOE, (String)OBJECT_CLASS_ATTR_NAME)), l_aliasNameVals);
            l_distNameVal = ns.getAttributeDefinition(newOE, SchemaUtil.translateNDAPAttr((ObjectEntry)newOE, (String)ALIAS_ATTR_NAME)).getSyntax().createValueComponent((Object)ns.getUnrootedName(newOE));
            ValueComponent[] l_distNameVals = new ValueComponent[]{l_distNameVal};
            ObjectAttribute l_aliasNameAttr = new ObjectAttribute(ns.getAttributeDefinition(newOE, SchemaUtil.translateNDAPAttr((ObjectEntry)newOE, (String)ALIAS_ATTR_NAME)), l_distNameVals);
            Vector<ObjectAttribute> l_attrNDSOV = new Vector<ObjectAttribute>();
            l_attrNDSOV.addElement(l_aliasNameAttr);
            l_attrNDSOV.addElement(l_objClassAttr);
            ObjectEntry l_aliasObjectEntry = ns.createObjectEntry(newOE.getParent(), oldObjName, SchemaUtil.translateNDAPClass((ObjectEntry)newOE, (String)ALIAS_CLASS_NAME));
            NSObject l_aliasObj = adminns.createNSObject(l_aliasObjectEntry, l_attrNDSOV);
            ns.create(l_aliasObj);
        }
        catch (SPIException e) {
            D.log(e);
            return false;
        }
        catch (SnapinVetoException e) {
            D.log(e);
            return false;
        }
        catch (ComponentCreationException e) {
            D.log(e);
            return false;
        }
        catch (NamespaceException e) {
            D.log(e);
            return false;
        }
        return true;
    }

    public boolean renameIfRegistered(ObjectEntry oe, String newObjectName) throws ClassNotFoundException, PluginException {
        String objectClass = oe.getObjectType().getName();
        long objFlags = 0L;
        objFlags = oe.getObjectFlags();
        if (ObjectFlags.isAlias((long)objFlags)) {
            return false;
        }
        String oeFullName = oe.getFullName();
        try {
            Document renameDoc = GlobalRegistry.getRenameDoc(objectClass);
            if (renameDoc != null) {
                String renameClass = eMFrameUtils.getClassName(renameDoc);
                Rename newRename = new Rename();
                Class<?> c = Class.forName(renameClass);
                newRename = (Rename)c.newInstance();
                newRename.doRename(oe, newObjectName, this.context);
                D.log("This object type is registered in rename.xml : " + oeFullName + "(" + oe.getObjectType().getName() + ")", 3);
                return true;
            }
            D.log("No registration found for renaming the selected object type: " + oe.getObjectType().getName(), 3);
            return false;
        }
        catch (InstantiationException e) {
            D.log(e);
            return false;
        }
        catch (IllegalAccessException e) {
            D.log(e);
            return false;
        }
    }

    public String getTargetObjects(HttpServletRequest req) {
        String targetObjects = req.getParameter(STR_TARGETOBJECT);
        D.log("Renaming-------------" + targetObjects);
        Vector<String> validObjects = new Vector<String>(5);
        if (targetObjects != null) {
            StringTokenizer st = new StringTokenizer(targetObjects, ",");
            String strObject = null;
            while (st.hasMoreTokens()) {
                strObject = st.nextToken();
                validObjects.addElement(strObject);
            }
        } else {
            targetObjects = "*";
            validObjects.addElement(targetObjects);
        }
        String gifName = "object16.gif";
        String translatedClass = eMFrameUtils.getLocalizedString("BaseResources", "DeleteObject.Objects", this.context);
        if (!validObjects.firstElement().equals("*")) {
            gifName = this.context.getDirUtils().getObjectTypeImageName((String)validObjects.firstElement());
            translatedClass = this.context.getDirUtils().getObjectTypeDisplayName((String)validObjects.firstElement(), this.context);
        }
        this.resultStrings.put(HTMLPARAM_TRANSLATEDCLASS, translatedClass);
        this.resultStrings.put(HTMLPARAM_GIFNAME, gifName);
        return targetObjects;
    }
}

