/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSReportUtil;
import com.novell.emframe.fw.RBSRoleRightsReportSort;
import com.novell.emframe.fw.ReportsExportUtil;
import com.novell.emframe.fw.RoleRightsReport;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSRole;
import java.text.Collator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class RightsForRoleReport
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private HttpServletRequest m_req;
    private NDSNamespace m_ns;
    private ObjectEntry m_treeOE;
    private ArrayList m_rbsTaskRightsReport = new ArrayList();
    private String m_reportTime;
    private ReportsExportUtil m_exportUtil = null;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_req = this.m_context.getRequest();
        this.m_treeOE = (ObjectEntry)this.m_context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        this.m_ns = (NDSNamespace)this.m_treeOE.getNamespace();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.initialState();
        }
        if (nextState.equalsIgnoreCase("getRoleRightsReport")) {
            return this.getRoleRightsReport();
        }
        if (nextState.equalsIgnoreCase("sortByColumn")) {
            return this.sortByColumn();
        }
        if (nextState.equalsIgnoreCase("exportReport")) {
            return this.handleExportFile();
        }
        return true;
    }

    private boolean initialState() {
        ArrayList<String[]> roleArrayList = new ArrayList<String[]>();
        RBSCollection[] rbsCollection = null;
        try {
            ObjectEntry whoamiOE = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
            RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(whoamiOE);
            rbsCollection = rbsAssociatedObject.getAllOwnedCollections2();
        }
        catch (Exception exc) {
            D.log(exc);
            String strException = eMFrameUtils.getExceptionMessage(exc, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
            return false;
        }
        if (rbsCollection != null) {
            for (int index = 0; index < rbsCollection.length; ++index) {
                RBSRole[] rbsRole = null;
                try {
                    rbsRole = rbsCollection[index].getRoles();
                    if (rbsRole == null) continue;
                    for (int count = 0; count < rbsRole.length; ++count) {
                        String roleFDN = this.m_ns.getUnrootedName(rbsRole[count].getObjectEntry());
                        String roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, rbsRole[count]);
                        if (rbsCollection.length > 1) {
                            String collectionName = this.m_ns.getUnrootedName(rbsCollection[index].getObjectEntry());
                            roleDisplayName = eMFrameUtils.formatMessage("{0} ({1})", new String[]{roleDisplayName, collectionName});
                        }
                        String[] roleNames = new String[]{roleDisplayName, roleFDN};
                        roleArrayList.add(roleNames);
                    }
                    continue;
                }
                catch (SPIException exc) {
                    D.log(exc);
                    String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)exc), this.m_context);
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                    eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
                    return false;
                }
            }
        }
        if (roleArrayList.size() > 1) {
            Collections.sort(roleArrayList, new StringSort(this.m_context));
        }
        this.m_req.setAttribute("roleData", roleArrayList);
        return true;
    }

    private boolean getRoleRightsReport() {
        this.m_rbsTaskRightsReport.clear();
        String selectedRoleFullName = this.m_req.getParameter("RoleListSelect");
        Date date = new Date();
        Locale locale = this.m_context.getLocale();
        String reportTime = DateFormat.getDateInstance(0, locale).format(date);
        String reportDate = DateFormat.getTimeInstance(0, locale).format(date);
        this.m_reportTime = eMFrameUtils.formatMessage("{0} ({1})", new String[]{reportTime, reportDate});
        RoleRightsReport roleRightsReport = new RoleRightsReport(this.m_context, selectedRoleFullName);
        String roleDisplayName = null;
        try {
            this.m_rbsTaskRightsReport = roleRightsReport.geterateRoleRightsReport();
            if (this.m_rbsTaskRightsReport.size() == 0) {
                ObjectEntry roleOE = this.m_ns.getObjectEntry(this.m_treeOE, selectedRoleFullName);
                roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, roleOE);
            } else {
                RoleRightsReport.RBSTaskRightsReport rbsTaskRightsReport = (RoleRightsReport.RBSTaskRightsReport)this.m_rbsTaskRightsReport.get(0);
                roleDisplayName = rbsTaskRightsReport.getRoleDisplayName();
            }
        }
        catch (Exception exc) {
            D.log(exc);
            String strException = eMFrameUtils.getExceptionMessage(exc, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
            return false;
        }
        String sortColumn = "sortTaskName";
        String sortDirection = "descending";
        Collections.sort(this.m_rbsTaskRightsReport, new RBSRoleRightsReportSort(this.m_context, sortColumn, sortDirection));
        this.m_req.setAttribute("roleRightsReportData", (Object)this.m_rbsTaskRightsReport);
        this.m_req.setAttribute("sortColumn", (Object)sortColumn);
        this.m_req.setAttribute("sortDirection", (Object)sortDirection);
        this.m_req.setAttribute("reportTime", (Object)this.m_reportTime);
        this.m_req.setAttribute("selectedRoleDisplayName", (Object)roleDisplayName);
        this.m_req.setAttribute("selectedRoleFDN", (Object)selectedRoleFullName);
        this.m_req.setAttribute("RBSAdmin_RoleType", (Object)"");
        return true;
    }

    private boolean sortByColumn() {
        String sortColumn = this.m_req.getParameter("sortColumn");
        String sortDirection = this.m_req.getParameter("sortDirection");
        String selectedRoleDisplayName = this.m_req.getParameter("selectedRoleDisplayName");
        String selectedRoleFullName = this.m_req.getParameter("selectedRoleFDN");
        String rbsAdmin_RoleType = this.m_req.getParameter("RBSAdmin_RoleType");
        Collections.sort(this.m_rbsTaskRightsReport, new RBSRoleRightsReportSort(this.m_context, sortColumn, sortDirection));
        this.m_req.setAttribute("roleRightsReportData", (Object)this.m_rbsTaskRightsReport);
        this.m_req.setAttribute("sortColumn", (Object)sortColumn);
        this.m_req.setAttribute("sortDirection", (Object)sortDirection);
        this.m_req.setAttribute("reportTime", (Object)this.m_reportTime);
        this.m_req.setAttribute("selectedRoleDisplayName", (Object)selectedRoleDisplayName);
        this.m_req.setAttribute("selectedRoleFDN", (Object)selectedRoleFullName);
        this.m_req.setAttribute("RBSAdmin_RoleType", (Object)rbsAdmin_RoleType);
        return true;
    }

    public boolean handleExportFile() {
        if (this.m_context != null && this.m_rbsTaskRightsReport != null) {
            this.m_exportUtil = new ReportsExportUtil(this.m_context, this.m_rbsTaskRightsReport);
            this.m_exportUtil.exportRoleRightsReport();
        }
        return true;
    }

    public boolean handlePostRequestActions(HttpServletRequest req, HttpServletResponse resp) throws GadgetInstanceException {
        return this.m_exportUtil.sendRedirect(req, resp);
    }

    public class StringSort
    implements Comparator {
        Collator m_collator = null;
        TaskContext m_context = null;

        public StringSort(TaskContext context) {
            this.m_context = context;
            this.m_collator = Collator.getInstance(this.m_context.getLocale());
        }

        public int compare(Object object1, Object object2) {
            String[] str1 = (String[])object1;
            String[] str2 = (String[])object2;
            return this.m_collator.compare(str1[0], str2[0]);
        }
    }
}

