/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.LDAPSPIException;
import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.SchemaDefinition;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.ValueList;
import com.novell.admin.ns.ldap.LDAPSchemaDefinition;
import com.novell.admin.ns.nds.ObjectACLFacade;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectType;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.application.console.snapin.ResultModifierFilterEntry;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CategoryData;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.RoleAssocObject;
import com.novell.emframe.fw.RoleManagementInfo;
import com.novell.emframe.fw.VersionInfo;
import com.novell.emframe.fw.iManager;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSBook;
import com.novell.rbs.RBSCategory;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSModule;
import com.novell.rbs.RBSNVDSRights;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSTask;
import java.lang.reflect.Array;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.List;
import java.util.ListIterator;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.filter.ElementFilter;
import org.jdom.filter.Filter;

public final class RoleManagementTask
extends Task {
    private static final long serialVersionUID = 1L;
    public static final String HTMLPARAM_CREATECONTEXTNAME = "CreateRoleContext";
    public static final String HTMLPARAM_ROLEDISPLAYNAME = "SelectedRoleDisplayName";
    public static final String HTMLPARAM_ROLEFULLNAME = "SelectedRoleFullName";
    public static final String HTMLPARAM_NEWROLEDISPLAYNAME = "CreateRoleDisplayName";
    public static final String HTMLPARAM_CREATEROLEDESCRIPTION = "CreateRoleDescription";
    public static final String HTMLPARAM_DELMEMBERSLIST = "DeleteMemberList";
    public static final String HTMLPARAM_NEWMEMBER = "NewMemberName";
    public static final String HTMLPARAM_NEWROLEMEMBERS = "NewRoleMembers";
    public static final String HTMLPARAM_NEWMEMBERANDSCOPE = "NewMemberAndScope";
    public static final String HTMLPARAM_MODIFYSCOPELIST = "ModifyScopeList";
    public static final String HTMLPARAM_MODIFYINHERITANCELIST = "MemberInheritanceList";
    public static final String HTMLPARAM_ASSIGNEDTASKSCHANGED = "AssignedTasksChanged";
    public static final String HTMLPARAM_ASSIGNEDTASKSCOUNT = "AssignedTasksCount";
    public static final String HTMLPARAM_ASSIGNEDTASKS = "Role.AssignedTasks";
    public static final String HTMLPARAM_INHERITANCECHANGED = "MemberInheritanceChanged";
    public static final String HTMLPARAM_ASSIGN_RIGHTS_CHANGED = "MemberAssignRightsChanged";
    public static final String HTMLPARAM_ASSIGN_RIGHTS_LIST = "MemberAssignRightsList";
    public static final String HTMLPARAM_CREATEROLEPREVIOUSPAGE = "CreateRolePreviousPage";
    public static final String HTMLPARAM_RBSADMIN_ROLE_TYPE = "RBSAdmin_RoleType";
    public static final String ROLEMANAGEMENT_DESCRIPTION = "Description";
    public static final String EMPTY_STRING = "";
    public static final int HISTORY_MAXIMUM = 10;
    private HttpServletRequest m_req;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private AdminNamespace m_ns;
    private ObjectEntry m_treeOE;
    private Locale m_locale;
    private Collator m_localeCollator;
    private boolean m_bCallGetUsersAndScopes = true;
    private boolean m_bFirstTime = true;
    private boolean m_bCategoryRead = false;
    private boolean m_bNVDS = false;
    private ArrayList m_availableCategoryList = new ArrayList();
    private ArrayList m_assignedCategoryList = new ArrayList();
    private String m_sException;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        boolean controlPreviouslySet = true;
        try {
            this.m_context = context;
            this.m_resultStrings = resultStrings;
            this.m_treeOE = RBSUtil.getTreeOE(this.m_context);
            this.m_ns = this.m_treeOE.getAdminNamespace();
            this.m_req = this.m_context.getRequest();
            this.m_locale = this.m_context.getLocale();
            this.m_localeCollator = Collator.getInstance(this.m_locale);
            this.m_bNVDS = this.isNVDS();
            controlPreviouslySet = RBSUtil.setAliasControl(this.m_ns);
            String nextState = this.m_req.getParameter("nextState");
            if (nextState == null || nextState.equalsIgnoreCase("startRoleWizard")) {
                boolean bl = this.initializeRoleWizard();
                return bl;
            }
            if (nextState.equalsIgnoreCase("getFirstPageInfo")) {
                boolean bl = this.getFirstPageInfo();
                return bl;
            }
            if (nextState.equalsIgnoreCase("doCreateRole")) {
                boolean bl = this.doCreateRole();
                return bl;
            }
            if (nextState.equalsIgnoreCase("getUsersAndScopes")) {
                boolean bl = this.getUsersAndScopes();
                return bl;
            }
            if (nextState.equalsIgnoreCase("getTasksForRole")) {
                boolean bl = this.getTasksForRole();
                return bl;
            }
            if (nextState.equalsIgnoreCase("updateTasksInRole")) {
                boolean bl = this.updateTasksInRole();
                return bl;
            }
            if (nextState.equalsIgnoreCase("addMembersToTable")) {
                boolean bl = this.addMembersToTable();
                return bl;
            }
            if (nextState.equalsIgnoreCase("addMemberAndScopeToTable")) {
                boolean bl = this.addMemberAndScopeToTable();
                return bl;
            }
            if (nextState.equalsIgnoreCase("deleteMembersFromTable")) {
                boolean bl = this.deleteMembersFromTable();
                return bl;
            }
            if (nextState.equalsIgnoreCase("modifyMemberScopeInTable")) {
                boolean bl = this.modifyMemberScopeInTable();
                return bl;
            }
            if (nextState.equalsIgnoreCase("updateTable")) {
                boolean bl = this.updateTable();
                return bl;
            }
            if (nextState.equalsIgnoreCase("updateRole")) {
                boolean bl = this.updateRole();
                return bl;
            }
            if (nextState.equalsIgnoreCase("getSummaryInfo")) {
                boolean bl = this.getSummaryInfo();
                return bl;
            }
            if (nextState.equalsIgnoreCase("getRolesAndAssignedTasks")) {
                boolean bl = this.getRolesAndAssignedTasks("iManager");
                return bl;
            }
            if (nextState.equalsIgnoreCase("getEguideRolesAndAssignedTasks")) {
                boolean bl = this.getRolesAndAssignedTasks("eGuide");
                return bl;
            }
            if (nextState.equalsIgnoreCase("setupModifyTasksPage")) {
                boolean bl = this.setupModifyTasksPage();
                return bl;
            }
            if (nextState.equalsIgnoreCase("addTasksToRole")) {
                boolean bl = this.addTasksToRole();
                return bl;
            }
            if (nextState.equalsIgnoreCase("setupModifyAssociationsPage")) {
                boolean bl = this.setupModifyAssociationsPage();
                return bl;
            }
            if (nextState.equalsIgnoreCase("updateModifyRoleAssociations")) {
                boolean bl = this.updateModifyRoleAssociations();
                return bl;
            }
            if (nextState.equalsIgnoreCase("addScopeToTableMember")) {
                boolean bl = this.addScopeToTableMember();
                return bl;
            }
            if (nextState.equalsIgnoreCase("getCategories")) {
                boolean bl = this.getCategories();
                return bl;
            }
            boolean bl = true;
            return bl;
        }
        finally {
            RBSUtil.clearAliasControl(this.m_ns, controlPreviouslySet);
        }
    }

    private boolean getCategories() {
        String assignedTasksChanged;
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String createRoleDisplayName = roleInfoObject.getCreateRoleDisplayName();
        String createRoleContext = roleInfoObject.getCreateRoleContext();
        String previousPage = this.m_req.getParameter(HTMLPARAM_CREATEROLEPREVIOUSPAGE);
        if (previousPage != null && previousPage.equals("ChooseTasks") && (assignedTasksChanged = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKSCHANGED)) != null && assignedTasksChanged.equals("true")) {
            String assignedTasks = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKS);
            String assignedTasksCount = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKSCOUNT);
            roleInfoObject.setAssignedTasksChanged(assignedTasksChanged);
            roleInfoObject.setAssignedTasks(assignedTasks);
            roleInfoObject.setAssignedTasksCount(assignedTasksCount);
        }
        if (!this.m_bCategoryRead) {
            try {
                ObjectEntry collectionOE = this.m_ns.getObjectEntry(this.m_treeOE, createRoleContext);
                RBSCollection rbsCollection = new RBSCollection(collectionOE);
                RBSCategory[] rbsCategory = rbsCollection.getCategories();
                this.m_bCategoryRead = true;
                if (rbsCategory != null) {
                    this.m_resultStrings.put("AvailableCategory.Count", Integer.toString(rbsCategory.length));
                    for (int i = 0; i < rbsCategory.length; ++i) {
                        String categoryDescription = this.getDescFromAttr(rbsCategory[i].getObjectEntry());
                        String fullName = this.m_ns.getUnrootedName(rbsCategory[i].getObjectEntry());
                        String displayName = RBSUtil.getLocalizedDisplayName(this.m_context, rbsCategory[i].getObjectEntry());
                        CategoryData categoryData = new CategoryData();
                        categoryData.setObjectFDN(fullName);
                        categoryData.setDisplayName(displayName);
                        categoryData.setCategoryDesc(categoryDescription);
                        this.m_availableCategoryList.add(categoryData);
                    }
                } else {
                    this.m_resultStrings.put("AvailableCategory.Count", Integer.toString(0));
                }
            }
            catch (Exception exc) {
                D.log(exc);
                this.m_sException = eMFrameUtils.getExceptionMessage(exc, this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context.getLocale());
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            }
        }
        this.m_resultStrings.put("RoleDisplayName", createRoleDisplayName);
        this.putAvailableCategories();
        this.putAssignedCategories();
        return true;
    }

    private boolean initializeRoleWizard() {
        RoleManagementInfo roleInfoObject = new RoleManagementInfo(this.m_ns);
        String taskDelegate = this.m_req.getParameter("RBSAdmin_TaskDelegate");
        roleInfoObject.setCreateNewRole("true");
        roleInfoObject.setTableChangedValue("false");
        if (taskDelegate != null) {
            roleInfoObject.setTaskDelegate(taskDelegate);
            String createRoleContext = this.m_req.getParameter(HTMLPARAM_CREATECONTEXTNAME);
            String[] strings = eMFrameUtils.unpack(createRoleContext, this.m_context);
            createRoleContext = strings[0];
            roleInfoObject.setCreateRoleContext(createRoleContext);
        }
        this.m_context.setAuthAttribute("RoleInfoObject", roleInfoObject);
        this.m_resultStrings.put(HTMLPARAM_NEWROLEDISPLAYNAME, EMPTY_STRING);
        this.m_resultStrings.put("CreateRoleFullName", EMPTY_STRING);
        this.m_resultStrings.put(HTMLPARAM_CREATEROLEDESCRIPTION, EMPTY_STRING);
        this.m_resultStrings.put(HTMLPARAM_CREATECONTEXTNAME, roleInfoObject.getCreateRoleContext());
        this.m_resultStrings.put("Role.Member.EmptyName", EMPTY_STRING);
        this.m_resultStrings.put("RBSAdmin_TaskDelegate", roleInfoObject.getTaskDelegate());
        return this.getOwnedRoles();
    }

    private boolean getFirstPageInfo() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String createNewRole = roleInfoObject.getCreateNewRole();
        String previousPage = this.m_req.getParameter(HTMLPARAM_CREATEROLEPREVIOUSPAGE);
        String assignedTasks = EMPTY_STRING;
        String assignedTasksCount = EMPTY_STRING;
        String assignedTasksChanged = EMPTY_STRING;
        if (previousPage != null && previousPage.equalsIgnoreCase("ChooseTasks") && (assignedTasksChanged = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKSCHANGED)).equals("true")) {
            assignedTasks = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKS);
            assignedTasksCount = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKSCOUNT);
            roleInfoObject.setAssignedTasksChanged(assignedTasksChanged);
            roleInfoObject.setAssignedTasks(assignedTasks);
            roleInfoObject.setAssignedTasksCount(assignedTasksCount);
        }
        if (createNewRole.equals("true")) {
            String createRoleDisplayName = roleInfoObject.getCreateRoleDisplayName();
            String createRoleFullName = roleInfoObject.getCreateRoleFullName();
            String createRoleDescription = roleInfoObject.getCreateRoleDescription();
            String createRoleContext = roleInfoObject.getCreateRoleContext();
            String selfProvisioningRole = roleInfoObject.getSelfProvisioningRole();
            this.m_resultStrings.put(HTMLPARAM_NEWROLEDISPLAYNAME, createRoleDisplayName);
            this.m_resultStrings.put("CreateRoleFullName", createRoleFullName);
            this.m_resultStrings.put(HTMLPARAM_CREATEROLEDESCRIPTION, createRoleDescription);
            this.m_resultStrings.put(HTMLPARAM_CREATECONTEXTNAME, createRoleContext);
            this.m_resultStrings.put("RoleDisplayName", createRoleDisplayName);
            this.m_resultStrings.put("SelfProvisioningRole", selfProvisioningRole);
            this.m_resultStrings.put("RBSAdmin_TaskDelegate", roleInfoObject.getTaskDelegate());
            roleInfoObject.setInitialSetup(true);
            return true;
        }
        String selectedRoleDisplayName = roleInfoObject.getSelectedRoleDisplayName();
        String selectedRoleFullName = roleInfoObject.getSelectedRoleFullName();
        this.m_resultStrings.put("RoleDisplayName", selectedRoleDisplayName);
        this.m_resultStrings.put(HTMLPARAM_ROLEFULLNAME, selectedRoleFullName);
        this.m_resultStrings.put(HTMLPARAM_ROLEDISPLAYNAME, selectedRoleDisplayName);
        return true;
    }

    private boolean searchForTasks() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        ObjectEntry collectionObjectEntry = null;
        String createNewRole = roleInfoObject.getCreateNewRole();
        String createRoleContext = roleInfoObject.getCreateRoleContext();
        boolean collectionOwner = false;
        int iTaskCount = 0;
        if (createRoleContext == null || createRoleContext.equalsIgnoreCase(EMPTY_STRING)) {
            if (createNewRole.equals("true")) {
                createRoleContext = this.m_req.getParameter(HTMLPARAM_CREATECONTEXTNAME);
            } else {
                String selectedRoleFullName = this.m_req.getParameter(HTMLPARAM_ROLEFULLNAME);
                String[] strings = eMFrameUtils.unpack(selectedRoleFullName, this.m_context);
                selectedRoleFullName = strings[0];
                try {
                    ObjectEntry selectedRoleOE = this.m_ns.getObjectEntry(this.m_treeOE, selectedRoleFullName);
                    ObjectEntry collectionOE = selectedRoleOE.getParent();
                    createRoleContext = this.m_ns.getUnrootedName(collectionOE);
                }
                catch (SPIException e) {
                    D.log(e);
                    this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                    eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                }
            }
        }
        if (!this.isValidCollectionObjectType(collectionObjectEntry = this.getObjectEntryFromString(createRoleContext))) {
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.COLLECTION_FAILURE_TITLE", this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.COLLECTION_NOTFOUND", this.m_context));
            return false;
        }
        collectionOwner = this.isCollectionOwner(collectionObjectEntry);
        if (collectionObjectEntry != null && collectionOwner) {
            try {
                String[] arStrTypeFilter = new String[]{"rbsModule2"};
                ResultModifier rm = new ResultModifier("SearchModifier");
                rm.setSortByKey(0);
                rm.setSubContainerSearch(true);
                ResultModifierFilterEntry filterEntry = new ResultModifierFilterEntry(null, arStrTypeFilter);
                rm.addFilter(filterEntry);
                ObjectEntryEnumeration enumCollection = this.m_ns.getChildren(collectionObjectEntry);
                while (enumCollection.hasMoreElements()) {
                    ObjectEntry oe = (ObjectEntry)enumCollection.nextElement();
                    ObjectType ot = oe.getObjectType();
                    if (!ot.isContainer() || !ot.getName().equals("rbsModule2")) continue;
                    RBSModule module = new RBSModule(oe);
                    String[] taskTypes = null;
                    RBSObject[] tasks = module.getSpecifiedTasks(taskTypes);
                    boolean addTaskToList = true;
                    if (tasks == null) continue;
                    for (int j = 0; j < tasks.length; ++j) {
                        addTaskToList = this.verifyTaskAttributesExist((RBSTask)tasks[j]);
                        if (!addTaskToList) continue;
                        String fullName = DirUtils.removeTreeFromFullName(this.m_treeOE, tasks[j].getObjectEntry().getFullName());
                        String displayName = DirUtils.getLeftMostName(this.m_ns, fullName);
                        String parameters = ((RBSTask)tasks[j]).getParameters();
                        String taskTranslatedName = RBSUtil.getLocalizedDisplayName(this.m_context, tasks[j].getObjectEntry());
                        String taskDescription = this.getDescFromAttr(tasks[j].getObjectEntry());
                        String supervisorRights = "false";
                        String secondaryRights = "false";
                        String superAndSecondaryRights = "false";
                        if (parameters != null) {
                            VersionInfo iManagerVersionInfo;
                            VersionInfo expiredVersionInfo;
                            String expiredVersion = RBSUtil.getKeyFromParameters(parameters, "expired-version");
                            boolean grantsSupervisorRights = this.checkTaskForSupervisorRights((RBSTask)tasks[j]);
                            boolean setsSecondaryRights = ((RBSTask)tasks[j]).hasSecondaryRights();
                            if (expiredVersion != null && (expiredVersionInfo = new VersionInfo(expiredVersion)).compareTo(iManagerVersionInfo = new VersionInfo(iManager.getVersionString())) <= 0) continue;
                            if (grantsSupervisorRights) {
                                supervisorRights = "true";
                            }
                            if (setsSecondaryRights) {
                                secondaryRights = "true";
                            }
                            if (grantsSupervisorRights && setsSecondaryRights) {
                                superAndSecondaryRights = "true";
                            }
                        }
                        if (tasks[j] instanceof RBSBook) {
                            // empty if block
                        }
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".FullName", fullName);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".DisplayName", displayName);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".Description", taskDescription);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".TaskTranslatedName", taskTranslatedName);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".SupervisorRights", supervisorRights);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".SecondaryRights", secondaryRights);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".SuperAndSecondaryRights", superAndSecondaryRights);
                        ++iTaskCount;
                    }
                }
            }
            catch (Exception e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                return false;
            }
        } else {
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.COLLECTION_OWNER_NOT_FOUND_TITLE", this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NOT_COLLECTION_OWNER", this.m_context));
            return false;
        }
        this.m_resultStrings.put("Alltasks.Count", Integer.toString(iTaskCount));
        return true;
    }

    private boolean searchForEguideTasks() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        ObjectEntry containerObjectEntry = null;
        String createNewRole = roleInfoObject.getCreateNewRole();
        String createRoleContext = roleInfoObject.getCreateRoleContext();
        boolean collectionOwner = false;
        int iTaskCount = 0;
        if (createRoleContext == null || createRoleContext.equalsIgnoreCase(EMPTY_STRING)) {
            if (createNewRole.equals("true")) {
                createRoleContext = this.m_req.getParameter(HTMLPARAM_CREATECONTEXTNAME);
            } else {
                String selectedRoleFullName = this.m_req.getParameter(HTMLPARAM_ROLEFULLNAME);
                try {
                    ObjectEntry selectedRoleOE = this.m_ns.getObjectEntry(this.m_treeOE, selectedRoleFullName);
                    ObjectEntry collectionOE = selectedRoleOE.getParent();
                    createRoleContext = this.m_ns.getUnrootedName(collectionOE);
                }
                catch (SPIException e) {
                    D.log(e);
                    this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                    eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                    return false;
                }
            }
        }
        if (!this.isValidCollectionObjectType(containerObjectEntry = this.getObjectEntryFromString(createRoleContext))) {
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.COLLECTION_FAILURE_TITLE", this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.COLLECTION_NOTFOUND", this.m_context));
            return false;
        }
        collectionOwner = this.isCollectionOwner(containerObjectEntry);
        if (containerObjectEntry != null && collectionOwner) {
            try {
                String[] arStrTypeFilter = new String[]{"rbsModule2"};
                ResultModifier rm = new ResultModifier("SearchModifier");
                rm.setSortByKey(0);
                rm.setSubContainerSearch(true);
                ResultModifierFilterEntry filterEntry = new ResultModifierFilterEntry(null, arStrTypeFilter);
                rm.addFilter(filterEntry);
                ObjectEntryEnumeration enumCollection = this.m_ns.getChildren(containerObjectEntry);
                while (enumCollection.hasMoreElements()) {
                    ObjectEntry oe = (ObjectEntry)enumCollection.nextElement();
                    ObjectType ot = oe.getObjectType();
                    if (!ot.isContainer() || !ot.getName().equals("rbsModule2")) continue;
                    RBSModule module = new RBSModule(oe);
                    String[] taskTypes = new String[]{"eGuide"};
                    RBSObject[] tasks = module.getSpecifiedTasks(taskTypes);
                    boolean addTaskToList = true;
                    if (tasks == null) continue;
                    for (int j = 0; j < tasks.length; ++j) {
                        VersionInfo iManagerVersionInfo;
                        VersionInfo expiredVersionInfo;
                        addTaskToList = this.verifyTaskAttributesExist((RBSTask)tasks[j]);
                        if (!addTaskToList) continue;
                        String fullName = DirUtils.removeTreeFromFullName(this.m_treeOE, tasks[j].getObjectEntry().getFullName());
                        String displayName = DirUtils.getLeftMostName(this.m_ns, fullName);
                        String taskDescription = RBSUtil.getLocalizedDescriptionName(this.m_context, tasks[j].getObjectEntry());
                        String parameters = ((RBSTask)tasks[j]).getParameters();
                        String taskTranslatedName = RBSUtil.getLocalizedDisplayName(this.m_context, tasks[j].getObjectEntry());
                        if (parameters == null) continue;
                        String eguideAttributes = this.getEguideAttributesFromTask(tasks[j]);
                        String supervisorRights = "false";
                        String secondaryRights = "false";
                        String superAndSecondaryRights = "false";
                        String expiredVersion = RBSUtil.getKeyFromParameters(parameters, "expired-version");
                        boolean grantsSupervisorRights = this.checkTaskForSupervisorRights((RBSTask)tasks[j]);
                        boolean setsSecondaryRights = ((RBSTask)tasks[j]).hasSecondaryRights();
                        if (expiredVersion != null && (expiredVersionInfo = new VersionInfo(expiredVersion)).compareTo(iManagerVersionInfo = new VersionInfo(iManager.getVersionString())) <= 0) continue;
                        if (grantsSupervisorRights) {
                            supervisorRights = "true";
                        }
                        if (setsSecondaryRights) {
                            secondaryRights = "true";
                        }
                        if (grantsSupervisorRights && setsSecondaryRights) {
                            superAndSecondaryRights = "true";
                        }
                        if (tasks[j] instanceof RBSBook) {
                            // empty if block
                        }
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".FullName", fullName);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".DisplayName", displayName);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".Description", taskDescription);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".TaskTranslatedName", taskTranslatedName);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".EguideAttributes", eguideAttributes);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".SupervisorRights", supervisorRights);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".SecondaryRights", secondaryRights);
                        this.m_resultStrings.put("Role.Alltasks." + iTaskCount + ".SuperAndSecondaryRights", superAndSecondaryRights);
                        ++iTaskCount;
                    }
                }
            }
            catch (Exception e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                return false;
            }
        } else {
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.COLLECTION_OWNER_NOT_FOUND_TITLE", this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NOT_COLLECTION_OWNER", this.m_context));
            return false;
        }
        this.m_resultStrings.put("Alltasks.Count", Integer.toString(iTaskCount));
        return true;
    }

    private boolean updateRole() {
        String strBody;
        String strTitle;
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String createNewRole = roleInfoObject.getCreateNewRole();
        String assignedTasksChanged = roleInfoObject.getAssignedTasksChanged();
        String inheritanceChanged = roleInfoObject.getInheritanceChanged();
        String assignRightsChanged = roleInfoObject.getAssignRightsChanged();
        String tableChanged = roleInfoObject.getTableChangedValue();
        boolean rVal = true;
        if (createNewRole.equals("true") && !(rVal = this.doCreateRole())) {
            return false;
        }
        try {
            if (this.m_assignedCategoryList.size() > 0) {
                ObjectEntry roleOE = this.m_ns.getObjectEntry(this.m_treeOE, roleInfoObject.getCreateRoleFullName());
                RBSRole rbsRole = new RBSRole(roleOE);
                ObjectEntry[] catOE = new ObjectEntry[this.m_assignedCategoryList.size()];
                for (int i = 0; i < this.m_assignedCategoryList.size(); ++i) {
                    CategoryData categoryData = (CategoryData)this.m_assignedCategoryList.get(i);
                    catOE[i] = this.m_ns.getObjectEntry(this.m_treeOE, categoryData.getObjectFDN());
                }
                rbsRole.setCategoryMembership(catOE);
                rbsRole.update();
            }
        }
        catch (Exception exc) {
            eMFrameUtils.setErrorMessage(exc, this.m_context);
            return false;
        }
        if (assignedTasksChanged.equals("true") && !(rVal = this.updateTasksInRole())) {
            return false;
        }
        if (inheritanceChanged.equals("true")) {
            this.modifyMemberInheritanceInTable();
        }
        if (assignRightsChanged.equals("true")) {
            this.modifyMemberAssignRightsInTable();
        }
        if (tableChanged.equals("true") && !(rVal = this.updateRoleAssociations())) {
            return false;
        }
        if (createNewRole.equals("true")) {
            strTitle = eMFrameUtils.getLocalizedString("BaseResources", "CreateRole.Title", this.m_context);
            strBody = eMFrameUtils.getLocalizedString("BaseResources", "CreateRole.Success", this.m_context);
            eMFrameUtils.setMessage("success", strTitle, strBody + " " + roleInfoObject.getCreateRoleFullName(), this.m_context);
        } else {
            strTitle = eMFrameUtils.getLocalizedString("BaseResources", "ModifyRole.Title", this.m_context);
            strBody = eMFrameUtils.getLocalizedString("BaseResources", "ModifyRole.Success", this.m_context);
            eMFrameUtils.setMessage("success", strTitle, strBody + " " + roleInfoObject.getSelectedRoleFullName(), this.m_context);
        }
        return true;
    }

    /*
     * Exception decompiling
     */
    private boolean updateRoleAssociations() {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 2 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private boolean updateTasksInRole() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String createRoleFullName = roleInfoObject.getCreateRoleFullName();
        String selectedRoleFullName = roleInfoObject.getSelectedRoleFullName();
        ObjectEntry roleOE = null;
        if (this.isCreateRoleTask()) {
            try {
                roleOE = this.m_ns.getObjectEntry(this.m_treeOE, createRoleFullName);
            }
            catch (SPIException e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                return false;
            }
        }
        if (selectedRoleFullName != null) {
            try {
                roleOE = this.m_ns.getObjectEntry(this.m_treeOE, selectedRoleFullName);
            }
            catch (SPIException e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                return false;
            }
        }
        RBSRole role = new RBSRole(roleOE);
        try {
            ArrayList alErrors = RBSUtil.checkMemberScopeRightsForRole(this.m_context, role);
            if (alErrors != null) {
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "EditTask.RequestFailedTitle", this.m_context);
                String strBody = eMFrameUtils.getLocalizedString("FwResources", "EditTask.RequestFailedMessage", this.m_context);
                eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, strBody, alErrors);
                this.setUIPage("dev/MooGenErr.jsp");
                this.setInitialMooError();
                return false;
            }
        }
        catch (Exception e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        String newTasks = roleInfoObject.getAssignedTasks();
        StringTokenizer izer = new StringTokenizer(newTasks, ";", false);
        RBSObject[] tasks = new RBSObject[izer.countTokens()];
        int tokenCount = 0;
        while (izer.hasMoreTokens()) {
            ObjectEntry taskOE = null;
            try {
                taskOE = this.m_ns.getObjectEntry(this.m_treeOE, izer.nextToken());
                RBSTask task = new RBSTask(taskOE);
                tasks[tokenCount] = task;
                ++tokenCount;
            }
            catch (SPIException e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                return false;
            }
        }
        try {
            String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
            role.setContent(tasks, dynamicGroupSearchType);
            role.update();
        }
        catch (Exception e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        String strTitle = eMFrameUtils.getLocalizedString("BaseResources", "ModifyRole.Title", this.m_context);
        String strBody = eMFrameUtils.getLocalizedString("BaseResources", "ModifyRole.Success", this.m_context);
        eMFrameUtils.setMessage("success", strTitle, strBody + roleInfoObject.getSelectedRoleFullName(), this.m_context);
        return true;
    }

    private boolean addTasksToRole() {
        boolean rVal;
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String rbsAdmin_RoleType = this.m_req.getParameter(HTMLPARAM_RBSADMIN_ROLE_TYPE);
        String assignedTasks = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKS);
        String assignedTasksCount = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKSCOUNT);
        String assignedTasksChanged = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKSCHANGED);
        roleInfoObject.setAssignedTasksChanged(assignedTasksChanged);
        roleInfoObject.setAssignedTasks(assignedTasks);
        roleInfoObject.setAssignedTasksCount(assignedTasksCount);
        this.m_resultStrings.put(HTMLPARAM_RBSADMIN_ROLE_TYPE, rbsAdmin_RoleType);
        return !assignedTasksChanged.equals("true") || (rVal = this.updateTasksInRole());
    }

    private boolean getUsersAndScopes() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String previousPage = this.m_req.getParameter(HTMLPARAM_CREATEROLEPREVIOUSPAGE);
        String createNewRole = roleInfoObject.getCreateNewRole();
        String rbsAdminRoleType = roleInfoObject.getRBSAdmin_RoleType();
        String selfProvisioningRole = roleInfoObject.getSelfProvisioningRole();
        String newMemberList = EMPTY_STRING;
        String assignedTasks = EMPTY_STRING;
        String assignedTasksCount = EMPTY_STRING;
        String assignedTasksChanged = EMPTY_STRING;
        if (previousPage != null && previousPage.equals("ChooseTasks") && (assignedTasksChanged = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKSCHANGED)) != null && assignedTasksChanged.equals("true")) {
            assignedTasks = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKS);
            assignedTasksCount = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKSCOUNT);
            roleInfoObject.setAssignedTasksChanged(assignedTasksChanged);
            roleInfoObject.setAssignedTasks(assignedTasks);
            roleInfoObject.setAssignedTasksCount(assignedTasksCount);
        }
        if (previousPage != null && previousPage.equals("ChooseCategory")) {
            this.getAvailableCategories();
            this.getAssignedCategories();
        }
        if (createNewRole.equals("true")) {
            String createRoleDisplayName = roleInfoObject.getCreateRoleDisplayName();
            this.m_resultStrings.put("RoleDisplayName", createRoleDisplayName);
            this.m_resultStrings.put("NewMemberList", newMemberList);
            this.m_resultStrings.put(HTMLPARAM_RBSADMIN_ROLE_TYPE, rbsAdminRoleType);
            this.m_resultStrings.put("SelfProvisioningRole", selfProvisioningRole);
            this.updateTable();
            return true;
        }
        String selectedRoleDisplayName = roleInfoObject.getSelectedRoleDisplayName();
        String selectedRoleFullName = roleInfoObject.getSelectedRoleFullName();
        this.m_resultStrings.put("RoleDisplayName", selectedRoleDisplayName);
        this.m_resultStrings.put(HTMLPARAM_ROLEFULLNAME, selectedRoleFullName);
        this.m_resultStrings.put(HTMLPARAM_ROLEDISPLAYNAME, selectedRoleDisplayName);
        roleInfoObject.clearRoleMemberData();
        ObjectEntry roleOE = null;
        try {
            roleOE = this.m_ns.getObjectEntry(this.m_treeOE, selectedRoleFullName);
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        try {
            RBSRole role = new RBSRole(roleOE);
            RBSAssociation[] roleAssociation = role.getMembers();
            if (roleAssociation != null) {
                Arrays.sort(roleAssociation, new RBSObjectComparator(this.m_locale));
                for (int i = 0; i < roleAssociation.length; ++i) {
                    ObjectEntry roleMember = roleAssociation[i].getMember();
                    String fullName = DirUtils.removeTreeFromFullName(this.m_treeOE, roleMember.getFullName());
                    ObjectEntry roleScope = roleAssociation[i].getScope();
                    String scopeFullName = EMPTY_STRING;
                    scopeFullName = roleScope.getObjectType().getName().equals("Top") ? roleScope.getFullName() : DirUtils.removeTreeFromFullName(this.m_treeOE, roleScope.getFullName());
                    if (this.m_bNVDS && scopeFullName.equalsIgnoreCase(EMPTY_STRING)) {
                        scopeFullName = "[root]";
                    }
                    String inheritance = roleAssociation[i].getInheritanceScope();
                    boolean rightsSet = roleAssociation[i].isRightsSet();
                    String assignRights = EMPTY_STRING;
                    assignRights = rightsSet ? "true" : "false";
                    if (!roleInfoObject.searchForMember(fullName)) {
                        roleInfoObject.addRoleMember(fullName, scopeFullName, inheritance, assignRights);
                        continue;
                    }
                    roleInfoObject.setScopeInheritance(fullName, scopeFullName, inheritance, assignRights);
                }
            }
        }
        catch (Exception e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        this.updateTable();
        this.m_resultStrings.put(HTMLPARAM_RBSADMIN_ROLE_TYPE, rbsAdminRoleType);
        this.m_resultStrings.put("SelfProvisioningRole", selfProvisioningRole);
        return true;
    }

    private boolean getSummaryInfo() {
        String roleType;
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String createNewRole = roleInfoObject.getCreateNewRole();
        String inheritanceChanged = this.m_req.getParameter(HTMLPARAM_INHERITANCECHANGED);
        String assignRightsChanged = this.m_req.getParameter(HTMLPARAM_ASSIGN_RIGHTS_CHANGED);
        boolean m_bChangedValues = false;
        if (inheritanceChanged != null && inheritanceChanged.equals("true")) {
            this.modifyMemberInheritanceInTable();
            roleInfoObject.setInheritanceChanged("false");
            m_bChangedValues = true;
        }
        if (assignRightsChanged != null && assignRightsChanged.equals("true")) {
            this.modifyMemberAssignRightsInTable();
            roleInfoObject.setAssignRightsChanged("false");
            m_bChangedValues = true;
        }
        if ((roleType = roleInfoObject.getRBSAdmin_RoleType()) != null) {
            this.m_resultStrings.put(HTMLPARAM_RBSADMIN_ROLE_TYPE, roleType);
        }
        if (createNewRole.equals("true")) {
            String createRoleDisplayName = roleInfoObject.getCreateRoleDisplayName();
            String createRoleFullName = roleInfoObject.getCreateRoleFullName();
            String createRoleContext = roleInfoObject.getCreateRoleContext();
            m_bChangedValues = true;
            this.m_resultStrings.put("CreateRoleFullName", createRoleFullName);
            this.m_resultStrings.put(HTMLPARAM_CREATECONTEXTNAME, createRoleContext);
            this.m_resultStrings.put("RoleDisplayName", createRoleDisplayName);
            if (roleInfoObject.getAssignedTasksChanged().equals("true")) {
                String newTasks = roleInfoObject.getAssignedTasks();
                StringTokenizer izer = new StringTokenizer(newTasks, ";", false);
                int iTask = 0;
                while (izer.hasMoreTokens()) {
                    ObjectEntry taskOE = null;
                    String taskName = izer.nextToken();
                    try {
                        taskOE = this.m_ns.getObjectEntry(taskName);
                    }
                    catch (SPIException spie) {
                        D.log(spie);
                        continue;
                    }
                    String displayName = RBSUtil.getLocalizedDisplayName(this.m_context, taskOE);
                    this.m_resultStrings.put("Role.Task." + iTask + ".DisplayName", displayName);
                    this.m_resultStrings.put("Role.Task." + iTask + ".FullName", taskName);
                    ++iTask;
                }
                this.m_resultStrings.put("Role.Tasks.Count", Integer.toString(iTask));
            }
            this.m_resultStrings.put("Role.Category.Count", Integer.toString(this.m_assignedCategoryList.size()));
            if (this.m_assignedCategoryList.size() > 0) {
                for (int i = 0; i < this.m_assignedCategoryList.size(); ++i) {
                    CategoryData categoryData = (CategoryData)this.m_assignedCategoryList.get(i);
                    this.m_resultStrings.put("Role.Category." + i + ".DisplayName", categoryData.getDisplayName());
                }
            }
            if (roleInfoObject.getTableChangedValue().equals("true")) {
                Vector roleAssocVector = roleInfoObject.getRoleAssocObjectsVector();
                Collections.sort(roleAssocVector, new RoleAssocComparator(this.m_locale));
                int memberCount = 0;
                for (int i = 0; i < roleAssocVector.size(); ++i) {
                    RoleAssocObject newMemberObject = (RoleAssocObject)roleAssocVector.get(i);
                    String memberName = newMemberObject.getName();
                    Hashtable scopeInheritanceTable = newMemberObject.getScopeHastable();
                    Object[] m_sArray = scopeInheritanceTable.keySet().toArray();
                    Arrays.sort(m_sArray, this.m_localeCollator);
                    for (int j = 0; j < m_sArray.length; ++j) {
                        String memberScope = (String)m_sArray[j];
                        String[] m_sInheritanceArray = (String[])scopeInheritanceTable.get(memberScope);
                        String memberInheritance = m_sInheritanceArray[1];
                        String assignRights = m_sInheritanceArray[0];
                        if (memberScope.equalsIgnoreCase(this.m_treeOE.getName())) {
                            memberScope = "[root]";
                        }
                        this.m_resultStrings.put("Role.Member." + memberCount + ".FullName", memberName);
                        this.m_resultStrings.put("Role.Member." + memberCount + ".ScopeFullName", memberScope);
                        this.m_resultStrings.put("Role.Member." + memberCount + ".Inheritance", memberInheritance);
                        this.m_resultStrings.put("Role.Member." + memberCount + ".AssignRights", assignRights);
                        ++memberCount;
                    }
                }
                this.m_resultStrings.put("Role.Member.Count", Integer.toString(memberCount));
            }
            return true;
        }
        if (!m_bChangedValues) {
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ModifyRoleAssociationsTitle", this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.NoChangesDetected", this.m_context));
            return false;
        }
        String selectedRoleDisplayName = roleInfoObject.getSelectedRoleDisplayName();
        String selectedRoleFullName = roleInfoObject.getSelectedRoleFullName();
        this.m_resultStrings.put("RoleDisplayName", selectedRoleDisplayName);
        this.m_resultStrings.put(HTMLPARAM_ROLEFULLNAME, selectedRoleFullName);
        this.m_resultStrings.put(HTMLPARAM_ROLEDISPLAYNAME, selectedRoleDisplayName);
        return true;
    }

    private boolean updateTable() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String createNewRole = roleInfoObject.getCreateNewRole();
        String[] memberListArray = roleInfoObject.getMemberList();
        String memberList = this.convertStringArrayToString(memberListArray);
        StringBuffer sbMemberScopeBuffer = new StringBuffer();
        ObjectEntry memberObjectEntry = null;
        this.setRoleMemberFilter();
        if (createNewRole.equals("true")) {
            String createRoleDisplayName = roleInfoObject.getCreateRoleDisplayName();
            this.setRoleScopeFilter(null);
            this.m_resultStrings.put("RoleDisplayName", createRoleDisplayName);
        } else {
            String selectedRoleDisplayName = roleInfoObject.getSelectedRoleDisplayName();
            String selectedRoleFullName = roleInfoObject.getSelectedRoleFullName();
            this.setRoleScopeFilter(selectedRoleFullName);
            this.m_resultStrings.put("RoleDisplayName", selectedRoleDisplayName);
            this.m_resultStrings.put(HTMLPARAM_ROLEFULLNAME, selectedRoleFullName);
            this.m_resultStrings.put(HTMLPARAM_ROLEDISPLAYNAME, selectedRoleDisplayName);
        }
        this.m_resultStrings.put("NewMemberList", memberList);
        this.m_resultStrings.put("rbs_isNVDS", String.valueOf(this.m_bNVDS));
        int memberCount = 0;
        Object[] aclScopeValueArray = this.getAclScopeValues();
        for (int j = 0; j < aclScopeValueArray.length; ++j) {
            this.m_resultStrings.put("Role.AclScopeValue" + j, aclScopeValueArray[j]);
        }
        this.m_resultStrings.put("Role.AclScopeValues.Count", String.valueOf(aclScopeValueArray.length));
        Arrays.sort(memberListArray, this.m_localeCollator);
        for (int i = 0; i < memberListArray.length; ++i) {
            String memberName = memberListArray[i];
            String memberDisplayName = roleInfoObject.getMemberDisplayName(memberName);
            String assignRights = "true";
            String inheritance = "true";
            memberObjectEntry = this.getObjectEntryFromString(memberName);
            Hashtable scopeInheritanceTable = roleInfoObject.getScopeInheritanceTable(memberName);
            if (scopeInheritanceTable.isEmpty()) {
                this.m_resultStrings.put("Role.Member." + memberCount + ".FullName", memberName);
                this.m_resultStrings.put("Role.Member." + memberCount + ".DisplayName", memberDisplayName);
                this.m_resultStrings.put("Role.Member." + memberCount + ".RowId", Integer.toString(memberCount));
                this.m_resultStrings.put("Role.Member." + memberCount + ".ScopeFullName", EMPTY_STRING);
                this.m_resultStrings.put("Role.Member." + memberCount + ".ScopeDisplayName", EMPTY_STRING);
                this.m_resultStrings.put("Role.Member." + memberCount + ".AssignRights", assignRights);
                this.m_resultStrings.put("Role.Member." + memberCount + ".Inheritance", inheritance);
                this.m_resultStrings.put("Role.Member." + memberCount + ".Type", this.m_context.getDirUtils().getObjectEntryImageName(memberObjectEntry));
                this.m_resultStrings.put("Role.Member." + memberCount + ".TypeNoGif", memberObjectEntry.getObjectType().getName());
                this.m_resultStrings.put("Role.Member." + memberCount + ".DynamicGroupAux", this.hasDynamicGroupAux(memberObjectEntry));
                ++memberCount;
                if (this.m_bNVDS) {
                    sbMemberScopeBuffer.append(memberName + "$,$;");
                    continue;
                }
                sbMemberScopeBuffer.append(memberName + ",;");
                continue;
            }
            Object[] m_sArray = scopeInheritanceTable.keySet().toArray();
            Arrays.sort(m_sArray, this.m_localeCollator);
            for (int j = 0; j < m_sArray.length; ++j) {
                String scope;
                String scopeDisplayName = scope = (String)m_sArray[j];
                String[] sInheritanceArray = (String[])scopeInheritanceTable.get(scope);
                inheritance = sInheritanceArray[1];
                assignRights = sInheritanceArray[0];
                if (scope.startsWith("tempscope")) {
                    scopeDisplayName = EMPTY_STRING;
                }
                if (scope.equalsIgnoreCase(this.m_treeOE.getName())) {
                    scopeDisplayName = "[root]";
                    if (this.m_bNVDS && scope.equalsIgnoreCase(EMPTY_STRING)) {
                        scope = "[root]";
                    }
                }
                this.m_resultStrings.put("Role.Member." + memberCount + ".FullName", memberName);
                this.m_resultStrings.put("Role.Member." + memberCount + ".DisplayName", memberDisplayName);
                this.m_resultStrings.put("Role.Member." + memberCount + ".ScopeFullName", scope);
                this.m_resultStrings.put("Role.Member." + memberCount + ".ScopeDisplayName", scopeDisplayName);
                this.m_resultStrings.put("Role.Member." + memberCount + ".ScopeId", Integer.toString(memberCount));
                this.m_resultStrings.put("Role.Member." + memberCount + ".Inheritance", inheritance);
                this.m_resultStrings.put("Role.Member." + memberCount + ".AssignRights", assignRights);
                this.m_resultStrings.put("Role.Member." + memberCount + ".RowId", Integer.toString(memberCount));
                this.m_resultStrings.put("Role.Member." + memberCount + ".Type", this.m_context.getDirUtils().getObjectEntryImageName(memberObjectEntry));
                this.m_resultStrings.put("Role.Member." + memberCount + ".TypeNoGif", memberObjectEntry.getObjectType().getName());
                this.m_resultStrings.put("Role.Member." + memberCount + ".DynamicGroupAux", this.hasDynamicGroupAux(memberObjectEntry));
                ++memberCount;
                if (this.m_bNVDS) {
                    sbMemberScopeBuffer.append(memberName + "$,$" + scope + ";");
                    continue;
                }
                sbMemberScopeBuffer.append(memberName + "," + scope + ";");
            }
        }
        this.m_resultStrings.put("NewMemberScopeList", sbMemberScopeBuffer.toString());
        this.m_resultStrings.put("RBSXMLAttributeDefined", this.isRBSXMLAttrDefined());
        this.m_resultStrings.put("Role.Member.Count", Integer.toString(memberCount));
        this.m_resultStrings.put("RoleManagementTask.TreeName", this.m_treeOE.getFullName());
        roleInfoObject.setRoleMemberCount(memberCount);
        return true;
    }

    private boolean setupModifyTasksPage() {
        RoleManagementInfo roleInfoObject = this.getRoleManagementInfoObject();
        roleInfoObject.setInitialSetup(false);
        String rbsAdmin_RoleType = this.m_req.getParameter(HTMLPARAM_RBSADMIN_ROLE_TYPE);
        String selectedRoleFullName = this.m_req.getParameter(HTMLPARAM_ROLEFULLNAME);
        String[] strings = eMFrameUtils.unpack(selectedRoleFullName, this.m_context);
        selectedRoleFullName = strings[0];
        String selfProvisioningRole = "false";
        boolean bSelfProvisioningRole = false;
        boolean bGetRolesSucceeded = this.getOwnedRoles();
        if (!bGetRolesSucceeded) {
            return false;
        }
        if (rbsAdmin_RoleType == null || rbsAdmin_RoleType.equalsIgnoreCase(EMPTY_STRING)) {
            rbsAdmin_RoleType = roleInfoObject.getRBSAdmin_RoleType();
        }
        if (rbsAdmin_RoleType != null && rbsAdmin_RoleType.equalsIgnoreCase("eGuide")) {
            try {
                ObjectEntry roleOE = this.m_ns.getObjectEntry(this.m_treeOE, selectedRoleFullName);
                RBSRole role = new RBSRole(roleOE);
                bSelfProvisioningRole = this.isSelfProvisioningEguideRole(role);
                if (bSelfProvisioningRole) {
                    selfProvisioningRole = "true";
                }
            }
            catch (SPIException e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                return false;
            }
        }
        this.m_resultStrings.put(HTMLPARAM_RBSADMIN_ROLE_TYPE, rbsAdmin_RoleType);
        roleInfoObject.setRBSAdmin_RoleType(rbsAdmin_RoleType);
        this.m_resultStrings.put("SelfProvisioningRole", selfProvisioningRole);
        roleInfoObject.setSelfProvisioningRole(selfProvisioningRole);
        this.m_resultStrings.put(HTMLPARAM_NEWROLEDISPLAYNAME, EMPTY_STRING);
        this.m_resultStrings.put("CreateRoleFullName", EMPTY_STRING);
        this.m_resultStrings.put(HTMLPARAM_CREATEROLEDESCRIPTION, EMPTY_STRING);
        this.m_resultStrings.put(HTMLPARAM_CREATECONTEXTNAME, EMPTY_STRING);
        this.m_context.setAuthAttribute("RoleInfoObject", roleInfoObject);
        return this.getTasksForRole();
    }

    private boolean setupModifyAssociationsPage() {
        RoleManagementInfo roleInfoObject = this.getRoleManagementInfoObject();
        roleInfoObject.setInitialSetup(false);
        String rbsAdminRoleType = this.m_req.getParameter(HTMLPARAM_RBSADMIN_ROLE_TYPE);
        String selfProvisioningRole = "false";
        String selectedRoleFullName = this.m_req.getParameter(HTMLPARAM_ROLEFULLNAME);
        String[] strings = eMFrameUtils.unpack(selectedRoleFullName, this.m_context);
        if (selectedRoleFullName != null) {
            selectedRoleFullName = strings[0];
        }
        String selectedRoleDisplayName = this.m_req.getParameter(HTMLPARAM_ROLEDISPLAYNAME);
        strings = eMFrameUtils.unpack(selectedRoleDisplayName, this.m_context);
        if (selectedRoleDisplayName != null) {
            selectedRoleDisplayName = strings[0];
        }
        ArrayList<String[]> alErrors = new ArrayList<String[]>();
        boolean bSelfProvisioningRole = false;
        boolean err = false;
        if (selectedRoleFullName == null) {
            selectedRoleFullName = roleInfoObject.getSelectedRoleFullName();
        }
        if (selectedRoleDisplayName == null) {
            selectedRoleDisplayName = roleInfoObject.getSelectedRoleDisplayName();
        }
        if (rbsAdminRoleType == null) {
            rbsAdminRoleType = roleInfoObject.getRBSAdmin_RoleType();
        }
        try {
            ObjectEntry roleOE = this.m_ns.getObjectEntry(this.m_treeOE, selectedRoleFullName);
            RBSRole role = new RBSRole(roleOE);
            if (rbsAdminRoleType != null && rbsAdminRoleType.equalsIgnoreCase("eGuide")) {
                bSelfProvisioningRole = this.isSelfProvisioningEguideRole(role);
                if (bSelfProvisioningRole) {
                    selfProvisioningRole = "true";
                }
            } else {
                ObjectEntry whoamiOE = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
                String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
                RBSObject[] tasksArray = role.getContent();
                String secondaryStr = RBSUtil.preCheckSecondaryRights(this.m_context, whoamiOE, tasksArray);
                if (secondaryStr != null) {
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ModifyRoleScopeTitle", this.m_context);
                    String strBody = eMFrameUtils.getLocalizedString("FwResources", "ModifyRBSObjectDescription.Failed", this.m_context);
                    alErrors.add(new String[]{selectedRoleFullName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "Secondary.InsufficientRights", this.m_context), new String[]{secondaryStr, selectedRoleFullName}), EMPTY_STRING});
                    eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, strBody, alErrors);
                    this.setUIPage("dev/MooGenErr.jsp");
                    this.setInitialMooError();
                    return false;
                }
                RBSAssociation[] associations = role.getMembers();
                if (associations != null) {
                    Hashtable<String, String> memberObjectEntryTable = new Hashtable<String, String>();
                    Hashtable<String, String> scopeObjectEntryTable = new Hashtable<String, String>();
                    for (int i = 0; i < associations.length; ++i) {
                        String scopeName;
                        String memberName = this.m_ns.getUnrootedName(associations[i].getMember());
                        if (memberObjectEntryTable.get(memberName.toLowerCase()) == null) {
                            memberObjectEntryTable.put(memberName.toLowerCase(), memberName.toLowerCase());
                            if (!this.isNameInArrayList(alErrors, memberName) && !RBSUtil.preCheckMemberRights(whoamiOE, associations[i].getMember(), dynamicGroupSearchType)) {
                                err = true;
                                alErrors.add(new String[]{memberName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "MemberCheckView.InsufficientRights", this.m_context), new String[]{memberName}), EMPTY_STRING});
                            }
                        }
                        if (scopeObjectEntryTable.get((scopeName = this.m_ns.getUnrootedName(associations[i].getScope())).toLowerCase()) != null) continue;
                        scopeObjectEntryTable.put(scopeName.toLowerCase(), scopeName.toLowerCase());
                        if (this.isNameInArrayList(alErrors, scopeName) || RBSUtil.preCheckScopeRights(whoamiOE, associations[i].getScope())) continue;
                        err = true;
                        alErrors.add(new String[]{scopeName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ScopeCheckView.InsufficientRights", this.m_context), new String[]{scopeName}), EMPTY_STRING});
                    }
                }
            }
        }
        catch (Exception e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        if (err) {
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ModifyRoleScopeTitle", this.m_context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "ModifyRBSObjectDescription.Failed", this.m_context);
            eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, strBody, alErrors);
            this.setUIPage("dev/MooGenErr.jsp");
            this.setInitialMooError();
            return false;
        }
        this.m_resultStrings.put("SelfProvisioningRole", selfProvisioningRole);
        this.m_resultStrings.put("Role.Member.EmptyName", EMPTY_STRING);
        this.m_resultStrings.put(HTMLPARAM_ROLEFULLNAME, selectedRoleFullName);
        this.m_resultStrings.put(HTMLPARAM_ROLEDISPLAYNAME, selectedRoleDisplayName);
        this.m_resultStrings.put("RoleDisplayName", selectedRoleDisplayName);
        this.m_resultStrings.put(HTMLPARAM_RBSADMIN_ROLE_TYPE, rbsAdminRoleType);
        roleInfoObject.setRBSAdmin_RoleType(rbsAdminRoleType);
        roleInfoObject.setSelectedRoleFullName(selectedRoleFullName);
        roleInfoObject.setSelectedRoleDisplayName(selectedRoleDisplayName);
        roleInfoObject.setSelfProvisioningRole(selfProvisioningRole);
        this.m_context.setAuthAttribute("RoleInfoObject", roleInfoObject);
        if (this.m_bCallGetUsersAndScopes) {
            boolean rVal = this.getUsersAndScopes();
            if (!rVal) {
                return false;
            }
        } else {
            this.updateTable();
            this.m_bCallGetUsersAndScopes = true;
        }
        roleInfoObject.setAssignedTasksChanged("false");
        return true;
    }

    private boolean updateModifyRoleAssociations() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String inheritanceChanged = this.m_req.getParameter(HTMLPARAM_INHERITANCECHANGED);
        String assignRightsChanged = this.m_req.getParameter(HTMLPARAM_ASSIGN_RIGHTS_CHANGED);
        String selectedRoleFullName = roleInfoObject.getSelectedRoleFullName();
        String selectedRoleDisplayName = roleInfoObject.getSelectedRoleDisplayName();
        String rbsAdmin_RoleType = this.m_req.getParameter(HTMLPARAM_RBSADMIN_ROLE_TYPE);
        String tableChanged = roleInfoObject.getTableChangedValue();
        this.m_resultStrings.put(HTMLPARAM_ROLEFULLNAME, selectedRoleFullName);
        this.m_resultStrings.put(HTMLPARAM_ROLEDISPLAYNAME, selectedRoleDisplayName);
        this.m_resultStrings.put("RoleDisplayName", selectedRoleDisplayName);
        this.m_resultStrings.put(HTMLPARAM_RBSADMIN_ROLE_TYPE, rbsAdmin_RoleType);
        roleInfoObject.setInitialSetup(false);
        roleInfoObject.setInheritanceChanged(inheritanceChanged);
        roleInfoObject.setAssignRightsChanged(assignRightsChanged);
        roleInfoObject.setRBSAdmin_RoleType(rbsAdmin_RoleType);
        if (inheritanceChanged.equals("true")) {
            this.modifyMemberInheritanceInTable();
            tableChanged = "true";
            roleInfoObject.setInheritanceChanged("false");
        }
        if (assignRightsChanged.equals("true")) {
            this.modifyMemberAssignRightsInTable();
            tableChanged = "true";
            roleInfoObject.setAssignRightsChanged("false");
        }
        if (tableChanged.equals("true")) {
            boolean rVal = this.updateRole();
            roleInfoObject.setTableChangedValue("false");
            if (!rVal) {
                return false;
            }
        } else {
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ModifyRoleAssociationsTitle", this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.NoChangesDetected", this.m_context));
            return false;
        }
        this.m_resultStrings.put("RoleDisplayName", selectedRoleDisplayName);
        return true;
    }

    private boolean getTasksForRole() {
        String strTitle;
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String rbsAdmin_RoleType = this.m_req.getParameter(HTMLPARAM_RBSADMIN_ROLE_TYPE);
        String selfProvisioningRole = this.m_req.getParameter("SelfProvisioningRole");
        Enumeration enumTasks = null;
        RBSObject[] tasks = null;
        RBSRole role = null;
        ObjectEntry roleObjectEntry = null;
        ObjectEntry contextObjectEntry = null;
        ObjectEntry createRoleObjectEntry = null;
        boolean rVal = false;
        boolean eguideRole = false;
        int iTask = 0;
        if (this.isCreateRoleTask()) {
            String createRoleContext = EMPTY_STRING;
            String createRoleDisplayName = EMPTY_STRING;
            String createRoleFullName = EMPTY_STRING;
            String createRoleDescription = EMPTY_STRING;
            String createRoleLDAPName = EMPTY_STRING;
            String createRolePreviousPage = this.m_req.getParameter(HTMLPARAM_CREATEROLEPREVIOUSPAGE);
            if (createRolePreviousPage.equals("ChooseCategory")) {
                this.getAvailableCategories();
                this.getAssignedCategories();
            }
            if (rbsAdmin_RoleType != null) {
                if (rbsAdmin_RoleType.equalsIgnoreCase(EMPTY_STRING)) {
                    rbsAdmin_RoleType = roleInfoObject.getRBSAdmin_RoleType();
                }
                roleInfoObject.setRBSAdmin_RoleType(rbsAdmin_RoleType);
                this.m_resultStrings.put(HTMLPARAM_RBSADMIN_ROLE_TYPE, rbsAdmin_RoleType);
                if (rbsAdmin_RoleType.equalsIgnoreCase("eGuide")) {
                    eguideRole = true;
                }
            }
            if (selfProvisioningRole != null) {
                roleInfoObject.setSelfProvisioningRole(selfProvisioningRole);
                this.m_resultStrings.put("SelfProvisioningRole", selfProvisioningRole);
            }
            if (roleInfoObject.getInitialSetup()) {
                createRoleContext = this.m_req.getParameter(HTMLPARAM_CREATECONTEXTNAME);
                createRoleDisplayName = this.m_req.getParameter(HTMLPARAM_NEWROLEDISPLAYNAME);
                boolean isLDAP = this.m_ns.getUniqueID().equalsIgnoreCase("LDAP");
                if (isLDAP) {
                    createRoleLDAPName = createRoleDisplayName = RBSUtil.formatLDAPString(createRoleDisplayName);
                }
                createRoleFullName = RBSUtil.concatStr(this.m_ns, createRoleDisplayName, createRoleContext);
                createRoleDescription = this.m_req.getParameter(HTMLPARAM_CREATEROLEDESCRIPTION);
                contextObjectEntry = this.getObjectEntryFromString(createRoleContext);
                if (contextObjectEntry == null) {
                    return false;
                }
                if (createRoleDisplayName.indexOf(".") != -1) {
                    createRoleFullName = RBSUtil.concatStr(this.m_ns, createRoleDisplayName, createRoleContext);
                    createRoleLDAPName = RBSUtil.concatStr(this.m_ns, createRoleLDAPName, createRoleContext);
                }
                if (!this.isValidCollectionObjectType(contextObjectEntry)) {
                    this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.COLLECTION_FAILURE_TITLE", this.m_context));
                    this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.COLLECTION_NOTFOUND", this.m_context));
                    return false;
                }
                createRoleObjectEntry = this.getObjectEntryFromString(createRoleFullName);
                if (createRoleObjectEntry != null) {
                    this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.ROLE_ALREADY_EXISTS_TITLE", this.m_context));
                    this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.ROLE_ALREADY_EXISTS", this.m_context));
                    return false;
                }
                if (createRoleDescription == null || createRoleDescription.length() == 0) {
                    createRoleDescription = EMPTY_STRING;
                }
                roleInfoObject.setCreateRoleFullName(createRoleFullName);
                roleInfoObject.setCreateRoleDisplayName(createRoleDisplayName);
                roleInfoObject.setCreateRoleContext(createRoleContext);
                roleInfoObject.setCreateRoleDescription(createRoleDescription);
                roleInfoObject.setCreateRoleLDAPName(createRoleLDAPName);
                roleInfoObject.setInitialSetup(false);
            }
            int assignedTasksCount = 0;
            String strTaskCount = roleInfoObject.getAssignedTasksCount();
            if (strTaskCount != null && strTaskCount.length() > 0) {
                assignedTasksCount = Integer.parseInt(strTaskCount);
            }
            if (roleInfoObject.getAssignedTasksChanged().equals("true") || assignedTasksCount > 0) {
                createRoleContext = roleInfoObject.getCreateRoleContext();
                createRoleDisplayName = roleInfoObject.getCreateRoleDisplayName();
                createRoleFullName = roleInfoObject.getCreateRoleFullName();
                createRoleDescription = roleInfoObject.getCreateRoleDescription();
                contextObjectEntry = this.getObjectEntryFromString(createRoleContext);
                String newTasks = roleInfoObject.getAssignedTasks();
                String taskName = EMPTY_STRING;
                String fullName = EMPTY_STRING;
                String displayName = EMPTY_STRING;
                String description = EMPTY_STRING;
                String eguideAttributes = EMPTY_STRING;
                String taskTranslatedName = null;
                String supervisorRights = "false";
                String secondaryRights = "false";
                String superAndSecondaryRights = "false";
                StringTokenizer izer = new StringTokenizer(newTasks, ";", false);
                ObjectEntry taskOE = null;
                RBSTask newTask = null;
                boolean addTaskToList = true;
                while (izer.hasMoreTokens()) {
                    taskName = izer.nextToken();
                    fullName = DirUtils.removeTreeFromFullName(this.m_treeOE, taskName);
                    displayName = DirUtils.getLeftMostName(this.m_ns, fullName);
                    eguideAttributes = EMPTY_STRING;
                    supervisorRights = "false";
                    secondaryRights = "false";
                    superAndSecondaryRights = "false";
                    addTaskToList = true;
                    try {
                        boolean setsSecondaryRights;
                        boolean grantsSupervisorRights;
                        taskOE = this.m_ns.getObjectEntry(this.m_treeOE, fullName);
                        newTask = new RBSTask(taskOE);
                        description = RBSUtil.getLocalizedDescriptionName(this.m_context, taskOE);
                        taskTranslatedName = RBSUtil.getLocalizedDisplayName(this.m_context, taskOE);
                        addTaskToList = this.verifyTaskAttributesExist(newTask);
                        if (!addTaskToList) continue;
                        if (taskTranslatedName == null) {
                            taskTranslatedName = newTask.getObjectEntry().getName();
                        }
                        if (grantsSupervisorRights = this.checkTaskForSupervisorRights(newTask)) {
                            supervisorRights = "true";
                        }
                        if (setsSecondaryRights = newTask.hasSecondaryRights()) {
                            secondaryRights = "true";
                        }
                        if (grantsSupervisorRights && setsSecondaryRights) {
                            superAndSecondaryRights = "true";
                        }
                    }
                    catch (SPIException e) {
                        D.log(e);
                        this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                        String strTitle2 = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                        eMFrameUtils.setMessage("error", strTitle2, this.m_sException, this.m_context);
                        return false;
                    }
                    if (description == null) {
                        description = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NO_DESCRIPTION", this.m_context);
                    }
                    this.m_resultStrings.put("Role.Task." + iTask + ".DisplayName", displayName);
                    this.m_resultStrings.put("Role.Task." + iTask + ".FullName", fullName);
                    this.m_resultStrings.put("Role.Task." + iTask + ".Description", description);
                    this.m_resultStrings.put("Role.Task." + iTask + ".TaskTranslatedName", taskTranslatedName);
                    this.m_resultStrings.put("Role.Task." + iTask + ".SupervisorRights", supervisorRights);
                    this.m_resultStrings.put("Role.Task." + iTask + ".SecondaryRights", secondaryRights);
                    this.m_resultStrings.put("Role.Task." + iTask + ".SuperAndSecondaryRights", superAndSecondaryRights);
                    if (eguideRole) {
                        eguideAttributes = this.getEguideAttributesFromTask((RBSObject)newTask);
                        this.m_resultStrings.put("Role.Task." + iTask + ".EguideAttributes", eguideAttributes);
                    } else {
                        this.m_resultStrings.put("Role.Task." + iTask + ".EguideAttributes", eguideAttributes);
                    }
                    ++iTask;
                }
            }
            if (!(rVal = rbsAdmin_RoleType != null && rbsAdmin_RoleType.equalsIgnoreCase("eGuide") ? this.searchForEguideTasks() : this.searchForTasks())) {
                return false;
            }
            this.m_resultStrings.put(HTMLPARAM_NEWROLEDISPLAYNAME, createRoleDisplayName);
            this.m_resultStrings.put(HTMLPARAM_CREATEROLEDESCRIPTION, createRoleDescription);
            this.m_resultStrings.put(HTMLPARAM_CREATEROLEPREVIOUSPAGE, createRolePreviousPage);
            this.m_resultStrings.put("RoleDisplayName", createRoleDisplayName);
            this.m_resultStrings.put("Role.Tasks.Count", Integer.toString(iTask));
            this.addObjectToHistory(contextObjectEntry);
            return true;
        }
        String selectedRoleFullName = this.m_req.getParameter(HTMLPARAM_ROLEFULLNAME);
        String[] strings = eMFrameUtils.unpack(selectedRoleFullName, this.m_context);
        selectedRoleFullName = strings[0];
        String selectedRoleDisplayName = this.m_req.getParameter(HTMLPARAM_ROLEDISPLAYNAME);
        strings = eMFrameUtils.unpack(selectedRoleDisplayName, this.m_context);
        selectedRoleDisplayName = strings[0];
        String paramStr = null;
        String roleType = null;
        if (selectedRoleFullName == null) {
            String createRoleContext = this.m_req.getParameter(HTMLPARAM_CREATECONTEXTNAME);
            String createRoleDisplayName = this.m_req.getParameter(HTMLPARAM_NEWROLEDISPLAYNAME);
            selectedRoleFullName = RBSUtil.concatStr(this.m_ns, createRoleDisplayName, createRoleContext);
        } else {
            roleInfoObject.setSelectedRoleFullName(selectedRoleFullName);
        }
        try {
            roleObjectEntry = this.m_ns.getObjectEntry(this.m_treeOE, selectedRoleFullName);
            role = new RBSRole(roleObjectEntry);
            paramStr = role.getParameters();
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        if (paramStr != null) {
            roleType = RBSUtil.getKeyFromParameters(paramStr, "type");
        }
        if (roleType != null && roleType.equalsIgnoreCase("eGuide")) {
            eguideRole = true;
        }
        try {
            tasks = role.getContent();
            if (tasks != null) {
                enumTasks = this.makeEnumeration(tasks);
                boolean addTaskToList = true;
                String taskFullName = EMPTY_STRING;
                String taskDisplayName = EMPTY_STRING;
                String eguideAttributes = EMPTY_STRING;
                String supervisorRights = "false";
                String secondaryRights = "false";
                String superAndSecondaryRights = "false";
                String taskDescription = EMPTY_STRING;
                String taskTranslatedName = EMPTY_STRING;
                boolean grantsSupervisorRights = false;
                boolean setsSecondaryRights = false;
                while (enumTasks.hasMoreElements()) {
                    RBSTask taskInfo = (RBSTask)enumTasks.nextElement();
                    addTaskToList = this.verifyTaskAttributesExist(taskInfo);
                    if (!addTaskToList) continue;
                    taskFullName = DirUtils.removeTreeFromFullName(this.m_treeOE, taskInfo.getObjectEntry().getFullName());
                    taskDisplayName = DirUtils.getLeftMostName(this.m_ns, taskFullName);
                    eguideAttributes = EMPTY_STRING;
                    supervisorRights = "false";
                    secondaryRights = "false";
                    superAndSecondaryRights = "false";
                    taskDescription = RBSUtil.getLocalizedDescriptionName(this.m_context, taskInfo.getObjectEntry());
                    taskTranslatedName = RBSUtil.getLocalizedDisplayName(this.m_context, taskInfo.getObjectEntry());
                    grantsSupervisorRights = this.checkTaskForSupervisorRights(taskInfo);
                    setsSecondaryRights = taskInfo.hasSecondaryRights();
                    if (grantsSupervisorRights) {
                        supervisorRights = "true";
                    }
                    if (setsSecondaryRights) {
                        secondaryRights = "true";
                    }
                    if (grantsSupervisorRights && setsSecondaryRights) {
                        superAndSecondaryRights = "true";
                    }
                    if (taskInfo instanceof RBSBook) {
                        // empty if block
                    }
                    this.m_resultStrings.put("Role.Task." + iTask + ".DisplayName", taskDisplayName);
                    this.m_resultStrings.put("Role.Task." + iTask + ".FullName", taskFullName);
                    this.m_resultStrings.put("Role.Task." + iTask + ".TaskTranslatedName", taskTranslatedName);
                    this.m_resultStrings.put("Role.Task." + iTask + ".Description", taskDescription);
                    this.m_resultStrings.put("Role.Task." + iTask + ".SupervisorRights", supervisorRights);
                    this.m_resultStrings.put("Role.Task." + iTask + ".SecondaryRights", secondaryRights);
                    this.m_resultStrings.put("Role.Task." + iTask + ".SuperAndSecondaryRights", superAndSecondaryRights);
                    if (eguideRole) {
                        eguideAttributes = this.getEguideAttributesFromTask((RBSObject)taskInfo);
                        this.m_resultStrings.put("Role.Task." + iTask + ".EguideAttributes", eguideAttributes);
                    } else {
                        this.m_resultStrings.put("Role.Task." + iTask + ".EguideAttributes", eguideAttributes);
                    }
                    ++iTask;
                }
            }
        }
        catch (Exception e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
            strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        rVal = roleType != null && roleType.equalsIgnoreCase("eGuide") ? this.searchForEguideTasks() : this.searchForTasks();
        if (!rVal) {
            return false;
        }
        this.m_resultStrings.put(HTMLPARAM_ROLEFULLNAME, selectedRoleFullName);
        this.m_resultStrings.put(HTMLPARAM_ROLEDISPLAYNAME, selectedRoleDisplayName);
        this.m_resultStrings.put("RoleDisplayName", selectedRoleDisplayName);
        this.m_resultStrings.put("Role.Tasks.Count", Integer.toString(iTask));
        roleInfoObject.setSelectedRoleFullName(selectedRoleFullName);
        roleInfoObject.setSelectedRoleDisplayName(selectedRoleDisplayName);
        return true;
    }

    private boolean getOwnedRoles() {
        ObjectEntry oeTrustee = null;
        try {
            oeTrustee = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        RBSAssociatedObject user = new RBSAssociatedObject(oeTrustee);
        RBSRole[] rbsArray = null;
        RBSCollection[] rbsCollections = null;
        try {
            rbsCollections = user.getAllOwnedCollections2();
            int iRoleCount = 0;
            if (rbsCollections != null) {
                for (int i = 0; i < rbsCollections.length; ++i) {
                    String[] roleTypes = null;
                    rbsArray = rbsCollections[i].getSpecifiedRoles(roleTypes);
                    if (rbsArray == null) continue;
                    iRoleCount = rbsArray.length;
                }
            } else {
                this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NOT_OWNER_OF_COLLECTION_TITLE", this.m_context));
                this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NOT_OWNER_OF_COLLECTION", this.m_context));
                return false;
            }
            this.m_resultStrings.put("OwnedRoles.Count", Integer.toString(iRoleCount));
        }
        catch (Exception e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        return true;
    }

    private boolean getRolesAndAssignedTasks(String roleType) {
        ObjectEntry oeTrustee = null;
        String assignedTasksChanged = this.m_req.getParameter(HTMLPARAM_ASSIGNEDTASKSCHANGED);
        if (assignedTasksChanged != null && assignedTasksChanged.equals("false")) {
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ModifyRoleTasksTitle", this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.NoChangesDetected", this.m_context));
            return false;
        }
        this.updateCreateRoleString();
        try {
            oeTrustee = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        RBSAssociatedObject user = new RBSAssociatedObject(oeTrustee);
        Enumeration enumRoles = null;
        RBSRole[] rbsRoleArray = null;
        RBSCollection[] rbsCollections = null;
        try {
            rbsCollections = user.getAllOwnedCollections2();
            int iRoleCount = 0;
            if (rbsCollections != null) {
                for (int i = 0; i < rbsCollections.length; ++i) {
                    String[] roleTypes = new String[]{roleType};
                    rbsRoleArray = rbsCollections[i].getSpecifiedRoles(roleTypes);
                    if (rbsRoleArray == null) continue;
                    Arrays.sort(rbsRoleArray, new RBSObjectComparator(this.m_locale));
                    enumRoles = this.makeEnumeration(rbsRoleArray);
                    RBSRole role = null;
                    ObjectEntry roleObjectEntry = null;
                    RBSObject[] tasksArray = null;
                    String roleDescription = null;
                    String selfManagementRole = "false";
                    String roleFullName = EMPTY_STRING;
                    String fullName = EMPTY_STRING;
                    String displayName = EMPTY_STRING;
                    String taskDescription = null;
                    String supervisorRights = "false";
                    String secondaryRights = "false";
                    String superAndSecondaryRights = "false";
                    boolean grantsSupervisorRights = false;
                    boolean isSelfManagementRole = false;
                    boolean setsSecondaryRights = false;
                    while (enumRoles.hasMoreElements()) {
                        role = (RBSRole)enumRoles.nextElement();
                        isSelfManagementRole = this.isSelfProvisioningEguideRole(role);
                        selfManagementRole = "false";
                        if (isSelfManagementRole) {
                            selfManagementRole = "true";
                            boolean thisEnabled = iManager.isThisEnabled();
                            if (!thisEnabled) continue;
                        }
                        roleObjectEntry = role.getObjectEntry();
                        roleFullName = DirUtils.removeTreeFromFullName(this.m_treeOE, roleObjectEntry.getFullName());
                        tasksArray = null;
                        roleDescription = null;
                        try {
                            roleDescription = role.getDescription();
                        }
                        catch (Exception e) {
                            D.log(e);
                            this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
                            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                            return false;
                        }
                        if (roleDescription == null) {
                            roleDescription = eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NO_DESCRIPTION", this.m_context);
                        }
                        this.m_resultStrings.put("Role." + iRoleCount + ".DisplayName", roleFullName);
                        this.m_resultStrings.put("Role." + iRoleCount + ".FullName", roleFullName);
                        this.m_resultStrings.put("Role." + iRoleCount + ".Description", roleDescription);
                        this.m_resultStrings.put("Role." + iRoleCount + ".SelfManagementRole", selfManagementRole);
                        try {
                            tasksArray = role.getContent();
                        }
                        catch (SPIException e) {
                            D.log(e);
                            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                            return false;
                        }
                        if (tasksArray != null) {
                            Arrays.sort(tasksArray, new RBSObjectComparator(this.m_locale));
                            int iTaskCount = 0;
                            boolean addTaskToList = true;
                            for (int j = 0; j < tasksArray.length; ++j) {
                                addTaskToList = this.verifyTaskAttributesExist((RBSTask)tasksArray[j]);
                                if (!addTaskToList) continue;
                                fullName = DirUtils.removeTreeFromFullName(this.m_treeOE, tasksArray[j].getObjectEntry().getFullName());
                                displayName = DirUtils.getLeftMostName(this.m_ns, fullName);
                                taskDescription = RBSUtil.getLocalizedDescriptionName(this.m_context, tasksArray[j].getObjectEntry());
                                if (tasksArray[j] instanceof RBSBook) {
                                    // empty if block
                                }
                                supervisorRights = (grantsSupervisorRights = this.checkTaskForSupervisorRights((RBSTask)tasksArray[j])) ? "true" : "false";
                                setsSecondaryRights = ((RBSTask)tasksArray[j]).hasSecondaryRights();
                                secondaryRights = setsSecondaryRights ? "true" : "false";
                                superAndSecondaryRights = grantsSupervisorRights && setsSecondaryRights ? "true" : "false";
                                this.m_resultStrings.put("Role." + iRoleCount + ".Task." + iTaskCount + ".FullName", fullName);
                                this.m_resultStrings.put("Role." + iRoleCount + ".Task." + iTaskCount + ".DisplayName", displayName);
                                this.m_resultStrings.put("Role." + iRoleCount + ".Task." + iTaskCount + ".Description", taskDescription);
                                this.m_resultStrings.put("Role." + iRoleCount + ".Task." + iTaskCount + ".SupervisorRights", supervisorRights);
                                this.m_resultStrings.put("Role." + iRoleCount + ".Task." + iTaskCount + ".SecondaryRights", secondaryRights);
                                this.m_resultStrings.put("Role." + iRoleCount + ".Task." + iTaskCount + ".SuperAndSecondaryRights", superAndSecondaryRights);
                                ++iTaskCount;
                            }
                            this.m_resultStrings.put("OwnedRole." + iRoleCount + ".Tasks.Count", Integer.toString(iTaskCount));
                        }
                        ++iRoleCount;
                    }
                }
            } else {
                this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NOT_OWNER_OF_COLLECTION_TITLE", this.m_context));
                this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NOT_OWNER_OF_COLLECTION", this.m_context));
                return false;
            }
            this.m_resultStrings.put("OwnedRoles.Count", Integer.toString(iRoleCount));
        }
        catch (Exception e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        return true;
    }

    private boolean addMembersToTable() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String inheritanceChanged = this.m_req.getParameter(HTMLPARAM_INHERITANCECHANGED);
        String newMemberName = this.m_req.getParameter(HTMLPARAM_NEWMEMBER);
        String newRoleMembers = this.m_req.getParameter(HTMLPARAM_NEWROLEMEMBERS);
        String selfProvisioningRole = roleInfoObject.getSelfProvisioningRole();
        String createNewRole = roleInfoObject.getCreateNewRole();
        ArrayList<String[]> alErrors = new ArrayList<String[]>();
        ObjectEntry newMemberObjectEntry = null;
        ObjectEntry whoamiOE = null;
        boolean err = false;
        try {
            whoamiOE = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
        String[] newMemberArray = this.spliceJavaScriptString(newRoleMembers, "$");
        alErrors.clear();
        for (int i = 0; i < newMemberArray.length; ++i) {
            boolean validMemberObject = true;
            boolean validRoleType = false;
            newMemberName = eMFrameUtils.urlDecode(newMemberArray[i], this.m_context);
            if (newMemberName.equalsIgnoreCase("[root]") || newMemberName.equalsIgnoreCase(this.m_treeOE.getName())) {
                validMemberObject = false;
                err = true;
                D.log("Tree or Root is not a valid role member. - " + newMemberName);
                if (this.isNameInArrayList(alErrors, newMemberName)) continue;
                alErrors.add(new String[]{newMemberName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.TREE_NOT_VALID_MEMBER", this.m_context), EMPTY_STRING});
                continue;
            }
            newMemberObjectEntry = this.getObjectEntryFromString(newMemberName);
            if (newMemberObjectEntry == null) {
                validMemberObject = false;
                err = true;
                D.log("Member name not valid. - " + newMemberName);
                if (this.isNameInArrayList(alErrors, newMemberName)) continue;
                alErrors.add(new String[]{newMemberName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND", this.m_context), new String[]{newMemberName}), EMPTY_STRING});
                continue;
            }
            if (!this.isNameInArrayList(alErrors, newMemberName) && !RBSUtil.preCheckMemberRights(whoamiOE, newMemberObjectEntry, dynamicGroupSearchType)) {
                validMemberObject = false;
                err = true;
                alErrors.add(new String[]{newMemberName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "MemberCheck.InsufficientRights", this.m_context), new String[]{newMemberName}), EMPTY_STRING});
                continue;
            }
            try {
                validRoleType = this.isValidRoleMemberType(newMemberObjectEntry, Boolean.getBoolean(selfProvisioningRole));
            }
            catch (Exception e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                return false;
            }
            if (!validRoleType) {
                validMemberObject = false;
                err = true;
                D.log("Member object type is not in the list. - " + newMemberName);
                if (this.isNameInArrayList(alErrors, newMemberName)) continue;
                alErrors.add(new String[]{newMemberName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NOT_VALID_MEMBER_TYPE", this.m_context), new String[]{newMemberName}), EMPTY_STRING});
                continue;
            }
            boolean dynamicGroupAuxObject = this.isDynamicGroupOrAuxObject(newMemberObjectEntry);
            boolean dynamicGroupFlagEnabled = this.getDynamicGroupFlagValue();
            if (dynamicGroupAuxObject) {
                if (!dynamicGroupFlagEnabled) {
                    err = true;
                    D.log("Dynamic Group support is not enabled. - " + newMemberName);
                    if (this.isNameInArrayList(alErrors, newMemberName)) continue;
                    alErrors.add(new String[]{newMemberName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.DynamicGroupsNotEnabled", this.m_context), new String[]{newMemberName}), EMPTY_STRING});
                    continue;
                }
                if (FwUtils.getDynamicSearchType(this.m_context).equals("DynamicGroupObjectsOnly") && this.hasDynamicGroupAux(newMemberObjectEntry).equals("true")) {
                    err = true;
                    D.log("Dynamic Group support is not enabled. - " + newMemberName);
                    if (this.isNameInArrayList(alErrors, newMemberName)) continue;
                    alErrors.add(new String[]{newMemberName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.DynamicGroupsNotEnabled", this.m_context), new String[]{newMemberName}), EMPTY_STRING});
                    continue;
                }
            }
            if (selfProvisioningRole.equals("true")) {
                if (this.isValidSelfManagementMember(newMemberObjectEntry)) {
                    roleInfoObject.addEguideRoleMember(newMemberName);
                    roleInfoObject.setTableChangedValue("true");
                }
            } else if (validMemberObject) {
                roleInfoObject.addRoleMember(newMemberName);
                roleInfoObject.setTableChangedValue("true");
                if (newMemberArray.length < 10) {
                    this.addObjectToHistory(newMemberObjectEntry);
                }
            }
            if (inheritanceChanged == null || !inheritanceChanged.equals("true")) continue;
            this.modifyMemberInheritanceInTable();
        }
        this.updateTable();
        if (err) {
            return this.setErrorMessageURL(alErrors, createNewRole);
        }
        return true;
    }

    private boolean modifyMemberScopeInTable() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String inheritanceChanged = this.m_req.getParameter(HTMLPARAM_INHERITANCECHANGED);
        String modifyScopeList = this.m_req.getParameter(HTMLPARAM_MODIFYSCOPELIST);
        String assignRightsChanged = this.m_req.getParameter(HTMLPARAM_ASSIGN_RIGHTS_CHANGED);
        String memberName = EMPTY_STRING;
        String oldScopeName = EMPTY_STRING;
        String newScopeName = EMPTY_STRING;
        String inheritable = "true";
        String assignRigts = "true";
        ArrayList<String[]> alErrors = new ArrayList<String[]>();
        ObjectEntry newScopeObjectEntry = null;
        String[] memberScopeArray = this.spliceJavaScriptString(modifyScopeList, "$");
        if (memberScopeArray != null && memberScopeArray.length > 0) {
            String nameScopeString = memberScopeArray[0];
            String[] nameScopeArray = this.spliceJavaScriptString(nameScopeString, ";");
            memberName = eMFrameUtils.urlDecode(nameScopeArray[0], this.m_context);
            oldScopeName = eMFrameUtils.urlDecode(nameScopeArray[1], this.m_context);
            newScopeName = eMFrameUtils.urlDecode(nameScopeArray[2], this.m_context);
            if (newScopeName.equalsIgnoreCase("[root]")) {
                newScopeName = this.m_treeOE.getName();
            }
            if ((newScopeObjectEntry = this.getObjectEntryFromString(newScopeName)) == null) {
                if (!this.isNameInArrayList(alErrors, newScopeName)) {
                    alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.SCOPE_NOT_FOUND_IN_TREE", this.m_context), EMPTY_STRING});
                }
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ModifyRoleScopeTitle", this.m_context);
                String strBody = eMFrameUtils.getLocalizedString("FwResources", "ModifyRBSObjectDescription.Failed", this.m_context);
                eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, strBody, alErrors);
                this.setUIPage("dev/MooGenErr.jsp");
                this.setInitialMooError();
                return false;
            }
            ObjectEntry whoamiOE = null;
            try {
                whoamiOE = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
            }
            catch (SPIException e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                return false;
            }
            if (!RBSUtil.preCheckScopeRights(whoamiOE, newScopeObjectEntry)) {
                if (!this.isNameInArrayList(alErrors, newScopeName)) {
                    alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ScopeCheck.InsufficientRights", this.m_context), new String[]{newScopeName}), EMPTY_STRING});
                }
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ModifyRoleScopeTitle", this.m_context);
                String strBody = eMFrameUtils.getLocalizedString("FwResources", "ModifyRBSObjectDescription.Failed", this.m_context);
                eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, strBody, alErrors);
                this.setUIPage("dev/MooGenErr.jsp");
                this.setInitialMooError();
                return false;
            }
            roleInfoObject.removeRoleMemberScope(memberName, oldScopeName);
            roleInfoObject.addRoleMemberScope(memberName, newScopeName, inheritable, assignRigts);
        }
        roleInfoObject.setTableChangedValue("true");
        if (inheritanceChanged.equals("true")) {
            this.modifyMemberInheritanceInTable();
        }
        if (assignRightsChanged.equals("true")) {
            this.modifyMemberAssignRightsInTable();
        }
        this.updateTable();
        return true;
    }

    private void setInitialMooError() {
        this.m_req.setAttribute("errorOnInit", (Object)"true");
    }

    private boolean addMemberAndScopeToTable() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        RBSObject[] tasksArray = null;
        ObjectEntry newMemberObjectEntry = null;
        ObjectEntry newScopeNameObjectEntry = null;
        ObjectEntry whoamiOE = null;
        ArrayList<String[]> alErrors = new ArrayList<String[]>();
        Hashtable<String, ObjectEntry> memberObjectEntryTable = new Hashtable<String, ObjectEntry>();
        Hashtable<String, ObjectEntry> scopeObjectEntryTable = new Hashtable<String, ObjectEntry>();
        Hashtable<String, String> memberInvalidTable = new Hashtable<String, String>();
        Hashtable<String, String> scopeInvalidTable = new Hashtable<String, String>();
        String inheritanceChanged = this.m_req.getParameter(HTMLPARAM_INHERITANCECHANGED);
        String assignRightsChanged = this.m_req.getParameter(HTMLPARAM_ASSIGN_RIGHTS_CHANGED);
        String modifyMemberAndScopeList = this.m_req.getParameter(HTMLPARAM_NEWMEMBERANDSCOPE);
        String createNewRole = roleInfoObject.getCreateNewRole();
        String selfProvisioningRole = roleInfoObject.getSelfProvisioningRole();
        String newMemberName = EMPTY_STRING;
        String newScopeName = EMPTY_STRING;
        String inheritable = "true";
        String assignRights = "true";
        boolean err = false;
        try {
            whoamiOE = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        String dynamicGroupSearchType = FwUtils.getDynamicSearchType(this.m_context);
        String[] memberScopeArray = this.spliceJavaScriptString(modifyMemberAndScopeList, "$");
        alErrors.clear();
        for (int i = 0; i < memberScopeArray.length; ++i) {
            String nameScopeString = memberScopeArray[i];
            boolean validMemberObject = true;
            boolean validScopeObject = true;
            String[] nameScopeArray = this.spliceJavaScriptString(nameScopeString, ";");
            if (nameScopeArray != null && nameScopeArray.length == 2) {
                newMemberName = eMFrameUtils.urlDecode(nameScopeArray[0], this.m_context);
                newScopeName = eMFrameUtils.urlDecode(nameScopeArray[1], this.m_context);
                if (newMemberName.equalsIgnoreCase("[root]") || newMemberName.equalsIgnoreCase(this.m_treeOE.getName())) {
                    validMemberObject = false;
                    err = true;
                    D.log("Tree or Root is not a valid role member. - " + newMemberName);
                    if (!this.isNameInArrayList(alErrors, newMemberName)) {
                        alErrors.add(new String[]{newMemberName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.TREE_NOT_VALID_MEMBER", this.m_context), EMPTY_STRING});
                    }
                }
                if (validMemberObject) {
                    newMemberObjectEntry = (ObjectEntry)memberObjectEntryTable.get(newMemberName.toLowerCase());
                    if (newMemberObjectEntry == null) {
                        newMemberObjectEntry = this.getObjectEntryFromString(newMemberName);
                        if (null == newMemberObjectEntry) {
                            validMemberObject = false;
                            err = true;
                            D.log("Member name not found - " + newMemberName);
                            if (!this.isNameInArrayList(alErrors, newMemberName)) {
                                alErrors.add(new String[]{newMemberName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND", this.m_context), new String[]{newMemberName}), EMPTY_STRING});
                            }
                        } else {
                            memberObjectEntryTable.put(newMemberName.toLowerCase(), newMemberObjectEntry);
                            boolean validMember = false;
                            try {
                                validMember = this.isValidRoleMemberType(newMemberObjectEntry, Boolean.getBoolean(selfProvisioningRole));
                            }
                            catch (Exception e) {
                                D.log(e);
                                this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
                                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                                return false;
                            }
                            if (!validMember) {
                                validMemberObject = false;
                                err = true;
                                memberInvalidTable.put(newMemberName.toLowerCase(), newMemberName.toLowerCase());
                                D.log("Member object type is not in the list. - " + newMemberName);
                                if (!this.isNameInArrayList(alErrors, newMemberName)) {
                                    alErrors.add(new String[]{newMemberName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.NOT_VALID_MEMBER_TYPE", this.m_context), new String[]{newMemberName}), EMPTY_STRING});
                                }
                            }
                            if (validMemberObject && !RBSUtil.preCheckMemberRights(whoamiOE, newMemberObjectEntry, dynamicGroupSearchType)) {
                                memberInvalidTable.put(newMemberName.toLowerCase(), newMemberName.toLowerCase());
                                validMemberObject = false;
                                err = true;
                                if (!this.isNameInArrayList(alErrors, newMemberName)) {
                                    alErrors.add(new String[]{newMemberName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "MemberCheck.InsufficientRights", this.m_context), new String[]{newMemberName}), EMPTY_STRING});
                                }
                            }
                        }
                    } else if (memberInvalidTable.get(newMemberName.toLowerCase()) != null) {
                        validMemberObject = false;
                    }
                }
                if (newScopeName.equalsIgnoreCase("[root]") && !this.isNVDS()) {
                    newScopeName = this.m_treeOE.getName();
                }
                if ((newScopeNameObjectEntry = (ObjectEntry)scopeObjectEntryTable.get(newScopeName.toLowerCase())) == null) {
                    newScopeNameObjectEntry = this.getObjectEntryFromString(newScopeName);
                    if (null == newScopeNameObjectEntry) {
                        validScopeObject = false;
                        err = true;
                        D.log("Scope name not found - " + newScopeName);
                        if (!this.isNameInArrayList(alErrors, newScopeName)) {
                            alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.SCOPE_NOT_FOUND_IN_TREE", this.m_context), new String[]{newScopeName}), EMPTY_STRING});
                        }
                    } else {
                        scopeObjectEntryTable.put(newScopeName.toLowerCase(), newScopeNameObjectEntry);
                        if (!this.isValidScopeType(newScopeNameObjectEntry)) {
                            validScopeObject = false;
                            err = true;
                            scopeInvalidTable.put(newScopeName.toLowerCase(), newScopeName.toLowerCase());
                            D.log("Selected scope is not a container. - " + newScopeName);
                            if (!this.isNameInArrayList(alErrors, newScopeName)) {
                                alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ScopeTypeNotValid", this.m_context), new String[]{newScopeName}), EMPTY_STRING});
                            }
                        }
                        if (validScopeObject && !RBSUtil.preCheckScopeRights(whoamiOE, newScopeNameObjectEntry)) {
                            scopeInvalidTable.put(newScopeName.toLowerCase(), newScopeName.toLowerCase());
                            validScopeObject = false;
                            err = true;
                            if (!this.isNameInArrayList(alErrors, newScopeName)) {
                                alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ScopeCheck.InsufficientRights", this.m_context), new String[]{newScopeName}), EMPTY_STRING});
                            }
                        }
                    }
                } else if (scopeInvalidTable.get(newScopeName.toLowerCase()) != null) {
                    validScopeObject = false;
                }
            } else {
                validMemberObject = false;
                validScopeObject = false;
            }
            if (validMemberObject) {
                boolean dynamicGroupAuxObject = this.isDynamicGroupOrAuxObject(newMemberObjectEntry);
                boolean dynamicGroupFlagEnabled = this.getDynamicGroupFlagValue();
                if (dynamicGroupAuxObject) {
                    if (!dynamicGroupFlagEnabled) {
                        err = true;
                        D.log("Dynamic Group support is not enabled. - " + newMemberName);
                        if (this.isNameInArrayList(alErrors, newMemberName)) continue;
                        alErrors.add(new String[]{newMemberName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.DynamicGroupsNotEnabled", this.m_context), new String[]{newMemberName}), EMPTY_STRING});
                        continue;
                    }
                    if (FwUtils.getDynamicSearchType(this.m_context).equals("DynamicGroupObjectsOnly") && this.hasDynamicGroupAux(newMemberObjectEntry).equals("true")) {
                        err = true;
                        D.log("Dynamic Group support is not enabled. - " + newMemberName);
                        if (this.isNameInArrayList(alErrors, newMemberName)) continue;
                        alErrors.add(new String[]{newMemberName, eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.ModifyRole", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ModifyRoleAssociations.DynamicGroupsAuxClassNotEnabled", this.m_context), new String[]{newMemberName}), EMPTY_STRING});
                        continue;
                    }
                }
            }
            if (createNewRole.equals("true")) {
                String newTasks = roleInfoObject.getAssignedTasks();
                StringTokenizer izer = new StringTokenizer(newTasks, ";", false);
                tasksArray = new RBSObject[izer.countTokens()];
                int tokenCount = 0;
                while (izer.hasMoreTokens()) {
                    ObjectEntry taskOE = null;
                    try {
                        taskOE = this.m_ns.getObjectEntry(this.m_treeOE, izer.nextToken());
                        RBSTask task = new RBSTask(taskOE);
                        tasksArray[tokenCount] = task;
                        ++tokenCount;
                    }
                    catch (SPIException e) {
                        D.log(e);
                        this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                        String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                        eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                        return false;
                    }
                }
                String secondaryStr = RBSUtil.preCheckSecondaryRights(this.m_context, whoamiOE, tasksArray);
                if (secondaryStr != null) {
                    validScopeObject = false;
                    err = true;
                    alErrors.add(new String[]{eMFrameUtils.getLocalizedString("FwResources", "Secondary.Object", this.m_context), eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "Secondary.InsufficientRights", this.m_context), new String[]{secondaryStr}), EMPTY_STRING});
                    break;
                }
            }
            if (!validMemberObject || !validScopeObject) continue;
            if (this.m_bNVDS) {
                inheritable = "wholeSubtree";
            }
            roleInfoObject.addRoleMember(newMemberName, newScopeName, inheritable, assignRights);
            roleInfoObject.setTableChangedValue("true");
            if (memberScopeArray.length >= 10) continue;
            this.addObjectToHistory(newMemberObjectEntry);
            this.addObjectToHistory(newScopeNameObjectEntry);
        }
        if (inheritanceChanged.equals("true")) {
            this.modifyMemberInheritanceInTable();
        }
        if (assignRightsChanged.equals("true")) {
            this.modifyMemberAssignRightsInTable();
        }
        this.updateTable();
        if (err) {
            return this.setErrorMessageURL(alErrors, createNewRole);
        }
        return true;
    }

    private boolean addScopeToTableMember() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        ObjectEntry whoamiOE = null;
        ObjectEntry newScopeNameObjectEntry = null;
        String inheritanceChanged = this.m_req.getParameter(HTMLPARAM_INHERITANCECHANGED);
        String assignRightsChanged = this.m_req.getParameter(HTMLPARAM_ASSIGN_RIGHTS_CHANGED);
        String modifyScopeList = this.m_req.getParameter(HTMLPARAM_MODIFYSCOPELIST);
        String createNewRole = roleInfoObject.getCreateNewRole();
        String memberName = EMPTY_STRING;
        String newScopeName = EMPTY_STRING;
        String inheritable = "true";
        String assignRights = "true";
        ArrayList<ObjectEntry> alValidScopeList = new ArrayList<ObjectEntry>(modifyScopeList.length());
        ArrayList<String[]> alErrors = new ArrayList<String[]>();
        boolean err = false;
        Hashtable<String, ObjectEntry> scopeObjectEntryTable = new Hashtable<String, ObjectEntry>();
        try {
            whoamiOE = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        String[] memberScopeArray = this.spliceJavaScriptString(modifyScopeList, "$");
        alErrors.clear();
        for (int i = 0; i < memberScopeArray.length; ++i) {
            String nameScopeString = memberScopeArray[i];
            boolean validScopeObject = true;
            String[] nameScopeArray = this.spliceJavaScriptString(nameScopeString, ";");
            if (nameScopeArray == null || nameScopeArray.length != 2) continue;
            memberName = eMFrameUtils.urlDecode(nameScopeArray[0], this.m_context);
            newScopeName = eMFrameUtils.urlDecode(nameScopeArray[1], this.m_context);
            if (newScopeName.equalsIgnoreCase("[root]")) {
                newScopeName = this.m_treeOE.getName();
            }
            if ((newScopeNameObjectEntry = (ObjectEntry)scopeObjectEntryTable.get(newScopeName.toLowerCase())) == null) {
                newScopeNameObjectEntry = this.getObjectEntryFromString(newScopeName);
                if (newScopeNameObjectEntry == null) {
                    validScopeObject = false;
                    err = true;
                    D.log("Member name not valid. - " + newScopeName);
                    if (this.isNameInArrayList(alErrors, newScopeName)) continue;
                    alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.SCOPE_NOT_FOUND_IN_TREE", this.m_context), new String[]{newScopeName}), EMPTY_STRING});
                    continue;
                }
                scopeObjectEntryTable.put(newScopeName.toLowerCase(), newScopeNameObjectEntry);
                if (!this.isNameInArrayList(alErrors, newScopeName) && !RBSUtil.preCheckScopeRights(whoamiOE, newScopeNameObjectEntry)) {
                    validScopeObject = false;
                    err = true;
                    alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "ScopeCheck.InsufficientRights", this.m_context), new String[]{newScopeName}), EMPTY_STRING});
                    continue;
                }
            }
            if (!this.isValidScopeType(newScopeNameObjectEntry)) {
                validScopeObject = false;
                err = true;
                D.log("Selected scope is not a container. - " + newScopeName);
                if (this.isNameInArrayList(alErrors, newScopeName)) continue;
                alErrors.add(new String[]{newScopeName, eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.OBJECT_NOT_FOUND_TITLE", this.m_context), eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ScopeTypeNotValid", this.m_context), new String[]{newScopeName}), EMPTY_STRING});
                continue;
            }
            if (!validScopeObject) continue;
            if (this.m_bNVDS) {
                inheritable = "wholeSubtree";
            }
            roleInfoObject.addRoleMemberScope(memberName, newScopeName, inheritable, assignRights);
            roleInfoObject.setTableChangedValue("true");
            if (memberScopeArray.length < 10) {
                this.addObjectToHistory(newScopeNameObjectEntry);
                continue;
            }
            if (alValidScopeList.contains(newScopeNameObjectEntry) || alValidScopeList.size() >= 10) continue;
            alValidScopeList.add(newScopeNameObjectEntry);
            this.addObjectToHistory(newScopeNameObjectEntry);
        }
        if (inheritanceChanged.equals("true")) {
            this.modifyMemberInheritanceInTable();
        }
        if (assignRightsChanged.equals("true")) {
            this.modifyMemberAssignRightsInTable();
        }
        this.updateTable();
        if (err) {
            return this.setErrorMessageURL(alErrors, createNewRole);
        }
        return true;
    }

    private void modifyMemberInheritanceInTable() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String MemberInheritanceList = this.m_req.getParameter(HTMLPARAM_MODIFYINHERITANCELIST);
        String[] memberInheritanceArray = this.spliceJavaScriptString(MemberInheritanceList, "$");
        for (int i = 0; i < memberInheritanceArray.length; ++i) {
            String[] nameScopeInheritanceArray = this.spliceJavaScriptString(memberInheritanceArray[i], ";");
            String memberName = eMFrameUtils.urlDecode(nameScopeInheritanceArray[0], this.m_context);
            String scopeName = eMFrameUtils.urlDecode(nameScopeInheritanceArray[1], this.m_context);
            String inheritance = eMFrameUtils.urlDecode(nameScopeInheritanceArray[2], this.m_context);
            roleInfoObject.setMemberInheritance(memberName, scopeName, inheritance);
        }
        roleInfoObject.setTableChangedValue("true");
        roleInfoObject.setInheritanceChanged("true");
    }

    private void modifyMemberAssignRightsInTable() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String MemberAssignRightsList = this.m_req.getParameter(HTMLPARAM_ASSIGN_RIGHTS_LIST);
        String[] memberAssignRightsArray = this.spliceJavaScriptString(MemberAssignRightsList, "$");
        for (int i = 0; i < memberAssignRightsArray.length; ++i) {
            String[] nameScopeAssignRightsArray = this.spliceJavaScriptString(memberAssignRightsArray[i], ";");
            String memberName = eMFrameUtils.urlDecode(nameScopeAssignRightsArray[0], this.m_context);
            String scopeName = eMFrameUtils.urlDecode(nameScopeAssignRightsArray[1], this.m_context);
            String assignRights = eMFrameUtils.urlDecode(nameScopeAssignRightsArray[2], this.m_context);
            roleInfoObject.setMemberAssignRights(memberName, scopeName, assignRights);
        }
        roleInfoObject.setTableChangedValue("true");
        roleInfoObject.setAssignRightsChanged("true");
    }

    private boolean deleteMembersFromTable() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String deleteMemberList = this.m_req.getParameter(HTMLPARAM_DELMEMBERSLIST);
        String inheritanceChanged = this.m_req.getParameter(HTMLPARAM_INHERITANCECHANGED);
        String assignRightsChanged = this.m_req.getParameter(HTMLPARAM_ASSIGN_RIGHTS_CHANGED);
        String[] memberScopeArray = this.spliceJavaScriptString(deleteMemberList, "$");
        for (int i = 0; i < memberScopeArray.length; ++i) {
            String nameScopeString = memberScopeArray[i];
            String memberName = EMPTY_STRING;
            String scopeName = EMPTY_STRING;
            String[] nameScopeArray = this.spliceJavaScriptString(nameScopeString, ";");
            for (int j = 0; j < nameScopeArray.length; ++j) {
                memberName = eMFrameUtils.urlDecode(nameScopeArray[j++], this.m_context);
                scopeName = eMFrameUtils.urlDecode(nameScopeArray[j], this.m_context);
            }
            roleInfoObject.removeRoleMember(memberName, scopeName);
        }
        roleInfoObject.setTableChangedValue("true");
        if (inheritanceChanged.equals("true")) {
            this.modifyMemberInheritanceInTable();
        }
        if (assignRightsChanged.equals("true")) {
            this.modifyMemberAssignRightsInTable();
        }
        this.updateTable();
        return true;
    }

    private boolean doCreateRole() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        NSObject roleObj = null;
        ObjectEntry whoamiOE = null;
        String createRoleDescription = roleInfoObject.getCreateRoleDescription();
        String createRoleContext = roleInfoObject.getCreateRoleContext();
        String selfProvisioningRole = roleInfoObject.getSelfProvisioningRole();
        String rbsAdminRoleType = roleInfoObject.getRBSAdmin_RoleType();
        String createRoleLDAPName = roleInfoObject.getCreateRoleLDAPName();
        String createRoleDisplayName = roleInfoObject.getCreateRoleDisplayName();
        if (0 == createRoleContext.indexOf("\\")) {
            createRoleContext = createRoleContext.substring(1);
        }
        ObjectEntry parentEntry = null;
        try {
            parentEntry = this.m_ns.getObjectEntry(this.m_treeOE, createRoleContext);
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        if (null == parentEntry) {
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CONTAINER_NOT_FOUND_TITLE", this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CONTAINER_NOT_FOUND", this.m_context));
            return false;
        }
        String strType = parentEntry.getObjectType().getName();
        if (0 != strType.compareTo("rbsCollection2")) {
            this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CONTAINER_NOT_FOUND_TITLE", this.m_context));
            this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.CONTAINER_NOT_FOUND", this.m_context));
            return false;
        }
        try {
            boolean isLDAP = this.m_ns.getUniqueID().equalsIgnoreCase("LDAP");
            roleObj = isLDAP ? this.createRBSObject(parentEntry, createRoleLDAPName, "rbsRole2") : this.createRBSObject(parentEntry, createRoleDisplayName, "rbsRole2");
        }
        catch (Exception e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        this.m_context.addToHistory(roleObj.getObjectEntry());
        try {
            whoamiOE = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
            NSObject whoamiObj = this.m_ns.getDetails(whoamiOE);
            ObjectEntry roleObjectEntry = roleObj.getObjectEntry();
            String rbsParametersValue = null;
            rbsParametersValue = rbsAdminRoleType.equalsIgnoreCase("eGuide") ? (selfProvisioningRole.equals("true") ? "type=eGuide;self-provisioning=true;required-version=" + iManager.getVersionString() : "type=eGuide;self-provisioning=false;required-version=" + iManager.getVersionString()) : "required-version=" + iManager.getVersionString();
            String[] attributes = new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)roleObjectEntry, (String)ROLEMANAGEMENT_DESCRIPTION), "rbsParameters"};
            String[] attrValues = new String[]{createRoleDescription, rbsParametersValue};
            DirUtils.attributeWriter(roleObjectEntry, attributes, attrValues);
            String memberName = this.m_ns.getUnrootedName(roleObj.getObjectEntry());
            if (this.m_ns.isSupported("NVDS")) {
                RBSNVDSRights attrRights = new RBSNVDSRights(memberName, EMPTY_STRING, "wholeSubtree", EMPTY_STRING, "any", 0L, 3L);
                RBSNVDSRights entryRights = new RBSNVDSRights(memberName, EMPTY_STRING, "wholeSubtree", EMPTY_STRING, EMPTY_STRING, 1L, 1L);
                this.addNVDSACLRights(roleObj, attrRights);
                this.addNVDSACLRights(roleObj, entryRights);
            } else {
                RBSRights attrRights = new RBSRights(memberName, "[All Attributes Rights]", 3L);
                RBSRights entryRights = new RBSRights(memberName, SchemaUtil.translateNDAPAttr((ObjectEntry)roleObj.getObjectEntry(), (String)"[Entry Rights]"), 1L);
                this.addACLRights(roleObj, attrRights);
                this.addACLRights(roleObj, entryRights);
            }
            this.m_ns.update(roleObj);
            this.m_ns.update(whoamiObj);
        }
        catch (Exception e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        return true;
    }

    private void addACLRights(NSObject roleObj, RBSRights rbsRights) throws SPIException, NamespaceException {
        ObjectAttribute aclAttrib = roleObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)roleObj.getObjectEntry(), (String)"ACL"));
        AttributeDefinition def = this.m_ns.getAttributeDefinition(roleObj.getObjectEntry(), SchemaUtil.translateNDAPAttr((ObjectEntry)roleObj.getObjectEntry(), (String)"ACL"));
        ValueList vl = null;
        if (aclAttrib == null) {
            aclAttrib = new ObjectAttribute(def);
            vl = ObjectACLFacade.createValueList((String)rbsRights.getProtectedAttrName(), (String)rbsRights.getSubjectName(), (long)rbsRights.getPrivileges());
            aclAttrib.addComponent((ValueComponent)vl);
            roleObj.addAttribute(aclAttrib);
        } else {
            boolean found = false;
            Enumeration myenum = aclAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                ObjectACLFacade facade = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
                RBSRights facadeRights = new RBSRights(facade);
                if (!facadeRights.equals(rbsRights, true, true, false) || facadeRights.getPrivileges() != rbsRights.getPrivileges()) continue;
                found = true;
                break;
            }
            if (!found) {
                vl = ObjectACLFacade.createValueList((String)rbsRights.getProtectedAttrName(), (String)rbsRights.getSubjectName(), (long)rbsRights.getPrivileges(), (Syntax)def.getSyntax());
                aclAttrib.addComponent((ValueComponent)vl);
            }
        }
    }

    private void addNVDSACLRights(NSObject roleObj, RBSNVDSRights rbsRights) throws SPIException, NamespaceException {
        ObjectAttribute aclAttrib = roleObj.getAttribute(SchemaUtil.translateNDAPAttr((ObjectEntry)roleObj.getObjectEntry(), (String)"ACL"));
        AttributeDefinition def = this.m_ns.getAttributeDefinition(roleObj.getObjectEntry(), SchemaUtil.translateNDAPAttr((ObjectEntry)roleObj.getObjectEntry(), (String)"ACL"));
        ValueList vl = null;
        if (aclAttrib == null) {
            aclAttrib = new ObjectAttribute(def);
            vl = ObjectACLFacade.createValueList((long)rbsRights.getPrivileges(), (long)rbsRights.getModifier(), (String)rbsRights.getSubjectName(), (String)rbsRights.getFilterName(), (String)rbsRights.getScopeName(), (String)rbsRights.getClassName(), (String)rbsRights.getProtectedAttrName(), (Syntax)def.getSyntax());
            aclAttrib.addComponent((ValueComponent)vl);
            roleObj.addAttribute(aclAttrib);
        } else {
            boolean found = false;
            Enumeration myenum = aclAttrib.getValueComponents();
            while (myenum.hasMoreElements()) {
                ObjectACLFacade facade = (ObjectACLFacade)((ValueList)myenum.nextElement()).createFacade();
                RBSNVDSRights facadeRights = new RBSNVDSRights(facade);
                if (!facadeRights.equals((RBSRights)rbsRights, true, true, false) || facadeRights.getPrivileges() != rbsRights.getPrivileges()) continue;
                found = true;
                break;
            }
            if (!found) {
                vl = ObjectACLFacade.createValueList((long)rbsRights.getPrivileges(), (long)rbsRights.getModifier(), (String)rbsRights.getSubjectName(), (String)rbsRights.getFilterName(), (String)rbsRights.getScopeName(), (String)rbsRights.getClassName(), (String)rbsRights.getProtectedAttrName(), (Syntax)def.getSyntax());
                aclAttrib.addComponent((ValueComponent)vl);
            }
        }
    }

    private boolean isValidScopeType(ObjectEntry objectEntry) {
        RBSObject[] tasksArray;
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        ObjectType objectType = objectEntry.getObjectType();
        String createNewRole = roleInfoObject.getCreateNewRole();
        if (createNewRole.equals("true")) {
            String newTasks = roleInfoObject.getAssignedTasks();
            StringTokenizer izer = new StringTokenizer(newTasks, ";", false);
            tasksArray = new RBSObject[izer.countTokens()];
            int tokenCount = 0;
            while (izer.hasMoreTokens()) {
                ObjectEntry taskOE = null;
                try {
                    taskOE = this.m_ns.getObjectEntry(this.m_treeOE, izer.nextToken());
                    RBSTask task = new RBSTask(taskOE);
                    tasksArray[tokenCount] = task;
                    ++tokenCount;
                }
                catch (SPIException e) {
                    D.log(e);
                    this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                    eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                    return false;
                }
            }
        } else {
            String roleName = roleInfoObject.getSelectedRoleFullName();
            ObjectEntry roleOE = this.getObjectEntryFromString(roleName);
            RBSRole role = new RBSRole(roleOE);
            try {
                tasksArray = role.getContent();
            }
            catch (SPIException e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                return false;
            }
        }
        try {
            if (tasksArray == null) {
                return objectType.isContainer();
            }
            String[] saLeafObjectTypes = RBSUtil.getLeafObjectTypes(tasksArray);
            if (saLeafObjectTypes == null) {
                return objectType.isContainer();
            }
            for (int j = 0; j < tasksArray.length; ++j) {
                String parameters = ((RBSTask)tasksArray[j]).getParameters();
                String leafObjectSupport = RBSUtil.getLeafObjectSupportParameter(parameters);
                if (leafObjectSupport == null) continue;
                if (leafObjectSupport.equals("cumulative") && objectType.isContainer()) {
                    return true;
                }
                for (int i = 0; i < saLeafObjectTypes.length; ++i) {
                    if (this.isTypeNameInExcludeFilterList(objectType.getName()) || !saLeafObjectTypes[i].equals(objectType.getName())) continue;
                    return true;
                }
            }
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        return false;
    }

    private boolean isValidSelfManagementMember(ObjectEntry objectEntry) {
        ObjectType objecttype = objectEntry.getObjectType();
        if (objecttype.isContainer()) {
            if (DirUtils.isOfType(objecttype, "Organization", true)) {
                return true;
            }
            return DirUtils.isOfType(objecttype, "Organizational Unit", true);
        }
        return false;
    }

    private boolean isValidCollectionObjectType(ObjectEntry objectEntry) {
        ObjectType objecttype = objectEntry.getObjectType();
        return objecttype.getName().equals("rbsCollection2");
    }

    private boolean isCollectionOwner(ObjectEntry collectionObjectEntry) {
        ObjectEntry[] collections = null;
        RBSCollection rbsCollection = null;
        ObjectEntry whoamiOE = null;
        boolean collectionOwner = false;
        try {
            rbsCollection = new RBSCollection(collectionObjectEntry);
            collections = rbsCollection.getOwners();
            whoamiOE = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        if (collections != null) {
            for (int i = 0; i < collections.length; ++i) {
                if (!collections[i].getFullName().equalsIgnoreCase(whoamiOE.getFullName())) continue;
                collectionOwner = true;
                break;
            }
        }
        return collectionOwner;
    }

    private Enumeration makeEnumeration(final Object obj) {
        Class<?> type = obj.getClass();
        if (!type.isArray()) {
            throw new IllegalArgumentException(obj.getClass().toString());
        }
        return new Enumeration(){
            int size;
            int cursor;
            {
                this.size = Array.getLength(obj);
            }

            @Override
            public boolean hasMoreElements() {
                return this.cursor < this.size;
            }

            public Object nextElement() {
                return Array.get(obj, this.cursor++);
            }
        };
    }

    private String convertStringArrayToString(String[] stringArray) {
        String newString = EMPTY_STRING;
        for (int i = 0; i < stringArray.length; ++i) {
            newString = i == 0 ? stringArray[i] : newString + ";" + stringArray[i];
        }
        return newString;
    }

    private boolean isSelfProvisioningEguideRole(RBSRole role) {
        try {
            String paramString;
            String paramStr = role.getParameters();
            return paramStr != null && (paramString = RBSUtil.getKeyFromParameters(paramStr, "self-provisioning")) != null && paramString.equalsIgnoreCase("true");
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
    }

    private boolean checkTaskForSupervisorRights(RBSTask task) {
        boolean grantsSupervisorRights = false;
        RBSRights[] taskRights = null;
        try {
            taskRights = task.getRights();
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            return false;
        }
        if (taskRights != null) {
            block2: for (int i = 0; i < taskRights.length; ++i) {
                String protectedAttrName = taskRights[i].getProtectedAttrName();
                if (!protectedAttrName.equalsIgnoreCase("[Entry Rights]")) continue;
                String[] privileges = taskRights[i].convertLongToPrivilegeStrings();
                for (int j = 0; j < privileges.length; ++j) {
                    if (!privileges[j].equalsIgnoreCase("Supervisor")) continue;
                    grantsSupervisorRights = true;
                    continue block2;
                }
            }
        }
        return grantsSupervisorRights;
    }

    private String getEguideAttributesFromTask(RBSObject task) {
        String sEguideAttributes = EMPTY_STRING;
        try {
            List attributeList;
            Element attributesElement;
            Element eguideElement;
            Element rootElement;
            Document doc = task.getrbsXMLInfo();
            if (!(doc == null || (rootElement = doc.getRootElement()).getChildren().isEmpty() || (eguideElement = rootElement.getChild("eguide")) == null || eguideElement.getChildren().isEmpty() || (attributesElement = eguideElement.getChild("Attributes")) == null || attributesElement.getChildren().isEmpty() || (attributeList = attributesElement.getChildren("Attribute")) == null)) {
                ListIterator it = attributeList.listIterator();
                while (it.hasNext()) {
                    Element el = (Element)it.next();
                    List attributeContentList = el.getContent((Filter)new ElementFilter("Name"));
                    ListIterator contentIterator = attributeContentList.listIterator();
                    while (contentIterator.hasNext()) {
                        Element contentElement = (Element)contentIterator.next();
                        if (!contentElement.getName().equalsIgnoreCase("Name")) continue;
                        sEguideAttributes = sEguideAttributes + contentElement.getTextTrim();
                        sEguideAttributes = sEguideAttributes + ";";
                    }
                }
            }
        }
        catch (Exception e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage(e, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
        }
        return sEguideAttributes;
    }

    private String isRBSXMLAttrDefined() {
        String xmlAttrDefined = "false";
        try {
            SchemaDefinition schemaDef = this.m_ns.getSchemaDefinition(this.m_treeOE);
            boolean rbsXmlAttrDefined = schemaDef.isAttributeDefined("rbsXMLInfo");
            if (rbsXmlAttrDefined) {
                xmlAttrDefined = "true";
            }
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
        }
        return xmlAttrDefined;
    }

    private boolean isValidRoleMemberType(ObjectEntry objectEntry, boolean selfProvisioningRole) throws NamespaceException, SPIException {
        String roleMemberObjectTypes = RBSUtil.getRoleMemberObjectTypes(this.m_context, this.m_ns, selfProvisioningRole);
        if (roleMemberObjectTypes == null) {
            return false;
        }
        String[] validMemberTypes = RBSUtil.tokenizeObjectTypes(roleMemberObjectTypes);
        ObjectType objecttype = objectEntry.getObjectType();
        boolean validType = true;
        for (int i = 0; i < validMemberTypes.length; ++i) {
            if (objecttype.getName().equals("rbsScope")) {
                return false;
            }
            if (DirUtils.isOfType(objecttype, validMemberTypes[i], true)) {
                validType = true;
                break;
            }
            validType = false;
        }
        if (!validType && this.getDynamicGroupFlagValue() && this.hasDynamicGroupAux(objectEntry).equals("true")) {
            validType = true;
        }
        return validType;
    }

    private boolean isDynamicGroupOrAuxObject(ObjectEntry objectEntry) {
        boolean dynamicGroup;
        block3: {
            dynamicGroup = false;
            try {
                Enumeration myenum;
                ObjectAttribute oa = this.m_ns.getAttribute(objectEntry, SchemaUtil.translateNDAPClass((ObjectEntry)objectEntry, (String)"Object Class"));
                if (oa == null || (myenum = oa.getValueComponents()) == null) break block3;
                while (myenum.hasMoreElements()) {
                    String value = myenum.nextElement().toString();
                    if (!value.equals(SchemaUtil.translateNDAPClass((ObjectEntry)objectEntry, (String)"dynamicGroup")) && !value.equals(SchemaUtil.translateNDAPClass((ObjectEntry)objectEntry, (String)"dynamicGroupAux"))) continue;
                    dynamicGroup = true;
                    break;
                }
            }
            catch (SPIException e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            }
        }
        return dynamicGroup;
    }

    private String hasDynamicGroupAux(ObjectEntry objectEntry) {
        String dynamicGroupAux;
        block3: {
            dynamicGroupAux = "false";
            try {
                Enumeration myenum;
                ObjectAttribute oa = this.m_ns.getAttribute(objectEntry, SchemaUtil.translateNDAPClass((ObjectEntry)objectEntry, (String)"Object Class"));
                if (oa == null || (myenum = oa.getValueComponents()) == null) break block3;
                while (myenum.hasMoreElements()) {
                    String value = myenum.nextElement().toString();
                    if (!value.equals(SchemaUtil.translateNDAPClass((ObjectEntry)objectEntry, (String)"dynamicGroupAux"))) continue;
                    dynamicGroupAux = "true";
                    break;
                }
            }
            catch (SPIException e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            }
        }
        return dynamicGroupAux;
    }

    private ObjectEntry getObjectEntryFromString(String objectName) {
        ObjectEntry objectEntry = null;
        try {
            objectEntry = this.m_treeOE.getName().equalsIgnoreCase(objectName) ? this.m_treeOE : this.m_ns.getObjectEntry(this.m_treeOE, objectName);
        }
        catch (SPIException e) {
            if (e instanceof UniqueSPIException && e.getErrorCode() == -601) {
                this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.COLLECTION_FAILURE_TITLE", this.m_context));
                this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.COLLECTION_NOTFOUND", this.m_context));
            }
            if (e instanceof LDAPSPIException && e.getErrorCode() == 32) {
                this.m_resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.COLLECTION_FAILURE_TITLE", this.m_context));
                this.m_resultStrings.put("GeneralMsg.MsgBody", eMFrameUtils.getLocalizedString("FwResources", "eMFrameConsts.COLLECTION_NOTFOUND", this.m_context));
            }
            D.log(e);
            String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
        }
        return objectEntry;
    }

    private boolean isNameInArrayList(ArrayList alErrors, String memberScopeName) {
        Object[] errorArray = alErrors.toArray();
        String[] arrayItem = null;
        for (int i = 0; i < errorArray.length; ++i) {
            arrayItem = (String[])errorArray[i];
            if (!memberScopeName.equalsIgnoreCase(arrayItem[0])) continue;
            return true;
        }
        return false;
    }

    private boolean isCreateRoleTask() {
        String taskId = this.m_req.getParameter("taskId");
        return taskId.equalsIgnoreCase("fw.Create eDirectory Role") || taskId.equalsIgnoreCase("fw.Create eGuide Role");
    }

    private void updateCreateRoleString() {
        RoleManagementInfo roleInfoObject = this.getRoleManagementInfoObject();
        if (this.isCreateRoleTask()) {
            roleInfoObject.setCreateNewRole("true");
        } else {
            roleInfoObject.setCreateNewRole("false");
        }
    }

    private RoleManagementInfo getRoleManagementInfoObject() {
        RoleManagementInfo roleInfoObject = null;
        if (this.m_context.getAuthAttribute("RoleInfoObject") != null && !this.m_bFirstTime) {
            roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        } else {
            roleInfoObject = new RoleManagementInfo(this.m_ns);
            this.m_context.setAuthAttribute("RoleInfoObject", roleInfoObject);
            this.m_bFirstTime = false;
        }
        return roleInfoObject;
    }

    private String[] spliceJavaScriptString(String joinedString, String delimiter) {
        StringTokenizer tokenIzer = new StringTokenizer(joinedString, delimiter, false);
        String[] stringArray = new String[tokenIzer.countTokens()];
        int tokenCount = 0;
        while (tokenIzer.hasMoreTokens()) {
            stringArray[tokenCount] = tokenIzer.nextToken();
            ++tokenCount;
        }
        return stringArray;
    }

    private boolean setErrorMessageURL(ArrayList alErrors, String createNewRole) {
        String strTitle = eMFrameUtils.getLocalizedString("FwResources", "RBSManagement.ModifyRoleScopeTitle", this.m_context);
        String strBody = eMFrameUtils.getLocalizedString("FwResources", "ModifyRBSObjectDescription.Failed", this.m_context);
        eMFrameUtils.setMooErrorMessage(this.m_resultStrings, strTitle, strBody, alErrors);
        String taskId = this.m_req.getParameter("taskId");
        String userContext = this.m_req.getParameter("User.context");
        String sNextState = "getUsersAndScopes";
        String sMerge = "fw.AssignUsersAndScopes";
        if (createNewRole.equals("false")) {
            sNextState = "setupModifyAssociationsPage";
            sMerge = "fw.ModifyRoleAssociations";
        }
        String url = "webacc?taskId=";
        url = url + taskId;
        url = url + "&merge=";
        url = url + sMerge;
        url = url + "&nextState=";
        url = url + sNextState;
        url = url + "&User.context=";
        url = url + userContext;
        this.m_resultStrings.put("GeneralMsg.Url", url);
        this.m_bCallGetUsersAndScopes = false;
        return false;
    }

    private boolean verifyTaskAttributesExist(RBSTask task) {
        ObjectEntry taskOE = task.getObjectEntry();
        SchemaDefinition schemaDef = null;
        RBSRights[] rights = null;
        boolean addToRole = true;
        try {
            schemaDef = this.m_ns.getSchemaDefinition(taskOE);
            rights = task.getRights();
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
        }
        if (rights != null && rights.length > 0) {
            for (int i = 0; i < rights.length; ++i) {
                if (rights[i].getProtectedAttrName().equalsIgnoreCase("[Entry Rights]") || rights[i].getProtectedAttrName().equalsIgnoreCase("[All Attributes Rights]") || rights[i].getProtectedAttrName().equalsIgnoreCase("[No Self Rights Assignment]") || schemaDef.isAttributeDefined(rights[i].getProtectedAttrName())) continue;
                D.log("--  Discarding task: " + this.m_ns.getUnrootedName(taskOE) + " attribute undefined: " + rights[i].getProtectedAttrName());
                addToRole = false;
                break;
            }
        }
        return addToRole;
    }

    private void addObjectToHistory(ObjectEntry objectEntry) {
        if (objectEntry != null) {
            if (objectEntry.getObjectType().getName().equalsIgnoreCase("Top")) {
                this.m_context.addToHistory("Top", objectEntry.getName());
            } else {
                this.m_context.addToHistory(objectEntry);
            }
        }
    }

    private boolean getDynamicGroupFlagValue() {
        SystemConfig systemConfig = SystemConfig.getSystemConfig(this.m_context);
        String dynamicGroupEnabled = systemConfig.getSetting("Provider.eMFrame.DynamicGroup.enable");
        return dynamicGroupEnabled != null && dynamicGroupEnabled.equalsIgnoreCase("true");
    }

    private void setRoleMemberFilter() {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        String sSelfProvisioningRole = roleInfoObject.getSelfProvisioningRole();
        String roleMemberFilter = EMPTY_STRING;
        try {
            roleMemberFilter = RBSUtil.getRoleMemberObjectTypes(this.m_context, this.m_ns, sSelfProvisioningRole.equalsIgnoreCase("true"));
        }
        catch (Exception exc) {
            D.log(exc);
        }
        this.m_resultStrings.put("RoleMemberFilter", roleMemberFilter);
    }

    private void setRoleScopeFilter(String roleName) {
        RoleManagementInfo roleInfoObject = (RoleManagementInfo)this.m_context.getAuthAttribute("RoleInfoObject");
        StringBuffer sbScopeFilter = new StringBuffer("[root],[containers]");
        RBSObject[] tasksArray = null;
        String parameters = null;
        String leafObjectSupport = null;
        String[] saLeafObjectTypes = null;
        if (roleName != null) {
            ObjectEntry roleOE = this.getObjectEntryFromString(roleName);
            RBSRole role = new RBSRole(roleOE);
            try {
                tasksArray = role.getContent();
            }
            catch (SPIException e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            }
        } else {
            String newTasks = roleInfoObject.getAssignedTasks();
            StringTokenizer izer = new StringTokenizer(newTasks, ";", false);
            tasksArray = new RBSObject[izer.countTokens()];
            int tokenCount = 0;
            while (izer.hasMoreTokens()) {
                ObjectEntry taskOE = null;
                try {
                    taskOE = this.m_ns.getObjectEntry(this.m_treeOE, izer.nextToken());
                    RBSTask task = new RBSTask(taskOE);
                    tasksArray[tokenCount] = task;
                    ++tokenCount;
                }
                catch (SPIException e) {
                    D.log(e);
                    this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                    String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                    eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
                }
            }
        }
        try {
            if (tasksArray != null) {
                saLeafObjectTypes = RBSUtil.getLeafObjectTypes(tasksArray);
            }
            if (saLeafObjectTypes != null) {
                for (int j = 0; j < tasksArray.length; ++j) {
                    parameters = ((RBSTask)tasksArray[j]).getParameters();
                    leafObjectSupport = RBSUtil.getLeafObjectSupportParameter(parameters);
                    if (leafObjectSupport == null || !leafObjectSupport.equals("overwritable")) continue;
                    sbScopeFilter.delete(0, sbScopeFilter.length());
                    break;
                }
                for (int i = 0; i < saLeafObjectTypes.length; ++i) {
                    if (this.isTypeNameInExcludeFilterList(saLeafObjectTypes[i])) continue;
                    sbScopeFilter.append("," + saLeafObjectTypes[i]);
                }
            }
        }
        catch (SPIException e) {
            D.log(e);
            this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
        }
        this.m_resultStrings.put("RoleScopeFilter", sbScopeFilter.toString());
    }

    private boolean isTypeNameInExcludeFilterList(String objectName) {
        ArrayList<String> alExcludeObjects = new ArrayList<String>(6);
        alExcludeObjects.add(SchemaUtil.translateNDAPClass((ObjectEntry)this.m_treeOE, (String)"Organization"));
        alExcludeObjects.add(SchemaUtil.translateNDAPClass((ObjectEntry)this.m_treeOE, (String)"Organizational Unit"));
        alExcludeObjects.add(SchemaUtil.translateNDAPClass((ObjectEntry)this.m_treeOE, (String)"Country"));
        alExcludeObjects.add(SchemaUtil.translateNDAPClass((ObjectEntry)this.m_treeOE, (String)"Locality"));
        alExcludeObjects.add(SchemaUtil.translateNDAPClass((ObjectEntry)this.m_treeOE, (String)"domain"));
        alExcludeObjects.add(SchemaUtil.translateNDAPClass((ObjectEntry)this.m_treeOE, (String)"ndsLoginProperties"));
        return alExcludeObjects.contains(objectName);
    }

    private void putAvailableCategories() {
        this.m_resultStrings.put("AvailableCategories.Count", Integer.toString(this.m_availableCategoryList.size()));
        for (int i = 0; i < this.m_availableCategoryList.size(); ++i) {
            CategoryData categoryData = (CategoryData)this.m_availableCategoryList.get(i);
            this.m_resultStrings.put("AvailableCategories." + i + ".ShortName", categoryData.getDisplayName());
            this.m_resultStrings.put("AvailableCategories." + i + ".FullName", categoryData.getObjectFDN());
            this.m_resultStrings.put("AvailableCategories." + i + ".Description", categoryData.getCategoryDesc());
        }
    }

    private void putAssignedCategories() {
        this.m_resultStrings.put("AssignedCategories.Count", Integer.toString(this.m_assignedCategoryList.size()));
        for (int i = 0; i < this.m_assignedCategoryList.size(); ++i) {
            CategoryData categoryData = (CategoryData)this.m_assignedCategoryList.get(i);
            this.m_resultStrings.put("AssignedCategories." + i + ".ShortName", categoryData.getDisplayName());
            this.m_resultStrings.put("AssignedCategories." + i + ".FullName", categoryData.getObjectFDN());
            this.m_resultStrings.put("AssignedCategories." + i + ".Description", categoryData.getCategoryDesc());
        }
    }

    private void getAvailableCategories() {
        this.m_availableCategoryList.clear();
        String availableRoleFullName = this.m_req.getParameter("AvailableCategoryFullName");
        String availableRoleShortName = this.m_req.getParameter("AvailableCategoryShortName");
        String availableRoleDescription = this.m_req.getParameter("AvailableCategoryDescription");
        StringTokenizer fullNameTokenizer = new StringTokenizer(availableRoleFullName, ";");
        StringTokenizer shortNameTokenizer = new StringTokenizer(availableRoleShortName, ";");
        StringTokenizer descriptionTokenizer = new StringTokenizer(availableRoleDescription, ";");
        if (fullNameTokenizer.countTokens() == shortNameTokenizer.countTokens() && fullNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() > 0) {
            while (shortNameTokenizer.hasMoreTokens()) {
                CategoryData categoryData = new CategoryData();
                categoryData.setDisplayName(eMFrameUtils.urlDecode(shortNameTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                categoryData.setObjectFDN(eMFrameUtils.urlDecode(fullNameTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                categoryData.setCategoryDesc(eMFrameUtils.urlDecode(descriptionTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                this.m_availableCategoryList.add(categoryData);
            }
        }
    }

    private void getAssignedCategories() {
        this.m_assignedCategoryList.clear();
        String assignedRoleFullName = this.m_req.getParameter("AssignedCategoryFullName");
        String assignedRoleShortName = this.m_req.getParameter("AssignedCategoryShortName");
        String assignedRoleDescription = this.m_req.getParameter("AssignedCategoryDescription");
        StringTokenizer fullNameTokenizer = new StringTokenizer(assignedRoleFullName, ";");
        StringTokenizer shortNameTokenizer = new StringTokenizer(assignedRoleShortName, ";");
        StringTokenizer descriptionTokenizer = new StringTokenizer(assignedRoleDescription, ";");
        if (fullNameTokenizer.countTokens() == shortNameTokenizer.countTokens() && fullNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() == descriptionTokenizer.countTokens() && shortNameTokenizer.countTokens() > 0) {
            while (shortNameTokenizer.hasMoreTokens()) {
                CategoryData categoryData = new CategoryData();
                categoryData.setDisplayName(eMFrameUtils.urlDecode(shortNameTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                categoryData.setObjectFDN(eMFrameUtils.urlDecode(fullNameTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                categoryData.setCategoryDesc(eMFrameUtils.urlDecode(descriptionTokenizer.nextToken(), this.m_req.getCharacterEncoding()));
                this.m_assignedCategoryList.add(categoryData);
            }
        }
    }

    private NSObject createRBSObject(ObjectEntry oe, String name, String className) throws SPIException, SnapinVetoException, ComponentCreationException, NamespaceException {
        ValueComponent[] vals = new ValueComponent[1];
        ValueComponent[] nameVal = new ValueComponent[1];
        AttributeDefinition objClassAttrDef = this.m_ns.getAttributeDefinition(oe, SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"Object Class"));
        Syntax objClassSyn = objClassAttrDef.getSyntax();
        vals[0] = objClassSyn.createValueComponent((Object)className);
        ObjectAttribute attrObj = new ObjectAttribute(objClassAttrDef, vals);
        AttributeDefinition cnAttrDef = this.m_ns.getAttributeDefinition(oe, SchemaUtil.translateNDAPAttr((ObjectEntry)oe, (String)"CN"));
        Syntax cnSyn = cnAttrDef.getSyntax();
        nameVal[0] = cnSyn.createValueComponent((Object)name);
        ObjectAttribute objNameAttr = new ObjectAttribute(cnAttrDef, nameVal);
        Vector<ObjectAttribute> attrOV = new Vector<ObjectAttribute>();
        attrOV.addElement(attrObj);
        attrOV.addElement(objNameAttr);
        ObjectEntry roleOE = this.m_ns.createObjectEntry(oe, name, "rbsRole2");
        NSObject roleObj = this.m_ns.createNSObject(roleOE, attrOV);
        this.m_ns.create(roleObj);
        return roleObj;
    }

    private boolean isNVDS() {
        boolean rval = false;
        try {
            rval = this.m_ns.isSupported("NVDS");
        }
        catch (Exception exception) {
            // empty catch block
        }
        return rval;
    }

    private Object[] getAclScopeValues() {
        Vector<String> scopeVector = new Vector<String>(2);
        scopeVector.addElement("baseObject");
        scopeVector.addElement("wholeSubtree");
        String[] aclScopes = null;
        if (this.isNVDS()) {
            try {
                SchemaDefinition sd = this.m_ns.getSchemaDefinition(this.m_treeOE);
                aclScopes = ((LDAPSchemaDefinition)sd).aclScopes();
            }
            catch (SPIException e) {
                D.log(e);
                this.m_sException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                eMFrameUtils.setMessage("error", strTitle, this.m_sException, this.m_context);
            }
            if (aclScopes != null) {
                for (int i = 0; i < aclScopes.length; ++i) {
                    if (aclScopes[i].equalsIgnoreCase("inheritedRightsFilterWholeSubtree") || aclScopes[i].equalsIgnoreCase("inheritedRightsFilterSubordinateSubtree") || scopeVector.contains(aclScopes[i])) continue;
                    scopeVector.addElement(aclScopes[i]);
                }
            }
        }
        Object[] aclScopeValueArray = scopeVector.toArray();
        return aclScopeValueArray;
    }

    private String getDescFromAttr(ObjectEntry objectEntry) throws SPIException {
        String categoryDescription = null;
        ObjectAttribute categoryDescAttr = this.m_ns.getAttribute(objectEntry, SchemaUtil.translateNDAPAttr((ObjectEntry)objectEntry, (String)ROLEMANAGEMENT_DESCRIPTION));
        categoryDescription = categoryDescAttr != null ? categoryDescAttr.toString() : RBSUtil.getLocalizedDescriptionName(this.m_context, objectEntry);
        return categoryDescription;
    }

    private static class RoleAssocComparator
    implements Comparator {
        private Comparator caseIgnoreCompare = null;

        RoleAssocComparator(Locale locale) {
            this.caseIgnoreCompare = Collator.getInstance(locale);
        }

        public int compare(Object rbs1, Object rbs2) {
            if (rbs1 == null || rbs2 == null) {
                D.assrt(false, "RoleAssocComparator: One or both of the elements being compared are null.");
                return 0;
            }
            return this.caseIgnoreCompare.compare(((RoleAssocObject)rbs1).getName(), ((RoleAssocObject)rbs2).getName());
        }
    }

    private static class RBSObjectComparator
    implements Comparator {
        private Comparator caseIgnoreCompare = null;

        RBSObjectComparator(Locale locale) {
            this.caseIgnoreCompare = Collator.getInstance(locale);
        }

        public int compare(Object rbs1, Object rbs2) {
            if (rbs1 == null || rbs2 == null) {
                D.assrt(false, "RBSObjectComparator: One or both of the elements being compared are null.");
                return 0;
            }
            if (rbs1 instanceof RBSAssociation) {
                return this.caseIgnoreCompare.compare(((RBSAssociation)rbs1).getRole().getObjectEntry().getName(), ((RBSAssociation)rbs2).getRole().getObjectEntry().getName());
            }
            return this.caseIgnoreCompare.compare(((RBSObject)rbs1).getObjectEntry().getName(), ((RBSObject)rbs2).getObjectEntry().getName());
        }
    }
}

