/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.fw.RBSReportUtil;
import com.novell.rbs.RBSObject;
import com.novell.rbs.RBSRights;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSTask;
import java.util.ArrayList;

public class RoleRightsReport {
    private TaskContext m_context;
    private NDSNamespace m_ns;
    private ObjectEntry m_treeOE;
    private String m_roleFDN;

    public RoleRightsReport() {
        this.m_roleFDN = "";
    }

    public RoleRightsReport(TaskContext context, String roleFDN) {
        this.m_roleFDN = roleFDN;
        this.m_context = context;
        this.m_treeOE = (ObjectEntry)this.m_context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        this.m_ns = (NDSNamespace)this.m_treeOE.getNamespace();
    }

    public ArrayList geterateRoleRightsReport() throws SPIException {
        ArrayList<RBSTaskRightsReport> taskRightsArrayList = new ArrayList<RBSTaskRightsReport>();
        ObjectEntry roleOE = this.m_ns.getObjectEntry(this.m_treeOE, this.m_roleFDN);
        RBSRole rbsRole = new RBSRole(roleOE);
        RBSObject[] rbsContent = rbsRole.getContent();
        if (rbsContent != null) {
            String roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, roleOE);
            for (int index = 0; index < rbsContent.length; ++index) {
                RBSRights[] rbsRights = ((RBSTask)rbsContent[index]).getRights();
                if (rbsRights == null) continue;
                String taskObject = this.m_ns.getUnrootedName(rbsContent[index].getObjectEntry());
                String taskName = RBSReportUtil.getTaskDisplayName(this.m_context, (RBSTask)rbsContent[index]);
                for (int count = 0; count < rbsRights.length; ++count) {
                    String privDisplayName = RBSReportUtil.convertLongToPrivilegeDisplayString(this.m_context, rbsRights[count].getProtectedAttrName(), rbsRights[count].getPrivileges());
                    String attrName = rbsRights[count].getProtectedAttrName();
                    if (attrName.equals("[No Self Rights Assignment]")) {
                        attrName = "";
                    }
                    RBSTaskRightsReport rbsTaskRightsReport = new RBSTaskRightsReport(roleDisplayName, this.m_roleFDN, taskName, taskObject, attrName, privDisplayName);
                    taskRightsArrayList.add(rbsTaskRightsReport);
                }
            }
        }
        return taskRightsArrayList;
    }

    public class RBSTaskRightsReport {
        private String roleDisplayName;
        private String roleFDN;
        private String taskDisplayName;
        private String taskFDN;
        private String attrName;
        private String privDisplayName;

        public RBSTaskRightsReport() {
            this.roleDisplayName = "";
            this.roleFDN = "";
            this.taskDisplayName = "";
            this.taskFDN = "";
            this.attrName = "";
            this.privDisplayName = "";
        }

        public RBSTaskRightsReport(String roleDisplayName, String roleFDN, String taskDisplayName, String taskFDN, String attrName, String privDisplayName) {
            this.roleDisplayName = roleDisplayName;
            this.roleFDN = roleFDN;
            this.taskDisplayName = taskDisplayName;
            this.taskFDN = taskFDN;
            this.attrName = attrName;
            this.privDisplayName = privDisplayName;
        }

        public String getRoleDisplayName() {
            return this.roleDisplayName;
        }

        public void setRoleDisplayName(String roleDisplayName) {
            this.roleDisplayName = roleDisplayName;
        }

        public String getRoleFDN() {
            return this.roleFDN;
        }

        public void setRoleFDN(String roleFDN) {
            this.roleFDN = roleFDN;
        }

        public String getTaskDisplayName() {
            return this.taskDisplayName;
        }

        public void setTaskDisplayName(String taskDisplayName) {
            this.taskDisplayName = taskDisplayName;
        }

        public String getTaskFDN() {
            return this.taskFDN;
        }

        public void setTaskFDN(String taskFDN) {
            this.taskFDN = taskFDN;
        }

        public String getAttrName() {
            return this.attrName;
        }

        public void setAttrName(String attrName) {
            this.attrName = attrName;
        }

        public String getPrivDisplayName() {
            return this.privDisplayName;
        }

        public void setPrivDisplayName(String privDisplayName) {
            this.privDisplayName = privDisplayName;
        }
    }
}

