/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.authDev.iMgrAuthenticatorImpl;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.authenticator.iMgrAuthenticator;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.nps.configManager.ConfigData;
import com.novell.nps.configManager.ConfigSettings;
import com.novell.nps.configManager.GadgetAssignment;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jdom.Document;
import org.jdom.Element;

public class RunnableManager {
    public static void init(HttpServletRequest req, iMgrAuthenticator auth) {
    }

    public static GadgetAssignment getGadgetAssignment(String pluginId, HttpSession session) {
        HashMap authenticators = FwAuthUtils.getSessionAuthenticators(session);
        Iterator authsIter = authenticators.values().iterator();
        boolean bFound = false;
        while (!bFound && authsIter.hasNext()) {
            GadgetAssignment ga;
            iMgrAuthenticatorImpl auth = (iMgrAuthenticatorImpl)authsIter.next();
            HashMap<String, GadgetAssignment> gadgetAssignments = (HashMap<String, GadgetAssignment>)auth.getAttribute("fw.gadgetAssignments");
            if (gadgetAssignments == null) {
                gadgetAssignments = new HashMap<String, GadgetAssignment>();
                auth.setAttribute("fw.gadgetAssignments", gadgetAssignments);
            }
            if ((ga = (GadgetAssignment)gadgetAssignments.get(pluginId)) != null) {
                return ga;
            }
            Registry globalRegistry = Registry.getRegistry("Global");
            HashMap globalTaskDocs = globalRegistry.getRunnablesForAuthenticator(auth.getAuthContext().getName());
            Document doc = (Document)globalTaskDocs.get(pluginId);
            if (doc != null) {
                String ldapDN = doc.getRootElement().getChildTextTrim("ldap-dn");
                if (ldapDN != null && ldapDN.equals("")) {
                    ldapDN = null;
                }
                ga = RunnableManager.createGadgetAssignment(pluginId, doc, ldapDN, globalRegistry);
                gadgetAssignments.put(pluginId, ga);
                return ga;
            }
            Map privateTaskDocs = auth.getRunnablesDocs(session);
            D.assrt(privateTaskDocs != null, "RunnableManager.init must be called before RunnableManager.getGadgetAssignment!");
            doc = (Document)privateTaskDocs.get(pluginId);
            if (doc == null) continue;
            String ldapDN = doc.getRootElement().getChildTextTrim("ldap-dn");
            if (ldapDN != null && ldapDN.equals("")) {
                ldapDN = null;
            }
            ga = RunnableManager.createGadgetAssignment(pluginId, doc, ldapDN, globalRegistry);
            gadgetAssignments.put(pluginId, ga);
            return ga;
        }
        return null;
    }

    private static GadgetAssignment createGadgetAssignment(String serviceName, Document doc, String gadgetLDAPDN, Registry registry) {
        if (serviceName == null) {
            serviceName = doc.getRootElement().getChildTextTrim("id");
        }
        String entryPoint = doc.getRootElement().getChildTextTrim("class-name");
        GadgetAssignment tempGA = null;
        if (entryPoint != null) {
            if (entryPoint.startsWith("java:")) {
                entryPoint = entryPoint.substring("java:".length());
            }
            tempGA = new GadgetAssignment();
            tempGA.setRegistrationKey("iManager");
            tempGA.setAssignmentName(serviceName);
            tempGA.setServiceName(serviceName);
            tempGA.setColumn("Column 1");
            tempGA.setGadgetAssignmentID((long)serviceName.hashCode());
            tempGA.setGadgetInstanceClass(entryPoint);
            tempGA.setHasFrame(false);
            tempGA.setLocation("Body");
            tempGA.setColumn("Column 1");
            ArrayList chainedTaskIds = Registry.getGlobalChainedTaskIds(serviceName);
            if (chainedTaskIds != null && chainedTaskIds.size() > 0) {
                tempGA.setChainedServices((List)chainedTaskIds);
            }
            if (gadgetLDAPDN == null) {
                tempGA.setIntPriority(Integer.MAX_VALUE);
                tempGA.setGadgetDN("");
            } else {
                tempGA.setIntPriority(0);
                tempGA.setGadgetDN(gadgetLDAPDN);
            }
            tempGA.setIsServiceAssignment(true);
            tempGA.setSupportsFullFrame(true);
            tempGA.setSupportsTableData(false);
            Element rootEl = doc.getRootElement();
            if (rootEl != null) {
                List list;
                String sSupportsTableData;
                String sSupportsFullFrame = rootEl.getChildTextTrim("SupportsFullFrame");
                if (sSupportsFullFrame != null) {
                    if (sSupportsFullFrame.equalsIgnoreCase("false")) {
                        tempGA.setSupportsFullFrame(false);
                    } else {
                        tempGA.setSupportsFullFrame(true);
                    }
                }
                if ((sSupportsTableData = rootEl.getChildTextTrim("SupportsTableData")) != null) {
                    if (sSupportsTableData.equalsIgnoreCase("false")) {
                        tempGA.setSupportsTableData(false);
                    } else {
                        tempGA.setSupportsTableData(true);
                    }
                }
                if ((list = rootEl.getChildren("frame-type")) != null) {
                    boolean bSetTD = false;
                    boolean bSetFullFrame = false;
                    ListIterator iterator = list.listIterator();
                    while (iterator.hasNext()) {
                        Element frameEl = (Element)iterator.next();
                        String sFrameType = frameEl.getTextTrim();
                        if (sFrameType != null) {
                            if (sFrameType.equalsIgnoreCase("td")) {
                                tempGA.setSupportsTableData(true);
                                bSetTD = true;
                            } else if (sFrameType.equalsIgnoreCase("Full")) {
                                tempGA.setSupportsFullFrame(true);
                                bSetFullFrame = true;
                            }
                        }
                        if (!bSetTD) {
                            tempGA.setSupportsTableData(false);
                        }
                        if (bSetFullFrame) continue;
                        tempGA.setSupportsFullFrame(false);
                    }
                }
            }
            try {
                Element configEl = null;
                Element rbsXmlInfo = doc.getRootElement().getChild("rbs-xml-info");
                if (rbsXmlInfo != null) {
                    configEl = rbsXmlInfo.getChild("config");
                }
                if (configEl == null) {
                    configEl = doc.getRootElement().getChild("config");
                }
                if (configEl != null) {
                    ConfigSettings cd = new ConfigSettings();
                    List list = configEl.getChildren("setting");
                    ListIterator iterator = list.listIterator();
                    while (iterator.hasNext()) {
                        Element settingEl = (Element)iterator.next();
                        String sName = settingEl.getChildTextTrim("name");
                        List valueList = settingEl.getChildren("value");
                        ListIterator valueIterator = valueList.listIterator();
                        ArrayList<String> valueArrayList = new ArrayList<String>();
                        while (valueIterator.hasNext()) {
                            valueArrayList.add(((Element)valueIterator.next()).getTextTrim());
                        }
                        String[] values = new String[valueArrayList.size()];
                        valueArrayList.toArray(values);
                        cd.setSetting(sName, values);
                    }
                    tempGA.setGadgetConfig((ConfigData)cd);
                }
            }
            catch (Exception e) {
                D.log(e);
            }
            ArrayList<String> supportedDevicesArray = new ArrayList<String>();
            Element root = doc.getRootElement();
            ListIterator iterator = root.getChildren("supported-device-type").listIterator();
            while (iterator.hasNext()) {
                Element element = (Element)iterator.next();
                String supportedDeviceType = element.getTextTrim();
                supportedDevicesArray.add(supportedDeviceType);
            }
            if (supportedDevicesArray.size() == 0) {
                supportedDevicesArray.addAll(Registry.getDefaultDevices());
            }
            tempGA.setSupportedDevices(supportedDevicesArray);
        }
        return tempGA;
    }
}

