/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.QueryItem;
import java.util.ArrayList;
import java.util.Arrays;
import javax.servlet.http.HttpServletRequest;

public class SaveQueryTask
extends MTask {
    @Override
    public void execute(MContext context) {
        HttpServletRequest req = context.getRequest();
        String nextState = req.getParameter("nextState");
        if (nextState == null || nextState.equals("initialState")) {
            this.setUIPage("fw/SaveQuery.jsp");
        } else if (nextState.equals("load")) {
            this.showLoadQueryDlg(context, req);
        } else if (nextState.equals("delete")) {
            this.deleteQuery(req, context);
        } else if (nextState.equals("save")) {
            this.showSaveQueryDlg(req, context);
        }
    }

    private void showSaveQueryDlg(HttpServletRequest req, MContext context) {
        String[] unpacked;
        String query = req.getParameter("query");
        String name = req.getParameter("queryName");
        String overwrite = req.getParameter("overwrite");
        String currentListPack = context.getPersistentData("fwPrefs", "fw.savedQueries");
        String[] currentList = null;
        currentList = currentListPack == null ? new String[]{} : eMFrameUtils.unpack(currentListPack, context);
        String[] newList = null;
        if (!"true".equals(overwrite)) {
            String pack;
            int i;
            newList = new String[currentList.length + 1];
            for (i = 0; i < currentList.length; ++i) {
                newList[i] = currentList[i];
            }
            for (i = 0; i < currentList.length; ++i) {
                unpacked = eMFrameUtils.unpack(currentList[i], context);
                if (!unpacked[0].equalsIgnoreCase(name)) continue;
                D.log("Query name already exits.");
                req.setAttribute("nameExists", (Object)"true");
                req.setAttribute("queryName", (Object)name);
                req.setAttribute("query", (Object)query);
                this.setUIPage("fw/SaveQuery.jsp");
                return;
            }
            String[] array = new String[]{name, query};
            newList[currentList.length] = pack = eMFrameUtils.pack(array, context);
        } else {
            newList = currentList;
            for (int i = 0; i < newList.length; ++i) {
                unpacked = eMFrameUtils.unpack(newList[i], context);
                if (!unpacked[0].equalsIgnoreCase(name)) continue;
                unpacked[1] = query;
                newList[i] = eMFrameUtils.pack(unpacked, context);
                break;
            }
        }
        String newPack = eMFrameUtils.pack(newList, context);
        context.setPersistentData("fwPrefs", "fw.savedQueries", newPack);
        String savedMsg = eMFrameUtils.getLocalizedString("FwResources", "TC.SavedQuerySuccessMsg", context);
        String title = eMFrameUtils.getLocalizedString("FwResources", "Success", context);
        eMFrameUtils.setMessage("success", title, savedMsg, context);
        this.setUIPage("dev/GenConf.jsp");
    }

    private void showLoadQueryDlg(MContext context, HttpServletRequest req) {
        String currentListPack = context.getPersistentData("fwPrefs", "fw.savedQueries");
        Object[] currentList = null;
        currentList = currentListPack == null ? new String[]{} : eMFrameUtils.unpack(currentListPack, context);
        ArrayList<QueryItem> queries = new ArrayList<QueryItem>();
        Arrays.sort(currentList);
        for (int i = 0; i < currentList.length; ++i) {
            String[] pair = eMFrameUtils.unpack((String)currentList[i], context);
            queries.add(new QueryItem(pair[0], pair[1]));
        }
        req.setAttribute("queries", queries);
        this.setUIPage("fw/LoadQuery.jsp");
    }

    private void deleteQuery(HttpServletRequest req, MContext context) {
        String[] strIndexToDelete = eMFrameUtils.unpack(req.getParameter("deleteIndex"), context);
        int[] indices = new int[strIndexToDelete.length];
        for (int i = 0; i < indices.length; ++i) {
            indices[i] = Integer.parseInt(strIndexToDelete[i]);
        }
        String currentListPack = context.getPersistentData("fwPrefs", "fw.savedQueries");
        D.assrt(currentListPack != null, "Cannot delete items that do not exist.");
        Object[] currentList = eMFrameUtils.unpack(currentListPack, context);
        Arrays.sort(currentList);
        String[] newList = new String[currentList.length - indices.length];
        int dstIndex = 0;
        boolean delIndex = false;
        for (int srcIndex = 0; srcIndex < currentList.length; ++srcIndex) {
            for (int i = 0; i < indices.length; ++i) {
                if (srcIndex == indices[i]) {
                    delIndex = true;
                    break;
                }
                delIndex = false;
            }
            if (delIndex) continue;
            newList[dstIndex++] = currentList[srcIndex];
        }
        String pack = eMFrameUtils.pack(newList, context);
        context.setPersistentData("fwPrefs", "fw.savedQueries", pack);
        String deletedMsg = eMFrameUtils.getLocalizedString("FwResources", "TC.DeletedQuerySuccessMsg", context);
        String title = eMFrameUtils.getLocalizedString("FwResources", "Deleted", context);
        eMFrameUtils.setMessage("success", title, deletedMsg, context);
        this.setUIPage("dev/GenConf.jsp");
    }
}

