/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.ResultModifier;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.TaskContext;

public class SearchObjectContext {
    private ResultModifier m_modifier = null;
    private ObjectEntry m_container = null;
    private ObjectEntry m_parentContainer = null;
    private ObjectEntryEnumeration m_containers = null;
    private ObjectEntryEnumeration m_children = null;
    private String m_containerName = null;
    private String m_parentContainerName = null;
    private int m_iLastMovementCount = 0;
    private AdminNamespace m_namespace = null;
    private TaskContext m_searchTaskContext = null;

    public SearchObjectContext(TaskContext searchTaskContext, ObjectEntry container, ResultModifier modifier) {
        this.m_searchTaskContext = searchTaskContext;
        if (searchTaskContext != null) {
            AuthenticationBroker broker = this.m_searchTaskContext.getAuthenticationBroker();
            ObjectEntry treeOE = null;
            try {
                treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            }
            catch (AuthBrokerException e) {
                D.log(e);
            }
            this.m_namespace = treeOE.getAdminNamespace();
        }
        this.setContainer(container);
        this.m_modifier = modifier;
    }

    public void setContainer(ObjectEntry container) {
        this.m_container = container;
        this.m_containerName = null;
        this.m_parentContainer = container != null ? container.getParent() : null;
        this.m_parentContainerName = null;
    }

    public ObjectEntry getContainer() {
        return this.m_container;
    }

    public String getContainerName() {
        if (this.m_containerName != null) {
            return this.m_containerName;
        }
        if (this.m_container == null || this.m_namespace == null) {
            this.m_containerName = "";
        } else {
            this.m_containerName = this.m_namespace.getUnrootedName(this.m_container);
            if (this.m_containerName == null) {
                this.m_containerName = "";
            } else if (this.m_containerName.length() == 0) {
                this.m_containerName = "[root]";
            }
        }
        return this.m_containerName;
    }

    public ObjectEntry getParentContainer() {
        return this.m_parentContainer;
    }

    public String getParentContainerName() {
        if (this.m_parentContainerName != null) {
            return this.m_parentContainerName;
        }
        if (this.m_parentContainer == null || this.m_namespace == null) {
            this.m_parentContainerName = "";
        } else if (this.m_parentContainer.getParent() == null) {
            this.m_parentContainerName = "[root]";
        } else {
            this.m_parentContainerName = this.m_namespace.getUnrootedName(this.m_parentContainer);
            if (this.m_parentContainerName == null) {
                this.m_parentContainerName = "";
            } else if (this.m_parentContainerName.length() == 0) {
                this.m_parentContainerName = "[root]";
            }
        }
        return this.m_parentContainerName;
    }

    public ResultModifier getModifier() {
        return this.m_modifier;
    }

    public void setModifier(ResultModifier modifier) {
        this.m_modifier = modifier;
    }

    public ObjectEntryEnumeration getContainerEnumeration() {
        return this.m_containers;
    }

    public void setContainerEnumeration(ObjectEntryEnumeration containers) {
        this.m_containers = containers;
    }

    public ObjectEntryEnumeration getChildrenEnumeration() {
        return this.m_children;
    }

    public void setChildrenEnumeration(ObjectEntryEnumeration children) {
        this.m_children = children;
    }

    public void setLastMovementCount(int count) {
        this.m_iLastMovementCount = count;
    }

    public int getLastMovementCount() {
        return this.m_iLastMovementCount;
    }
}

