/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.StreamValue;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DataHandlerHelper;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.fw.LoginScriptStreamFactory;
import com.novell.emframe.fw.StreamFactory;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.UnsupportedEncodingException;
import org.jdom.Element;
import org.jdom.Verifier;

public class StreamSyntaxHandler
extends DataHandlerHelper {
    @Override
    protected void valueComponentToXml(ValueComponent vc, StringBuffer resultValue, String attrName, Syntax syntax) throws eDirAccessServiceException {
        try {
            resultValue.append("<value>");
            String value = this.readStreamComponent(vc, attrName);
            StringBuffer copyvalue = new StringBuffer();
            if (Verifier.checkCharacterData((String)value) != null) {
                for (int i = 0; i < value.length(); ++i) {
                    if (!Verifier.isXMLCharacter((char)value.charAt(i))) continue;
                    copyvalue.append(value.charAt(i));
                }
                value = copyvalue.toString();
            }
            value = XmlUtils.xmlEncode(value);
            resultValue.append(value);
            resultValue.append("</value>");
        }
        catch (Exception e) {
            D.log(e);
            D.log("EDAS: Error reading stream attribute = " + attrName);
            throw new eDirAccessServiceException(e);
        }
    }

    @Override
    protected ValueComponent xmlToValueComponent(AttributeDefinition attributeDefinition, Element xml, MContext context) throws Exception {
        return this.modifyStreamAttr(xml.getText(), attributeDefinition);
    }

    private ValueComponent modifyStreamAttr(String value, AttributeDefinition attributeDefinition) throws UnsupportedEncodingException {
        ValueComponent newvc = null;
        String item = value;
        try {
            if (attributeDefinition.getName().equals("Login Script")) {
                LoginScriptStreamFactory factory = new LoginScriptStreamFactory(item);
                newvc = NDSSyntax.SYN_STREAM.createValueComponent((Object)factory);
            } else {
                StreamFactory factory = new StreamFactory(item);
                newvc = NDSSyntax.SYN_STREAM.createValueComponent((Object)factory);
            }
        }
        catch (ComponentCreationException e) {
            D.log(e);
        }
        return newvc;
    }

    private String readStreamComponent(ValueComponent vc, String attrName) throws SPIException, IOException {
        return this.readStreamComponent(vc, attrName, false);
    }

    private String readStreamComponent(ValueComponent vc, String attrName, boolean retry) throws SPIException, IOException {
        BufferedReader reader = null;
        StringBuffer str = new StringBuffer();
        reader = attrName.equals("Login Script") || retry ? new BufferedReader(new InputStreamReader(((StreamValue)vc).getValue(), "cp850")) : new BufferedReader(new InputStreamReader(((StreamValue)vc).getValue(), "UTF-8"));
        String line = new String();
        while (true) {
            try {
                line = reader.readLine();
            }
            catch (IOException e) {
                if (reader != null) {
                    reader.close();
                }
                if (!retry) {
                    return this.readStreamComponent(vc, attrName, true);
                }
                throw e;
            }
            if (line == null) break;
            str.append(line);
            str.append("\n");
        }
        if (reader != null) {
            reader.close();
        }
        return new String(str);
    }
}

