/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.AuditLog;
import com.novell.emframe.fw.DebugLogging;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.LookAndFeelDefaults;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import com.novell.nps.utils.XMLUtils;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.Properties;
import javax.crypto.Cipher;
import javax.servlet.ServletContext;
import javax.servlet.http.HttpServletRequest;

public class SystemConfigurationTask
extends Task {
    private static final String EMPTY_STRING = "";
    private static final String _CIPHERSUITE = "ciphersuite";
    private static final String _HIGH = "HIGH";
    private static final String _CIPHERS = "ciphers";
    private static final String _CONNECTOR = "Connector";
    private static final String _SERVICE = "Service";
    private static final String _SERVER = "Server";
    private static final long serialVersionUID = 1L;
    private int m_iLoggingLevel = 0;
    private boolean m_bLoggingToErr = false;
    private boolean m_bLoggingToOut = true;
    private boolean m_bLoggingToFile = false;
    private String m_tabSelection = "SecurityTab";
    private String m_authenticatedProtocol = "eDirectory";
    private static final String NOVELL_DOWNLOAD_URL = "https://www.novell.com/products/consoles/imanager/iman_mod_desc.xml";
    private Exception excep;
    private boolean isConfigSaveErr = false;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        HttpServletRequest req = context.getRequest();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        if (!FwUtils.canConfigureiManager(req)) {
            eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("FwResources", "Error", context), eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", context), context);
            return false;
        }
        try {
            boolean unlimitedJCE = Cipher.getMaxAllowedKeyLength("RC5") >= 256;
            D.log("Is Unlimited cryptography enabled: " + unlimitedJCE);
            req.setAttribute("JCEEnabled", (Object)unlimitedJCE);
        }
        catch (NoSuchAlgorithmException e1) {
            D.log("\nCould not read the allowed ciphers. Disabling the option to use Higher Ciphers\n");
            req.setAttribute("JCEEnabled", (Object)false);
        }
        if (req != null) {
            String nextState = req.getParameter("nextState");
            this.m_tabSelection = null == req.getParameter("selectedTab") ? "SecurityTab" : req.getParameter("selectedTab");
            if (nextState == null || nextState.length() == 0 || nextState.equalsIgnoreCase("initialState")) {
                this.initialState(req, resultStrings, config, context);
            } else if (nextState.equals("SaveConfiguration")) {
                try {
                    this.applyLookAndFeelSettings(config, req, context);
                    this.readLoggingSettings(req);
                    this.applyLoggingSettings(context, resultStrings);
                    this.applyAuthSettings(context);
                    this.applyRBSSettings(config, req, context);
                    this.applyMiscSettings(config, req);
                    this.applySecuritySettings(config, req, context);
                    if (!GlobalRegistry.isOES()) {
                        this.applyEncryptionSettings(context);
                    }
                    config.writeSettings();
                    String userName = context.getAuthenticator().getUserId(context);
                    String host = context.getRequest().getHeader("X-FORWARDED-FOR");
                    if (null == host) {
                        host = context.getRequest().getRemoteHost();
                    }
                    AuditLog.logSystemConfigurationChanged(userName, host);
                    D.log("Success Save Configuration: Your settings have been saved and will be visible after next login.\r\n");
                    req.setAttribute("nextState", (Object)"initialState");
                    if (this.isConfigSaveErr) {
                        eMFrameUtils.setErrorMessage(this.excep, context);
                        this.isConfigSaveErr = false;
                        this.excep = null;
                    } else {
                        eMFrameUtils.setMessage("success", eMFrameUtils.getLocalizedString("FwResources", "Success", context), eMFrameUtils.getLocalizedString("FwResources", "ChangesSaved", context), context);
                    }
                    this.setUIPage("fw/SystemConfigurationPage1.jsp");
                    this.initialState(req, resultStrings, config, context);
                }
                catch (ConfigException e) {
                    D.log("Error Saving Configuration: Your settings could not be saved.\r\n");
                    D.log(e);
                    req.setAttribute("nextState", (Object)"initialState");
                    eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("FwResources", "Error", context), eMFrameUtils.getLocalizedString("DevResources", "ParentWindowChangedErrorAlertMessage", context) + e.getMessage(), context);
                    this.setUIPage("fw/SystemConfigurationPage1.jsp");
                    this.initialState(req, resultStrings, config, context);
                }
            } else if (nextState.equals("LoggingClear")) {
                this.readLoggingSettings(req);
                String sFile = DebugLogging.getLogFileName();
                DebugLogging.stop();
                File f = new File(sFile);
                f.delete();
                DebugLogging.start();
                req.setAttribute("nextState", (Object)"initialState");
                this.setUIPage("fw/SystemConfigurationPage1.jsp");
                this.initialState(req, resultStrings, config, context);
                req.setAttribute("selectedIndex", (Object)"2");
            } else if (nextState.equals("QuickLogClearing")) {
                this.readLoggingSettings(req);
                String sFile = DebugLogging.getLogFileName();
                DebugLogging.stop();
                File f = new File(sFile);
                f.delete();
                DebugLogging.start();
                this.setUIPage("fw/Empty.jsp");
                req.setAttribute("quickLogClearing", (Object)"true");
            } else if (nextState.equals("LoggingView")) {
                this.doLoggingView(req);
            } else if (nextState.equals("QuickLogViewing")) {
                this.doLoggingView(req);
                req.setAttribute("quickLogViewing", (Object)"true");
            } else {
                this.initialState(req, resultStrings, config, context);
            }
        }
        req.setAttribute("selectedTab", (Object)this.m_tabSelection);
        return true;
    }

    private void applyEncryptionSettings(TaskContext context) {
        HttpServletRequest request = context.getRequest();
        ServletContext servletContext = request.getSession().getServletContext();
        String serverXML = this.getServerXMLPath(servletContext);
        try {
            XMLUtils utils = new XMLUtils(serverXML);
            String cipherSuite = request.getParameter(_CIPHERSUITE);
            String serverCipherSuite = this.getServerCipherSuite(utils);
            String cipherCert = this.getCert(cipherSuite);
            String serverCert = this.getCert(serverCipherSuite);
            String SSL = "sslEnabledProtocols";
            String SSL_RSA = "+TLSv1.1,+TLSv1.2";
            String SSL_EC = "+TLSv1.2";
            if (serverCipherSuite.equalsIgnoreCase(cipherSuite)) {
                return;
            }
            if (!cipherCert.equalsIgnoreCase(serverCert)) {
                utils.removeAttribute(_CONNECTOR, _CIPHERS);
                if (System.getProperty("os.name").toLowerCase().contains("linux")) {
                    SystemConfigurationTask.runCommand("rm  /var/opt/novell/novlwww/.keystore", "No such file or directory");
                    if (cipherCert.equalsIgnoreCase("ECDSA256")) {
                        SystemConfigurationTask.runCommand("cp /var/opt/novell/novlwww/.keystoreEC_256 /var/opt/novell/novlwww/.keystore", "No such file or directory");
                        utils.modifySpecificElement(_SERVER, _SERVICE, _CONNECTOR, SSL, SSL_EC);
                    } else if (cipherCert.equalsIgnoreCase("ECDSA384")) {
                        SystemConfigurationTask.runCommand("cp /var/opt/novell/novlwww/.keystoreEC_384 /var/opt/novell/novlwww/.keystore", "No such file or directory");
                        utils.modifySpecificElement(_SERVER, _SERVICE, _CONNECTOR, SSL, SSL_EC);
                    } else {
                        SystemConfigurationTask.runCommand("cp /var/opt/novell/novlwww/.keystoreRSA /var/opt/novell/novlwww/.keystore", "No such file or directory");
                        utils.modifySpecificElement(_SERVER, _SERVICE, _CONNECTOR, SSL, SSL_RSA);
                    }
                } else {
                    String keystore = serverXML.substring(0, serverXML.indexOf("server.xml")) + "ssl\\.keystore";
                    SystemConfigurationTask.runCommand("cmd /c del \"" + keystore + "\"", "The system cannot find the file specified.");
                    if (cipherCert.equalsIgnoreCase("ECDSA256")) {
                        SystemConfigurationTask.runCommand("cmd /c copy \"" + keystore + "EC_256\" \"" + keystore + "\"", "Could Not Find " + keystore + "EC_256");
                        utils.modifySpecificElement(_SERVER, _SERVICE, _CONNECTOR, SSL, SSL_EC);
                    } else if (cipherCert.equalsIgnoreCase("ECDSA384")) {
                        SystemConfigurationTask.runCommand("cmd /c copy \"" + keystore + "EC_384\" \"" + keystore + "\"", "Could Not Find " + keystore + "EC_384");
                        utils.modifySpecificElement(_SERVER, _SERVICE, _CONNECTOR, SSL, SSL_EC);
                    } else {
                        SystemConfigurationTask.runCommand("cmd /c copy \"" + keystore + "RSA\" \"" + keystore + "\"", "Could Not Find " + keystore + "RSA");
                        utils.modifySpecificElement(_SERVER, _SERVICE, _CONNECTOR, SSL, SSL_RSA);
                    }
                }
            }
            if (cipherSuite.equalsIgnoreCase(_HIGH)) {
                utils.modifySpecificElement(_SERVER, _SERVICE, _CONNECTOR, _CIPHERS, "TLS_RSA_WITH_AES_128_GCM_SHA256, TLS_DHE_RSA_WITH_AES_128_GCM_SHA256, TLS_DHE_DSS_WITH_AES_128_GCM_SHA256, TLS_ECDHE_RSA_WITH_AES_128_GCM_SHA256");
            } else if (cipherSuite.equalsIgnoreCase("LOW")) {
                utils.modifySpecificElement(_SERVER, _SERVICE, _CONNECTOR, _CIPHERS, "SSL_RSA_WITH_DES_CBC_SHA,SSL_DHE_RSA_WITH_DES_CBC_SHA,SSL_DHE_DSS_WITH_DES_CBC_SHA,SSL_RSA_EXPORT_WITH_RC4_40_MD5,SSL_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_DHE_RSA_EXPORT_WITH_DES40_CBC_SHA,SSL_DHE_DSS_EXPORT_WITH_DES40_CBC_SHA,TLS_RSA_WITH_AES_128_CBC_SHA");
            } else if (cipherSuite.equalsIgnoreCase("MEDIUM")) {
                utils.modifySpecificElement(_SERVER, _SERVICE, _CONNECTOR, _CIPHERS, "SSL_RSA_WITH_RC4_128_MD5, SSL_RSA_WITH_RC4_128_SHA, TLS_RSA_WITH_AES_128_CBC_SHA, TLS_DHE_RSA_WITH_AES_128_CBC_SHA, TLS_DHE_DSS_WITH_AES_128_CBC_SHA ");
            } else if (cipherSuite.equalsIgnoreCase("SUITEB128")) {
                utils.modifySpecificElement(_SERVER, _SERVICE, _CONNECTOR, _CIPHERS, "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256,TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
            } else if (cipherSuite.equalsIgnoreCase("SUITEB128ONLY")) {
                utils.modifySpecificElement(_SERVER, _SERVICE, _CONNECTOR, _CIPHERS, "TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256");
            } else if (cipherSuite.equalsIgnoreCase("SUITEB192")) {
                utils.modifySpecificElement(_SERVER, _SERVICE, _CONNECTOR, _CIPHERS, "TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384");
            } else if (cipherSuite.equalsIgnoreCase("NONE")) {
                utils.removeAttribute(_CONNECTOR, _CIPHERS);
            }
            utils.save();
        }
        catch (IOException e) {
            D.log(e);
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    private void applyLookAndFeelSettings(SystemConfig config, HttpServletRequest req, TaskContext context) throws ConfigException {
        this.validateLAFFilePaths(req, context);
        config.setSetting("LookAndFeel_OrganizationName", req.getParameter("LookAndFeel_OrganizationName"));
        config.setSetting("LookAndFeel_iManagerHeaderBackgroundImage", req.getParameter("LookAndFeel_iManagerHeaderBackgroundImage"));
        config.setSetting("LookAndFeel_iManagerHeaderFillerImage", req.getParameter("LookAndFeel_iManagerHeaderFillerImage"));
        config.setSetting("LookAndFeel_iManagerBrandingImage", req.getParameter("LookAndFeel_iManagerBrandingImage"));
        config.setSetting("LookAndFeel_MenuHeaderColor", req.getParameter("LookAndFeel_MenuHeaderColor"));
        config.setSetting("LookAndFeel_MenuColor", req.getParameter("LookAndFeel_MenuColor"));
        config.setSetting("LookAndFeel_MenuTitleColor", req.getParameter("LookAndFeel_MenuTitleColor"));
        config.setSetting("LookAndFeel_HomeImage", req.getParameter("LookAndFeel_HomeImage"));
        String doShowHomeImage = req.getParameter("LookAndFeel_ShowHomeImage");
        config.setSetting("LookAndFeel_ShowHomeImage", null == doShowHomeImage ? "false" : doShowHomeImage);
    }

    private void readLookAndFeelInfoAndSet(HttpServletRequest req, Properties resultStrings, SystemConfig config) {
        resultStrings.put("LookAndFeel_OrganizationName", eMFrameUtils.stringToHTMLExt(config.getSetting("LookAndFeel_OrganizationName", LookAndFeelDefaults.OrganizationName)));
        resultStrings.put("LookAndFeel_iManagerHeaderBackgroundImage", config.getSetting("LookAndFeel_iManagerHeaderBackgroundImage", LookAndFeelDefaults.HeaderBackgroundImage));
        resultStrings.put("LookAndFeel_iManagerHeaderFillerImage", config.getSetting("LookAndFeel_iManagerHeaderFillerImage", LookAndFeelDefaults.HeaderFillerImage));
        resultStrings.put("LookAndFeel_iManagerBrandingImage", config.getSetting("LookAndFeel_iManagerBrandingImage", LookAndFeelDefaults.BrandingImage));
        resultStrings.put("LookAndFeel_MenuHeaderColor", config.getSetting("LookAndFeel_MenuHeaderColor", LookAndFeelDefaults.MenuHeaderColor));
        resultStrings.put("LookAndFeel_MenuColor", config.getSetting("LookAndFeel_MenuColor", LookAndFeelDefaults.MenuColor));
        resultStrings.put("LookAndFeel_MenuTitleColor", config.getSetting("LookAndFeel_MenuTitleColor", LookAndFeelDefaults.MenuTitleColor));
        resultStrings.put("LookAndFeel_HomeImage", eMFrameUtils.stringToHTMLExt(config.getSetting("LookAndFeel_HomeImage", LookAndFeelDefaults.HomeImage)));
        resultStrings.put("LookAndFeel_ShowHomeImage", config.getSetting("LookAndFeel_ShowHomeImage", LookAndFeelDefaults.ShowHomeImage));
    }

    private void validateLAFFilePaths(HttpServletRequest req, TaskContext context) throws ConfigException {
        String errmsg = EMPTY_STRING;
        String path = EMPTY_STRING;
        boolean valid = true;
        path = req.getParameter("LookAndFeel_iManagerHeaderBackgroundImage");
        File infile = new File(path = eMFrameUtils.getRealPath(path));
        if (!infile.exists()) {
            errmsg = errmsg + eMFrameUtils.getLocalizedString("FwResources", "SysConfig.LAFHeaderImgLoc", context);
            errmsg = errmsg + eMFrameUtils.getLocalizedString("FwResources", "SysConfig.LAFFilePathInvalid", context) + "\n  ";
            valid = false;
        }
        path = req.getParameter("LookAndFeel_iManagerHeaderFillerImage");
        infile = new File(path = eMFrameUtils.getRealPath(path));
        if (!infile.exists()) {
            errmsg = errmsg + eMFrameUtils.getLocalizedString("FwResources", "SysConfig.LAFHeaderFillerImgLoc", context);
            errmsg = errmsg + eMFrameUtils.getLocalizedString("FwResources", "SysConfig.LAFFilePathInvalid", context) + "\n  ";
            valid = false;
        }
        path = req.getParameter("LookAndFeel_iManagerBrandingImage");
        infile = new File(path = eMFrameUtils.getRealPath(path));
        if (!infile.exists()) {
            errmsg = errmsg + eMFrameUtils.getLocalizedString("FwResources", "SysConfig.LAFBrandingImgLoc", context);
            errmsg = errmsg + eMFrameUtils.getLocalizedString("FwResources", "SysConfig.LAFFilePathInvalid", context) + "\n  ";
            valid = false;
        }
        if (!valid) {
            throw new ConfigException(errmsg);
        }
    }

    private void doLoggingView(HttpServletRequest req) {
        this.readLoggingSettings(req);
        this.setUIPage("fw/ViewLog.jsp");
        req.setAttribute("loggingLevel", (Object)String.valueOf(this.m_iLoggingLevel));
        req.setAttribute("loggingToErr", (Object)String.valueOf(this.m_bLoggingToErr));
        req.setAttribute("loggingToOut", (Object)String.valueOf(this.m_bLoggingToOut));
        req.setAttribute("loggingToFile", (Object)String.valueOf(this.m_bLoggingToFile));
        req.setAttribute("loggingFile", (Object)DebugLogging.getLogFileName());
        req.setAttribute("loggingFileSize", (Object)String.valueOf(DebugLogging.getLogFileSize()));
    }

    private void initialState(HttpServletRequest req, Properties resultStrings, SystemConfig config, TaskContext context) {
        this.setUIPage("fw/SystemConfigurationPage1.jsp");
        req.setAttribute("selectedIndex", (Object)"1");
        req.setAttribute("selectedTab", (Object)"SecurityTab");
        AuthenticationBroker broker = context.getAuthenticationBroker();
        try {
            ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            this.m_authenticatedProtocol = treeOE.getAdminNamespace().getUniqueID().equalsIgnoreCase("NDS") ? "eDirectory" : "LDAP";
            req.setAttribute("authenticatedProtocol", (Object)this.m_authenticatedProtocol);
        }
        catch (Exception e) {
            D.log(e);
        }
        this.readLookAndFeelInfoAndSet(req, resultStrings, config);
        this.readLoggingInfoAndSet(context.getRequest());
        this.readAuthInfoAndSet(context);
        try {
            this.readRBSSettings(context);
        }
        catch (ConfigException e) {
            D.log("SystemConfigurationTask::readRBSSettings: RBS configuration cannot be read from config.");
            D.log(e);
        }
        this.readMiscInfoAndSet(context);
        this.readSecurityInfoAndSet(context);
        if (!GlobalRegistry.isOES()) {
            this.readEncryptInfoAndSet(context);
        }
    }

    private void readEncryptInfoAndSet(TaskContext context) {
        HttpServletRequest instRequest = context.getRequest();
        ServletContext servletContext = instRequest.getSession().getServletContext();
        String serverXML = this.getServerXMLPath(servletContext);
        try {
            XMLUtils utils = new XMLUtils(serverXML);
            String serverCipherSuite = this.getServerCipherSuite(utils);
            if (EMPTY_STRING != serverCipherSuite) {
                instRequest.setAttribute(_CIPHERSUITE, (Object)serverCipherSuite);
            }
        }
        catch (IOException e) {
            D.log(e);
        }
        catch (Exception e) {
            D.log(e);
        }
    }

    private String getServerCipherSuite(XMLUtils utils) {
        String cipherSuite = EMPTY_STRING;
        String cipherValue = utils.getAttribute(_CONNECTOR, _CIPHERS);
        if (null != cipherValue) {
            cipherSuite = cipherValue.contains("SSL_RSA_EXPORT_WITH_RC4_40_MD5") ? "LOW" : (cipherValue.contains("SSL_RSA_WITH_RC4_128_SHA") ? "MEDIUM" : (cipherValue.contains("TLS_RSA_WITH_AES_128_GCM_SHA256") ? _HIGH : (cipherValue.contains("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256") && cipherValue.contains("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384") ? "SUITEB128" : (cipherValue.contains("TLS_ECDHE_ECDSA_WITH_AES_128_GCM_SHA256") ? "SUITEB128ONLY" : (cipherValue.contains("TLS_ECDHE_ECDSA_WITH_AES_256_GCM_SHA384") ? "SUITEB192" : "NONE")))));
            return cipherSuite;
        }
        return cipherSuite;
    }

    private String getServerXMLPath(ServletContext servletContext) {
        StringBuilder sPath = new StringBuilder(256);
        if (System.getProperty("os.name").toLowerCase().indexOf("linux") != -1) {
            String catalinePath = System.getProperty("catalina.base");
            if (null == catalinePath || catalinePath.isEmpty()) {
                catalinePath = System.getProperty("catalina.home");
            }
            sPath.append(catalinePath);
        } else {
            String realPath = servletContext.getRealPath("/");
            String[] serverPath = realPath.split("webapps");
            sPath.append(serverPath[0]);
        }
        sPath.append(File.separator);
        sPath.append("conf");
        sPath.append(File.separator);
        sPath.append("server.xml");
        String serverXML = sPath.toString();
        return serverXML;
    }

    private void readSecurityInfoAndSet(TaskContext context) {
        HttpServletRequest req = context.getRequest();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        Boolean bSecurityWarnNonSecure = new Boolean(true);
        Boolean bSecurityEnableNSureAudit = new Boolean(false);
        Boolean bSecurityEnableXDASAudit = new Boolean(false);
        Boolean bSecurityEnableCEFAudit = new Boolean(false);
        Boolean bSecurityEnableNSureAuditAuthorizedUsers = new Boolean(false);
        Boolean bSecurityEnableNSureAuditFailedSSLConnection = new Boolean(false);
        Boolean bSecurityEnableNSureAuditLoginFailed = new Boolean(false);
        Boolean bSecurityEnableNSureAuditLoginSuccess = new Boolean(false);
        Boolean bSecurityEnableNSureAuditLogout = new Boolean(false);
        Boolean bSecurityEnableNSureAuditNPMFailedInstall = new Boolean(false);
        Boolean bSecurityEnableNSureAuditNPMInstalled = new Boolean(false);
        Boolean bSecurityEnableNSureAuditNPMUploaded = new Boolean(false);
        Boolean bSecurityEnableNSureAuditChangedConfiguration = new Boolean(false);
        Boolean bSecurityEnableNSureAuditStartup = new Boolean(false);
        Boolean bSecurityEnableNSureAuditShutdown = new Boolean(false);
        Boolean bSecurityEnableXDASAuditAuthorizedUsers = new Boolean(false);
        Boolean bSecurityEnableXDASAuditFailedSSLConnection = new Boolean(false);
        Boolean bSecurityEnableXDASAuditLoginFailed = new Boolean(false);
        Boolean bSecurityEnableXDASAuditLoginSuccess = new Boolean(false);
        Boolean bSecurityEnableXDASAuditLogout = new Boolean(false);
        Boolean bSecurityEnableXDASAuditNPMFailedInstall = new Boolean(false);
        Boolean bSecurityEnableXDASAuditNPMInstalled = new Boolean(false);
        Boolean bSecurityEnableXDASAuditNPMUploaded = new Boolean(false);
        Boolean bSecurityEnableXDASAuditChangedConfiguration = new Boolean(false);
        Boolean bSecurityEnableXDASAuditStartup = new Boolean(false);
        Boolean bSecurityEnableXDASAuditShutdown = new Boolean(false);
        Boolean bSecurityEnableCEFAuditAuthorizedUsers = new Boolean(false);
        Boolean bSecurityEnableCEFAuditFailedSSLConnection = new Boolean(false);
        Boolean bSecurityEnableCEFAuditLoginFailed = new Boolean(false);
        Boolean bSecurityEnableCEFAuditLoginSuccess = new Boolean(false);
        Boolean bSecurityEnableCEFAuditLogout = new Boolean(false);
        Boolean bSecurityEnableCEFAuditNPMFailedInstall = new Boolean(false);
        Boolean bSecurityEnableCEFAuditNPMInstalled = new Boolean(false);
        Boolean bSecurityEnableCEFAuditNPMUploaded = new Boolean(false);
        Boolean bSecurityEnableCEFAuditChangedConfiguration = new Boolean(false);
        Boolean bSecurityEnableCEFAuditStartup = new Boolean(false);
        Boolean bSecurityEnableCEFAuditShutdown = new Boolean(false);
        Boolean bSecurityAutoImportCertificate = new Boolean(true);
        bSecurityWarnNonSecure = Boolean.valueOf(config.getSetting("Security.Warn.nonSecure", String.valueOf(bSecurityWarnNonSecure)));
        bSecurityEnableNSureAudit = Boolean.valueOf(config.getSetting("Audit.EnableNSureAuditLog", String.valueOf(bSecurityEnableNSureAudit)));
        bSecurityEnableXDASAudit = Boolean.valueOf(config.getSetting("Audit.EnableXDASAuditLog", String.valueOf(bSecurityEnableXDASAudit)));
        bSecurityEnableCEFAudit = Boolean.valueOf(config.getSetting("Audit.EnableCEFAuditLog", String.valueOf(bSecurityEnableCEFAudit)));
        bSecurityEnableNSureAuditAuthorizedUsers = Boolean.valueOf(config.getSetting("Audit.AuthorizedUsers", String.valueOf(bSecurityEnableNSureAuditAuthorizedUsers)));
        bSecurityEnableNSureAuditFailedSSLConnection = Boolean.valueOf(config.getSetting("Audit.FailedSSLConnection", String.valueOf(bSecurityEnableNSureAuditFailedSSLConnection)));
        bSecurityEnableNSureAuditLoginFailed = Boolean.valueOf(config.getSetting("Audit.LoginFailed", String.valueOf(bSecurityEnableNSureAuditLoginFailed)));
        bSecurityEnableNSureAuditLoginSuccess = Boolean.valueOf(config.getSetting("Audit.LoginSuccess", String.valueOf(bSecurityEnableNSureAuditLoginSuccess)));
        bSecurityEnableNSureAuditLogout = Boolean.valueOf(config.getSetting("Audit.Logout", String.valueOf(bSecurityEnableNSureAuditLogout)));
        bSecurityEnableNSureAuditNPMFailedInstall = Boolean.valueOf(config.getSetting("Audit.NPMFailedInstall", String.valueOf(bSecurityEnableNSureAuditNPMFailedInstall)));
        bSecurityEnableNSureAuditNPMInstalled = Boolean.valueOf(config.getSetting("Audit.NPMInstalled", String.valueOf(bSecurityEnableNSureAuditNPMInstalled)));
        bSecurityEnableNSureAuditNPMUploaded = Boolean.valueOf(config.getSetting("Audit.NPMUploaded", String.valueOf(bSecurityEnableNSureAuditNPMUploaded)));
        bSecurityEnableNSureAuditChangedConfiguration = Boolean.valueOf(config.getSetting("Audit.ChangedConfiguration", String.valueOf(bSecurityEnableNSureAuditChangedConfiguration)));
        bSecurityEnableNSureAuditStartup = Boolean.valueOf(config.getSetting("Audit.Startup", String.valueOf(bSecurityEnableNSureAuditStartup)));
        bSecurityEnableNSureAuditShutdown = Boolean.valueOf(config.getSetting("Audit.Shutdown", String.valueOf(bSecurityEnableNSureAuditShutdown)));
        bSecurityEnableXDASAuditAuthorizedUsers = Boolean.valueOf(config.getSetting("XDAS.Audit.AuthorizedUsers", String.valueOf(bSecurityEnableXDASAuditAuthorizedUsers)));
        bSecurityEnableXDASAuditFailedSSLConnection = Boolean.valueOf(config.getSetting("XDAS.Audit.FailedSSLConnection", String.valueOf(bSecurityEnableXDASAuditFailedSSLConnection)));
        bSecurityEnableXDASAuditLoginFailed = Boolean.valueOf(config.getSetting("XDAS.Audit.LoginFailed", String.valueOf(bSecurityEnableXDASAuditLoginFailed)));
        bSecurityEnableXDASAuditLoginSuccess = Boolean.valueOf(config.getSetting("XDAS.Audit.LoginSuccess", String.valueOf(bSecurityEnableXDASAuditLoginSuccess)));
        bSecurityEnableXDASAuditLogout = Boolean.valueOf(config.getSetting("XDAS.Audit.Logout", String.valueOf(bSecurityEnableXDASAuditLogout)));
        bSecurityEnableXDASAuditNPMFailedInstall = Boolean.valueOf(config.getSetting("XDAS.Audit.NPMFailedInstall", String.valueOf(bSecurityEnableXDASAuditNPMFailedInstall)));
        bSecurityEnableXDASAuditNPMInstalled = Boolean.valueOf(config.getSetting("XDAS.Audit.NPMInstalled", String.valueOf(bSecurityEnableXDASAuditNPMInstalled)));
        bSecurityEnableXDASAuditNPMUploaded = Boolean.valueOf(config.getSetting("XDAS.Audit.NPMUploaded", String.valueOf(bSecurityEnableXDASAuditNPMUploaded)));
        bSecurityEnableXDASAuditChangedConfiguration = Boolean.valueOf(config.getSetting("XDAS.Audit.ChangedConfiguration", String.valueOf(bSecurityEnableXDASAuditChangedConfiguration)));
        bSecurityEnableXDASAuditStartup = Boolean.valueOf(config.getSetting("XDAS.Audit.Startup", String.valueOf(bSecurityEnableXDASAuditStartup)));
        bSecurityEnableXDASAuditShutdown = Boolean.valueOf(config.getSetting("XDAS.Audit.Shutdown", String.valueOf(bSecurityEnableXDASAuditShutdown)));
        bSecurityEnableCEFAuditAuthorizedUsers = Boolean.valueOf(config.getSetting("CEF.Audit.AuthorizedUsers", String.valueOf(bSecurityEnableCEFAuditAuthorizedUsers)));
        bSecurityEnableCEFAuditFailedSSLConnection = Boolean.valueOf(config.getSetting("CEF.Audit.FailedSSLConnection", String.valueOf(bSecurityEnableCEFAuditFailedSSLConnection)));
        bSecurityEnableCEFAuditLoginFailed = Boolean.valueOf(config.getSetting("CEF.Audit.LoginFailed", String.valueOf(bSecurityEnableCEFAuditLoginFailed)));
        bSecurityEnableCEFAuditLoginSuccess = Boolean.valueOf(config.getSetting("CEF.Audit.LoginSuccess", String.valueOf(bSecurityEnableCEFAuditLoginSuccess)));
        bSecurityEnableCEFAuditLogout = Boolean.valueOf(config.getSetting("CEF.Audit.Logout", String.valueOf(bSecurityEnableCEFAuditLogout)));
        bSecurityEnableCEFAuditNPMFailedInstall = Boolean.valueOf(config.getSetting("CEF.Audit.NPMFailedInstall", String.valueOf(bSecurityEnableCEFAuditNPMFailedInstall)));
        bSecurityEnableCEFAuditNPMInstalled = Boolean.valueOf(config.getSetting("CEF.Audit.NPMInstalled", String.valueOf(bSecurityEnableCEFAuditNPMInstalled)));
        bSecurityEnableCEFAuditNPMUploaded = Boolean.valueOf(config.getSetting("CEF.Audit.NPMUploaded", String.valueOf(bSecurityEnableCEFAuditNPMUploaded)));
        bSecurityEnableCEFAuditChangedConfiguration = Boolean.valueOf(config.getSetting("CEF.Audit.ChangedConfiguration", String.valueOf(bSecurityEnableCEFAuditChangedConfiguration)));
        bSecurityEnableCEFAuditStartup = Boolean.valueOf(config.getSetting("CEF.Audit.Startup", String.valueOf(bSecurityEnableCEFAuditStartup)));
        bSecurityEnableCEFAuditShutdown = Boolean.valueOf(config.getSetting("CEF.Audit.Shutdown", String.valueOf(bSecurityEnableCEFAuditShutdown)));
        bSecurityAutoImportCertificate = Boolean.valueOf(config.getSetting("Security.KeyStore.AutoUpdate", String.valueOf(bSecurityAutoImportCertificate)));
        req.setAttribute("SecurityWarnNonSecure", (Object)String.valueOf(bSecurityWarnNonSecure));
        req.setAttribute("SecurityEnableNSureAudit", (Object)String.valueOf(bSecurityEnableNSureAudit));
        req.setAttribute("SecurityEnableXDASAudit", (Object)String.valueOf(bSecurityEnableXDASAudit));
        req.setAttribute("SecurityEnableCEFAudit", (Object)String.valueOf(bSecurityEnableCEFAudit));
        req.setAttribute("SecurityEnableNSureAuditAuthorizedUsers", (Object)String.valueOf(bSecurityEnableNSureAuditAuthorizedUsers));
        req.setAttribute("SecurityEnableNSureAuditFailedSSLConnection", (Object)String.valueOf(bSecurityEnableNSureAuditFailedSSLConnection));
        req.setAttribute("SecurityEnableNSureAuditLoginFailed", (Object)String.valueOf(bSecurityEnableNSureAuditLoginFailed));
        req.setAttribute("SecurityEnableNSureAuditLoginSuccess", (Object)String.valueOf(bSecurityEnableNSureAuditLoginSuccess));
        req.setAttribute("SecurityEnableNSureAuditLogout", (Object)String.valueOf(bSecurityEnableNSureAuditLogout));
        req.setAttribute("SecurityEnableNSureAuditNPMFailedInstall", (Object)String.valueOf(bSecurityEnableNSureAuditNPMFailedInstall));
        req.setAttribute("SecurityEnableNSureAuditNPMInstalled", (Object)String.valueOf(bSecurityEnableNSureAuditNPMInstalled));
        req.setAttribute("SecurityEnableNSureAuditNPMUploaded", (Object)String.valueOf(bSecurityEnableNSureAuditNPMUploaded));
        req.setAttribute("SecurityEnableNSureAuditChangedConfiguration", (Object)String.valueOf(bSecurityEnableNSureAuditChangedConfiguration));
        req.setAttribute("SecurityEnableNSureAuditStartup", (Object)String.valueOf(bSecurityEnableNSureAuditStartup));
        req.setAttribute("SecurityEnableNSureAuditShutdown", (Object)String.valueOf(bSecurityEnableNSureAuditShutdown));
        req.setAttribute("SecurityEnableXDASAuditAuthorizedUsers", (Object)String.valueOf(bSecurityEnableXDASAuditAuthorizedUsers));
        req.setAttribute("SecurityEnableXDASAuditFailedSSLConnection", (Object)String.valueOf(bSecurityEnableXDASAuditFailedSSLConnection));
        req.setAttribute("SecurityEnableXDASAuditLoginFailed", (Object)String.valueOf(bSecurityEnableXDASAuditLoginFailed));
        req.setAttribute("SecurityEnableXDASAuditLoginSuccess", (Object)String.valueOf(bSecurityEnableXDASAuditLoginSuccess));
        req.setAttribute("SecurityEnableXDASAuditLogout", (Object)String.valueOf(bSecurityEnableXDASAuditLogout));
        req.setAttribute("SecurityEnableXDASAuditNPMFailedInstall", (Object)String.valueOf(bSecurityEnableXDASAuditNPMFailedInstall));
        req.setAttribute("SecurityEnableXDASAuditNPMInstalled", (Object)String.valueOf(bSecurityEnableXDASAuditNPMInstalled));
        req.setAttribute("SecurityEnableXDASAuditNPMUploaded", (Object)String.valueOf(bSecurityEnableXDASAuditNPMUploaded));
        req.setAttribute("SecurityEnableXDASAuditChangedConfiguration", (Object)String.valueOf(bSecurityEnableXDASAuditChangedConfiguration));
        req.setAttribute("SecurityEnableXDASAuditStartup", (Object)String.valueOf(bSecurityEnableXDASAuditStartup));
        req.setAttribute("SecurityEnableXDASAuditShutdown", (Object)String.valueOf(bSecurityEnableXDASAuditShutdown));
        req.setAttribute("SecurityEnableCEFAuditAuthorizedUsers", (Object)String.valueOf(bSecurityEnableCEFAuditAuthorizedUsers));
        req.setAttribute("SecurityEnableCEFAuditFailedSSLConnection", (Object)String.valueOf(bSecurityEnableCEFAuditFailedSSLConnection));
        req.setAttribute("SecurityEnableCEFAuditLoginFailed", (Object)String.valueOf(bSecurityEnableCEFAuditLoginFailed));
        req.setAttribute("SecurityEnableCEFAuditLoginSuccess", (Object)String.valueOf(bSecurityEnableCEFAuditLoginSuccess));
        req.setAttribute("SecurityEnableCEFAuditLogout", (Object)String.valueOf(bSecurityEnableCEFAuditLogout));
        req.setAttribute("SecurityEnableCEFAuditNPMFailedInstall", (Object)String.valueOf(bSecurityEnableCEFAuditNPMFailedInstall));
        req.setAttribute("SecurityEnableCEFAuditNPMInstalled", (Object)String.valueOf(bSecurityEnableCEFAuditNPMInstalled));
        req.setAttribute("SecurityEnableCEFAuditNPMUploaded", (Object)String.valueOf(bSecurityEnableCEFAuditNPMUploaded));
        req.setAttribute("SecurityEnableCEFAuditChangedConfiguration", (Object)String.valueOf(bSecurityEnableCEFAuditChangedConfiguration));
        req.setAttribute("SecurityEnableCEFAuditStartup", (Object)String.valueOf(bSecurityEnableCEFAuditStartup));
        req.setAttribute("SecurityEnableCEFAuditShutdown", (Object)String.valueOf(bSecurityEnableCEFAuditShutdown));
        req.setAttribute("SecurityAutoImportCertificate", (Object)String.valueOf(bSecurityAutoImportCertificate));
        this.readSecurityConfigIman(req, context);
    }

    private void readSecurityConfigIman(HttpServletRequest req, TaskContext context) {
        Properties propFile = new Properties();
        String sPath = eMFrameUtils.getRealPath("/WEB-INF") + "/configiman.properties";
        FileInputStream inputStream = null;
        try {
            inputStream = new FileInputStream(sPath);
            if (inputStream != null) {
                int size = ((InputStream)inputStream).available();
                byte[] bArray = new byte[size];
                ((InputStream)inputStream).read(bArray, 0, size);
                String sTemp = new String(bArray, 0, size);
                ByteArrayInputStream byteAis = new ByteArrayInputStream(sTemp.getBytes());
                propFile.load(byteAis);
                int i = 0;
                Enumeration<Object> myenum = propFile.keys();
                String[] sArray = new String[propFile.entrySet().size()];
                while (myenum.hasMoreElements()) {
                    String sKey = (String)myenum.nextElement();
                    String sValue = propFile.getProperty(sKey);
                    if (sValue.equalsIgnoreCase("eDirectory") || sValue.equalsIgnoreCase("LDAP")) {
                        if (sKey.endsWith(".")) {
                            sKey = sKey.substring(0, sKey.lastIndexOf("."));
                        }
                        sArray[i++] = new String(sKey);
                        continue;
                    }
                    sArray[i++] = new String(sKey);
                }
                if (sArray.length > 0 && !sArray[0].equals(EMPTY_STRING)) {
                    req.setAttribute("SecurityAuthorizedUsers", (Object)eMFrameUtils.pack(sArray, context));
                }
                ((InputStream)inputStream).close();
            }
        }
        catch (Exception e) {
            D.log(e);
            inputStream = null;
        }
    }

    private void applySecuritySettings(SystemConfig config, HttpServletRequest req, TaskContext context) throws ConfigException {
        String sTemp = req.getParameter("SecurityWarnNonSecure");
        config.setSetting("Security.Warn.nonSecure", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAudit");
        config.setSetting("Audit.EnableNSureAuditLog", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableXDASAudit");
        config.setSetting("Audit.EnableXDASAuditLog", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableCEFAudit");
        config.setSetting("Audit.EnableCEFAuditLog", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditAuthorizedUsers");
        config.setSetting("Audit.AuthorizedUsers", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditFailedSSLConnection");
        config.setSetting("Audit.FailedSSLConnection", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditLoginFailed");
        config.setSetting("Audit.LoginFailed", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditLoginSuccess");
        config.setSetting("Audit.LoginSuccess", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditLogout");
        config.setSetting("Audit.Logout", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditNPMFailedInstall");
        config.setSetting("Audit.NPMFailedInstall", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditNPMInstalled");
        config.setSetting("Audit.NPMInstalled", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditNPMUploaded");
        config.setSetting("Audit.NPMUploaded", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditChangedConfiguration");
        config.setSetting("Audit.ChangedConfiguration", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditStartup");
        config.setSetting("Audit.Startup", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableNSureAuditShutdown");
        config.setSetting("Audit.Shutdown", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableXDASAuditAuthorizedUsers");
        config.setSetting("XDAS.Audit.AuthorizedUsers", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableXDASAuditFailedSSLConnection");
        config.setSetting("XDAS.Audit.FailedSSLConnection", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableXDASAuditLoginFailed");
        config.setSetting("XDAS.Audit.LoginFailed", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableXDASAuditLoginSuccess");
        config.setSetting("XDAS.Audit.LoginSuccess", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableXDASAuditLogout");
        config.setSetting("XDAS.Audit.Logout", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableXDASAuditNPMFailedInstall");
        config.setSetting("XDAS.Audit.NPMFailedInstall", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableXDASAuditNPMInstalled");
        config.setSetting("XDAS.Audit.NPMInstalled", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableXDASAuditNPMUploaded");
        config.setSetting("XDAS.Audit.NPMUploaded", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableXDASAuditChangedConfiguration");
        config.setSetting("XDAS.Audit.ChangedConfiguration", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableXDASAuditStartup");
        config.setSetting("XDAS.Audit.Startup", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableXDASAuditShutdown");
        config.setSetting("XDAS.Audit.Shutdown", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableCEFAuditAuthorizedUsers");
        config.setSetting("CEF.Audit.AuthorizedUsers", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableCEFAuditFailedSSLConnection");
        config.setSetting("CEF.Audit.FailedSSLConnection", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableCEFAuditLoginFailed");
        config.setSetting("CEF.Audit.LoginFailed", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableCEFAuditLoginSuccess");
        config.setSetting("CEF.Audit.LoginSuccess", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableCEFAuditLogout");
        config.setSetting("CEF.Audit.Logout", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableCEFAuditNPMFailedInstall");
        config.setSetting("CEF.Audit.NPMFailedInstall", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableCEFAuditNPMInstalled");
        config.setSetting("CEF.Audit.NPMInstalled", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableCEFAuditNPMUploaded");
        config.setSetting("CEF.Audit.NPMUploaded", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableCEFAuditChangedConfiguration");
        config.setSetting("CEF.Audit.ChangedConfiguration", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableCEFAuditStartup");
        config.setSetting("CEF.Audit.Startup", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityEnableCEFAuditShutdown");
        config.setSetting("CEF.Audit.Shutdown", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("SecurityAutoImportCertificate");
        config.setSetting("Security.KeyStore.AutoUpdate", null == sTemp ? "false" : sTemp);
        this.applySecurityConfigIman(context, req);
    }

    private void applySecurityConfigIman(TaskContext context, HttpServletRequest req) {
        int count = 0;
        boolean isFileNew = false;
        String sTreeName = DirAuthenticator.getDirAuth(context).getConnectionProfile(context.getRequest()).getUniqueHostId();
        Properties propFile = new Properties();
        String sPath = eMFrameUtils.getRealPath("/WEB-INF") + "/configiman.properties";
        FileInputStream inputStream = null;
        try {
            File fconfig = new File(sPath);
            if (!fconfig.exists()) {
                fconfig.createNewFile();
                isFileNew = true;
            }
            if ((inputStream = new FileInputStream(sPath)) != null) {
                int size = ((InputStream)inputStream).available();
                byte[] bArray = new byte[size];
                ((InputStream)inputStream).read(bArray, 0, size);
                String sTemp = new String(bArray, 0, size);
                ByteArrayInputStream byteInputStream = new ByteArrayInputStream(sTemp.getBytes());
                propFile.load(byteInputStream);
                String[] sArray = eMFrameUtils.unpack(req.getParameter("SecurityAuthorizedUsers_packedValues"), context);
                Enumeration<Object> propUsers = propFile.keys();
                ArrayList<Object> existingSecurityAuthUsers = Collections.list(propUsers);
                propFile.clear();
                for (int i = 0; i < sArray.length; ++i) {
                    try {
                        if (sArray[i].equalsIgnoreCase("AllUsers")) {
                            propFile.setProperty(sArray[i], "true");
                            continue;
                        }
                        AuthenticationBroker broker = context.getAuthenticationBroker();
                        ObjectEntry tree_oe = (ObjectEntry)broker.getAPIObject("NDSNamespace");
                        AdminNamespace ns = tree_oe.getAdminNamespace();
                        ns.getObjectEntry(sArray[i] + ".");
                        if (!existingSecurityAuthUsers.contains(sArray[i])) {
                            String clientHostIP = context.getRequest().getHeader("X-FORWARDED-FOR");
                            if (null == clientHostIP) {
                                clientHostIP = req.getRemoteHost();
                            }
                            AuditLog.logAuthorizedUserAdded(DirAuthenticator.getDirAuth(context).getAuthenticationBroker().getAuthNdapName(), sArray[i], sTreeName, clientHostIP);
                        }
                        propFile.setProperty(sArray[i], this.m_authenticatedProtocol);
                        continue;
                    }
                    catch (SPIException e) {
                        D.log(e);
                        if (isFileNew || sArray.length == ++count) {
                            propFile.setProperty("AllUsers", "true");
                        }
                        this.isConfigSaveErr = true;
                        this.excep = e;
                    }
                }
                ((InputStream)inputStream).close();
                FileOutputStream outputStream = new FileOutputStream(sPath);
                propFile.store(outputStream, EMPTY_STRING);
                ((OutputStream)outputStream).close();
            }
        }
        catch (Exception e) {
            D.log(e);
            inputStream = null;
        }
    }

    private void readMiscInfoAndSet(TaskContext context) {
        HttpServletRequest req = context.getRequest();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        String sMisceGuideURL = "EMFRAME_SERVER";
        Boolean bShouldModuleDownload = new Boolean(true);
        String sWhichModuleToDownload = new String("All");
        Boolean bModulesDownloadEnableProxy = new Boolean(false);
        String sModulesDownloadProxyHost = new String("127.0.0.1");
        String sModulesDownloadProxyPort = new String("80");
        String sModulesDownloadProxyUserName = EMPTY_STRING;
        String sModulesDownloadProxyPassword = EMPTY_STRING;
        sMisceGuideURL = config.getSetting("Provider.eMFrame.eGuide.location", sMisceGuideURL);
        bShouldModuleDownload = Boolean.valueOf(config.getSetting("ShouldModuleDownload", String.valueOf(bShouldModuleDownload)));
        sWhichModuleToDownload = config.getSetting("WhichModuleToDownload", sWhichModuleToDownload);
        bModulesDownloadEnableProxy = Boolean.valueOf(config.getSetting("ModulesDownloadEnableProxy", String.valueOf(bModulesDownloadEnableProxy)));
        sModulesDownloadProxyHost = config.getSetting("ModulesDownloadProxyHost", sModulesDownloadProxyHost);
        sModulesDownloadProxyPort = config.getSetting("ModulesDownloadProxyPort", sModulesDownloadProxyPort);
        sModulesDownloadProxyUserName = config.getSetting("ModulesDownloadProxyUserName", sModulesDownloadProxyUserName);
        sModulesDownloadProxyPassword = config.getSetting("ModulesDownloadProxyPassword", sModulesDownloadProxyPassword);
        req.setAttribute("MisceGuideURL", (Object)sMisceGuideURL);
        req.setAttribute("ShouldModuleDownload", (Object)String.valueOf(bShouldModuleDownload));
        if (null != sWhichModuleToDownload && sWhichModuleToDownload.equalsIgnoreCase("All")) {
            req.setAttribute("AllModulesToDownload", (Object)"true");
            req.setAttribute("PartialModulesToDownload", (Object)"false");
        } else {
            req.setAttribute("AllModulesToDownload", (Object)"false");
            req.setAttribute("PartialModulesToDownload", (Object)"true");
        }
        req.setAttribute("ModulesDownloadEnableProxy", (Object)String.valueOf(bModulesDownloadEnableProxy));
        req.setAttribute("ModulesDownloadProxyHost", (Object)sModulesDownloadProxyHost);
        req.setAttribute("ModulesDownloadProxyPort", (Object)sModulesDownloadProxyPort);
        req.setAttribute("ModulesDownloadProxyUserName", (Object)sModulesDownloadProxyUserName);
        req.setAttribute("ModulesDownloadProxyPassword", (Object)sModulesDownloadProxyPassword);
    }

    private void applyMiscSettings(SystemConfig config, HttpServletRequest req) throws ConfigException {
        config.setSetting("Provider.eMFrame.eGuide.location", req.getParameter("MisceGuideURL"));
        String sShouldModuleDownload = req.getParameter("ShouldModuleDownload");
        String sAllModuleToDownload = req.getParameter("AllModulesToDownload");
        if (null == sShouldModuleDownload) {
            sShouldModuleDownload = "false";
        }
        config.setSetting("ShouldModuleDownload", sShouldModuleDownload);
        if (null == sAllModuleToDownload && null == sShouldModuleDownload) {
            config.removeSetting("WhichModuleToDownload");
        } else if (null != sAllModuleToDownload && sAllModuleToDownload.equalsIgnoreCase("true")) {
            config.setSetting("WhichModuleToDownload", "All");
        } else {
            config.setSetting("WhichModuleToDownload", "Partial");
        }
        String sModulesDownloadEnableProxy = req.getParameter("ModulesDownloadEnableProxy");
        String sModulesDownloadProxyHost = req.getParameter("ModulesDownloadProxyHost");
        String sModulesDownloadProxyPort = req.getParameter("ModulesDownloadProxyPort");
        String sModulesDownloadProxyUserName = req.getParameter("ModulesDownloadProxyUserName");
        String sModulesDownloadProxyPassword = req.getParameter("ModulesDownloadProxyPassword");
        config.setSetting("ModulesDownloadEnableProxy", null == sModulesDownloadEnableProxy ? "false" : sModulesDownloadEnableProxy);
        if (null != sModulesDownloadProxyHost) {
            config.setSetting("ModulesDownloadProxyHost", sModulesDownloadProxyHost);
        }
        if (null != sModulesDownloadProxyPort) {
            config.setSetting("ModulesDownloadProxyPort", sModulesDownloadProxyPort);
        }
        if (null != sModulesDownloadProxyUserName) {
            config.setSetting("ModulesDownloadProxyUserName", sModulesDownloadProxyUserName);
        }
        if (null != sModulesDownloadProxyPassword) {
            config.setSetting("ModulesDownloadProxyPassword", sModulesDownloadProxyPassword);
        }
    }

    private void readRBSSettings(TaskContext context) throws ConfigException {
        Boolean bRBSEnableThis = new Boolean(false);
        Boolean bRBSEnableGroup = new Boolean(true);
        Boolean bRBSUnrestrictedAccess = new Boolean(false);
        Boolean bsRBShowRoleInCollec = new Boolean(true);
        String sRBSRoleDiscover = "Parent";
        String sRBSGroupDomain = "Root";
        String sRBSGroupSearchType = "DynamicGroupObjects&AuxClasses";
        HttpServletRequest req = context.getRequest();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        sRBSRoleDiscover = config.getSetting("Provider.eMFrame.Role.discoveryDomain", sRBSRoleDiscover);
        sRBSGroupDomain = config.getSetting("Provider.eMFrame.DynamicGroup.discoveryDomain", sRBSGroupDomain);
        sRBSGroupSearchType = config.getSetting("Provider.eMFrame.DynamicGroup.Searchtype", sRBSGroupSearchType);
        bRBSEnableThis = Boolean.valueOf(config.getSetting("Provider.eMFrame.This.enable", String.valueOf(bRBSEnableThis)));
        bRBSUnrestrictedAccess = Boolean.valueOf(config.getSetting("RBS.forceUnrestricted", String.valueOf(bRBSUnrestrictedAccess)));
        bRBSEnableGroup = Boolean.valueOf(config.getSetting("Provider.eMFrame.DynamicGroup.enable", String.valueOf(bRBSEnableGroup)));
        bsRBShowRoleInCollec = Boolean.valueOf(config.getSetting("Provider.eMFrame.ShowRolesInOwnedCollections.enable", String.valueOf(bsRBShowRoleInCollec)));
        String[] sRBSTreeList = config.getSettings("RBS.Installed.Trees.List");
        if (null == sRBSTreeList) {
            sRBSTreeList = new String[]{};
        }
        req.setAttribute("RBSEnableThis", (Object)String.valueOf(bRBSEnableThis));
        req.setAttribute("RBSUnrestrictedAccess", (Object)String.valueOf(bRBSUnrestrictedAccess));
        req.setAttribute("RBSEnableDynamicGroup", (Object)String.valueOf(bRBSEnableGroup));
        req.setAttribute("RBSShowRolesInCollection", (Object)String.valueOf(bsRBShowRoleInCollec));
        req.setAttribute("RBSRoleDiscovery", (Object)sRBSRoleDiscover);
        req.setAttribute("RBSGroupDiscovery", (Object)sRBSGroupDomain);
        req.setAttribute("RBSGroupSearchType", (Object)sRBSGroupSearchType);
        req.setAttribute("RBSTreeListParam", (Object)sRBSTreeList);
    }

    private void applyRBSSettings(SystemConfig config, HttpServletRequest req, TaskContext context) throws ConfigException {
        config.setSetting("Provider.eMFrame.Role.discoveryDomain", req.getParameter("RBSRoleDiscovery").toLowerCase());
        config.setSetting("Provider.eMFrame.DynamicGroup.discoveryDomain", req.getParameter("RBSGroupDiscovery").toLowerCase());
        config.setSetting("Provider.eMFrame.DynamicGroup.Searchtype", req.getParameter("RBSGroupSearchType"));
        String sTemp = req.getParameter("RBSEnableThis");
        config.setSetting("Provider.eMFrame.This.enable", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("RBSEnableDynamicGroup");
        config.setSetting("Provider.eMFrame.DynamicGroup.enable", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("RBSUnrestrictedAccess");
        config.setSetting("RBS.forceUnrestricted", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("RBSShowRolesInCollection");
        config.setSetting("Provider.eMFrame.ShowRolesInOwnedCollections.enable", null == sTemp ? "false" : sTemp);
        String[] sTree = eMFrameUtils.unpack(req.getParameter("RBSTreeListParam"), context);
        req.setAttribute("RBSTreeListParam", (Object)sTree);
        config.setSetting("RBS.Installed.Trees.List", sTree);
    }

    private void readLoggingSettings(HttpServletRequest req) {
        String sTemp = req.getParameter("loggingLevel");
        if (sTemp != null) {
            try {
                this.m_iLoggingLevel = Integer.parseInt(sTemp);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (this.m_iLoggingLevel > 0) {
            this.m_bLoggingToErr = req.getParameter("loggingToErr") != null;
            this.m_bLoggingToOut = req.getParameter("loggingToOut") != null;
            this.m_bLoggingToFile = req.getParameter("loggingToFile") != null;
        }
    }

    private void applyLoggingSettings(TaskContext context, Properties resultStrings) throws ConfigException {
        DebugLogging.stop();
        DebugLogging.setLoggingLevel(this.m_iLoggingLevel);
        DebugLogging.setLoggingToErr(this.m_bLoggingToErr);
        DebugLogging.setLoggingToOut(this.m_bLoggingToOut);
        DebugLogging.setLoggingToFile(this.m_bLoggingToFile);
        HttpServletRequest req = context.getRequest();
        req.setAttribute("loggingLevel", (Object)String.valueOf(this.m_iLoggingLevel));
        req.setAttribute("loggingToErr", (Object)String.valueOf(this.m_bLoggingToErr));
        req.setAttribute("loggingToOut", (Object)String.valueOf(this.m_bLoggingToOut));
        req.setAttribute("loggingToFile", (Object)String.valueOf(this.m_bLoggingToFile));
        req.setAttribute("loggingFile", (Object)DebugLogging.getLogFileName());
        req.setAttribute("loggingFileSize", (Object)String.valueOf(DebugLogging.getLogFileSize()));
        DebugLogging.start();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        DebugLogging.saveToConfig(config);
    }

    public void readLoggingInfoAndSet(HttpServletRequest req) {
        this.m_iLoggingLevel = DebugLogging.getLoggingLevel();
        this.m_bLoggingToErr = DebugLogging.getLoggingToErr();
        this.m_bLoggingToOut = DebugLogging.getLoggingToOut();
        this.m_bLoggingToFile = DebugLogging.getLoggingToFile();
        req.setAttribute("loggingLevel", (Object)String.valueOf(this.m_iLoggingLevel));
        req.setAttribute("loggingToErr", (Object)String.valueOf(this.m_bLoggingToErr));
        req.setAttribute("loggingToOut", (Object)String.valueOf(this.m_bLoggingToOut));
        req.setAttribute("loggingToFile", (Object)String.valueOf(this.m_bLoggingToFile));
        req.setAttribute("loggingFile", (Object)DebugLogging.getLogFileName());
        req.setAttribute("loggingFileSize", (Object)String.valueOf(DebugLogging.getLogFileSize()));
    }

    private void readAuthInfoAndSet(TaskContext context) {
        String[] sAuthSelectedTree;
        String sAuthDefProtocol = EMPTY_STRING;
        String sAuthDefTree = EMPTY_STRING;
        String sAuthEnableCxtlessLogin = "true";
        String sAuthPublicPassword = EMPTY_STRING;
        String sAuthPublicUser = EMPTY_STRING;
        String sAuthShowProtocol = "true";
        String sAuthShowTree = "true";
        String sAuthUseCookies = "false";
        String sHideLoginFailReason = "false";
        String sAuthSecondayLDAPUsingSSL = "false";
        String sPostLogoutURL = EMPTY_STRING;
        String sPostLogoutURLEnable = "false";
        String sNeverTimeoutEnable = "false";
        String sTimeoutInSeconds = "1800";
        String sNovellDownloadSiteOption = "true";
        String sBoxDownloadURL = NOVELL_DOWNLOAD_URL;
        HttpServletRequest req = context.getRequest();
        SystemConfig config = SystemConfig.getSystemConfig(context);
        sAuthDefProtocol = config.getSetting("Authenticate.Form.DefaultProtocol", "NDAP");
        sAuthDefTree = config.getSetting("Authenticate.Form.DefaultTree");
        if (null == sAuthDefTree || sAuthDefTree.length() == 0) {
            sAuthDefTree = DirAuthenticator.getDirAuth(context).getConnectionProfile(context.getRequest()).getUniqueHostId();
        } else {
            req.setAttribute("AuthDefTree", (Object)sAuthDefTree.toLowerCase());
        }
        sAuthEnableCxtlessLogin = config.getSetting("Authenticate.Form.EnableContextlessLogin", sAuthEnableCxtlessLogin);
        sAuthShowProtocol = config.getSetting("Authenticate.Form.ShowProtocol");
        sAuthShowTree = config.getSetting("Authenticate.Form.ShowTree");
        sAuthUseCookies = config.getSetting("Authenticate.Form.UseCookies");
        sHideLoginFailReason = config.getSetting("Authenticate.Form.HideLoginFailReason");
        sAuthSecondayLDAPUsingSSL = config.getSetting("Authenticate.LDAP.useSSL");
        sNovellDownloadSiteOption = config.getSetting("NovellDownloadSiteOption", sNovellDownloadSiteOption);
        sNeverTimeoutEnable = config.getSetting("NeverTimeoutEnable", sNeverTimeoutEnable);
        sTimeoutInSeconds = config.getSetting("TimeoutInSeconds", sTimeoutInSeconds);
        String[] sPostLogoutURLStrings = config.getSettings("PostLogoutURL");
        sBoxDownloadURL = config.getSetting("BoxModuleDownloadDescriptorURL", sBoxDownloadURL);
        if (sPostLogoutURLStrings != null) {
            sPostLogoutURLEnable = sPostLogoutURLStrings[0];
            if (sPostLogoutURLStrings.length == 2 && sPostLogoutURLStrings[1] != null) {
                sPostLogoutURL = sPostLogoutURLStrings[1];
            }
        }
        if (null == (sAuthSelectedTree = config.getSettings("Authenticate.Form.Trees.List"))) {
            sAuthSelectedTree = new String[]{sAuthDefTree};
        } else {
            String currentTreeName = DirAuthenticator.getDirAuth(context).getConnectionProfile(context.getRequest()).getUniqueHostId();
            boolean found = false;
            for (int i = 0; i < sAuthSelectedTree.length; ++i) {
                if (!currentTreeName.equalsIgnoreCase(sAuthSelectedTree[i])) continue;
                found = true;
            }
            if (!found) {
                String[] tempArray = new String[sAuthSelectedTree.length + 1];
                for (int i = 0; i < sAuthSelectedTree.length; ++i) {
                    tempArray[i] = sAuthSelectedTree[i];
                }
                tempArray[tempArray.length - 1] = currentTreeName;
                sAuthSelectedTree = tempArray;
            }
        }
        String authSelectedTree = DirAuthenticator.getDirAuth(context).getConnectionProfile(context.getRequest()).getUniqueHostId();
        sAuthPublicPassword = config.getSetting("Authenticate.Form.PublicPassword." + sAuthDefProtocol + "." + authSelectedTree.toLowerCase());
        sAuthPublicUser = config.getSetting("Authenticate.Form.PublicUser." + sAuthDefProtocol + "." + authSelectedTree.toLowerCase());
        String[] sAuthSearchContainers = config.getSettings("Authenticate.Form.SearchContainers." + sAuthDefProtocol + "." + authSelectedTree.toLowerCase());
        req.setAttribute("SelectedAuthTreeList", (Object)sAuthSelectedTree[0].toLowerCase());
        String searchContainerOption = "root";
        if (sAuthSearchContainers != null && sAuthSearchContainers.length > 0) {
            searchContainerOption = "containers";
        }
        if (sAuthDefProtocol.equalsIgnoreCase("NDAP")) {
            sAuthDefProtocol = eMFrameUtils.getLocalizedString("FwResources", "SysConfig.AutheDirectory", context);
        } else if (sAuthDefProtocol.equalsIgnoreCase("LDAP")) {
            sAuthDefProtocol = eMFrameUtils.getLocalizedString("FwResources", "SysConfig.AuthLDAP", context);
        }
        if (sAuthDefProtocol.equalsIgnoreCase("LDAPS")) {
            sAuthDefProtocol = eMFrameUtils.getLocalizedString("FwResources", "SysConfig.AuthLDAPUsingSSL", context);
        }
        req.setAttribute("AuthDefProtocol", (Object)sAuthDefProtocol);
        req.setAttribute("AuthEnableCxtlessLogin", (Object)sAuthEnableCxtlessLogin);
        req.setAttribute("AuthPublicPassword", (Object)sAuthPublicPassword);
        req.setAttribute("AuthPublicUser", (Object)sAuthPublicUser);
        req.setAttribute("AuthSearchContainers", (Object)sAuthSearchContainers);
        req.setAttribute("AuthShowProtocol", (Object)sAuthShowProtocol);
        req.setAttribute("AuthShowTree", (Object)sAuthShowTree);
        req.setAttribute("AuthUseCookies", (Object)sAuthUseCookies);
        req.setAttribute("AuthHideLoginFailReason", (Object)sHideLoginFailReason);
        req.setAttribute("AuthSecondayLDAPUsingSSL", (Object)sAuthSecondayLDAPUsingSSL);
        req.setAttribute("AuthTreeListParam", (Object)sAuthSelectedTree);
        req.setAttribute("AuthSelectedTree", (Object)authSelectedTree);
        req.setAttribute("SearchContainerOption", (Object)searchContainerOption);
        req.setAttribute("PostLogoutURL", (Object)sPostLogoutURL);
        req.setAttribute("PostLogoutURLEnable", (Object)sPostLogoutURLEnable);
        req.setAttribute("DownloadURL", (Object)sBoxDownloadURL);
        req.setAttribute("NovellSite", (Object)sNovellDownloadSiteOption);
        req.setAttribute("NeverTimeoutEnable", (Object)sNeverTimeoutEnable);
        req.setAttribute("TimeoutInSeconds", (Object)sTimeoutInSeconds);
        req.setAttribute("iManagerPlatform", (Object)FwUtils.getiManagerPlatform());
    }

    private void applyAuthSettings(TaskContext context) throws ConfigException {
        SystemConfig config = SystemConfig.getSystemConfig(context);
        HttpServletRequest req = context.getRequest();
        String sProtocol = req.getParameter("AuthDefProtocol");
        if (sProtocol.equalsIgnoreCase(eMFrameUtils.getLocalizedString("FwResources", "SysConfig.AutheDirectory", context)) || null == sProtocol) {
            sProtocol = "NDAP";
        } else if (sProtocol.equalsIgnoreCase(eMFrameUtils.getLocalizedString("FwResources", "SysConfig.AuthLDAP", context))) {
            sProtocol = "LDAP";
        } else if (sProtocol.equalsIgnoreCase(eMFrameUtils.getLocalizedString("FwResources", "SysConfig.AuthLDAPUsingSSL", context))) {
            sProtocol = "LDAPS";
        }
        String sTree = req.getParameter("AuthDefTree");
        config.setSetting("Authenticate.Form.DefaultTree", sTree.toLowerCase());
        String sTemp = req.getParameter("AuthEnableCxtlessLogin");
        config.setSetting("Authenticate.Form.EnableContextlessLogin", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("AuthShowProtocol");
        config.setSetting("Authenticate.Form.ShowProtocol", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("AuthShowTree");
        config.setSetting("Authenticate.Form.ShowTree", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("AuthSecondayLDAPUsingSSL");
        config.setSetting("Authenticate.LDAP.useSSL", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("AuthUseCookies");
        config.setSetting("Authenticate.Form.UseCookies", null == sTemp ? "false" : sTemp);
        sTemp = req.getParameter("AuthHideLoginFailReason");
        config.setSetting("Authenticate.Form.HideLoginFailReason", null == sTemp ? "false" : sTemp);
        config.setSetting("Authenticate.Form.DefaultProtocol", sProtocol);
        sTemp = req.getParameter("DownloadURL");
        if (sTemp != null) {
            config.setSetting("BoxModuleDownloadDescriptorURL", sTemp);
        }
        if ((sTemp = req.getParameter("DownloadModulesOption")) != null) {
            if (sTemp.equals("novell-site")) {
                config.setSetting("NovellDownloadSiteOption", "true");
                config.setSetting("ModuleDownloadDescriptorURL", NOVELL_DOWNLOAD_URL);
            } else {
                config.setSetting("NovellDownloadSiteOption", "false");
                sTemp = req.getParameter("DownloadURL");
                if (sTemp != null) {
                    config.setSetting("ModuleDownloadDescriptorURL", sTemp);
                }
            }
        }
        config.setSetting("NeverTimeoutEnable", null != (sTemp = req.getParameter("NeverTimeout")) ? "true" : "false");
        sTemp = req.getParameter("ServerTimeoutSettings");
        config.setSetting("TimeoutInSeconds", sTemp);
        sTemp = req.getParameter("PostLogoutURLEnable");
        String[] sPostLogoutURLStrings = new String[]{sTemp != null ? new String("true") : new String("false"), new String(req.getParameter("PostLogoutURLFinal"))};
        if (sPostLogoutURLStrings[1] == null) {
            sPostLogoutURLStrings[1] = EMPTY_STRING;
        } else {
            sTemp = sPostLogoutURLStrings[1];
            if (sTemp.length() > 0 && sTemp.indexOf("://") < 0) {
                sTemp = "http://" + sTemp;
            }
            sPostLogoutURLStrings[1] = sTemp;
        }
        config.setSetting("PostLogoutURL", sPostLogoutURLStrings);
        String sAuthTree = req.getParameter("AuthSelectedTreeName");
        req.setAttribute("AuthTreeListParam", (Object)sAuthTree);
        config.setSetting("Authenticate.Form.Trees.List", sAuthTree);
        String sSelectedAuthTreeList = sAuthTree;
        if (sSelectedAuthTreeList != null && sSelectedAuthTreeList.length() > 0) {
            sProtocol = this.m_authenticatedProtocol.equals("eDirectory") ? "NDAP" : this.m_authenticatedProtocol;
            config.setSetting("Authenticate.Form.PublicPassword." + sProtocol + "." + sSelectedAuthTreeList.toLowerCase(), req.getParameter("AuthPublicPassword"));
            config.setSetting("Authenticate.Form.PublicUser." + sProtocol + "." + sSelectedAuthTreeList.toLowerCase(), req.getParameter("AuthPublicUser"));
            String[] sContainers = eMFrameUtils.unpack(req.getParameter("AuthSearchContainers_mvedData"), context);
            config.setSetting("Authenticate.Form.SearchContainers." + sProtocol + "." + sSelectedAuthTreeList.toLowerCase(), sContainers);
        }
    }

    private String getCert(String x) {
        if (x.equals("LOW") || x.equals("MEDIUM") || x.equals(_HIGH)) {
            return "RSA";
        }
        if (x.equals("SUITEB128") || x.equals("SUITEB192")) {
            return "ECDSA384";
        }
        if (x.equals("SUITEB128ONLY")) {
            return "ECDSA256";
        }
        return "NONE";
    }

    public static void runCommand(String cmd, String errorMessage) {
        try {
            Process p = Runtime.getRuntime().exec(cmd);
            String s = EMPTY_STRING;
            BufferedReader stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
            BufferedReader stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
            while ((s = stdError.readLine()) != null) {
                D.log(s);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun(req, sServiceName);
        if (!FwUtils.canConfigureiManager(req)) {
            TaskContext context = eMFrameFactory.getTaskContext(req);
            throw new Exception(eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", context));
        }
    }
}

