/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.common.exceptions.UniqueSPIException;
import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.ClassDefinition;
import com.novell.admin.ns.MOOManager;
import com.novell.admin.ns.MOOManagerCallBack;
import com.novell.admin.ns.MOOManagerImpl;
import com.novell.admin.ns.NSObject;
import com.novell.admin.ns.ObjectAttribute;
import com.novell.admin.ns.ObjectOperation;
import com.novell.admin.ns.SchemaUtil;
import com.novell.admin.ns.StringValue;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSObjectRights;
import com.novell.admin.ns.nds.NDSPropertyRights;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.SnapinVetoException;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DataHandler;
import com.novell.emframe.dev.DirUtils;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.TargetObjects;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eDirAccessServiceException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.BackLinkUtils;
import com.novell.emframe.fw.CallBack;
import com.novell.emframe.fw.FakeRightsCache;
import com.novell.emframe.fw.FormElement;
import com.novell.emframe.fw.RightsCache;
import com.novell.emframe.fw.util.Loader;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.JDOMException;

public class Target {
    private boolean m_isMOO = false;
    private Object m_theObject = null;
    private TargetObjects m_targetObjects = null;
    protected ObjectEntry m_oe = null;
    RightsCache m_rightsCache = null;
    int m_progressCount = 0;
    ArrayList m_progressErrors = new ArrayList();
    boolean m_abortUpdate = false;
    boolean m_progressComplete = false;
    public static final String[] s_syncableAttributes = new String[]{"Member", "Group Membership", "groupMember", "directReports", "manager"};

    public TargetObjects getTargetObjects() {
        return this.m_targetObjects;
    }

    public ObjectEntry getOE() {
        return this.m_oe;
    }

    int getProgressCount() {
        return this.m_progressCount;
    }

    ArrayList getProgressErrors() {
        return this.m_progressErrors;
    }

    void abortUpdate() {
        this.m_abortUpdate = true;
    }

    public boolean isProgressComplete() {
        return this.m_progressComplete;
    }

    protected Target(NSObject nsObj) {
        this.m_oe = nsObj.getObjectEntry();
        this.m_theObject = nsObj;
    }

    protected Target(TargetObjects objects, ArrayList typeFilter, String[] delayedAttributes, TaskContext context) throws eDirAccessServiceException {
        this.m_targetObjects = objects;
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        AdminNamespace ns = treeOE.getAdminNamespace();
        if (objects.isMultiple()) {
            this.m_isMOO = true;
            this.m_theObject = new MOOManagerImpl(treeOE, this.m_targetObjects.getObjectEntryEnumeration());
            this.m_rightsCache = new FakeRightsCache();
        } else {
            block17: {
                try {
                    this.m_isMOO = false;
                    this.m_oe = this.m_targetObjects.getObjectEntry();
                    ObjectAttribute oa = ns.getAttribute(this.m_oe, "Object Class");
                    if (this.isDynamic(oa)) {
                        if (delayedAttributes == null || delayedAttributes.length == 0) {
                            this.m_theObject = ns.getDelayedAttibuteDetails(this.m_oe, new String[]{"Member"});
                        } else {
                            boolean found = false;
                            int i = 0;
                            if (i < delayedAttributes.length) {
                                if (delayedAttributes[i].equals("Member")) {
                                    // empty if block
                                }
                                found = true;
                                this.m_theObject = ns.getDelayedAttibuteDetails(this.m_oe, delayedAttributes);
                            }
                            if (!found) {
                                String[] delAttrs = new String[delayedAttributes.length + 1];
                                for (int i2 = 0; i2 < delayedAttributes.length; ++i2) {
                                    delAttrs[i2] = delayedAttributes[i2];
                                }
                                delAttrs[delayedAttributes.length] = "Member";
                                this.m_theObject = ns.getDelayedAttibuteDetails(this.m_oe, delAttrs);
                            }
                        }
                    } else {
                        this.m_theObject = delayedAttributes == null || delayedAttributes.length == 0 ? ns.getDetails(this.m_oe) : ns.getDelayedAttibuteDetails(this.m_oe, delayedAttributes);
                    }
                    this.validateType((NSObject)this.m_theObject, typeFilter, context);
                }
                catch (SPIException e) {
                    D.log(e);
                    if (e instanceof UniqueSPIException && ((UniqueSPIException)e).getErrorCode() == -6089) {
                        String title = eMFrameUtils.getLocalizedString("BaseResources", "Modify.eDirEncryptedAttrTitle", context);
                        String formatdetails = eMFrameUtils.getLocalizedString("BaseResources", "Modify.eDirEncryptedAttrError", context);
                        String body = eMFrameUtils.formatMessage(formatdetails, new String[]{((UniqueSPIException)e).getMessage()});
                        throw new eDirAccessServiceException(title, body);
                    }
                    if (this.m_theObject != null) break block17;
                    throw new eDirAccessServiceException((Exception)((Object)e));
                }
            }
            NSObject nsobj = (NSObject)this.m_theObject;
            try {
                ObjectEntry userOE = ns.getAuthenticatedIdentity(treeOE);
                ObjectEntry targetOE = nsobj.getObjectEntry();
                this.m_rightsCache = new RightsCache(targetOE, userOE, context);
            }
            catch (SPIException e) {
                D.log(e);
                throw new eDirAccessServiceException((Exception)((Object)e));
            }
        }
    }

    boolean isDynamic(ObjectAttribute oa) {
        if (oa != null) {
            Enumeration objclasses = oa.getValueComponents();
            while (objclasses.hasMoreElements()) {
                String cls = ((StringValue)objclasses.nextElement()).getValue();
                if (!cls.equals("dynamicGroup") && !cls.equals("dynamicGroupAux")) continue;
                return true;
            }
        }
        return false;
    }

    void validateType(NSObject nsobj, ArrayList typeFilter, TaskContext context) throws eDirAccessServiceException {
        if (typeFilter == null || typeFilter.size() == 0) {
            return;
        }
        ClassDefinition[] classes = nsobj.getClassDefinitions();
        for (int i = 0; i < classes.length; ++i) {
            if (!typeFilter.contains(classes[i].getName())) continue;
            if (context.getDirUtils().isAuxClass(classes[i].getName())) {
                context.addToHistory(classes[i].getName(), nsobj.getObjectEntry().getNamespace().getUnrootedName(nsobj.getObjectEntry()));
            }
            return;
        }
        String header = eMFrameUtils.getLocalizedString("FwResources", "Book.invalidObject", context);
        String body = eMFrameUtils.getLocalizedString("FwResources", "Book.invalidObjectType", context);
        throw new eDirAccessServiceException(header, body);
    }

    public void read(String targetName, String[] attributes, Properties customHandlers, boolean bigXmlOnly, TaskContext context) throws eDirAccessServiceException {
        HttpServletRequest req = context.getRequest();
        DirUtils dirUtils = context.getDirUtils();
        for (int i = 0; i < attributes.length; ++i) {
            String temp = dirUtils.getSafeName(attributes[i]) + "DisplayName";
            req.setAttribute(temp, (Object)dirUtils.getAttributeDisplayName(attributes[i], context));
        }
        context.getRequest().setAttribute("targetObjects", (Object)this.m_targetObjects);
        StringBuffer bigXml = new StringBuffer(200);
        bigXml.append("<edas>");
        String prefix = "eDir$" + targetName + "$";
        for (int cntr = 0; cntr < attributes.length; ++cntr) {
            String safeAttributeName = dirUtils.getSafeName(attributes[cntr]);
            String resultValue = null;
            String customHandler = customHandlers.getProperty(safeAttributeName);
            if (customHandler != null) {
                DataHandler handler = Loader.getHandlerById(customHandler, true);
                resultValue = handler.getString(this.m_theObject, attributes[cntr], context);
            } else {
                resultValue = DirUtils.readAttributeXML(context, this.m_theObject, attributes[cntr]);
            }
            if (resultValue != null) {
                bigXml.append(resultValue);
                if (bigXmlOnly) continue;
                String resultKey = prefix + safeAttributeName;
                req.setAttribute(resultKey, (Object)resultValue);
                continue;
            }
            D.log("Null returned from handler for attribute!");
        }
        bigXml.append("</edas>");
        String bigXmlString = bigXml.toString();
        D.log("xml = " + bigXmlString);
        long start = System.currentTimeMillis();
        this.m_rightsCache.readRights(attributes);
        long end = System.currentTimeMillis();
        D.log("Read rights in " + (end - start) + " ms.");
        if (targetName.equals("target")) {
            req.setAttribute("edas", (Object)bigXmlString);
        }
    }

    public final Enumeration getValueComponents(String attributeName) {
        if (this.isMOO()) {
            MOOManager mooMananger = (MOOManager)this.m_theObject;
            ObjectOperation op = mooMananger.getObjectOperation(attributeName);
            return op.getValueComponents();
        }
        NSObject nsObject = (NSObject)this.m_theObject;
        return nsObject.getAttribute(attributeName).getValueComponents();
    }

    public void update(TaskContext context) throws eDirAccessServiceException {
        if (this.m_isMOO) {
            MOOManager mooManager = (MOOManager)this.m_theObject;
            CallBack cb = new CallBack(1, this);
            mooManager.updateObjects((MOOManagerCallBack)cb);
            Target.mooSyncBacklinks(this.m_targetObjects, mooManager, context);
        } else {
            try {
                NSObject nsobj = (NSObject)this.m_theObject;
                AuthenticationBroker broker = context.getAuthenticationBroker();
                ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
                AdminNamespace ns = treeOE.getAdminNamespace();
                String[] targetattrs = null;
                for (int i = 0; i < s_syncableAttributes.length; ++i) {
                    int s;
                    ObjectAttribute oa = nsobj.getAttribute(s_syncableAttributes[i]);
                    if (oa == null) continue;
                    if (oa.getAddedComponents().length > 0 && (targetattrs = this.getBacklinkAttributes(nsobj.getObjectEntry(), s_syncableAttributes[i])) != null) {
                        ValueComponent[] added = oa.getAddedComponents();
                        for (s = 0; s < added.length; ++s) {
                            if (this.hasRightsToModify(ns, broker.getAuthNdapName(), targetattrs, added[s].toString(), nsobj.getObjectEntry())) continue;
                            String header = eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", context);
                            String body = eMFrameUtils.getLocalizedString("FwResources", "Client.No.Rights", context);
                            throw new eDirAccessServiceException(header, body);
                        }
                    }
                    if (oa.getDeletedComponents().length > 0 && (targetattrs = this.getBacklinkAttributes(nsobj.getObjectEntry(), s_syncableAttributes[i])) != null) {
                        ValueComponent[] deleted = oa.getDeletedComponents();
                        for (s = 0; s < deleted.length; ++s) {
                            if (this.hasRightsToModify(ns, broker.getAuthNdapName(), targetattrs, deleted[s].toString(), nsobj.getObjectEntry())) continue;
                            String header = eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", context);
                            String body = eMFrameUtils.getLocalizedString("FwResources", "Client.No.Rights", context);
                            throw new eDirAccessServiceException(header, body);
                        }
                    }
                    if (oa.getModifiedComponents().length <= 0) continue;
                    ObjectAttribute.ModifyValue[] modifyVal = oa.getModifiedComponents();
                    s = 0;
                    while (i < modifyVal.length) {
                        if (!this.hasRightsToModify(ns, broker.getAuthNdapName(), targetattrs, modifyVal[s].getNewValue().toString(), nsobj.getObjectEntry())) {
                            String header = eMFrameUtils.getLocalizedString("FwResources", "Insufficient.Rights", context);
                            String body = eMFrameUtils.getLocalizedString("FwResources", "Client.No.Rights", context);
                            throw new eDirAccessServiceException(header, body);
                        }
                        ++s;
                    }
                }
                Target.singleSyncBackLinks(nsobj);
                this.m_theObject = ns.getDetails(nsobj.getObjectEntry());
            }
            catch (SPIException e) {
                D.log(e);
                throw new eDirAccessServiceException((Exception)((Object)e));
            }
            catch (AuthBrokerException e) {
                D.log(e);
                throw new eDirAccessServiceException(e);
            }
            catch (PluginException e) {
                D.log(e);
                throw new eDirAccessServiceException(e);
            }
        }
    }

    private String[] getBacklinkAttributes(ObjectEntry thisOE, String attributeName) {
        String[] targetAttributes = null;
        if (attributeName.equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Member"))) {
            targetAttributes = new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Group Membership"), SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Security Equals")};
        } else if (attributeName.equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"groupMember"))) {
            targetAttributes = new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Group Membership")};
        } else if (attributeName.equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Group Membership"))) {
            if (!thisOE.getObjectType().getName().equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Template"))) {
                targetAttributes = thisOE.getTypeName().equals("Group") ? new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"groupMember")} : new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Member"), SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Equivalent To Me")};
            }
        } else if (attributeName.equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"manager"))) {
            targetAttributes = new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"directReports")};
        } else if (attributeName.equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"directReports"))) {
            targetAttributes = new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"manager")};
        } else {
            D.assrt(false, "EDAS: syncWithOthers called on invalid attribute.");
        }
        return targetAttributes;
    }

    private boolean hasRightsToModify(AdminNamespace ns, String authNdapName, String[] attrs, String objName, ObjectEntry nsObjectEntry) throws SPIException {
        int i;
        ObjectEntry objOE = ns.getObjectEntry(objName);
        ObjectEntry trusteeOE = ns.getObjectEntry(authNdapName);
        NDSObjectRights right = (NDSObjectRights)ns.getObjectEffectiveRights(objOE, trusteeOE);
        NDSPropertyRights[] rights = (NDSPropertyRights[])ns.getPropertyEffectiveRights(objOE, trusteeOE, attrs);
        for (i = 0; i < rights.length && (rights[i].getAttributeName().equals("Group Membership") || rights[i].getAttributeName().equals("Security Equals") || rights[i].canModify()); ++i) {
        }
        return i >= rights.length;
    }

    public static void singleSyncBackLinks(NSObject nsobj) throws PluginException {
        int i;
        AdminNamespace ns = nsobj.getObjectEntry().getAdminNamespace();
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < s_syncableAttributes.length; ++i2) {
            ObjectAttribute attr = nsobj.getAttribute(s_syncableAttributes[i2]);
            if (attr == null || attr.getAddedComponents().length <= 0 && attr.getDeletedComponents().length <= 0 && attr.getModifiedComponents().length <= 0) continue;
            list.add(s_syncableAttributes[i2]);
        }
        String[] attributesNamesToSync = list.toArray(new String[list.size()]);
        ArrayList[] addLists = new ArrayList[attributesNamesToSync.length];
        ArrayList[] deletedLists = new ArrayList[attributesNamesToSync.length];
        for (i = 0; i < attributesNamesToSync.length; ++i) {
            addLists[i] = new ArrayList();
            deletedLists[i] = new ArrayList();
            Target.populateSyncLists(nsobj, attributesNamesToSync[i], addLists[i], deletedLists[i]);
        }
        try {
            ns.update(nsobj);
        }
        catch (SPIException e) {
            throw new PluginException((Exception)((Object)e));
        }
        catch (SnapinVetoException e) {
            throw new PluginException((Exception)((Object)e));
        }
        if (ns.getUniqueID().equals("NDS")) {
            for (i = 0; i < attributesNamesToSync.length; ++i) {
                Target.syncWithOthers(nsobj.getObjectEntry(), attributesNamesToSync[i], addLists[i], deletedLists[i]);
            }
        }
    }

    public static void syncBackLinks(NSObject nsobj) throws PluginException {
        int i;
        AdminNamespace ns = nsobj.getObjectEntry().getAdminNamespace();
        ArrayList<String> list = new ArrayList<String>();
        for (int i2 = 0; i2 < s_syncableAttributes.length; ++i2) {
            ObjectAttribute attr = nsobj.getAttribute(s_syncableAttributes[i2]);
            if (attr == null || attr.getAddedComponents().length <= 0 && attr.getDeletedComponents().length <= 0 && attr.getModifiedComponents().length <= 0) continue;
            list.add(s_syncableAttributes[i2]);
        }
        String[] attributesNamesToSync = list.toArray(new String[list.size()]);
        ArrayList[] addLists = new ArrayList[attributesNamesToSync.length];
        ArrayList[] deletedLists = new ArrayList[attributesNamesToSync.length];
        for (i = 0; i < attributesNamesToSync.length; ++i) {
            addLists[i] = new ArrayList();
            deletedLists[i] = new ArrayList();
            Target.populateSyncLists(nsobj, attributesNamesToSync[i], addLists[i], deletedLists[i]);
        }
        if (ns.getUniqueID().equals("NDS")) {
            for (i = 0; i < attributesNamesToSync.length; ++i) {
                Target.syncWithOthers(nsobj.getObjectEntry(), attributesNamesToSync[i], addLists[i], deletedLists[i]);
            }
        }
    }

    private static void mooSyncBacklinks(TargetObjects targetObjects, MOOManager mooManager, TaskContext context) {
        try {
            ArrayList<String> list = new ArrayList<String>();
            ArrayList<ArrayList> addLists = new ArrayList<ArrayList>();
            ArrayList deletedLists = new ArrayList();
            for (int i = 0; i < s_syncableAttributes.length; ++i) {
                ObjectOperation objectOperation = mooManager.getObjectOperation(s_syncableAttributes[i]);
                if (objectOperation == null) continue;
                if (objectOperation.getMode() == 1) {
                    list.add(s_syncableAttributes[i]);
                    addLists.add(Target.getValues(objectOperation));
                    deletedLists.add(new ArrayList());
                    continue;
                }
                if (objectOperation.getMode() == 2) {
                    list.add(s_syncableAttributes[i]);
                    deletedLists.add(Target.getValues(objectOperation));
                    addLists.add(new ArrayList());
                    continue;
                }
                if (objectOperation.getMode() != 3) continue;
                list.add(s_syncableAttributes[i]);
                ValueComponent[] vcs = objectOperation.getObjectAttribute().getDeletedComponents();
                ArrayList<String> delArrList = new ArrayList<String>();
                for (int j = 0; j < vcs.length; ++j) {
                    delArrList.add(vcs[j].toString());
                }
                deletedLists.add(delArrList);
                addLists.add(Target.getValues(objectOperation));
            }
            String[] attributesNamesToSync = list.toArray(new String[list.size()]);
            ArrayList[] adds = addLists.toArray(new ArrayList[addLists.size()]);
            ArrayList[] deletes = deletedLists.toArray(new ArrayList[deletedLists.size()]);
            targetObjects.reset(context);
            ObjectEntryEnumeration myenum = targetObjects.getObjectEntryEnumeration();
            for (int i = 0; i < attributesNamesToSync.length; ++i) {
                while (myenum.hasMoreElements()) {
                    ObjectEntry oe = (ObjectEntry)myenum.nextElement();
                    Target.syncWithOthers(oe, attributesNamesToSync[i], adds[i], deletes[i]);
                }
            }
        }
        catch (Throwable e) {
            D.log(e);
        }
    }

    private static ArrayList getValues(ObjectOperation objectOperation) {
        ArrayList<String> list = new ArrayList<String>();
        Enumeration myenum = objectOperation.getValueComponents();
        while (myenum.hasMoreElements()) {
            ValueComponent vc = (ValueComponent)myenum.nextElement();
            list.add(vc.toString());
        }
        return list;
    }

    private static void populateSyncLists(NSObject nsobj, String attributeName, ArrayList addedItems, ArrayList deletedItems) {
        ObjectAttribute attribute = nsobj.getAttribute(attributeName);
        if (attribute == null) {
            addedItems = new ArrayList();
            deletedItems = new ArrayList();
            return;
        }
        ValueComponent[] addedComponents = attribute.getAddedComponents();
        ValueComponent[] deletedComponents = attribute.getDeletedComponents();
        if (!(addedComponents != null && addedComponents.length != 0 || deletedComponents != null && deletedComponents.length != 0)) {
            return;
        }
        ValueComponent[] vcArray = attribute.getBeginingComponents();
        ArrayList<String> origValues = new ArrayList<String>(vcArray.length);
        for (int i = 0; i < vcArray.length; ++i) {
            origValues.add(vcArray[i].toString());
        }
        ArrayList<String> curValues = new ArrayList<String>();
        if (attribute != null) {
            Enumeration myenum = attribute.getValueComponents();
            while (myenum.hasMoreElements()) {
                curValues.add(myenum.nextElement().toString());
            }
        }
        addedItems.addAll(curValues);
        addedItems.removeAll(origValues);
        deletedItems.addAll(origValues);
        deletedItems.removeAll(curValues);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static void syncWithOthers(ObjectEntry thisOE, String attributeName, ArrayList addedItems, ArrayList deletedItems) throws PluginException {
        String[] targetAttributes;
        AdminNamespace ns = thisOE.getObjectType().getAdminNamespace();
        if (attributeName.equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Member"))) {
            targetAttributes = new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Group Membership"), SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Security Equals")};
        } else if (attributeName.equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"groupMember"))) {
            targetAttributes = new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Group Membership")};
        } else if (attributeName.equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Group Membership"))) {
            if (thisOE.getObjectType().getName().equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Template"))) return;
            targetAttributes = thisOE.getTypeName().equals("Group") ? new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"groupMember")} : new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Member"), SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Equivalent To Me")};
        } else if (attributeName.equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Security Equals"))) {
            targetAttributes = new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Equivalent To Me")};
        } else if (attributeName.equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Equivalent To Me"))) {
            targetAttributes = new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"Security Equals")};
        } else if (attributeName.equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"manager"))) {
            targetAttributes = new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"directReports")};
        } else if (attributeName.equals(SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"directReports"))) {
            targetAttributes = new String[]{SchemaUtil.translateNDAPAttr((ObjectEntry)thisOE, (String)"manager")};
        } else {
            D.assrt(false, "EDAS: syncWithOthers called on invalid attribute.");
            throw new eDirAccessServiceException("Error", "Invalid attribute for sync");
        }
        try {
            ObjectEntry treeObjectEntry = thisOE.getRoot();
            String objectName = ns.getUnrootedName(thisOE);
            String[] values = new String[]{objectName};
            BackLinkUtils.updateBacklinks(addedItems, targetAttributes, values, 1, treeObjectEntry);
            BackLinkUtils.updateBacklinks(deletedItems, targetAttributes, values, 2, treeObjectEntry);
            return;
        }
        catch (Exception e) {
            throw new eDirAccessServiceException(e);
        }
    }

    public void create(TaskContext context) throws eDirAccessServiceException {
        try {
            AuthenticationBroker broker = context.getAuthenticationBroker();
            ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
            AdminNamespace ns = treeOE.getAdminNamespace();
            ns.create((NSObject)this.m_theObject);
        }
        catch (SnapinVetoException e) {
            throw new eDirAccessServiceException("Error", "SnapinVeto Exception during update");
        }
        catch (SPIException e) {
            D.log(e);
            throw new eDirAccessServiceException((Exception)((Object)e));
        }
        catch (AuthBrokerException e) {
            D.log(e);
            throw new eDirAccessServiceException(e);
        }
    }

    public void resetMOOManager(TaskContext context) throws SPIException, JDOMException {
        ObjectEntry treeOE = null;
        try {
            treeOE = (ObjectEntry)context.getAuthenticationBroker().getProtocolObject("AdminNamespace");
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        this.m_targetObjects.reset(context);
        this.m_theObject = new MOOManagerImpl(treeOE, this.m_targetObjects.getObjectEntryEnumeration());
        this.m_progressComplete = false;
        this.m_progressCount = 0;
        this.m_abortUpdate = false;
        this.m_progressErrors = new ArrayList();
    }

    public int getCount() {
        return this.m_targetObjects.getCount();
    }

    public int getCountReliablity() {
        return this.m_targetObjects.getCountReliability();
    }

    public String getCountReliablityMessage() {
        return this.m_targetObjects.getCountReliablityMessage();
    }

    public Object getObject() {
        return this.m_theObject;
    }

    public boolean isMOO() {
        return this.m_isMOO;
    }

    void write(FormElement theElement, Properties customHandlers, TaskContext context) throws eDirAccessServiceException {
        String attributeName = theElement.getRealName();
        context.getRequest().setAttribute("targetObjects", (Object)this.m_targetObjects);
        String safeAttributeName = context.getDirUtils().getSafeName(attributeName);
        String customHandler = customHandlers.getProperty(safeAttributeName);
        if (customHandler != null) {
            DataHandler handler = Loader.getHandlerById(customHandler, true);
            handler.setString(this.m_theObject, attributeName, theElement.getValue(), context);
        } else {
            DirUtils.writeAttributeXML(context, this.m_theObject, attributeName, theElement.getValue());
        }
    }
}

