/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ClassDefinition;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.authenticator.DirAuthenticator;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;

public class TargetChooserUtils {
    public static List getTCQuickFindAttributes(String objectTypeName, MContext context) {
        Hashtable quickFindInfo = TargetChooserUtils.getTCQuickFindHashtable(context);
        List attrs = (List)quickFindInfo.get(objectTypeName);
        if (attrs == null) {
            TargetChooserUtils.initTCFavoritesList(objectTypeName, context);
            quickFindInfo = TargetChooserUtils.getTCQuickFindHashtable(context);
            ArrayList list = (ArrayList)quickFindInfo.get(objectTypeName);
            if (list == null) {
                list = new ArrayList();
            }
            return list;
        }
        return attrs;
    }

    private static Hashtable getTCQuickFindHashtable(MContext context) {
        Hashtable quickFindInfo = (Hashtable)context.getAuthAttribute("fw.tcQuickFindData");
        try {
            if (quickFindInfo == null) {
                String data = context.getPersistentData("fwPrefs", "fw.tcQuickFindData");
                quickFindInfo = data == null ? new Hashtable() : TargetChooserUtils.unpackHashtable(data, context);
                context.setAuthAttribute("fw.tcQuickFindData", quickFindInfo);
            }
        }
        catch (Throwable e) {
            D.log(e);
            quickFindInfo = new Hashtable();
            context.setAuthAttribute("fw.tcQuickFindData", quickFindInfo);
        }
        return quickFindInfo;
    }

    public static void addTCQuickFindAttribute(String objectTypeName, String attributeName, MContext context) {
        Hashtable quickFindInfo = TargetChooserUtils.getTCQuickFindHashtable(context);
        ArrayList<String> list = (ArrayList<String>)quickFindInfo.get(objectTypeName);
        if (list != null) {
            Iterator iter = list.iterator();
            while (iter.hasNext()) {
                if (!iter.next().equals(attributeName)) continue;
                return;
            }
        } else {
            list = new ArrayList<String>();
            quickFindInfo.put(objectTypeName, list);
        }
        list.add(attributeName);
        String data = TargetChooserUtils.packUpHashtable(quickFindInfo, context);
        context.setPersistentData("fwPrefs", "fw.tcQuickFindData", data);
    }

    private static String packUpHashtable(Hashtable hashtable, MContext context) {
        ArrayList<String> allEntries = new ArrayList<String>();
        Enumeration myenum = hashtable.keys();
        while (myenum.hasMoreElements()) {
            String key = (String)myenum.nextElement();
            List value = (List)hashtable.get(key);
            String[] valueArray = value.toArray(new String[value.size()]);
            String valuePack = eMFrameUtils.pack(valueArray, context);
            String[] entryArray = new String[]{key, valuePack};
            String entryPack = eMFrameUtils.pack(entryArray, context);
            allEntries.add(entryPack);
        }
        String[] allEntryArray = allEntries.toArray(new String[allEntries.size()]);
        return eMFrameUtils.pack(allEntryArray, context);
    }

    private static Hashtable unpackHashtable(String pack, MContext context) {
        String[] entries = eMFrameUtils.unpack(pack, context);
        Hashtable hashtable = new Hashtable();
        for (int i = 0; i < entries.length; ++i) {
            String[] entry = eMFrameUtils.unpack(entries[i], context);
            String[] values = eMFrameUtils.unpack(entry[1], context);
            ArrayList<String> valueList = new ArrayList<String>();
            for (int j = 0; j < values.length; ++j) {
                valueList.add(values[j]);
            }
            hashtable.put(entry[0], valueList);
        }
        return hashtable;
    }

    public static void initTCFavoritesList(String objectTypeName, MContext context) {
        try {
            if (objectTypeName.equals("User") || objectTypeName.equalsIgnoreCase("inetorgperson")) {
                TargetChooserUtils.addTCQuickFindAttribute(objectTypeName, "CN", context);
                TargetChooserUtils.addTCQuickFindAttribute(objectTypeName, "givenName", context);
                TargetChooserUtils.addTCQuickFindAttribute(objectTypeName, "Surname", context);
            } else {
                AuthenticationBroker broker = DirAuthenticator.getDirAuth(context).getAuthenticationBroker();
                ObjectEntry treeOE = (ObjectEntry)broker.getProtocolObject("AdminNamespace");
                AdminNamespace ns = treeOE.getAdminNamespace();
                String objectTypeNameNew = objectTypeName;
                if (objectTypeName.indexOf(44) > 0) {
                    objectTypeNameNew = objectTypeName.split(",")[0];
                }
                ClassDefinition classDefinition = ns.getSchemaDefinition(treeOE).getClassDefinition(objectTypeNameNew);
                AttributeDefinition[] namingAttrs = classDefinition.getNamingAttributes();
                for (int i = 0; i < namingAttrs.length; ++i) {
                    String attrName = eMFrameUtils.makeAttributeNameLDAPCompliant(namingAttrs[i].getName(), context);
                    TargetChooserUtils.addTCQuickFindAttribute(objectTypeName, attrName, context);
                }
            }
        }
        catch (AuthBrokerException e) {
            D.log(e);
        }
        catch (Throwable e) {
            D.log(e);
        }
    }
}

