/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.ComponentCreationException;
import com.novell.admin.ns.HexValue;
import com.novell.admin.ns.IncompatibleComponentException;
import com.novell.admin.ns.Syntax;
import com.novell.admin.ns.ValueComponent;
import com.novell.admin.ns.nds.NDSSyntax;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DataHandlerHelper;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.eDirAccessServiceException;
import java.util.TimeZone;
import org.jdom.Element;

public class TimeRestrictionsAttributeHandler
extends DataHandlerHelper {
    private static final int NUM_OF_BYTES = 42;
    private static final int SECONDS_IN_AN_HOUR = 3600;
    private static final int LOCAL_TO_UTC = -1;
    private static final int UTC_TO_LOCAL = 1;

    @Override
    protected void valueComponentToXml(ValueComponent vc, StringBuffer resultValue, String attrName, Syntax syntax) throws eDirAccessServiceException {
        byte[] bytes = ((HexValue)vc).getValue();
        resultValue.append("<value>");
        resultValue.append(TimeRestrictionsAttributeHandler.binaryEncode(bytes));
        resultValue.append("</value>");
    }

    @Override
    protected ValueComponent xmlToValueComponent(AttributeDefinition attributeDefinition, Element element, MContext context) throws ComponentCreationException, IncompatibleComponentException, eDirAccessServiceException {
        byte[] bytes = TimeRestrictionsAttributeHandler.makeBytes(element.getText());
        return NDSSyntax.SYN_OCTET_STRING.createValueComponent((Object)bytes);
    }

    public static byte[] makeBytes(String src) {
        int halfHourShift = 0;
        TimeZone timeZone = TimeZone.getDefault();
        halfHourShift = timeZone.getRawOffset() * 2 / 3600000;
        String shiftSrc = TimeRestrictionsAttributeHandler.shiftString(src, halfHourShift * -1);
        byte[] bytes = new byte[42];
        for (int r = 0; r < 42; ++r) {
            byte wb = 0;
            for (int col = 0; col < 8; ++col) {
                int offset = r * 8 + col;
                if (shiftSrc.charAt(offset) != '0') continue;
                wb = (byte)(wb | 1 << col);
            }
            bytes[r] = wb;
        }
        return bytes;
    }

    private static String shiftString(String sb, int distance) {
        StringBuffer temp = new StringBuffer(336);
        int loc = distance < 0 ? distance * -1 : 336 - distance;
        for (int x = 0; x < 336; ++x) {
            if (loc >= 336) {
                loc = 0;
            }
            temp.append(sb.charAt(loc++));
        }
        return temp.toString();
    }

    private static String binaryEncode(byte[] set) {
        byte read = 0;
        StringBuffer sb = new StringBuffer();
        if (set == null) {
            D.log("EDAS: Login Allowed Time Map was not valued");
            for (int i = 0; i < 42; ++i) {
                sb.append("00000000");
            }
        } else {
            for (int r = 0; r < 42; ++r) {
                read = set[r];
                for (int bitpos = 0; bitpos < 8; ++bitpos) {
                    if ((read & 1 << bitpos) == 0) {
                        sb.append("1");
                        continue;
                    }
                    sb.append("0");
                }
            }
        }
        int halfHourShift = 0;
        TimeZone timeZone = TimeZone.getDefault();
        halfHourShift = timeZone.getRawOffset() * 2 / 3600000;
        return TimeRestrictionsAttributeHandler.shiftString(sb.toString(), halfHourShift * 1);
    }
}

