/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.BrowserObjectEntryEnumeration;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.application.console.snapin.ObjectEntryEnumeration;
import com.novell.application.console.snapin.SnapinException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.MTask;
import com.novell.emframe.dev.XmlUtils;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.ContainerObjectEntryNode;
import com.novell.emframe.fw.TreeViewContentMenuItem;
import com.novell.emframe.fw.TreeViewContentUtils;
import java.io.IOException;
import java.io.PrintWriter;
import java.util.ArrayList;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class TreeViewContentTask
extends MTask {
    private static final long serialVersionUID = 1L;
    private MContext m_context;
    private HttpServletRequest m_req;
    private ObjectEntry m_treeOE;
    private AdminNamespace m_ns;

    @Override
    public void execute(MContext context) {
        block13: {
            this.m_context = context;
            this.m_req = this.m_context.getRequest();
            this.m_treeOE = (ObjectEntry)context.getAuthenticationBroker().getAPIObject("NDSNamespace");
            this.m_ns = this.m_treeOE.getAdminNamespace();
            String nextState = this.m_req.getParameter("nextState");
            try {
                if (nextState == null || nextState.equals("initialState")) {
                    this.initialState();
                    return;
                }
                if (nextState.equals("initialCallBack")) {
                    this.initialCallBack();
                    return;
                }
                if (nextState.equals("getNextBlockCallBack")) {
                    this.getNextBlockCallBack();
                    return;
                }
                if (nextState.equals("getPreviousBlockCallBack")) {
                    this.getPreviousBlockCallBack();
                    return;
                }
                if (nextState.equals("browseIntoContainerCallBack")) {
                    this.browseIntoContainerCallBack();
                    return;
                }
                if (nextState.equals("changeDirectionCallBack")) {
                    this.changeDirectionCallBack();
                    return;
                }
                if (nextState.equals("changeFilterCallBack")) {
                    this.changeFilterCallBack();
                    return;
                }
                if (nextState.equals("getActionsMenuTaskListCallBack")) {
                    this.getActionsMenuTaskListCallBack();
                    return;
                }
                if (nextState.equals("getDeleteMenuTaskListCallBack")) {
                    this.getDeleteMenuTaskListCallBack();
                    return;
                }
                if (nextState.equals("getEditMenuTaskListCallBack")) {
                    this.getEditMenuTaskListCallBack();
                    return;
                }
                if (nextState.equals("refreshListCallBack")) {
                    this.refreshListCallBack();
                }
            }
            catch (Exception exc) {
                TreeViewContentUtils.setExceptionMessage(exc, context);
                if (nextState != null && !nextState.equals("initialState")) break block13;
                this.setUIPage("dev/GenMsg.jsp");
                this.m_req.setAttribute("initialError", (Object)"true");
            }
        }
    }

    private void initialState() throws Exception {
        this.m_context.removeAuthAttribute("TVC_Direction");
        this.m_context.removeAuthAttribute("TVC_DisplayBlockSize");
        String containerStr = eMFrameUtils.getSingleTarget(this.m_req);
        ObjectEntry containerOE = this.m_ns.getObjectEntry(this.m_treeOE, containerStr);
        TreeViewContentUtils.initialContainerRead(this.m_context, containerOE);
    }

    private void changeDirectionCallBack() throws SnapinException {
        ContainerObjectEntryNode containerOEN = (ContainerObjectEntryNode)this.m_context.getAuthAttribute("TVC_ContainerObjectEntryNode");
        String direction = TreeViewContentUtils.changeDirection(this.m_context);
        if (direction.equals("ascending")) {
            ObjectEntryEnumeration oeeChildren = TreeViewContentUtils.getObjectEntryEnumeration(containerOEN.getObjectEntry(), this.m_context);
            if (oeeChildren instanceof BrowserObjectEntryEnumeration) {
                ((BrowserObjectEntryEnumeration)oeeChildren).moveLast();
                oeeChildren.next();
                this.m_context.setAuthAttribute("TVC_ObjectEntryEnumeration", oeeChildren);
                this.initialCallBack();
            }
        } else {
            ObjectEntryEnumeration oeeChildren = TreeViewContentUtils.getObjectEntryEnumeration(containerOEN.getObjectEntry(), this.m_context);
            if (oeeChildren instanceof BrowserObjectEntryEnumeration) {
                ((BrowserObjectEntryEnumeration)oeeChildren).moveFirst();
                this.m_context.setAuthAttribute("TVC_ObjectEntryEnumeration", oeeChildren);
                this.initialCallBack();
            }
        }
    }

    private void changeFilterCallBack() throws Exception {
        String newNameFilter = this.m_req.getParameter("TVC_NameFilter");
        newNameFilter = XmlUtils.xmlDecode(newNameFilter);
        String newSelectedType = this.m_req.getParameter("TVC_SelectedType");
        newSelectedType = XmlUtils.xmlDecode(newSelectedType);
        String advFilterXML = this.m_req.getParameter("TVC_AdvFilterXML");
        advFilterXML = XmlUtils.xmlDecode(advFilterXML);
        String showAllContainers = this.m_req.getParameter("TVC_ShowAllContainers");
        showAllContainers = XmlUtils.xmlDecode(showAllContainers);
        this.m_context.setAuthAttribute("TVC_NameFilterCache", newNameFilter);
        this.m_context.setAuthAttribute("TVC_TypeFilterCache", newSelectedType);
        this.m_context.setAuthAttribute("TVC_AdvancedFilterCache", advFilterXML);
        this.m_context.setAuthAttribute("TVC_ShowAllContainersCache", showAllContainers);
        ContainerObjectEntryNode coeNode = (ContainerObjectEntryNode)this.m_context.getAuthAttribute("TVC_ContainerObjectEntryNode");
        TreeViewContentUtils.initialContainerRead(this.m_context, coeNode.getObjectEntry());
        this.initialCallBack();
    }

    private void browseIntoContainerCallBack() throws Exception {
        String containerStr = this.m_req.getParameter("TVC_ContainerName");
        containerStr = XmlUtils.xmlDecode(containerStr);
        ObjectEntry containerOE = null;
        containerOE = containerStr.startsWith(".") && containerStr.endsWith(".") ? this.m_treeOE : this.m_ns.getObjectEntry(this.m_treeOE, containerStr);
        TreeViewContentUtils.initialContainerRead(this.m_context, containerOE);
        this.initialCallBack();
    }

    private int initialCallBack() throws SnapinException {
        ContainerObjectEntryNode containerOEN = (ContainerObjectEntryNode)this.m_context.getAuthAttribute("TVC_ContainerObjectEntryNode");
        ObjectEntryEnumeration oeeChildren = (ObjectEntryEnumeration)this.m_context.getAuthAttribute("TVC_ObjectEntryEnumeration");
        Long displayBlockSize = TreeViewContentUtils.getDisplayBlockSize(this.m_context);
        String direction = TreeViewContentUtils.getDirection(this.m_context);
        ArrayList oenList = null;
        oenList = direction.equals("ascending") ? TreeViewContentUtils.getNextAscendingObjectEntryNodeList(oeeChildren, this.m_context, displayBlockSize.intValue()) : TreeViewContentUtils.getNextDescendingObjectEntryNodeList(oeeChildren, this.m_context, displayBlockSize.intValue());
        int startNumber = oenList.size() == 0 ? 0 : 1;
        Long startIndex = new Long(startNumber);
        Long endIndex = new Long(oenList.size());
        TreeViewContentUtils.addCurrentAndParentNode(containerOEN, oenList, this.m_context);
        String docString = TreeViewContentUtils.createXMLDoc(this.m_context, containerOEN, oenList, direction, startIndex.intValue(), endIndex.intValue());
        this.m_context.getRequest().setAttribute("TVC_xmlDocString", (Object)docString);
        this.m_context.setAuthAttribute("TVC_ObjectEntryEnumeration", oeeChildren);
        this.m_context.setAuthAttribute("TVC_StartIndex", startIndex.toString());
        this.m_context.setAuthAttribute("TVC_EndIndex", endIndex.toString());
        this.m_context.setAuthAttribute("TVC_Direction", direction);
        return oenList.size();
    }

    @Override
    public void render(MContext context, HttpServletResponse resp) {
        String docString = (String)context.getRequest().getAttribute("TVC_xmlDocString");
        String initialError = (String)context.getRequest().getAttribute("initialError");
        if (initialError == null || initialError.equals("")) {
            initialError = "false";
        }
        if (docString != null && initialError.equals("false")) {
            try {
                PrintWriter out = TreeViewContentUtils.getPrintWriterFormResponse(context, resp);
                out.print(docString);
                out.close();
            }
            catch (IOException e) {
                D.log(e);
            }
        } else {
            context.getRequest().removeAttribute("initialError");
            super.render(context, resp);
        }
    }

    private void getNextBlockCallBack() throws SnapinException {
        ContainerObjectEntryNode containerOEN = (ContainerObjectEntryNode)this.m_context.getAuthAttribute("TVC_ContainerObjectEntryNode");
        String endIndexStr = (String)this.m_context.getAuthAttribute("TVC_EndIndex");
        ObjectEntryEnumeration oeeChildren = TreeViewContentUtils.getObjectEntryEnumeration(containerOEN.getObjectEntry(), this.m_context);
        Long displayBlockSize = TreeViewContentUtils.getDisplayBlockSize(this.m_context);
        String direction = TreeViewContentUtils.getDirection(this.m_context);
        ArrayList oenList = null;
        oenList = direction.equals("ascending") ? TreeViewContentUtils.getNextAscendingObjectEntryNodeList(oeeChildren, this.m_context, displayBlockSize.intValue()) : TreeViewContentUtils.getNextDescendingObjectEntryNodeList(oeeChildren, this.m_context, displayBlockSize.intValue());
        Long lastReadBlockSize = new Long(oenList.size());
        Long endIndex = new Long(endIndexStr);
        Long startIndex = new Long(endIndex.intValue() + 1);
        endIndex = new Long(endIndex.intValue() + oenList.size());
        TreeViewContentUtils.addCurrentAndParentNode(containerOEN, oenList, this.m_context);
        String docString = TreeViewContentUtils.createXMLDoc(this.m_context, containerOEN, oenList, direction, startIndex.intValue(), endIndex.intValue());
        this.m_context.getRequest().setAttribute("TVC_xmlDocString", (Object)docString);
        this.m_context.setAuthAttribute("TVC_ObjectEntryEnumeration", oeeChildren);
        this.m_context.setAuthAttribute("TVC_StartIndex", startIndex.toString());
        this.m_context.setAuthAttribute("TVC_EndIndex", endIndex.toString());
        this.m_context.setAuthAttribute("TVC_LastBlockReadSize", lastReadBlockSize.toString());
    }

    private void getPreviousBlockCallBack() throws SnapinException {
        ContainerObjectEntryNode containerOEN = (ContainerObjectEntryNode)this.m_context.getAuthAttribute("TVC_ContainerObjectEntryNode");
        String startIndexStr = (String)this.m_context.getAuthAttribute("TVC_StartIndex");
        String lastBlockReadStr = (String)this.m_context.getAuthAttribute("TVC_LastBlockReadSize");
        Long lastReadBlockSize = new Long(lastBlockReadStr);
        ObjectEntryEnumeration oeeChildren = TreeViewContentUtils.getObjectEntryEnumeration(containerOEN.getObjectEntry(), this.m_context);
        Long displayBlockSize = TreeViewContentUtils.getDisplayBlockSize(this.m_context);
        String direction = TreeViewContentUtils.getDirection(this.m_context);
        ArrayList oenList = null;
        oenList = direction.equals("ascending") ? TreeViewContentUtils.getPreviousAscendingObjectEntryNodeList(oeeChildren, this.m_context, displayBlockSize.intValue(), lastReadBlockSize.intValue()) : TreeViewContentUtils.getPreviousDescendingObjectEntryNodeList(oeeChildren, this.m_context, displayBlockSize.intValue(), lastReadBlockSize.intValue());
        lastReadBlockSize = new Long(oenList.size());
        Long startIndex = new Long(startIndexStr);
        Long endIndex = new Long(startIndex.intValue() - 1);
        startIndex = new Long(startIndex.intValue() - oenList.size());
        TreeViewContentUtils.addCurrentAndParentNode(containerOEN, oenList, this.m_context);
        String docString = TreeViewContentUtils.createXMLDoc(this.m_context, containerOEN, oenList, direction, startIndex.intValue(), endIndex.intValue());
        this.m_context.getRequest().setAttribute("TVC_xmlDocString", (Object)docString);
        this.m_context.setAuthAttribute("TVC_ObjectEntryEnumeration", oeeChildren);
        this.m_context.setAuthAttribute("TVC_StartIndex", startIndex.toString());
        this.m_context.setAuthAttribute("TVC_EndIndex", endIndex.toString());
        this.m_context.setAuthAttribute("TVC_LastBlockReadSize", lastReadBlockSize.toString());
    }

    private void getActionsMenuTaskListCallBack() throws Exception {
        ContainerObjectEntryNode containerOEN = (ContainerObjectEntryNode)this.m_context.getAuthAttribute("TVC_ContainerObjectEntryNode");
        ArrayList menuItems = null;
        ArrayList<TreeViewContentMenuItem> actionsMenuList = new ArrayList<TreeViewContentMenuItem>();
        String selectedObjectList = this.m_req.getParameter("TVC_SelectedObjectList");
        String[] objectNames = eMFrameUtils.unpack(selectedObjectList, this.m_context);
        if (objectNames != null && objectNames.length > 0 && (menuItems = TreeViewContentUtils.getTasksForObjects(objectNames, this.m_context)) != null && menuItems.size() > 0) {
            for (int i = 0; i < menuItems.size(); ++i) {
                TreeViewContentMenuItem menuItem = (TreeViewContentMenuItem)menuItems.get(i);
                String menuType = menuItem.getMenuType();
                if (menuType != null) continue;
                actionsMenuList.add(menuItem);
            }
        }
        String docString = TreeViewContentUtils.createMenuXMLDoc(this.m_context, actionsMenuList, containerOEN);
        this.m_context.getRequest().setAttribute("TVC_xmlDocString", (Object)docString);
    }

    private void getDeleteMenuTaskListCallBack() throws Exception {
        ContainerObjectEntryNode containerOEN = (ContainerObjectEntryNode)this.m_context.getAuthAttribute("TVC_ContainerObjectEntryNode");
        ArrayList menuItems = null;
        ArrayList<TreeViewContentMenuItem> deleteMenuList = new ArrayList<TreeViewContentMenuItem>();
        String selectedObjectList = this.m_req.getParameter("TVC_SelectedObjectList");
        String[] objectNames = eMFrameUtils.unpack(selectedObjectList, this.m_context);
        if (objectNames != null && objectNames.length > 0 && (menuItems = TreeViewContentUtils.getTasksForObjects(objectNames, this.m_context)) != null && menuItems.size() > 0) {
            for (int i = 0; i < menuItems.size(); ++i) {
                TreeViewContentMenuItem menuItem = (TreeViewContentMenuItem)menuItems.get(i);
                String menuType = menuItem.getMenuType();
                if (menuType == null || !menuType.equals("delete")) continue;
                deleteMenuList.add(menuItem);
            }
        }
        String docString = TreeViewContentUtils.createMenuXMLDoc(this.m_context, deleteMenuList, containerOEN);
        this.m_context.getRequest().setAttribute("TVC_xmlDocString", (Object)docString);
    }

    private void getEditMenuTaskListCallBack() throws Exception {
        ContainerObjectEntryNode containerOEN = (ContainerObjectEntryNode)this.m_context.getAuthAttribute("TVC_ContainerObjectEntryNode");
        ArrayList menuItems = null;
        ArrayList<TreeViewContentMenuItem> editMenuList = new ArrayList<TreeViewContentMenuItem>();
        String selectedObjectList = this.m_req.getParameter("TVC_SelectedObjectList");
        String[] objectNames = eMFrameUtils.unpack(selectedObjectList, this.m_context);
        if (objectNames != null && objectNames.length > 0 && (menuItems = TreeViewContentUtils.getTasksForObjects(objectNames, this.m_context)) != null && menuItems.size() > 0) {
            for (int i = 0; i < menuItems.size(); ++i) {
                TreeViewContentMenuItem menuItem = (TreeViewContentMenuItem)menuItems.get(i);
                String menuType = menuItem.getMenuType();
                if (menuType == null || !menuType.equals("edit")) continue;
                editMenuList.add(menuItem);
            }
        }
        String docString = TreeViewContentUtils.createMenuXMLDoc(this.m_context, editMenuList, containerOEN);
        this.m_context.getRequest().setAttribute("TVC_xmlDocString", (Object)docString);
    }

    private void refreshListCallBack() throws Exception {
        String refreshStartIndexStr = (String)this.m_context.getAuthAttribute("TVC_StartIndex");
        Long refreshStartIndex = new Long(refreshStartIndexStr);
        Long displayBlockSize = TreeViewContentUtils.getDisplayBlockSize(this.m_context);
        ContainerObjectEntryNode coeNode = (ContainerObjectEntryNode)this.m_context.getAuthAttribute("TVC_ContainerObjectEntryNode");
        ObjectEntry containerOE = this.m_ns.getObjectEntry(coeNode.getObjectEntry().getRoot(), this.m_ns.getUnrootedName(coeNode.getObjectEntry()));
        TreeViewContentUtils.initialContainerRead(this.m_context, containerOE);
        int currentCount = this.initialCallBack();
        if (currentCount == 0) {
            return;
        }
        if (refreshStartIndex.intValue() >= 0 && refreshStartIndex.intValue() <= displayBlockSize.intValue()) {
            return;
        }
        ObjectEntryEnumeration oeeChildren = (ObjectEntryEnumeration)this.m_context.getAuthAttribute("TVC_ObjectEntryEnumeration");
        String direction = TreeViewContentUtils.getDirection(this.m_context);
        ArrayList oenList = null;
        do {
            oenList = direction.equals("ascending") ? TreeViewContentUtils.getNextAscendingObjectEntryNodeList(oeeChildren, this.m_context, displayBlockSize.intValue()) : TreeViewContentUtils.getNextDescendingObjectEntryNodeList(oeeChildren, this.m_context, displayBlockSize.intValue());
        } while (refreshStartIndex.intValue() < (currentCount += oenList.size()) - displayBlockSize.intValue() || refreshStartIndex.intValue() > currentCount);
        Long lastReadBlockSize = new Long(oenList.size());
        Long startIndex = new Long(currentCount + 1);
        Long endIndex = new Long(startIndex.intValue() - 1);
        startIndex = new Long(startIndex.intValue() - oenList.size());
        ContainerObjectEntryNode containerOEN = (ContainerObjectEntryNode)this.m_context.getAuthAttribute("TVC_ContainerObjectEntryNode");
        TreeViewContentUtils.addCurrentAndParentNode(containerOEN, oenList, this.m_context);
        String docString = TreeViewContentUtils.createXMLDoc(this.m_context, containerOEN, oenList, direction, startIndex.intValue(), endIndex.intValue());
        this.m_context.getRequest().setAttribute("TVC_xmlDocString", (Object)docString);
        this.m_context.setAuthAttribute("TVC_ObjectEntryEnumeration", oeeChildren);
        this.m_context.setAuthAttribute("TVC_StartIndex", startIndex.toString());
        this.m_context.setAuthAttribute("TVC_EndIndex", endIndex.toString());
        this.m_context.setAuthAttribute("TVC_LastBlockReadSize", lastReadBlockSize.toString());
    }
}

