/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSReportUtil;
import com.novell.emframe.fw.ReportsExportUtil;
import com.novell.emframe.fw.UnassignedRolesClass;
import com.novell.emframe.fw.UnassignedRolesReportSort;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSRole;
import com.novell.webaccess.common.I18NServletRequest;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public final class UnassignedRolesReport
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private HttpServletRequest m_req;
    private NDSNamespace m_ns;
    private ObjectEntry m_treeOE;
    private ArrayList m_collectionList = new ArrayList();
    private ArrayList m_reportList = new ArrayList();
    private String m_inProgress = "false";
    private String m_progressCancelled = "false";
    private String m_sortColumn;
    private String m_sortDirection;
    private boolean m_threadDone;
    private boolean m_stopThread;
    private ReportThread reportThread;
    private int m_totalReportsCount = 0;
    private String m_progressMessage = "";
    private String m_reportTime;
    private int m_reportCount = 0;
    private ArrayList m_errors = new ArrayList();
    private String[] m_selectedCollections;
    private String m_selectedElements;
    private ReportsExportUtil m_exportUtil = null;

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = this.m_context.getRequest();
        this.m_treeOE = (ObjectEntry)this.m_context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        this.m_ns = (NDSNamespace)this.m_treeOE.getNamespace();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.initialState();
        }
        if (nextState.equalsIgnoreCase("getUnassignedRoles")) {
            this.getUnassignedRoles();
        } else {
            if (nextState.equalsIgnoreCase("refresh")) {
                return this.refresh();
            }
            if (nextState.equalsIgnoreCase("cancel")) {
                return this.cancel();
            }
            if (nextState.equalsIgnoreCase("finished")) {
                return this.finished();
            }
            if (nextState.equalsIgnoreCase("sortByColumn")) {
                return this.sortByColumn();
            }
            if (nextState.equalsIgnoreCase("exportReport")) {
                return this.handleExportFile();
            }
        }
        return true;
    }

    private boolean initialState() {
        try {
            RBSAssociatedObject rbsAssociatedObject = new RBSAssociatedObject(this.m_ns.getAuthenticatedIdentity(this.m_treeOE));
            RBSCollection[] rbsCollections = rbsAssociatedObject.getAllOwnedCollections2();
            if (rbsCollections == null) {
                String strTitle = eMFrameUtils.getLocalizedString("FwResources", "UnassignedRolesReport.Title", this.m_context.getLocale());
                String strBody = eMFrameUtils.getLocalizedString("FwResources", "UnassignedRolesReport.NotACollectionOwner", this.m_context.getLocale());
                eMFrameUtils.setMessage("success", strTitle, strBody, this.m_context);
                return false;
            }
            this.m_resultStrings.put("Selected.Elements", String.valueOf(0));
            this.m_resultStrings.put("Collection.Count", String.valueOf(rbsCollections.length));
            for (int i = 0; i < rbsCollections.length; ++i) {
                String collectionFDN = this.m_ns.getUnrootedName(rbsCollections[i].getObjectEntry());
                this.m_collectionList.add(collectionFDN);
                this.m_resultStrings.put("Collection." + i + ".FDN", collectionFDN);
            }
        }
        catch (Exception exc) {
            eMFrameUtils.setErrorMessage(exc, this.m_context);
            return false;
        }
        this.m_req.setAttribute("inProgress", (Object)this.m_inProgress);
        this.m_req.setAttribute("progressCancelled", (Object)this.m_progressCancelled);
        return true;
    }

    private boolean getUnassignedRoles() {
        this.m_selectedCollections = this.m_req.getParameterValues("CollectionList");
        this.m_selectedElements = this.m_req.getParameter("selectedElements");
        this.m_reportCount = 0;
        this.m_progressMessage = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Initializing", this.m_context);
        this.m_inProgress = "true";
        StringBuffer url = new StringBuffer("webacc?taskId=" + eMFrameUtils.urlEncode(this.m_req.getParameter("taskId"), this.m_context) + "&merge=fw.GetUnassignedRolesFormTask&nextState=refresh&inProgress=" + this.m_inProgress + "&progressMessage=" + this.m_progressMessage + "&Collection.Count=" + String.valueOf(this.m_collectionList.size()) + "&Selected.Elements=" + this.m_selectedElements);
        for (int i = 0; i < this.m_collectionList.size(); ++i) {
            url.append("&Collection." + i + ".FDN=" + eMFrameUtils.urlEncode(this.m_collectionList.get(i).toString(), "utf-8"));
        }
        this.m_resultStrings.put("UrlTask.url", url.toString());
        ((I18NServletRequest)this.m_req).setParameter("merge", "fw.UrlTask");
        Date date = new Date();
        Locale locale = this.m_context.getLocale();
        String reportTime = DateFormat.getDateInstance(0, locale).format(date);
        String reportDate = DateFormat.getTimeInstance(0, locale).format(date);
        this.m_reportTime = eMFrameUtils.formatMessage("{0} ({1})", new String[]{reportTime, reportDate});
        this.m_stopThread = false;
        this.m_threadDone = false;
        this.reportThread = new ReportThread();
        this.reportThread.start();
        return true;
    }

    private void getAllUnassignedRoles() {
        int count;
        this.m_reportList.clear();
        this.m_totalReportsCount = 0;
        RBSCollection[] rbsCollection = new RBSCollection[this.m_selectedCollections.length];
        for (count = 0; count < this.m_selectedCollections.length; ++count) {
            try {
                ObjectEntry collectionOE = this.m_ns.getObjectEntry(this.m_treeOE, this.m_selectedCollections[count]);
                rbsCollection[count] = new RBSCollection(collectionOE);
                RBSRole[] rbsRoles = rbsCollection[count].getRoles();
                if (rbsRoles == null) continue;
                this.m_totalReportsCount += rbsRoles.length;
                continue;
            }
            catch (Exception exc) {
                D.log(exc);
                eMFrameUtils.setErrorMessage(exc, this.m_context);
            }
        }
        for (count = 0; count < rbsCollection.length; ++count) {
            block9: {
                try {
                    RBSRole[] rbsRoles = rbsCollection[count].getRoles();
                    if (rbsRoles == null) break block9;
                    for (int i = 0; i < rbsRoles.length; ++i) {
                        ++this.m_reportCount;
                        RBSAssociation[] rbsAssociations = rbsRoles[i].getMembers();
                        if (rbsAssociations == null) {
                            UnassignedRolesClass uRoles = new UnassignedRolesClass();
                            String roleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, this.m_ns.getUnrootedName(rbsRoles[i].getObjectEntry()));
                            uRoles.setRoleDisplayName(roleDisplayName);
                            uRoles.setRoleFDN(this.m_ns.getUnrootedName(rbsRoles[i].getObjectEntry()));
                            uRoles.setCollectionFDN(this.m_selectedCollections[count]);
                            this.m_reportList.add(uRoles);
                        }
                        if (!this.m_stopThread) {
                            continue;
                        }
                        break;
                    }
                }
                catch (Exception exc) {
                    D.log(exc);
                    eMFrameUtils.setErrorMessage(exc, this.m_context);
                }
            }
            if (this.m_stopThread) break;
        }
        this.m_sortColumn = "sortRoleName";
        this.m_sortDirection = "descending";
        Collections.sort(this.m_reportList, new UnassignedRolesReportSort(this.m_context, this.m_sortColumn, this.m_sortDirection));
    }

    private boolean refresh() {
        String taskId = this.m_req.getParameter("taskId");
        if (!this.m_threadDone) {
            if (this.m_reportCount == 0) {
                this.m_progressMessage = eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.Initializing", this.m_context);
            } else {
                Object[] values = new String[]{Integer.toString(this.m_reportCount), Integer.toString(this.m_totalReportsCount)};
                this.m_progressMessage = eMFrameUtils.formatMessage(eMFrameUtils.getLocalizedString("FwResources", "RolesToUserReport.ReadingReport", this.m_context), values);
            }
            this.m_resultStrings.put("progressMessage", this.m_progressMessage);
        } else {
            StringBuffer url = new StringBuffer("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context) + "&nextState=finished&Collection.Count=" + String.valueOf(this.m_collectionList.size()) + "&Selected.Elements=" + this.m_selectedElements);
            for (int i = 0; i < this.m_collectionList.size(); ++i) {
                url.append("&Collection." + i + ".FDN=" + eMFrameUtils.urlEncode(this.m_collectionList.get(i).toString(), "utf-8"));
            }
            if (this.m_errors.size() > 0) {
                url.append("&merge=dev.MooGenErr&GeneralMsg.Mode=error");
            }
            this.m_resultStrings.put("UrlTask.url", url.toString());
            ((I18NServletRequest)this.m_req).setParameter("merge", "fw.UrlTask");
        }
        return true;
    }

    private boolean finished() {
        this.m_req.setAttribute("unassignedRoleReportData", (Object)this.m_reportList);
        this.m_req.setAttribute("sortColumn", (Object)this.m_sortColumn);
        this.m_req.setAttribute("sortDirection", (Object)this.m_sortDirection);
        this.m_req.setAttribute("reportTime", (Object)this.m_reportTime);
        String taskId = this.m_req.getParameter("taskId");
        String url = new String("webacc?taskId=" + eMFrameUtils.urlEncode(taskId, this.m_context));
        this.m_resultStrings.put("UrlTask.url", url);
        ((I18NServletRequest)this.m_req).setParameter("merge", "fw.UnassignedRolesReport");
        return true;
    }

    private boolean cancel() {
        this.m_stopThread = true;
        this.m_inProgress = "false";
        this.m_progressCancelled = "true";
        this.m_req.setAttribute("inProgress", (Object)this.m_inProgress);
        this.m_req.setAttribute("progressCancelled", (Object)this.m_progressCancelled);
        this.m_resultStrings.put("Selected.Elements", this.m_selectedElements);
        this.m_resultStrings.put("Collection.Count", String.valueOf(this.m_collectionList.size()));
        for (int i = 0; i < this.m_collectionList.size(); ++i) {
            this.m_resultStrings.put("Collection." + i + ".FDN", this.m_collectionList.get(i));
        }
        return true;
    }

    private boolean handleExportFile() {
        if (this.m_context != null && this.m_reportList != null) {
            this.m_exportUtil = new ReportsExportUtil(this.m_context, this.m_reportList);
            this.m_exportUtil.exportUnassignedRolesReport();
        }
        return true;
    }

    public boolean handlePostRequestActions(HttpServletRequest req, HttpServletResponse resp) throws GadgetInstanceException {
        return this.m_exportUtil.sendRedirect(req, resp);
    }

    private boolean sortByColumn() {
        this.m_sortColumn = this.m_req.getParameter("sortColumn");
        this.m_sortDirection = this.m_req.getParameter("sortDirection");
        Collections.sort(this.m_reportList, new UnassignedRolesReportSort(this.m_context, this.m_sortColumn, this.m_sortDirection));
        this.m_req.setAttribute("unassignedRoleReportData", (Object)this.m_reportList);
        this.m_req.setAttribute("reportTime", (Object)this.m_reportTime);
        this.m_req.setAttribute("sortColumn", (Object)this.m_sortColumn);
        this.m_req.setAttribute("sortDirection", (Object)this.m_sortDirection);
        return true;
    }

    class ReportThread
    extends Thread {
        public ReportThread() {
            this.setPriority(4);
            this.setDaemon(true);
        }

        @Override
        public void run() {
            UnassignedRolesReport.this.getAllUnassignedRoles();
            UnassignedRolesReport.this.m_threadDone = true;
        }
    }
}

