/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.NamespaceException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.RBSReportUtil;
import com.novell.emframe.fw.RBSRoleReportSort;
import com.novell.emframe.fw.ReportsExportUtil;
import com.novell.nps.gadgetManager.GadgetInstanceException;
import com.novell.rbs.RBSAssociatedObject;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSCollection;
import com.novell.rbs.RBSException;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSRoleReport;
import java.text.Collator;
import java.text.DateFormat;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.Date;
import java.util.Hashtable;
import java.util.Locale;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

public class UsersToRoleReport
extends Task {
    private static final long serialVersionUID = 1L;
    private TaskContext m_context;
    private Properties m_resultStrings;
    private HttpServletRequest m_req;
    private NDSNamespace m_ns;
    private ObjectEntry m_treeOE;
    private Hashtable m_htRoles = new Hashtable();
    private ArrayList m_reportList;
    private String m_sortColumn;
    private String m_sortDirection;
    private String m_reportTime;
    private String m_sSelectedRolesDisplayNames = null;
    private ReportsExportUtil m_exportUtil = null;
    private Hashtable m_htRoleDisplayNames = new Hashtable();

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        FwUtils.verifyRbsInstalled(req, sServiceName);
    }

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.m_context = context;
        this.m_resultStrings = resultStrings;
        this.m_req = this.m_context.getRequest();
        this.m_treeOE = (ObjectEntry)this.m_context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        this.m_ns = (NDSNamespace)this.m_treeOE.getNamespace();
        String nextState = this.m_req.getParameter("nextState");
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.initialState();
        }
        if (nextState.equalsIgnoreCase("getRolesReport")) {
            return this.getRolesReport();
        }
        if (nextState.equalsIgnoreCase("sortByColumn")) {
            return this.sortByColumn();
        }
        if (nextState.equalsIgnoreCase("exportReport")) {
            return this.handleExportFile();
        }
        return true;
    }

    private boolean initialState() {
        return this.getCollectionAndRoleData();
    }

    private boolean getCollectionAndRoleData() {
        RBSCollection[] rbsCollections = null;
        try {
            rbsCollections = this.getCollectionList();
            if (rbsCollections != null) {
                this.m_resultStrings.put("Collection.Count", String.valueOf(rbsCollections.length));
                ArrayList<String> roleArrayList = new ArrayList<String>();
                for (int i = 0; i < rbsCollections.length; ++i) {
                    RBSCollection rbsCollection = rbsCollections[i];
                    this.m_resultStrings.put("Collection." + String.valueOf(i), rbsCollection.getObjectEntry().getAsIsName());
                    RBSRole[] roles = rbsCollection.getRoles();
                    if (roles != null) {
                        for (int j = 0; j < roles.length; ++j) {
                            RBSRole role = roles[j];
                            String sRoleObjectName = this.m_ns.getUnrootedName(role.getObjectEntry());
                            this.m_htRoles.put(sRoleObjectName, role);
                            roleArrayList.add(sRoleObjectName);
                            this.m_resultStrings.put(sRoleObjectName, this.getRoleDisplayName(role));
                        }
                    }
                    this.m_resultStrings.put("Collection." + i + ".Role.Count", String.valueOf(roleArrayList.size()));
                }
                Collections.sort(roleArrayList, new StringSort(this.m_context));
                for (int j = 0; j < roleArrayList.size(); ++j) {
                    String saRole = (String)roleArrayList.get(j);
                    this.m_resultStrings.put("Role." + String.valueOf(j), saRole);
                }
                this.m_resultStrings.put("Role.Count", String.valueOf(roleArrayList.size()));
            } else {
                this.m_resultStrings.put("Collection.Count", "0");
            }
        }
        catch (SPIException e) {
            D.log(e);
            eMFrameUtils.setErrorMessage(e, this.m_context);
            return false;
        }
        return true;
    }

    private RBSCollection[] getCollectionList() {
        ObjectEntry oeTrustee = null;
        try {
            oeTrustee = this.m_ns.getAuthenticatedIdentity(this.m_treeOE);
            RBSAssociatedObject user = new RBSAssociatedObject(oeTrustee);
            return user.getAllOwnedCollections2();
        }
        catch (Exception e) {
            D.log(e);
            String strException = eMFrameUtils.getExceptionMessage(e, this.m_context);
            String strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
            eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
            return null;
        }
    }

    private boolean getRolesReport() {
        this.m_reportList = new ArrayList();
        String[] roles = this.m_req.getParameterValues("SelectedRole");
        if (roles != null) {
            if (roles.length == 1) {
                RBSRole role = (RBSRole)this.m_htRoles.get(roles[0]);
                this.m_sSelectedRolesDisplayNames = this.getRoleDisplayName(role);
            } else {
                this.m_sSelectedRolesDisplayNames = eMFrameUtils.getLocalizedString("FwResources", "UsersToRoleReport.SelectedMultiple", this.m_context);
            }
            for (int j = 0; j < roles.length; ++j) {
                String strTitle;
                String m_sSelectedRole = roles[j];
                RBSRole role = (RBSRole)this.m_htRoles.get(m_sSelectedRole);
                String sRoleDisplayName = null;
                sRoleDisplayName = this.getRoleDisplayName(role);
                try {
                    RBSAssociation[] rbsAssocations = role.getMembers();
                    if (rbsAssocations != null) {
                        for (int i = 0; i < rbsAssocations.length; ++i) {
                            RBSAssociation assoc = rbsAssocations[i];
                            RBSRoleReport reportObject = new RBSRoleReport(null, sRoleDisplayName, this.m_ns.getUnrootedName(role.getObjectEntry()), assoc.getScope().getAsIsName(), assoc.getMember().getObjectType().getName().replace(' ', '_'), assoc.getMember().getAsIsName(), assoc.getInheritanceScope(), assoc.isRightsSet(), false);
                            this.m_reportList.add(reportObject);
                        }
                    }
                    this.m_sortColumn = "sortRoleName";
                    this.m_sortDirection = "descending";
                    Collections.sort(this.m_reportList, new RBSRoleReportSort(this.m_context, this.m_sortColumn, this.m_sortDirection));
                    continue;
                }
                catch (SPIException e) {
                    String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                    strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                    eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
                    return false;
                }
                catch (NamespaceException e) {
                    String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                    strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                    eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
                    return false;
                }
                catch (RBSException e) {
                    String strException = eMFrameUtils.getExceptionMessage((Exception)((Object)e), this.m_context);
                    strTitle = eMFrameUtils.getLocalizedString("FwResources", "Error", this.m_context);
                    eMFrameUtils.setMessage("error", strTitle, strException, this.m_context);
                    return false;
                }
            }
        }
        this.m_req.setAttribute("roleReportData", (Object)this.m_reportList);
        Date date = new Date();
        Locale locale = this.m_context.getLocale();
        String reportTime = DateFormat.getDateInstance(0, locale).format(date);
        String reportDate = DateFormat.getTimeInstance(0, locale).format(date);
        this.m_reportTime = eMFrameUtils.formatMessage("{0} ({1})", new String[]{reportTime, reportDate});
        this.addHeaderInfo();
        return true;
    }

    private String getRoleDisplayName(RBSRole sRole) {
        String sRoleDisplayName = null;
        String sFullName = sRole.getObjectEntry().getFullName();
        sRoleDisplayName = (String)this.m_htRoleDisplayNames.get(sFullName);
        if (sRoleDisplayName == null) {
            try {
                sRoleDisplayName = RBSReportUtil.getRoleDisplayName(this.m_context, this.m_treeOE, sFullName);
            }
            catch (SPIException e) {
                D.log(e);
            }
            if (sRoleDisplayName == null) {
                sRoleDisplayName = sRole.getObjectEntry().getName();
            }
            this.m_htRoleDisplayNames.put(sFullName, sRoleDisplayName);
        }
        return sRoleDisplayName;
    }

    private void addHeaderInfo() {
        this.m_req.setAttribute("reportTime", (Object)this.m_reportTime);
        this.m_req.setAttribute("selectedRolesDisplayNames", (Object)this.m_sSelectedRolesDisplayNames);
        this.m_req.setAttribute("reportTime", (Object)this.m_reportTime);
        this.m_req.setAttribute("sortColumn", (Object)this.m_sortColumn);
        this.m_req.setAttribute("sortDirection", (Object)this.m_sortDirection);
    }

    private boolean sortByColumn() {
        this.m_sortColumn = this.m_req.getParameter("sortColumn");
        this.m_sortDirection = this.m_req.getParameter("sortDirection");
        Collections.sort(this.m_reportList, new RBSRoleReportSort(this.m_context, this.m_sortColumn, this.m_sortDirection));
        this.m_req.setAttribute("roleReportData", (Object)this.m_reportList);
        this.addHeaderInfo();
        return true;
    }

    public boolean handleExportFile() {
        if (this.m_context != null && this.m_reportList != null) {
            this.m_exportUtil = new ReportsExportUtil(this.m_context, this.m_reportList);
            this.m_exportUtil.exportUsersToRoleReport();
        }
        return true;
    }

    public boolean handlePostRequestActions(HttpServletRequest req, HttpServletResponse resp) throws GadgetInstanceException {
        return this.m_exportUtil.sendRedirect(req, resp);
    }

    public class StringSort
    implements Comparator {
        Collator m_collator = null;
        TaskContext m_context = null;

        public StringSort(TaskContext context) {
            this.m_context = context;
            this.m_collator = Collator.getInstance(this.m_context.getLocale());
        }

        public int compare(Object object1, Object object2) {
            String str1 = (String)object1;
            String str2 = (String)object2;
            return this.m_collator.compare(str1, str2);
        }
    }
}

