/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.dev.config.ConfigException;
import com.novell.emframe.dev.config.UserConfig;
import com.novell.emframe.dev.eMFrameFactory;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwUtils;
import com.novell.nps.WebappUtil;
import com.novell.webaccess.common.I18NServletRequest;
import java.util.ArrayList;
import java.util.Properties;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class ViewAdminTask
extends Task {
    private static final long serialVersionUID = 1L;
    public static String READ_PARENT_OBJECTS = "ReadParentObjects";
    public static String EDIT_FLAGS = "EditFlags";
    public static String SAVE_FLAGS = "SaveFlags";
    public static String IMANAGER_VIEW = "iManagerView:";
    public static int SHOW = 1;
    public static int HIDE = 0;
    public static int DO_NOT_SET = 2;
    TaskContext context = null;
    Properties resultStrings = null;
    String m_sTargetName = null;

    @Override
    public boolean execute(TaskContext context, Properties resultStrings) {
        this.context = context;
        this.resultStrings = resultStrings;
        HttpServletRequest req = context.getRequest();
        String nextState = req.getParameter("nextState");
        String targetName = eMFrameUtils.getSingleTarget(req);
        if (targetName.length() > 0) {
            nextState = EDIT_FLAGS;
            ((I18NServletRequest)req).setParameter("merge", "dev.GenConf");
            ((I18NServletRequest)req).setParameter("error", "dev.GenFatal");
        }
        if (targetName.length() <= 0) {
            String targetNames = req.getParameter("eDir$target");
            String[] targets = null;
            if (targetNames != null) {
                targets = eMFrameUtils.unpack(targetNames, context);
                targetName = targets[0];
            }
        }
        if (nextState == null || nextState.equalsIgnoreCase("initialState")) {
            return this.showInitialForm();
        }
        if (nextState.equalsIgnoreCase(EDIT_FLAGS)) {
            if (targetName.length() == 0) {
                targetName = req.getParameter("single");
            }
            if (targetName == null || targetName.length() == 0) {
                eMFrameUtils.setMessage("error", eMFrameUtils.getLocalizedString("FwResources", "ViewAdmin.Failure", context), eMFrameUtils.getLocalizedString("BaseResources", "Common.EnterObject", context), context);
                return false;
            }
            this.m_sTargetName = targetName;
            req.setAttribute("ObjectDisplayName", (Object)this.m_sTargetName);
            this.showFlags(context, targetName);
            return true;
        }
        if (nextState.equalsIgnoreCase(SAVE_FLAGS)) {
            req.setAttribute("ObjectDisplayName", (Object)this.m_sTargetName);
            this.saveFlags(context, this.m_sTargetName);
            return true;
        }
        throw new RuntimeException("Task received invalid nextState:" + nextState);
    }

    private boolean showInitialForm() {
        eMFrameUtils.setupTargetChooser(new String[]{"User", "Person", "Organizational Person", "[containers]"}, this.context);
        return true;
    }

    private void showFlags(TaskContext context, String sObjectName) {
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        ObjectEntry oeUser = null;
        try {
            oeUser = namespace.getObjectEntry(treeOE, sObjectName);
        }
        catch (SPIException e) {
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ViewAdmin.Failure", context));
            this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString("BaseResources", "Common.ObjectNotFound", context));
            this.resultStrings.put("GeneralMsg.MsgBodyBoldText", sObjectName);
            HttpServletRequest req = context.getRequest();
            ((I18NServletRequest)req).setParameter("merge", "dev.GenConf");
            return;
        }
        context.addToHistory(oeUser);
        UserConfig uc = UserConfig.getUserConfig("fwViewAdmin", sObjectName, context);
        ArrayList views = GlobalRegistry.getViews();
        Document viewDoc = null;
        Element rootEl = null;
        String viewId = null;
        String sName = null;
        String sDisplayName = null;
        String sDescription = null;
        String sIcon = null;
        String sValue = null;
        int iValue = SHOW;
        this.resultStrings.put("Flags.Count", String.valueOf(views.size() - 1));
        for (int j = 0; j < views.size(); ++j) {
            viewDoc = (Document)views.get(j);
            rootEl = viewDoc.getRootElement();
            viewId = rootEl.getChildTextTrim("id");
            sName = IMANAGER_VIEW + viewId;
            sDisplayName = eMFrameUtils.getDisplayName(rootEl, "header-hint-text-key", context);
            sDescription = eMFrameUtils.getDisplayName(rootEl, "description-key", context);
            sIcon = WebappUtil.getContext() + "/portal" + rootEl.getChildTextTrim("header-normal-icon");
            if (uc != null) {
                sValue = uc.getSetting(sName);
                if (sValue != null) {
                    try {
                        iValue = Integer.parseInt(sValue);
                    }
                    catch (NumberFormatException e) {
                        iValue = DO_NOT_SET;
                    }
                    this.resultStrings.put("Flags." + String.valueOf(j) + ".Show", String.valueOf(iValue));
                } else {
                    iValue = DO_NOT_SET;
                    this.resultStrings.put("Flags." + String.valueOf(j) + ".Show", String.valueOf(iValue));
                }
            } else {
                iValue = DO_NOT_SET;
                this.resultStrings.put("Flags." + String.valueOf(j) + ".Show", String.valueOf(iValue));
            }
            this.resultStrings.put("Flags." + String.valueOf(j) + ".Name", sName);
            this.resultStrings.put("Flags." + String.valueOf(j) + ".Icon", sIcon);
            if (sDisplayName != null && sDisplayName.length() != 0) {
                this.resultStrings.put("Flags." + String.valueOf(j) + ".DisplayName", sDisplayName);
            } else {
                this.resultStrings.put("Flags." + String.valueOf(j) + ".DisplayName", viewId);
            }
            if (sDescription == null || sDescription.length() == 0) continue;
            this.resultStrings.put("Flags." + String.valueOf(j) + ".Description", sDescription);
        }
        sName = READ_PARENT_OBJECTS;
        this.resultStrings.put("Flags.ReadParent.Name", sName);
        if (uc != null) {
            sValue = uc.getSetting(sName);
            if (sValue != null) {
                try {
                    iValue = Integer.parseInt(sValue);
                }
                catch (NumberFormatException e) {
                    iValue = DO_NOT_SET;
                }
                this.resultStrings.put("Flags.ReadParent.Show", String.valueOf(iValue));
            } else {
                iValue = DO_NOT_SET;
                this.resultStrings.put("Flags.ReadParent.Show", String.valueOf(iValue));
            }
        } else {
            iValue = DO_NOT_SET;
            this.resultStrings.put("Flags.ReadParent.Show", String.valueOf(iValue));
        }
    }

    private void saveFlags(TaskContext context, String sObjectName) {
        UserConfig uc = UserConfig.getUserConfig("fwViewAdmin", sObjectName, context);
        HttpServletRequest req = context.getRequest();
        ArrayList views = GlobalRegistry.getViews();
        String sName = null;
        Document viewDoc = null;
        Element rootEl = null;
        String viewId = null;
        String sValue = null;
        for (int j = 0; j < views.size(); ++j) {
            viewDoc = (Document)views.get(j);
            rootEl = viewDoc.getRootElement();
            viewId = rootEl.getChildTextTrim("id");
            sName = IMANAGER_VIEW + viewId;
            sValue = req.getParameter(sName);
            try {
                if (sValue == null || sValue.length() == 0) {
                    uc.removeSetting(sName);
                    continue;
                }
                if (sValue.equalsIgnoreCase("1")) {
                    uc.setSetting(sName, String.valueOf(SHOW));
                    continue;
                }
                if (sValue.equalsIgnoreCase("0")) {
                    uc.setSetting(sName, String.valueOf(HIDE));
                    continue;
                }
                uc.removeSetting(sName);
                continue;
            }
            catch (ConfigException configException) {
                // empty catch block
            }
        }
        sName = READ_PARENT_OBJECTS;
        sValue = req.getParameter(sName);
        try {
            if (sValue == null || sValue.length() == 0) {
                uc.setSetting(sName, String.valueOf(HIDE));
            } else if (sValue.equalsIgnoreCase("on")) {
                uc.setSetting(sName, String.valueOf(SHOW));
            } else {
                uc.setSetting(sName, String.valueOf(HIDE));
            }
        }
        catch (ConfigException j) {
            // empty catch block
        }
        try {
            uc.writeSettings();
        }
        catch (ConfigException e) {
            this.setUIPage("dev/GenErr.jsp");
            this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ViewAdmin.Failure", context));
            this.resultStrings.put("GeneralMsg.MsgBodyPlainText", e.getLocalizedMessage());
            return;
        }
        this.setUIPage("dev/GenConf.jsp");
        this.resultStrings.put("GeneralMsg.MsgTitle", eMFrameUtils.getLocalizedString("FwResources", "ViewAdmin.Success", context));
        this.resultStrings.put("GeneralMsg.MsgBodyPlainText", eMFrameUtils.getLocalizedString("FwResources", "ViewAdmin.SuccessfullySavedFlags", context));
    }

    public static void shouldRun(HttpServletRequest req, String sServiceName) throws Exception {
        Task.shouldRun(req, sServiceName);
        if (!FwUtils.canConfigureiManager(req)) {
            TaskContext context = eMFrameFactory.getTaskContext(req);
            throw new Exception(eMFrameUtils.getLocalizedString("FwResources", "Configure.UserNotAuthorizedToConfigureiManager", context));
        }
    }
}

