/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.authenticator;

import com.novell.emframe.authDev.iMgrAuthenticatorImpl;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.authenticator.AuthClassContext;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.authenticator.FwAuthContext;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jdom.Document;
import org.jdom.Element;

public final class AuthLoader {
    public static final String AUTHMAPKEY = "AuthMap";
    private static Object sm_syncObject = new Object();
    private static Hashtable sm_AuthContexts = null;
    protected static String sm_sDefaultAuthenticator = null;
    protected static SystemConfig sm_config = null;
    protected static Hashtable sm_classContextCache = null;
    private static final String AUTH_DEFAULT = "Auth.default";
    private static final String AUTHKEYROOT = "Auth.";

    private AuthLoader() {
    }

    public static void init(SystemConfig config) {
        if (sm_classContextCache == null) {
            sm_classContextCache = new Hashtable();
        }
        if (sm_AuthContexts == null) {
            sm_AuthContexts = new Hashtable();
        }
        if ((sm_sDefaultAuthenticator = (sm_config = config).getSetting(AUTH_DEFAULT)) == null) {
            sm_sDefaultAuthenticator = "dir";
        }
        AuthLoader.initClassContexts();
    }

    private static void initClassContexts() {
        AuthClassContext acc = null;
        String sAuthName = null;
        Enumeration en = sm_classContextCache.keys();
        while (en.hasMoreElements()) {
            sAuthName = (String)en.nextElement();
            acc = (AuthClassContext)sm_classContextCache.get(sAuthName);
            if (acc == null) continue;
            AuthLoader.initAuthData(sAuthName, acc);
        }
    }

    public static String getDefaultAuthenticatorName() {
        return sm_sDefaultAuthenticator;
    }

    public static iMgrAuthenticatorImpl getPrimaryAuthenticator(HttpServletRequest req) {
        String sAuthName = AuthLoader.getPrimaryAuthenticatorName(req);
        iMgrAuthenticatorImpl auth = AuthLoader.loadAuthenticator(sAuthName, req);
        return auth;
    }

    public static iMgrAuthenticatorImpl[] getAllSystemAuths(HttpServletRequest req) {
        ArrayList names = AuthLoader.getAllSystemAuthNames();
        return AuthLoader.getAuthenticatorsFromNames(names, req);
    }

    private static ArrayList getAllSystemAuthNames() {
        Set authIds = Registry.getRegistry("Global").getAuthenticators().keySet();
        return new ArrayList(authIds);
    }

    public static iMgrAuthenticatorImpl[] getRequiredAuthenticators(HttpServletRequest req) {
        return AuthLoader.getAuthenticatorsFromNames(AuthLoader.getRequiredAuthenticatorNames(req), req);
    }

    public static iMgrAuthenticatorImpl[] getRequiredAuthenticatorsForPlugin(MContext context, Document pluginDoc) {
        return AuthLoader.getAuthenticatorsFromNames(AuthLoader.getRequiredAuthenticatorNamesForPlugin(pluginDoc), context.getRequest());
    }

    private static iMgrAuthenticatorImpl[] getAuthenticatorsFromNames(ArrayList names, HttpServletRequest req) {
        ArrayList<iMgrAuthenticatorImpl> auths = new ArrayList<iMgrAuthenticatorImpl>(names.size());
        for (String sName : names) {
            iMgrAuthenticatorImpl auth = AuthLoader.loadAuthenticator(sName, req);
            if (auth == null) continue;
            auths.add(auth);
        }
        return auths.toArray(new iMgrAuthenticatorImpl[auths.size()]);
    }

    public static iMgrAuthenticatorImpl[] getAssignedAuths(HttpServletRequest req) {
        return AuthLoader.getAuthenticatorsFromNames(AuthLoader.getAssignedAuthNames(req), req);
    }

    public static iMgrAuthenticatorImpl[] getSupportedAuthenticatorsForPlugin(MContext context, Document doc) {
        return AuthLoader.getAuthenticatorsFromNames(FwAuthUtils.getSupportedAuthenticatorNamesForPlugin(doc), context.getRequest());
    }

    private static String getPrimaryAuthenticatorName(HttpServletRequest req) {
        Document doc = AuthLoader.getTaskDocument(req);
        Element root = null;
        if (doc != null) {
            root = doc.getRootElement();
        }
        return FwAuthUtils.getPrimaryAuthenticatorName(root);
    }

    private static ArrayList getRequiredAuthenticatorNames(HttpServletRequest req) {
        Document doc = AuthLoader.getTaskDocument(req);
        return AuthLoader.getRequiredAuthenticatorNamesForPlugin(doc);
    }

    private static ArrayList getRequiredAuthenticatorNamesForPlugin(Document doc) {
        ArrayList<String> authenticatorNames = new ArrayList<String>();
        if (doc != null) {
            List auths = doc.getRootElement().getChildren("auth-assignment");
            if (auths.isEmpty()) {
                authenticatorNames.add("dir");
                return authenticatorNames;
            }
            for (Element auth : auths) {
                String sRequired = auth.getChildTextTrim("required");
                if (!"true".equals(sRequired)) continue;
                authenticatorNames.add(auth.getChildTextTrim("id"));
            }
        }
        return authenticatorNames;
    }

    private static ArrayList getAssignedAuthNames(HttpServletRequest req) {
        Document doc = AuthLoader.getTaskDocument(req);
        return FwAuthUtils.getSupportedAuthenticatorNamesForPlugin(doc);
    }

    private static Document getTaskDocument(HttpServletRequest req) {
        String taskInstanceId = FwUtils.getTaskInstanceId(req);
        String taskId = null;
        if (taskInstanceId != null) {
            taskId = FwUtils.getTaskId(taskInstanceId);
        }
        Document doc = null;
        if (taskId != null && (doc = Registry.getRegistry("Global").getPluginDocument(taskId)) == null) {
            doc = Registry.getRegistry("Install").getPluginDocument(taskId);
        }
        return doc;
    }

    public static iMgrAuthenticatorImpl loadAuthenticator(String sAuthName, HttpServletRequest req) {
        iMgrAuthenticatorImpl auth = null;
        HttpSession session = req.getSession();
        try {
            HashMap<String, iMgrAuthenticatorImpl> authMap;
            if (sAuthName == null || sAuthName.length() == 0 || sAuthName.equalsIgnoreCase("any")) {
                sAuthName = sm_sDefaultAuthenticator;
            }
            if ((authMap = FwAuthUtils.getSessionAuthenticators(session)) == null) {
                authMap = new HashMap<String, iMgrAuthenticatorImpl>();
                FwAttr.setFwSessionAttribute(AUTHMAPKEY, authMap, session);
            } else {
                auth = (iMgrAuthenticatorImpl)authMap.get(sAuthName);
            }
            if (auth == null && (auth = AuthLoader.loadNConstruct(sAuthName, req)) != null) {
                authMap.put(sAuthName, auth);
                FwAttr.initFwAuthAttributes(auth);
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return auth;
    }

    private static iMgrAuthenticatorImpl loadNConstruct(String sAuthName, HttpServletRequest req) {
        iMgrAuthenticatorImpl auth = null;
        Document authDoc = Registry.getRegistry("Global").getAuthenticator(sAuthName);
        String sClassPath = authDoc.getRootElement().getChildTextTrim("class-name");
        if (sClassPath == null) {
            D.log("No class-name in authenticator descriptor: " + sAuthName, 1);
        } else {
            Class cAuthClass = AuthLoader.LoadAuthClass(sAuthName, sClassPath, req);
            if (cAuthClass != null) {
                auth = AuthLoader.ConstructAuth(cAuthClass, sAuthName, req);
            }
        }
        return auth;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Class LoadAuthClass(String sAuthName, String sClassPath, HttpServletRequest req) {
        AuthClassContext acc = null;
        Class cAuthClass = null;
        Object object = sm_syncObject;
        synchronized (object) {
            if (cAuthClass == null) {
                try {
                    cAuthClass = AuthLoader.loadClass(sClassPath);
                    acc = new AuthClassContext(sAuthName);
                    sm_classContextCache.put(sAuthName, acc);
                }
                catch (Exception e) {
                    D.log("AuthLoader.failure:  " + sAuthName + " -- class=" + sClassPath, 1);
                    D.log(e);
                }
            }
        }
        if (acc != null) {
            AuthLoader.initAuthData(sAuthName, acc);
            D.log("AuthLoader.authenticatorLoaded:  " + sClassPath);
        }
        return cAuthClass;
    }

    private static Class loadClass(String name) throws ClassNotFoundException {
        ClassLoader cl = sm_config.getClass().getClassLoader();
        Class<?> c = cl.loadClass(name);
        return c;
    }

    private static iMgrAuthenticatorImpl ConstructAuth(Class cAuthClass, String sAuthName, HttpServletRequest req) {
        iMgrAuthenticatorImpl auth = null;
        Document authDoc = Registry.getRegistry("Global").getAuthenticator(sAuthName);
        String sClassPath = authDoc.getRootElement().getChildTextTrim("class-name");
        try {
            Constructor co = cAuthClass.getConstructor(new Class[0]);
            auth = (iMgrAuthenticatorImpl)co.newInstance(new Class[0]);
            AuthLoader.initAuthenticator(sAuthName, auth, req);
        }
        catch (Exception e) {
            D.log("Error instantiating Authenticator:  " + sAuthName + " -- class=" + sClassPath, 1);
            D.log(e);
        }
        return auth;
    }

    private static void initAuthenticator(String sAuthName, iMgrAuthenticatorImpl auth, HttpServletRequest req) {
        AuthClassContext acc = null;
        FwAuthContext ac = null;
        acc = (AuthClassContext)sm_classContextCache.get(sAuthName);
        ac = new FwAuthContext(acc, req.getSession());
        sm_AuthContexts.put(auth, ac);
        auth.init(ac);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected static void initAuthData(String sAuthName, AuthClassContext acc) {
        Document authDoc = Registry.getRegistry("Global").getAuthenticator(sAuthName);
        Element settings = authDoc.getRootElement().getChild("settings");
        if (settings != null) {
            List children = settings.getChildren("setting");
            for (Element element : children) {
                String settingName = element.getAttributeValue("name");
                String settingValue = element.getTextTrim();
                acc.put(settingName, settingValue);
            }
        }
        String sAuthKey = AUTHKEYROOT + sAuthName + ".";
        int iKeyLen = sAuthKey.length();
        Object object = sm_syncObject;
        synchronized (object) {
            String[] saNames = sm_config.getSettingNames();
            String sKey = null;
            for (int i = 0; i < saNames.length; ++i) {
                sKey = saNames[i];
                if (!sKey.startsWith(sAuthKey)) continue;
                acc.put(sKey.substring(iKeyLen), sm_config.getSetting(sKey));
            }
        }
    }
}

