/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.authenticator;

import com.novell.emframe.authDev.iMgrAuthenticatorImpl;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.authenticator.AuthNotAuthenticatedException;
import com.novell.emframe.dev.authenticator.InvalidAuthMethodException;
import com.novell.emframe.dev.authenticator.iMgrAuthenticator;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.Registry;
import com.novell.emframe.fw.authenticator.AuthLoader;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpSession;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.xpath.XPath;

public class FwAuthUtils {
    private static HashMap sm_hmXPathGetPluginAuthDoc = new HashMap();

    public static iMgrAuthenticator getAuthenticator(String authName, HttpServletRequest req) {
        return AuthLoader.loadAuthenticator(authName, req);
    }

    public static iMgrAuthenticatorImpl getDefaultAuthenticator(HttpServletRequest req) {
        String sAuthName = AuthLoader.getDefaultAuthenticatorName();
        iMgrAuthenticatorImpl auth = AuthLoader.loadAuthenticator(sAuthName, req);
        return auth;
    }

    public static HashMap getSessionAuthenticators(HttpSession session) {
        return (HashMap)FwAttr.getFwSessionAttribute("AuthMap", session);
    }

    public static ArrayList getSupportedAuthenticatorNamesForPlugin(Document doc) {
        ArrayList<String> authenticatorNames = new ArrayList<String>();
        if (doc != null) {
            List auths = doc.getRootElement().getChildren("auth-assignment");
            if (auths.isEmpty()) {
                authenticatorNames.add("dir");
                return authenticatorNames;
            }
            for (Element auth : auths) {
                authenticatorNames.add(auth.getChildTextTrim("id"));
            }
        }
        return authenticatorNames;
    }

    public static void invalidateCachedRoleAndTasks(MContext context) {
        FwAttr.removeFwSessionAttribute("authentication.authenticatedroles", context.getSession());
    }

    public static void invalidateRolesAndTasksForAuth(MContext context, iMgrAuthenticator auth) {
        FwAuthUtils.invalidateCachedRoleAndTasks(context);
        FwAttr.setFwAuthAttribute("InvalidateCacheCalledByFramework", "true", auth);
        ((iMgrAuthenticatorImpl)auth).invalidateRolesAndTasks((FwTaskContext)context);
        D.assrt(FwAttr.getFwAuthAttribute("InvalidateCacheCalledByFramework", auth) == null, "Authenticator: " + auth.getAuthContext().getName() + " method invalidateRolesAndTasks should not be implemented without calling iMgrAuthenticatorImpl implementation.");
    }

    public static void invalidateRolesAndTasksForAllAuths(FwTaskContext context) {
        FwAuthUtils.invalidateCachedRoleAndTasks(context);
        HashMap authsById = FwAuthUtils.getSessionAuthenticators(context.getSession());
        for (iMgrAuthenticatorImpl auth : authsById.values()) {
            FwAuthUtils.invalidateRolesAndTasksForAuth(context, auth);
        }
    }

    public static Set getAuthSettingForPlugin(MContext context, Document doc, String sAuthName, String setting) {
        XPath xpathGetPluginAuthDoc = (XPath)sm_hmXPathGetPluginAuthDoc.get(sAuthName);
        try {
            if (xpathGetPluginAuthDoc == null) {
                xpathGetPluginAuthDoc = XPath.newInstance((String)(".//auth-assignment[id = \"" + sAuthName + "\" and setting]"));
                sm_hmXPathGetPluginAuthDoc.put(sAuthName, xpathGetPluginAuthDoc);
            }
            Element authDoc = null;
            authDoc = (Element)xpathGetPluginAuthDoc.selectSingleNode((Object)doc);
            if (authDoc == null) {
                return Collections.EMPTY_SET;
            }
            List settingElements = authDoc.getChildren("setting");
            for (Element settingElement : settingElements) {
                if (!setting.equalsIgnoreCase(settingElement.getChildTextTrim("name"))) continue;
                List valueElements = settingElement.getChildren("value");
                HashSet<String> hsRet = new HashSet<String>(valueElements.size());
                for (Element elementValue : valueElements) {
                    String sValue = elementValue.getTextTrim();
                    hsRet.add(sValue);
                }
                return hsRet;
            }
        }
        catch (JDOMException e) {
            D.log(e);
        }
        return Collections.EMPTY_SET;
    }

    public static String getUserFullId(HttpServletRequest req) {
        String sUserName = "";
        iMgrAuthenticatorImpl auth = AuthLoader.getPrimaryAuthenticator(req);
        try {
            sUserName = auth.getCredentials(req).getFullId();
        }
        catch (AuthNotAuthenticatedException e) {
            D.log(e);
        }
        return sUserName;
    }

    public static String getUserId(HttpServletRequest req) {
        String sUserId = "";
        iMgrAuthenticatorImpl auth = AuthLoader.getPrimaryAuthenticator(req);
        sUserId = FwAuthUtils.getUserId(auth, req);
        return sUserId;
    }

    public static String getUserId(iMgrAuthenticator auth, HttpServletRequest req) {
        String sUserId = "";
        try {
            sUserId = ((iMgrAuthenticatorImpl)auth).getCredentials(req).getId();
        }
        catch (AuthNotAuthenticatedException e) {
            D.log(e);
        }
        return sUserId;
    }

    public static String getFriendlyHostName(HttpServletRequest req) {
        String sFriendlyHostName = "";
        iMgrAuthenticatorImpl auth = AuthLoader.getPrimaryAuthenticator(req);
        sFriendlyHostName = auth.getConnectionProfile(req).getUniqueHostId();
        return sFriendlyHostName;
    }

    public static String getPassword(HttpServletRequest req) {
        String sPassword = null;
        iMgrAuthenticatorImpl auth = AuthLoader.getPrimaryAuthenticator(req);
        try {
            sPassword = auth.getCredentials(req).getPassword();
        }
        catch (InvalidAuthMethodException e) {
            D.log(e);
        }
        catch (AuthNotAuthenticatedException e) {
            D.log(e);
        }
        return sPassword;
    }

    public static String getUIPage(HttpServletRequest req) {
        return (String)FwAttr.getFwRequestAttribute("AuthUIPage", req);
    }

    public static String getUIPageFromAuthDoc(String AuthId) {
        Document doc = Registry.getRegistry("Global").getAuthenticator(AuthId);
        String sUIPage = doc.getRootElement().getChildTextTrim("UIPage");
        return sUIPage;
    }

    public static String getPrimaryAuthenticatorName(Element root) {
        if (root != null) {
            try {
                Element e = (Element)XPath.selectSingleNode((Object)root, (String)"auth-assignment[primary]");
                if (e != null) {
                    return e.getChildTextTrim("id");
                }
            }
            catch (JDOMException e) {
                D.log(e);
            }
        }
        return AuthLoader.getDefaultAuthenticatorName();
    }
}

