/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.config;

import com.novell.emframe.dev.MContext;
import com.novell.emframe.fw.config.ConfigRecord;
import com.novell.emframe.fw.config.ConfigRecordManager;
import com.novell.emframe.fw.config.ConfigSettings;
import java.util.Vector;

public class ConfigManager {
    public static final int IMANAGER_MODE_1 = 1;
    public static final int IMANAGER_MODE_2 = 2;
    public static final int IMANAGER_MODE_3 = 3;
    private ConfigRecordManager m_configRecordManager = null;
    private Vector m_cachedConfigSettings = new Vector();
    private static final int MIN_CACHE_SIZE = 10;
    private int m_cacheSize = 10;
    private static int m_mode = 2;

    public ConfigManager() {
        this.m_configRecordManager = new ConfigRecordManager();
        this.m_configRecordManager.read();
    }

    public ConfigManager(MContext ctx, int iMode) {
        this.m_configRecordManager = new ConfigRecordManager(ctx, iMode);
        this.m_configRecordManager.read();
    }

    public ConfigManager(MContext ctx, String dn, int iMode) {
        this.m_configRecordManager = new ConfigRecordManager(ctx, dn, iMode);
        this.m_configRecordManager.read();
    }

    public ConfigManager(MContext ctx, String dn) {
        this.m_configRecordManager = new ConfigRecordManager(ctx, dn);
        this.m_configRecordManager.read();
    }

    public String[] getSettingNames(String configID) {
        ConfigSettings config = this.getConfigSettings(configID);
        if (config == null) {
            return null;
        }
        return config.getSettingNames();
    }

    public String[] getSetting(String configID, String setting) {
        ConfigSettings config = this.getConfigSettings(configID);
        if (config == null) {
            return null;
        }
        return config.getSetting(setting);
    }

    public String getSingleSetting(String configID, String setting) {
        ConfigSettings config = this.getConfigSettings(configID);
        if (config == null) {
            return null;
        }
        return config.getSingleSetting(setting);
    }

    public String getSingleSetting(String configID, String setting, String defaultValue) {
        ConfigSettings config = this.getConfigSettings(configID);
        if (config == null) {
            return null;
        }
        return config.getSingleSetting(setting, defaultValue);
    }

    public void setSetting(String configID, String setting, String[] values) {
        ConfigSettings config = this.getConfigSettings(configID);
        if (config == null) {
            return;
        }
        config.setSetting(setting, values);
    }

    public void setSetting(String configID, String setting, String value) {
        ConfigSettings config = this.getConfigSettings(configID);
        if (config == null) {
            return;
        }
        config.setSetting(setting, value);
    }

    public void addSettingValue(String configID, String setting, String value) {
        ConfigSettings config = this.getConfigSettings(configID);
        if (config == null) {
            return;
        }
        config.addSettingValue(setting, value);
    }

    public void removeSettingValue(String configID, String setting, String value) {
        ConfigSettings config = this.getConfigSettings(configID);
        if (config == null) {
            return;
        }
        config.removeSettingValue(setting, value);
    }

    public void removeSetting(String configID, String setting) {
        ConfigSettings config = this.getConfigSettings(configID);
        if (config == null) {
            return;
        }
        config.removeSetting(setting);
    }

    public ConfigSettings getConfigSettings(String configID) {
        ConfigSettings config = this.getCachedConfigSettings(configID);
        if (config == null) {
            config = this.cacheConfigSettings(configID);
        }
        return config;
    }

    public void setCacheSize(int size) {
        if (size < 10) {
            return;
        }
        if (size < this.m_cacheSize) {
            for (int i = size - 1; i < this.m_cacheSize; ++i) {
                ConfigSettings oldConfigSettings = (ConfigSettings)this.m_cachedConfigSettings.elementAt(i);
                this.writeConfigSettings(oldConfigSettings);
            }
            this.m_cachedConfigSettings.setSize(size);
            this.m_cacheSize = size;
        }
    }

    public void writeSettings(String configID) {
        ConfigSettings settings = this.getCachedConfigSettings(configID);
        if (settings != null) {
            this.writeConfigSettings(settings);
        }
    }

    public int getCacheSize() {
        return this.m_cacheSize;
    }

    public static int getMode() {
        return m_mode;
    }

    public static void setMode(int mode) {
        m_mode = mode;
    }

    public String getUserConfigFileName(String configID) {
        ConfigRecord cr = new ConfigRecord(configID);
        return this.m_configRecordManager.getUserConfigFileName(cr);
    }

    private void writeConfigSettings(ConfigSettings configSettings) {
        if (configSettings.isChanged()) {
            this.m_configRecordManager.writeRecord(configSettings.getConfigRecord());
        }
    }

    private ConfigSettings cacheConfigSettings(String configID) {
        if (this.m_configRecordManager == null) {
            return null;
        }
        ConfigRecord scr = this.m_configRecordManager.getRecord(configID);
        if (scr == null) {
            scr = new ConfigRecord(configID);
        }
        ConfigSettings scs = new ConfigSettings(scr);
        if (this.m_cachedConfigSettings.size() == this.m_cacheSize) {
            ConfigSettings oldConfigSettings = (ConfigSettings)this.m_cachedConfigSettings.elementAt(this.m_cacheSize - 1);
            this.writeConfigSettings(oldConfigSettings);
        }
        this.m_cachedConfigSettings.add(0, scs);
        return scs;
    }

    private ConfigSettings getCachedConfigSettings(String configID) {
        int numSettings = this.m_cachedConfigSettings.size();
        for (int i = 0; i < numSettings; ++i) {
            ConfigSettings tempSetting = (ConfigSettings)this.m_cachedConfigSettings.elementAt(i);
            String tmpConfigID = tempSetting.getConfigID();
            if (!this.isIDMatch(configID, tmpConfigID)) continue;
            return tempSetting;
        }
        return null;
    }

    private boolean isIDMatch(String sID1, String sID2) {
        boolean isMatch = false;
        if (sID1 != null && sID2 != null) {
            if (sID1.equals(sID2)) {
                isMatch = true;
            }
        } else if (sID1 == null && sID2 == null) {
            isMatch = true;
        }
        return isMatch;
    }
}

