/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.config;

import com.novell.emframe.dev.D;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.VersionInfo;
import com.novell.emframe.fw.config.ModuleInfo;
import com.novell.emframe.fw.config.SystemConfigManager;
import com.novell.emframe.fw.servlet.AuthenticatorServlet;
import com.novell.emframe.fw.util.ModuleGet;
import com.novell.nps.WebappUtil;
import com.novell.nps.serviceProviders.PortalModuleInstallManager;
import com.novell.nps.utils.Log;
import java.io.BufferedInputStream;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.security.cert.Certificate;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.MissingResourceException;
import java.util.ResourceBundle;
import java.util.Vector;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.servlet.http.HttpServletRequest;

public class ModuleManager {
    private static Hashtable m_htInstalledModules = null;
    private static Hashtable m_htModulePackages = null;
    private static Hashtable m_htModulePackagesToInstall = null;
    private static Hashtable m_htModulePackagesToInstallclone = null;
    private static Hashtable m_htModuleIDtoNPM = null;
    private static Hashtable m_htModuleToUpgrade = null;
    private static boolean m_bUpdatingModulesToInstall;
    private static Hashtable m_htHiddenModules;
    private static Hashtable m_htShowHiddenModules;
    private static boolean m_bResetCache;
    public static final String FOLDER_ADDITIONAL_FILES = "currentwebapp/";
    public static final String FOLDER_MODULE_FILES = "currentmodule/";
    public static final String FOLDER_PRECOMPILED_JSP = "jsp/";
    public static final String FILE_MODULE_PROPERTIES = "module";
    public static final String FILE_EXT_PROPERTIES = ".properties";
    public static final String FILE_EXT_GADGET = ".npg";
    public static final String FILE_EXT_PORTAL_MODULE = ".npm";
    private static final String DT = "PortalModule";
    private static boolean meetsCriteria;
    private static String webAppContextPathIfNotInsideiManager;
    private static boolean isInsideiManager;

    public static boolean doesMeetsCriteria() {
        return meetsCriteria;
    }

    public static void setMeetsCriteria(boolean criteria) {
        meetsCriteria = criteria;
    }

    public static void readModules() {
        m_htInstalledModules = new Hashtable();
        m_htModuleToUpgrade = new Hashtable();
        ArrayList mfFiles = ModuleManager.getManifestFiles();
        for (int i = 0; i < mfFiles.size(); ++i) {
            ModuleInfo mInfo = new ModuleInfo();
            String sManifest = mfFiles.get(i).toString();
            File fManifest = new File(sManifest);
            try {
                BufferedInputStream isMF = new BufferedInputStream(new FileInputStream(fManifest));
                ModuleManager.getNPMInfoFromManifest(isMF, mInfo);
                if (m_htInstalledModules.get(mInfo.getModuleID()) != null) continue;
                if (mInfo.getModuleTitle() == null || mInfo.getModuleTitle().length() == 0) {
                    mInfo.setModuleTitle(mInfo.getModuleID() + " ***");
                }
                m_htInstalledModules.put(mInfo.getModuleID(), mInfo);
                continue;
            }
            catch (Throwable t) {
                D.log("Cannot find manifest file: " + sManifest);
                D.log(t);
            }
        }
    }

    public static Hashtable getAllInstalledModules() {
        if (m_htInstalledModules == null) {
            ModuleManager.readModules();
        }
        return m_htInstalledModules;
    }

    public static ModuleInfo getModule(String sModuleID) {
        if (m_htInstalledModules == null) {
            ModuleManager.readModules();
        }
        return (ModuleInfo)m_htInstalledModules.get(sModuleID);
    }

    public static void readModulePackages() {
        HttpServletRequest req;
        String[] sPackages;
        VersionInfo iManVersion = new VersionInfo(ModuleManager.getiManagerVersion());
        String os = System.getProperty("os.name").toLowerCase();
        String platform = FwUtils.getiManagerPlatform();
        m_htModulePackages = new Hashtable();
        m_htModuleIDtoNPM = new Hashtable();
        File fPackagesDir = ModuleManager.getPackagesDir();
        if (fPackagesDir != null && (sPackages = fPackagesDir.list()) != null) {
            for (int i = 0; i < sPackages.length; ++i) {
                String sPackage = sPackages[i];
                int iExt = sPackage.lastIndexOf(46) + 1;
                if (iExt == 0 || !sPackage.substring(iExt).equalsIgnoreCase("npm")) continue;
                ModuleInfo mInfo = new ModuleInfo();
                ModuleManager.getNPMInfo(fPackagesDir.getAbsolutePath() + File.separator + sPackage, mInfo);
                if (mInfo.m_sModuleID.length() > 0 && mInfo.m_sModuleVersion.length() > 0) {
                    if (!mInfo.m_sModuleID.equalsIgnoreCase("custom")) {
                        if (FwUtils.doesModuleMeetCriteria(mInfo, iManVersion, os, platform)) {
                            mInfo.setFilename(sPackage);
                            mInfo.setIsLocal(true);
                            mInfo.setUrl("file://" + fPackagesDir.getAbsolutePath() + File.separator + sPackage, 0);
                            ModuleManager.addModuleInfo(mInfo);
                            m_htModuleIDtoNPM.put(mInfo.m_sModuleID, fPackagesDir.getAbsolutePath() + File.separator + sPackage);
                            continue;
                        }
                        meetsCriteria = false;
                        ModuleManager.moveModuleToDeleted(sPackage);
                        continue;
                    }
                    D.log("\n<<<-------------------------------------------------------------------------");
                    D.log("WARNING: \nThe custom plugins cannot be installed thru Available Modules To Install task!");
                    D.log("WARNING: \nUse Plugin Studio to install this NPM:  " + sPackage);
                    D.log(">>>------------------------------------------------------------------------- \n");
                    continue;
                }
                D.log("\n<<<-------------------------------------------------------------------------");
                D.log("WARNING: \nMissing required fields like Module-ID/Implementation-Version in the NPM's manifest file!");
                D.log("WARNING: \nCheck the manifest file for this NPM:  " + sPackage);
                D.log(">>>------------------------------------------------------------------------- \n");
            }
        }
        if ((req = AuthenticatorServlet.currentRequest()) != null) {
            String requri = req.getRequestURI();
            int index = requri.indexOf(47, 1);
            if (index != -1) {
                requri = requri.substring(0, index);
            }
            String uri = req.getScheme() + "://" + req.getServerName() + ":" + req.getServerPort() + requri + "/packages/";
            ModuleGet.buildModuleDownloadDescriptorFile(m_htModulePackages.entrySet(), fPackagesDir, uri);
        }
        String shouldDownload = "true";
        shouldDownload = SystemConfigManager.getSingleSetting(null, "ShouldModuleDownload", shouldDownload);
        String whichShouldDownload = "Partial";
        whichShouldDownload = SystemConfigManager.getSingleSetting(null, "WhichModuleToDownload", whichShouldDownload);
        boolean bDownloadAll = false;
        if (null != whichShouldDownload && whichShouldDownload.equalsIgnoreCase("All")) {
            bDownloadAll = true;
        }
        if (null != shouldDownload && shouldDownload.equals("true")) {
            ModuleGet moduleGetFromWeb = new ModuleGet(ModuleManager.getiManagerVersion(), System.getProperty("os.name").toLowerCase(), fPackagesDir.getAbsolutePath());
            String sDescriptorUrl = SystemConfigManager.getSingleSetting(null, "ModuleDownloadDescriptorURL");
            if (null != sDescriptorUrl && sDescriptorUrl.length() > 0) {
                ModuleGet.setDescriptorUrl(sDescriptorUrl);
            }
            if (m_bResetCache) {
                m_bResetCache = false;
                ModuleGet.clearCache();
            }
            Vector vc = moduleGetFromWeb.getUpdateListFromDownloadXML(bDownloadAll);
            for (int i = 0; i < vc.size(); ++i) {
                ModuleInfo mInfo = (ModuleInfo)vc.elementAt(i);
                ModuleManager.addModuleInfo(mInfo);
                m_htModuleIDtoNPM.put(mInfo.m_sModuleID, fPackagesDir.getAbsolutePath() + File.separator + mInfo.getFilename());
            }
        }
    }

    public static Hashtable getModulePackages() {
        if (m_htModulePackages == null) {
            ModuleManager.readModulePackages();
        }
        return m_htModulePackages;
    }

    public static void readModulesToInstall() {
        String whichShouldDownload = "Partial";
        String hidePluginUpdate = "False";
        whichShouldDownload = SystemConfigManager.getSingleSetting(null, "WhichModuleToDownload", whichShouldDownload);
        hidePluginUpdate = SystemConfigManager.getSingleSetting(null, "HidePluginUpdate", hidePluginUpdate);
        Object pluginsFromConfigFile = null;
        boolean bDownloadAll = false;
        if (null != whichShouldDownload && whichShouldDownload.equalsIgnoreCase("All")) {
            bDownloadAll = true;
        }
        ModuleManager.readModulePackages();
        m_htModulePackagesToInstall = (Hashtable)ModuleManager.getModulePackages().clone();
        m_htModulePackagesToInstallclone = (Hashtable)ModuleManager.getModulePackages().clone();
        Enumeration ePackages = m_htModulePackagesToInstall.keys();
        Enumeration ePackages1 = m_htModulePackagesToInstallclone.keys();
        while (ePackages.hasMoreElements()) {
            boolean found = false;
            String sKey = (String)ePackages.nextElement();
            ModuleInfo mInfo = (ModuleInfo)m_htModulePackagesToInstall.get(sKey);
            ModuleInfo mInfo1 = (ModuleInfo)m_htModulePackagesToInstallclone.get(sKey);
            D.log("--------------------------");
            D.log("Module ID:      " + mInfo.m_sModuleID);
            D.log("New version: " + mInfo.m_sModuleVersion);
            D.log("Info Url:      " + mInfo.getInfo_url());
            Hashtable htInstalledModules = ModuleManager.getAllInstalledModules();
            Enumeration eLocalModules = htInstalledModules.keys();
            String sID = mInfo.getModuleID();
            while (eLocalModules.hasMoreElements()) {
                String sLocalID = (String)eLocalModules.nextElement();
                ModuleInfo tempModuleConfig = (ModuleInfo)htInstalledModules.get(sLocalID);
                sID = tempModuleConfig.getModuleID();
                String sVersion = tempModuleConfig.getModuleVersion();
                if (!mInfo.m_sModuleID.equalsIgnoreCase(sID)) continue;
                found = true;
                D.log("Old version: " + sVersion);
                VersionInfo objectVersion = new VersionInfo(sVersion);
                VersionInfo packageVersion = new VersionInfo(mInfo.m_sModuleVersion);
                if (packageVersion.compareTo(objectVersion) > 0) {
                    m_htModuleToUpgrade.put(sKey, sID);
                    VersionInfo hiddenModuleVersion = packageVersion;
                    String[] hiddenModules = SystemConfigManager.getSetting(null, "UpdatedPluginList");
                    String hiddenModuleTobeDeleted = null;
                    if (hiddenModules != null) {
                        for (int i = 0; i < hiddenModules.length; ++i) {
                            if (!hiddenModules[i].substring(0, hiddenModules[i].indexOf(".")).equals(mInfo.m_sModuleID)) continue;
                            hiddenModuleVersion = new VersionInfo(hiddenModules[i].substring(hiddenModules[i].indexOf(".") + 1, hiddenModules[i].length()));
                            hiddenModuleTobeDeleted = hiddenModules[i];
                        }
                    }
                    if (packageVersion.compareTo(hiddenModuleVersion) > 0) {
                        D.log("Available version is latest than the Hidden.So delete Hidden");
                        SystemConfigManager.removeSettingValue(null, "UpdatedPluginList", hiddenModuleTobeDeleted);
                    }
                    D.log("Needs upgraded");
                    break;
                }
                if (packageVersion.compareTo(objectVersion) < 0) {
                    ModuleManager.moveModuleToDeleted(sKey);
                    m_htModulePackagesToInstall.remove(sKey);
                    m_htModulePackagesToInstallclone.remove(sKey);
                    D.log("Moving to deleted directory");
                    break;
                }
                m_htModulePackagesToInstall.remove(sKey);
                m_htModulePackagesToInstallclone.remove(sKey);
                D.log("NO upgrade needed");
                break;
            }
            if (found) continue;
            D.log("Did not find.");
            if (bDownloadAll) {
                VersionInfo newModuleVersion;
                VersionInfo hiddenModuleVersion = newModuleVersion = new VersionInfo(mInfo.m_sModuleVersion);
                String[] hiddenModules = SystemConfigManager.getSetting(null, "UpdatedPluginList");
                String hiddenModuleTobeDeleted = null;
                if (hiddenModules != null) {
                    for (int i = 0; i < hiddenModules.length; ++i) {
                        if (!hiddenModules[i].substring(0, hiddenModules[i].indexOf(".")).equals(mInfo.m_sModuleID)) continue;
                        hiddenModuleVersion = new VersionInfo(hiddenModules[i].substring(hiddenModules[i].indexOf(".") + 1, hiddenModules[i].length()));
                        hiddenModuleTobeDeleted = hiddenModules[i];
                    }
                }
                if (newModuleVersion.compareTo(hiddenModuleVersion) > 0) {
                    D.log("Available version is latest than the Hidden.So delete Hidden");
                    SystemConfigManager.removeSettingValue(null, "UpdatedPluginList", hiddenModuleTobeDeleted);
                    if (m_htHiddenModules.containsKey(hiddenModuleTobeDeleted.substring(0, hiddenModuleTobeDeleted.indexOf(".")))) {
                        ModuleManager.removeFromHiddenModules(hiddenModuleTobeDeleted.substring(0, hiddenModuleTobeDeleted.indexOf(".")));
                    }
                }
                D.log("New module available");
                continue;
            }
            m_htModulePackagesToInstall.remove(sKey);
            m_htModulePackagesToInstallclone.remove(sKey);
            D.log("NO upgrade needed");
        }
    }

    public static Hashtable getModulesToInstall() {
        if (!m_bUpdatingModulesToInstall && m_htModulePackagesToInstall == null) {
            ModuleManager.readModulesToInstall();
        }
        return m_htModulePackagesToInstall;
    }

    public static Hashtable getModulesToInstallPluginDependency() {
        return m_htModulePackagesToInstallclone;
    }

    public static Hashtable getModulesToUpgrade() {
        return m_htModuleToUpgrade;
    }

    public static File getPackagesDir() {
        File fPackagesDir = new File(WebappUtil.getRealPath((String)"/") + "packages/");
        return fPackagesDir;
    }

    public static ArrayList getManifestFiles() {
        ArrayList mfFiles = new ArrayList();
        ModuleManager.addManifestFiles(mfFiles);
        return mfFiles;
    }

    protected static void addManifestFiles(ArrayList mfFiles) {
        File[] moduleDirectories;
        File modulesParentDirectory = !isInsideiManager ? new File(webAppContextPathIfNotInsideiManager + File.separator + "WEB-INF/modules/") : new File(WebappUtil.getRealPath((String)"/") + "WEB-INF/modules/");
        if (modulesParentDirectory != null && modulesParentDirectory.isDirectory() && (moduleDirectories = modulesParentDirectory.listFiles()) != null) {
            for (int i = 0; i < moduleDirectories.length; ++i) {
                File moduleDirectory = moduleDirectories[i];
                if (!moduleDirectory.isDirectory()) continue;
                File pluginDirectory = new File(moduleDirectory, "META-INF");
                ModuleManager.addPluginDirRecursive(pluginDirectory, mfFiles);
            }
        }
    }

    static void addPluginDirRecursive(File dir, ArrayList mfFiles) {
        File[] children;
        if (dir.exists() && (children = dir.listFiles()) != null) {
            for (int j = 0; j < children.length; ++j) {
                File f = children[j];
                if (f.isFile() && f.getName().toLowerCase().endsWith("mf")) {
                    mfFiles.add(f);
                    continue;
                }
                if (!f.isDirectory()) continue;
                ModuleManager.addPluginDirRecursive(f, mfFiles);
            }
        }
    }

    public static void getNPMInfo(String sZipFile, ModuleInfo mInfo) {
        File fModule = new File(sZipFile);
        mInfo.m_sModuleID = "";
        ZipFile zipFile = null;
        InputStream inputStream = null;
        if (fModule.canRead() && fModule.length() > 0L) {
            try {
                zipFile = new ZipFile(fModule);
                String tmp = "META-INF/MANIFEST.MF";
                ZipEntry ze = zipFile.getEntry(tmp);
                if (null == ze) {
                    D.log("The NPM file " + zipFile.getName() + " does not have an acceptable path or name for manifest file, (has to be: WEB-INF/modules/<plugin>/META-INF/MANIFEST.MF)");
                    ze = zipFile.getEntry(tmp.toLowerCase());
                    if (null == ze) {
                        mInfo.m_sTitle = zipFile.getName();
                        mInfo.m_sModuleID = zipFile.getName();
                        mInfo.m_sModuleVersion = "Unknown";
                        zipFile.close();
                        return;
                    }
                }
                D.log("----------------------------------------------------------------------------------------------");
                D.log("Reading the manifest file for: " + zipFile.getName());
                inputStream = zipFile.getInputStream(ze);
                ModuleManager.getNPMInfoFromManifest(inputStream, mInfo);
                if (null != zipFile) {
                    D.log("Done reading manifest file, closing zip file: " + zipFile.getName());
                    zipFile.close();
                }
            }
            catch (Throwable t) {
                try {
                    D.log("Error in NPM file: " + sZipFile);
                    D.log(t);
                    if (null != zipFile) {
                        zipFile.close();
                    }
                }
                catch (IOException e) {
                    D.log("Error in NPM file: " + sZipFile);
                    D.log(e);
                }
            }
        }
    }

    private static void getNPMInfoFromManifest(InputStream inputStream, ModuleInfo mInfo) throws IOException {
        mInfo.m_sModuleID = "";
        BufferedReader reader = null;
        String sVendor = null;
        String sKey = "";
        String sValue = "";
        reader = new BufferedReader(new InputStreamReader(inputStream));
        String sLine = reader.readLine();
        while (null != sLine && sLine != null && sLine.length() != 0) {
            int iIndex = sLine.indexOf(58);
            if (iIndex > 0) {
                sKey = sLine.substring(0, iIndex);
                sValue = sLine.substring(iIndex + 1).trim();
                if (sKey.equalsIgnoreCase("Implementation-Version")) {
                    mInfo.m_sModuleVersion = sValue;
                } else if (sKey.equalsIgnoreCase("Module-ID")) {
                    mInfo.m_sModuleID = sValue;
                } else if (sKey.equalsIgnoreCase("Implementation-Title")) {
                    mInfo.m_sTitle = sValue;
                } else if (sKey.equalsIgnoreCase("Implementation-Vendor")) {
                    sVendor = sValue;
                } else if (sKey.equalsIgnoreCase("Implementation-Description")) {
                    mInfo.m_sDescription = sValue;
                } else if (sKey.equalsIgnoreCase("Supported-OS")) {
                    mInfo.setSupportedOSTypes(sValue);
                } else if (sKey.equalsIgnoreCase("Min-iManager-Version")) {
                    mInfo.setMinRequiredVersion(sValue);
                } else if (sKey.equalsIgnoreCase("Max-iManager-Version")) {
                    mInfo.setMaxRequiredVersion(sValue);
                } else if (sKey.equalsIgnoreCase("Depends-on")) {
                    String[] sValuetemp = sValue.split(",");
                    for (int i = 0; i < sValuetemp.length; ++i) {
                        mInfo.setDependsOn(sValuetemp[i]);
                    }
                }
            } else if (sKey.equalsIgnoreCase("Implementation-Description")) {
                if (sLine.startsWith(" ")) {
                    sLine = sLine.substring(1);
                }
                sLine = sLine.replaceAll("\t", " ");
                sLine = sLine.replaceAll("\r", " ");
                mInfo.m_sDescription = sValue + sLine;
            }
            sLine = reader.readLine();
        }
        if (mInfo.m_sModuleID.length() == 0 && null != sVendor && null != mInfo.m_sTitle) {
            mInfo.m_sModuleID = sVendor + ": " + mInfo.m_sTitle;
        }
        if (mInfo.m_sModuleVersion.length() == 0) {
            mInfo.m_sModuleVersion = "Unknown";
        }
        reader.close();
        inputStream.close();
    }

    public static void moveModuleToDeleted(String sPackageName) {
        ModuleManager.moveModulesTo(sPackageName, "deleted");
    }

    public static void moveModulesTo(String sPackageName, String sDir) {
        if (sPackageName == null || sPackageName.length() == 0) {
            return;
        }
        File fSrc = new File(ModuleManager.getPackagesDir(), sPackageName);
        if (fSrc != null && fSrc.exists()) {
            try {
                ZipFile zSrc = new ZipFile(fSrc);
                if (zSrc != null) {
                    zSrc.close();
                }
            }
            catch (Exception zSrc) {
                // empty catch block
            }
            File fDeleted = new File(ModuleManager.getPackagesDir(), sDir);
            try {
                File fDest;
                if (!fDeleted.exists()) {
                    fDeleted.mkdir();
                }
                if ((fDest = new File(ModuleManager.getPackagesDir(), sDir + "/" + sPackageName)).exists()) {
                    fDest.delete();
                }
                try {
                    fSrc.renameTo(fDest);
                }
                catch (Exception ee) {
                    System.out.println("-------------------");
                    System.out.println("Cannot rename file!");
                    System.out.println("-------------------");
                }
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    public static String getModulePackageName(String sModuleID) {
        ModuleManager.getModulePackages();
        return (String)m_htModulePackages.get(sModuleID);
    }

    public static void externalInstall(File sWebAppContextPath, File npmFile, File fJspPath) {
        ModuleManager.externalInstall(sWebAppContextPath, npmFile, fJspPath, true, "", "", "");
    }

    public static void externalInstall(File sWebAppContextPath, File npmFile, File fJspPath, boolean silentInstall) {
        ModuleManager.externalInstall(sWebAppContextPath, npmFile, fJspPath, silentInstall, "", "", "");
    }

    public static void externalInstall(File sWebAppContextPath, File npmFile, File fJspPath, String LOGIN_DN, String HOST, String PASSWORD) {
        ModuleManager.externalInstall(sWebAppContextPath, npmFile, fJspPath, true, LOGIN_DN, HOST, PASSWORD);
    }

    public static void externalInstall(File sWebAppContextPath, File npmFile, File fJspPath, boolean silentInstall, String LOGIN_DN, String HOST, String PASSWORD) {
        if (PASSWORD == null) {
            PASSWORD = "";
        }
        if (LOGIN_DN != null && HOST != null && !LOGIN_DN.equals("") && !HOST.equals("")) {
            ModuleManager.getServerCertificate(sWebAppContextPath, LOGIN_DN, HOST, PASSWORD);
        }
        webAppContextPathIfNotInsideiManager = sWebAppContextPath.getAbsolutePath();
        isInsideiManager = false;
        File fPackagesDir = new File(sWebAppContextPath.getAbsolutePath() + File.separator + "packages");
        Hashtable ht_dependencies = FwUtils.getDependencyModulesForExternalInstall(sWebAppContextPath, npmFile);
        LinkedHashSet locallyAvailableModules = (LinkedHashSet)ht_dependencies.get("availablemodules");
        LinkedHashSet installedModules = (LinkedHashSet)ht_dependencies.get("installedmodules");
        LinkedHashSet locallyNotAvailableModules = (LinkedHashSet)ht_dependencies.get("nonavailablemodules");
        String strAlldependentModules = "";
        String strLocallyAvailableModules = "";
        String strInstalledModules = "";
        String strLocallyNotAvailableModules = "";
        Iterator avilableItr = locallyAvailableModules.iterator();
        while (avilableItr.hasNext()) {
            String moduleId = ((ModuleInfo)avilableItr.next()).getModuleID();
            strAlldependentModules = strAlldependentModules + "  " + moduleId;
            strLocallyAvailableModules = strLocallyAvailableModules + "  " + moduleId;
        }
        Iterator installedItr = installedModules.iterator();
        while (installedItr.hasNext()) {
            String moduleId = ((ModuleInfo)installedItr.next()).getModuleID();
            strAlldependentModules = strAlldependentModules + "  " + moduleId;
            strInstalledModules = strInstalledModules + "  " + moduleId;
        }
        for (String moduleId : locallyNotAvailableModules) {
            strAlldependentModules = strAlldependentModules + "  " + moduleId;
            strLocallyNotAvailableModules = strLocallyNotAvailableModules + "  " + moduleId;
        }
        D.log("All dependent modules::::" + strAlldependentModules);
        D.log("All locally available modules::::" + strLocallyAvailableModules);
        D.log("All locally not available modules::::" + strLocallyNotAvailableModules);
        D.log("All installed modules::::" + strInstalledModules);
        String npmPath_SelectedModule = npmFile.getAbsolutePath();
        ZipFile zipFile = null;
        try {
            zipFile = new ZipFile(npmPath_SelectedModule);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        String zipName = zipFile.getName();
        ModuleInfo mInfoSelectedModule = new ModuleInfo();
        ModuleManager.getNPMInfo(zipName, mInfoSelectedModule);
        if (silentInstall) {
            for (ModuleInfo mInfo : locallyAvailableModules) {
                String npmFileName = mInfo.getFilename();
                File fNpmFileName = mInfo.getModuleID().equals(mInfoSelectedModule.getModuleID()) ? npmFile : new File(fPackagesDir, npmFileName);
                ModuleManager.doExternalInstall(sWebAppContextPath, fNpmFileName, fJspPath);
            }
        } else {
            boolean doNeedToPrompt = true;
            if (locallyAvailableModules.size() == 1 && locallyNotAvailableModules.isEmpty()) {
                doNeedToPrompt = false;
                System.out.println("All Modules needs to be installed::" + strAlldependentModules);
                if (!strInstalledModules.trim().equals("")) {
                    System.out.println("Dependent Modules already installed::" + strInstalledModules);
                }
                ModuleManager.doExternalInstall(sWebAppContextPath, npmFile, fJspPath);
            }
            if (locallyAvailableModules.size() > 1 || !locallyNotAvailableModules.isEmpty()) {
                System.out.println("All Modules needs to be installed::" + strAlldependentModules);
                if (!strInstalledModules.trim().equals("")) {
                    System.out.println("Dependent Modules already installed::" + strInstalledModules);
                }
                if (!strLocallyNotAvailableModules.trim().equals("")) {
                    System.out.println("Dependent Modules not available locally::" + strLocallyNotAvailableModules);
                }
            }
            if (doNeedToPrompt) {
                BufferedReader br = new BufferedReader(new InputStreamReader(System.in));
                String userChoice = null;
                while (true) {
                    System.out.print("\n1.Continue with installation of dependent modules that are locally available \n2.Continue with installation of only selected module \n3.Skip installation");
                    System.out.print("\n\nEnter your choice:");
                    try {
                        userChoice = br.readLine();
                    }
                    catch (IOException ioe) {
                        System.out.println("IO error trying to read your name!");
                        System.exit(1);
                    }
                    if (userChoice.trim().equals("1")) {
                        for (ModuleInfo mInfo : locallyAvailableModules) {
                            String npmFileName = mInfo.getFilename();
                            File fNpmFileName = mInfo.getModuleID().equals(mInfoSelectedModule.getModuleID()) ? npmFile : new File(fPackagesDir, npmFileName);
                            ModuleManager.doExternalInstall(sWebAppContextPath, fNpmFileName, fJspPath);
                        }
                        break;
                    }
                    if (userChoice.trim().equals("2")) {
                        D.log("Installing only selected module");
                        ModuleManager.doExternalInstall(sWebAppContextPath, npmFile, fJspPath);
                        break;
                    }
                    if (userChoice.trim().equals("3")) {
                        D.log("Installation skipped");
                        break;
                    }
                    System.out.println("\nPlease enter correct choice");
                }
            }
        }
    }

    private static void doExternalInstall(File sWebAppContextPath, File npmFile, File fJspPath) {
        WebappUtil.init((String)sWebAppContextPath.getAbsolutePath());
        PortalModuleInstallManager installManager = new PortalModuleInstallManager(npmFile.getAbsolutePath(), sWebAppContextPath);
        installManager.getData(null);
        installManager.setInsideiManager(false);
        installManager.install(sWebAppContextPath.getAbsolutePath(), fJspPath.getAbsolutePath());
    }

    private static void getServerCertificate(File sWebAppContextPath, String LOGIN_DN, String HOST, String PASSWORD) {
        byte[] baCert = null;
        baCert = FwUtils.authenticateAndGetServerCertificate(LOGIN_DN, HOST, PASSWORD);
        if (baCert != null && baCert.length > 0) {
            try {
                ByteArrayInputStream baisCert = new ByteArrayInputStream(baCert);
                CertificateFactory certFact = CertificateFactory.getInstance("X.509");
                Collection<? extends Certificate> certCollection = certFact.generateCertificates(baisCert);
                X509Certificate[] x509Certs = new X509Certificate[certCollection.size()];
                certCollection.toArray(x509Certs);
                if (x509Certs.length >= 1) {
                    X509Certificate rootCertificate = x509Certs[x509Certs.length - 1];
                    rootCertificate.checkValidity();
                    File output = new File(sWebAppContextPath.getAbsolutePath() + File.separatorChar + "WEB-INF" + File.separatorChar + "ServerCert.der");
                    if (output.exists()) {
                        output.delete();
                    }
                    output = new File(sWebAppContextPath.getAbsolutePath() + File.separatorChar + "WEB-INF" + File.separatorChar + "ServerCert.der");
                    FileOutputStream out = new FileOutputStream(output);
                    out.write(rootCertificate.getEncoded());
                    out.flush();
                    out.close();
                }
            }
            catch (Throwable e) {
                e.printStackTrace();
            }
        }
    }

    public static void externalUninstall(File sWebAppContextPath, String npmFileName) {
        WebappUtil.init((String)sWebAppContextPath.getAbsolutePath());
        PortalModuleInstallManager installManager = new PortalModuleInstallManager(npmFileName, sWebAppContextPath);
        installManager.setInsideiManager(false);
        installManager.uninstall(sWebAppContextPath.getAbsolutePath(), npmFileName);
    }

    public static boolean areNewModulesPresent() {
        String[] hiddenModules = SystemConfigManager.getSetting(null, "UpdatedPluginList");
        if (m_htModulePackagesToInstall != null && m_htModulePackagesToInstall.size() != 0) {
            return hiddenModules == null || m_htModulePackagesToInstall.size() != hiddenModules.length;
        }
        return false;
    }

    public static String getNpmFileName(String sModuleID) {
        String sNpmFile = (String)m_htModuleIDtoNPM.get(sModuleID);
        return sNpmFile;
    }

    public static String getiManagerVersion() {
        String strImanVer;
        block3: {
            strImanVer = "2.7.0";
            ResourceBundle rb = null;
            try {
                rb = ResourceBundle.getBundle("com.novell.emframe.version");
                if (rb != null) {
                    strImanVer = rb.getString("version");
                }
            }
            catch (Exception e) {
                Log.log((String)DT, (int)2, (Throwable)e);
                if (!(e instanceof MissingResourceException)) break block3;
                strImanVer = "2.7.0";
            }
        }
        return strImanVer;
    }

    public static void resetCache(boolean flag) {
        m_bResetCache = flag;
    }

    private static void addModuleInfo(ModuleInfo mInfo) {
        if (m_htModulePackages.containsKey(mInfo.getModuleID())) {
            VersionInfo oldVersion;
            ModuleInfo modInfo = (ModuleInfo)m_htModulePackages.get(mInfo.getModuleID());
            VersionInfo newVersion = new VersionInfo(mInfo.getModuleVersion());
            if (newVersion.compareTo(oldVersion = new VersionInfo(modInfo.getModuleVersion())) > 0) {
                if (mInfo.getModuleTitle() == null || mInfo.getModuleTitle().length() == 0) {
                    mInfo.setModuleTitle(mInfo.getModuleID() + " ***");
                }
                ModuleInfo oldModInfo = m_htModulePackages.put(mInfo.getModuleID(), mInfo);
                D.log("----------------------------------------------------------------------------------------------");
                D.log("   Replaced: " + oldModInfo.getModuleID() + " " + oldModInfo.getModuleVersion() + " " + (oldModInfo.isLocal() ? "local packages directory" : "download site") + " " + oldModInfo.getFilename());
                D.log("         With: " + mInfo.getModuleID() + " " + mInfo.getModuleVersion() + " " + (mInfo.isLocal() ? "local packages directory" : "download site") + " " + modInfo.getFilename());
            } else {
                D.log("----------------------------------------------------------------------------------------------");
                D.log(" Discarding: " + mInfo.getModuleID() + " " + mInfo.getModuleVersion() + " " + (mInfo.isLocal() ? "local packages directory" : "download site") + " " + modInfo.getFilename());
            }
        } else {
            if (mInfo.getModuleTitle() == null || mInfo.getModuleTitle().length() == 0) {
                mInfo.setModuleTitle(mInfo.getModuleID() + " ***");
            }
            m_htModulePackages.put(mInfo.getModuleID(), mInfo);
            D.log("----------------------------------------------------------------------------------------------");
            D.log("      Adding: " + mInfo.getModuleID() + " " + mInfo.getModuleVersion() + " " + (mInfo.isLocal() ? "local packages directory" : "download site") + " " + mInfo.getFilename());
        }
    }

    public static Hashtable getHiddenModules() {
        return m_htHiddenModules;
    }

    public static void addToHiddenModules(String key, Object moduleVal) {
        m_htHiddenModules.put(key, moduleVal);
    }

    public static void removeFromHiddenModules(String key) {
        m_htHiddenModules.remove(key);
    }

    public static Hashtable getShowModules() {
        return m_htShowHiddenModules;
    }

    public static void addToShowModules(String key, Object moduleVal) {
        m_htShowHiddenModules.put(key, moduleVal);
    }

    public static void removeFromShowModules(String key) {
        m_htShowHiddenModules.remove(key);
    }

    public static void setShowModules(Hashtable initModules) {
        m_htShowHiddenModules = initModules;
    }

    static {
        m_htHiddenModules = new Hashtable();
        m_htShowHiddenModules = new Hashtable();
        m_bResetCache = false;
        meetsCriteria = true;
        webAppContextPathIfNotInsideiManager = "";
        isInsideiManager = true;
    }
}

