/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.config;

import com.novell.emframe.dev.XmlUtils;
import java.util.Iterator;
import java.util.Vector;

public class Setting {
    private String m_sName = null;
    private Vector m_vValues = null;

    public Setting(String name, Vector values) {
        this.m_sName = name;
        this.m_vValues = values;
    }

    public String getName() {
        return this.m_sName;
    }

    public void setName(String name) {
        this.m_sName = name;
    }

    public Vector getValues() {
        return this.m_vValues;
    }

    public void setValues(Vector values) {
        this.m_vValues = values;
    }

    public void addValue(String value) {
        if (this.m_vValues == null) {
            this.m_vValues = new Vector();
        }
        int numValues = this.m_vValues.size();
        for (int i = 0; i < numValues; ++i) {
            String tempValue = (String)this.m_vValues.elementAt(i);
            if (!tempValue.equalsIgnoreCase(value)) continue;
            return;
        }
        this.m_vValues.add(value);
    }

    public void removeValue(String value) {
        if (this.m_vValues == null) {
            return;
        }
        int numValues = this.m_vValues.size();
        for (int i = 0; i < numValues; ++i) {
            String tempValue = (String)this.m_vValues.elementAt(i);
            if (!tempValue.equalsIgnoreCase(value)) continue;
            this.m_vValues.remove(i);
            return;
        }
    }

    public Setting copy() {
        Setting s = new Setting(this.getName(), (Vector)this.getValues().clone());
        return s;
    }

    public String toXMLString() {
        String data = "";
        data = data + "<setting>\n";
        data = data + "<name><![CDATA[" + XmlUtils.xmlEncode(this.m_sName) + "]]>" + "</" + "name" + ">\n";
        for (int i = 0; i < this.m_vValues.size(); ++i) {
            String value = (String)this.m_vValues.elementAt(i);
            data = data + "<value><![CDATA[" + XmlUtils.xmlEncode(value) + "]]>" + "</" + "value" + ">\n";
        }
        data = data + "</setting>\n";
        return data;
    }

    public String toString() {
        String data = new String();
        data = data + "={";
        Iterator iterValues = this.m_vValues.iterator();
        while (iterValues.hasNext()) {
            String value = (String)iterValues.next();
            data = data + value;
            if (!iterValues.hasNext()) continue;
            data = data + ", ";
        }
        data = data + "}";
        return data;
    }
}

