/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.filter;

import com.novell.emframe.dev.D;
import com.novell.emframe.fw.servlet.AuthenticatorServlet;
import com.novell.emframe.fw.servlet.FwSession;
import java.io.BufferedReader;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.PrintWriter;
import java.security.NoSuchAlgorithmException;
import java.security.SecureRandom;
import java.util.HashSet;
import java.util.Locale;
import java.util.Set;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ReadListener;
import javax.servlet.ServletException;
import javax.servlet.ServletInputStream;
import javax.servlet.ServletOutputStream;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.WriteListener;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpServletResponseWrapper;
import javax.servlet.http.HttpSession;
import org.apache.commons.fileupload.MultipartStream;

public final class AntiCsrfServletFilter
implements Filter {
    private static final String IMAN_ANTICSRF_LOGOUT_REQUEST = "iManAntiCSRF.LogoutRequest";
    private static final String IMAN_ANTICSRF_INVALID_TOKEN = "invalidToken";
    private static final String IMAN_ANTI_CSRF_NO_INSERT_ID = "iManAntiCSRF.NoInsertID";
    private static final String ESCAPE_QUOTE = "EscapeQuote";
    private static final String EXCLUSION = "Exclusion";
    private static final String IGNORE_RESPONSE = "IgnoreResponse";
    private static final String JSESSION_ID = ";jsessionid=";
    public static final String ACSRF_ID = "imanuasess";
    public static final String ACSRF_VALIDATOR_ID = "iManAntiCSRF.NoValidation";
    private static SecureRandom g_rand;
    private boolean m_escapeQuote = false;
    private Set<String> m_exclusion = new HashSet<String>();
    private boolean m_ignoreResponse = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static String generateId() {
        SecureRandom secureRandom = g_rand;
        synchronized (secureRandom) {
            return String.valueOf(g_rand.nextLong());
        }
    }

    public void destroy() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static String getAcsrfIdFromSession(HttpSession session) {
        String id;
        HttpSession httpSession = session;
        synchronized (httpSession) {
            id = (String)session.getAttribute(ACSRF_ID);
            if (null == id) {
                id = AntiCsrfServletFilter.generateId();
                assert (id != null);
                session.setAttribute(ACSRF_ID, (Object)id);
            }
        }
        return id;
    }

    public void doFilter(ServletRequest req, ServletResponse res, FilterChain fc) throws IOException, ServletException {
        HttpServletRequest oriRequest = (HttpServletRequest)req;
        oriRequest.setCharacterEncoding("UTF-8");
        HttpServletResponse oriResponse = (HttpServletResponse)res;
        boolean isLogoutRequest = false;
        String requestURI = oriRequest.getRequestURI();
        if (null != oriRequest.getParameter(ACSRF_VALIDATOR_ID) && oriRequest.getParameter(ACSRF_VALIDATOR_ID).equalsIgnoreCase("true")) {
            fc.doFilter((ServletRequest)oriRequest, (ServletResponse)oriResponse);
            return;
        }
        if (null != requestURI && (requestURI.toLowerCase().endsWith(".jpeg") || requestURI.endsWith(".png") || requestURI.endsWith(".gif") || requestURI.endsWith(".css"))) {
            fc.doFilter((ServletRequest)oriRequest, (ServletResponse)oriResponse);
            return;
        }
        if (null != requestURI && (requestURI.toLowerCase().endsWith(".tld") || requestURI.toLowerCase().endsWith(".jpg"))) {
            fc.doFilter((ServletRequest)oriRequest, (ServletResponse)oriResponse);
            return;
        }
        if (null != requestURI && requestURI.toLowerCase().endsWith(".html") && requestURI.toLowerCase().contains("/help/")) {
            fc.doFilter((ServletRequest)oriRequest, (ServletResponse)oriResponse);
            return;
        }
        if (null != requestURI && requestURI.toLowerCase().endsWith("tiny_mce.js")) {
            fc.doFilter((ServletRequest)oriRequest, (ServletResponse)oriResponse);
            return;
        }
        this.insertCacheControl(requestURI, oriResponse);
        if (null != oriRequest.getParameter("fw.exit") && oriRequest.getParameter("fw.exit").equalsIgnoreCase("true")) {
            isLogoutRequest = true;
        }
        if (oriRequest.getMethod().equalsIgnoreCase("HEAD")) {
            fc.doFilter((ServletRequest)oriRequest, (ServletResponse)oriResponse);
            return;
        }
        if (oriResponse.containsHeader("ignoreResponse")) {
            fc.doFilter((ServletRequest)oriRequest, (ServletResponse)oriResponse);
            return;
        }
        if (oriRequest.getParameterMap().containsKey("taskId") && oriRequest.getParameter("taskId").trim().equalsIgnoreCase("base.CreateUser") && !oriRequest.getMethod().equalsIgnoreCase("POST")) {
            oriResponse.sendError(403);
            return;
        }
        for (String s : this.m_exclusion) {
            String oriRequestURLStripped;
            String oriRequestURL = oriRequest.getRequestURL().toString();
            String string = oriRequestURLStripped = oriRequestURL.indexOf(JSESSION_ID) == -1 ? oriRequestURL : oriRequestURL.substring(0, oriRequestURL.indexOf(JSESSION_ID));
            if (null == s || s.length() <= 0 || !oriRequestURLStripped.contains(s)) continue;
            fc.doFilter((ServletRequest)oriRequest, (ServletResponse)oriResponse);
            return;
        }
        Object request = oriRequest;
        String sessionAcsrfId = AntiCsrfServletFilter.getAcsrfIdFromSession(oriRequest.getSession());
        String acsrfToken_Headers = oriRequest.getHeader(ACSRF_ID);
        String acsrfToken_Header = null;
        if (acsrfToken_Headers != null) {
            acsrfToken_Header = acsrfToken_Headers.split(",")[0];
        }
        if ((!oriRequest.getMethod().equalsIgnoreCase("GET") || null != oriRequest.getParameter("taskId") && oriRequest.getParameter("taskId").equalsIgnoreCase("fw.SetPassword")) && !sessionAcsrfId.equalsIgnoreCase(acsrfToken_Header)) {
            String requestAcsrfId;
            if (this.ifMultipartRequest(oriRequest)) {
                byte[] reqContent = this.getRequestContent(oriRequest);
                String type = oriRequest.getContentType();
                requestAcsrfId = this.getAcsrfIdFromRequestContent(type, reqContent);
                request = new AcsrfRequestWrapper(oriRequest, reqContent);
            } else {
                requestAcsrfId = this.getAcsrfIdFromRequestParam(oriRequest);
            }
            if (!sessionAcsrfId.equals(requestAcsrfId)) {
                D.log("Potential CSRF(Cross-site Request Forgery) detected against " + requestURI + "?" + oriRequest.getQueryString() + ". Session has been logged out.", 1);
                request.setAttribute(IMAN_ANTICSRF_INVALID_TOKEN, (Object)"true");
                this.logout((HttpServletRequest)request, oriResponse);
                isLogoutRequest = true;
                oriRequest.setAttribute(IMAN_ANTICSRF_LOGOUT_REQUEST, (Object)"true");
            }
        }
        if (isLogoutRequest) {
            oriRequest.getSession().removeAttribute(ACSRF_ID);
            sessionAcsrfId = AntiCsrfServletFilter.getAcsrfIdFromSession(oriRequest.getSession());
        }
        if (this.m_ignoreResponse || "true".equalsIgnoreCase(oriRequest.getParameter(IMAN_ANTI_CSRF_NO_INSERT_ID))) {
            fc.doFilter((ServletRequest)request, (ServletResponse)oriResponse);
            return;
        }
        AcsrfResponseWrapper resWrapper = new AcsrfResponseWrapper(oriResponse);
        fc.doFilter((ServletRequest)request, (ServletResponse)resWrapper);
        if (resWrapper.isCommitted()) {
            return;
        }
        String contType = resWrapper.getContentType();
        if (null != contType && (contType.equalsIgnoreCase("application/octet-stream") || contType.equalsIgnoreCase("Novell/WebAccess-eMFrameNative"))) {
            ServletOutputStream outputStream = oriResponse.getOutputStream();
            outputStream.write(resWrapper.getData());
            outputStream.close();
        } else {
            this.insertID(resWrapper, oriResponse, sessionAcsrfId);
        }
        oriResponse.flushBuffer();
    }

    public void init(FilterConfig conf) {
        this.m_escapeQuote = Boolean.parseBoolean(conf.getInitParameter(ESCAPE_QUOTE));
        this.m_ignoreResponse = Boolean.parseBoolean(conf.getInitParameter(IGNORE_RESPONSE));
        String exclusion = conf.getInitParameter(EXCLUSION);
        if (exclusion != null) {
            String[] rs;
            for (String s : rs = exclusion.split(",")) {
                this.m_exclusion.add(s);
            }
        }
    }

    private void insertCacheControl(String uri, HttpServletResponse res) {
        assert (uri != null);
        int i = uri.lastIndexOf(47);
        if (-1 != i) {
            uri = uri.substring(i);
        }
        if (uri.toLowerCase().endsWith(".js")) {
            res.addHeader("Cache-Control", "no-store");
            res.addHeader("Pragma", "no-cache");
        }
    }

    private byte[] getRequestContent(HttpServletRequest oriRequest) throws IOException {
        ServletInputStream sis = oriRequest.getInputStream();
        ByteArrayOutputStream bos = new ByteArrayOutputStream();
        byte[] buf = new byte[1024];
        int n = 0;
        do {
            if ((n = sis.read(buf)) == -1) continue;
            bos.write(buf, 0, n);
        } while (n != -1);
        return bos.toByteArray();
    }

    private boolean ifMultipartRequest(HttpServletRequest oriRequest) {
        String type = oriRequest.getContentType();
        return null != type && type.toLowerCase(new Locale("UTF-8")).startsWith("multipart/form-data");
    }

    private String getAcsrfIdFromRequestParam(HttpServletRequest oriRequest) {
        return oriRequest.getParameter(ACSRF_ID);
    }

    private String getAcsrfIdFromRequestContent(String type, byte[] content) {
        try {
            int boundaryIndex = type.indexOf("boundary=");
            byte[] boundary = type.substring(boundaryIndex + 9).getBytes("UTF-8");
            ByteArrayInputStream bis = new ByteArrayInputStream(content);
            MultipartStream multipartStream = new MultipartStream((InputStream)bis, boundary);
            boolean nextPart = multipartStream.skipPreamble();
            while (nextPart) {
                String headers = multipartStream.readHeaders().toLowerCase(new Locale("UTF-8"));
                int i = headers.indexOf("name=\"");
                if (i != -1 && headers.startsWith(ACSRF_ID.toLowerCase(new Locale("UTF-8")), i + 6)) {
                    ByteArrayOutputStream data = new ByteArrayOutputStream();
                    multipartStream.readBodyData((OutputStream)data);
                    return data.toString("UTF-8");
                }
                multipartStream.discardBodyData();
                nextPart = multipartStream.readBoundary();
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return null;
    }

    private void logout(HttpServletRequest req, HttpServletResponse res) throws ServletException {
        HttpSession sessionObj = req.getSession();
        FwSession session = null;
        session = sessionObj instanceof FwSession ? (FwSession)sessionObj : (FwSession)sessionObj.getAttribute("PORTAL_SESSION");
        if (session != null) {
            AuthenticatorServlet.logout((HttpSession)session, null);
        }
    }

    private void insertID(AcsrfResponseWrapper wrapper, HttpServletResponse oriResponse, String id) throws IOException {
        String content = new String(wrapper.getData(), "UTF-8");
        boolean isIDInserted = false;
        StringBuffer newContent = new StringBuffer();
        Pattern p = Pattern.compile("</[fF][oO][rR][mM]>");
        Matcher m = p.matcher(content);
        int beginIndex = 0;
        while (m.find()) {
            newContent.append(content.substring(beginIndex, m.start()));
            if (this.m_escapeQuote) {
                newContent.append(String.format("<input type=\\\"hidden\\\" name=\\\"%s\\\" value=\\\"%s\\\">", ACSRF_ID, id));
            } else {
                newContent.append(String.format("<input type=\"hidden\" name=\"%s\" value=\"%s\">", ACSRF_ID, id));
            }
            newContent.append(content.substring(m.start(), m.end()));
            beginIndex = m.end();
            isIDInserted = true;
        }
        newContent.append(content.substring(beginIndex));
        String strNewContent = newContent.toString();
        StringBuffer newContent1 = new StringBuffer();
        boolean isAjaxFound = false;
        int beginIndex1 = 0;
        try {
            Pattern p1 = Pattern.compile("[\\.][sS][eE][nN][dD][\\s]*[\\(]");
            Matcher m1 = p1.matcher(strNewContent);
            while (m1.find()) {
                String substring = strNewContent.substring(beginIndex1, m1.start());
                int lastIndexOf = this.getXMLHTTPRequestVarLastIndex(substring);
                String requestObjContent = substring.substring(lastIndexOf + 1, substring.length());
                Pattern p2 = Pattern.compile("[" + requestObjContent + "][\\.][oO][pP][eE][nN][\\s]*[\\(]");
                Matcher m2 = p2.matcher(substring);
                if (!m2.find()) continue;
                String appContent = requestObjContent + String.format(".setRequestHeader(\"%s\", \"%s\");\n", ACSRF_ID, id);
                newContent1.append(substring.substring(0, lastIndexOf + 1));
                newContent1.append(appContent);
                newContent1.append(substring.substring(lastIndexOf + 1, substring.length()));
                newContent1.append(strNewContent.substring(m1.start(), m1.end()));
                beginIndex1 = m1.end();
                isAjaxFound = true;
            }
        }
        catch (Exception p1) {
            // empty catch block
        }
        String strNewContent1 = null;
        if (isAjaxFound) {
            newContent1.append(strNewContent.substring(beginIndex1));
            strNewContent1 = newContent1.toString();
        } else {
            strNewContent1 = strNewContent;
        }
        if (isIDInserted || isAjaxFound) {
            oriResponse.setContentLength(strNewContent1.getBytes("UTF-8").length);
            PrintWriter out = oriResponse.getWriter();
            out.write(strNewContent1);
            out.close();
        } else {
            ServletOutputStream outputStream = oriResponse.getOutputStream();
            outputStream.write(wrapper.getData());
            outputStream.close();
        }
    }

    public int getXMLHTTPRequestVarLastIndex(String substring) {
        int colonIndex = substring.lastIndexOf(";");
        int newLineIndex = substring.lastIndexOf("\n");
        int catchIndex = substring.lastIndexOf("}");
        int openIndex = substring.lastIndexOf("{");
        if (newLineIndex > colonIndex && newLineIndex > catchIndex && newLineIndex > openIndex) {
            return newLineIndex;
        }
        if (catchIndex > newLineIndex && catchIndex > colonIndex && catchIndex > openIndex) {
            return catchIndex;
        }
        if (openIndex > newLineIndex && openIndex > colonIndex && openIndex > catchIndex) {
            return openIndex;
        }
        return colonIndex;
    }

    static {
        try {
            g_rand = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (NoSuchAlgorithmException e) {
            g_rand = new SecureRandom();
        }
    }

    private static class AcsrfResponseWrapper
    extends HttpServletResponseWrapper {
        private final ByteArrayOutputStream m_output = new ByteArrayOutputStream();
        private AcsrfServletOutputStream m_acsrfOutput = null;
        private String contType;
        private int contLength;
        private PrintWriter m_writer = null;

        public AcsrfResponseWrapper(HttpServletResponse response) {
            super(response);
        }

        public void setContentLength(int len) {
            this.contLength = len;
            super.setContentLength(len);
        }

        public int getContLength() {
            return this.contLength;
        }

        public void setContentType(String contentType) {
            this.contType = contentType;
            super.setContentType(contentType);
        }

        public String getContentType() {
            return this.contType;
        }

        public synchronized ServletOutputStream getOutputStream() {
            if (this.m_writer != null) {
                throw new IllegalStateException();
            }
            if (null == this.m_acsrfOutput) {
                this.m_acsrfOutput = new AcsrfServletOutputStream(this.m_output);
            }
            return this.m_acsrfOutput;
        }

        public synchronized PrintWriter getWriter() throws IOException {
            if (this.m_acsrfOutput != null) {
                throw new IllegalStateException();
            }
            if (null == this.m_writer) {
                this.m_writer = new PrintWriter(new OutputStreamWriter((OutputStream)this.m_output, "UTF-8"));
            }
            return this.m_writer;
        }

        public void flushBuffer() throws IOException {
        }

        public byte[] getData() {
            return this.m_output.toByteArray();
        }
    }

    private static class AcsrfRequestWrapper
    extends HttpServletRequestWrapper {
        private final ByteArrayInputStream m_input;
        private AcsrfServletInputStream m_acsrfInput = null;
        private BufferedReader m_reader = null;

        public AcsrfRequestWrapper(HttpServletRequest request, byte[] content) {
            super(request);
            this.m_input = new ByteArrayInputStream(content);
        }

        public synchronized ServletInputStream getInputStream() {
            if (this.m_reader != null) {
                throw new IllegalStateException();
            }
            if (null == this.m_acsrfInput) {
                this.m_acsrfInput = new AcsrfServletInputStream(this.m_input);
            }
            return this.m_acsrfInput;
        }

        public synchronized BufferedReader getReader() throws IOException {
            if (this.m_acsrfInput != null) {
                throw new IllegalStateException();
            }
            if (null == this.m_reader) {
                this.m_reader = new BufferedReader(new InputStreamReader((InputStream)this.m_input, "UTF-8"));
            }
            return this.m_reader;
        }
    }

    private static class AcsrfServletInputStream
    extends ServletInputStream {
        private final InputStream m_stream;

        public AcsrfServletInputStream(InputStream input) {
            this.m_stream = input;
        }

        public int read() throws IOException {
            return this.m_stream.read();
        }

        public boolean isFinished() {
            return false;
        }

        public boolean isReady() {
            return false;
        }

        public void setReadListener(ReadListener arg0) {
        }
    }

    private static class AcsrfServletOutputStream
    extends ServletOutputStream {
        private final OutputStream m_stream;

        public AcsrfServletOutputStream(OutputStream output) {
            this.m_stream = output;
        }

        public void write(int b) throws IOException {
            this.m_stream.write(b);
        }

        public boolean isReady() {
            return false;
        }

        public void setWriteListener(WriteListener arg0) {
        }
    }
}

