/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.filter;

import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletRequestWrapper;

public final class RequestWrapper
extends HttpServletRequestWrapper {
    private static final String EMPTY_STRING = "";
    private static final String AUTH_REGEX = "[_A-Za-z0-9#~&+^\\]\\[,\\s:$@.!]*";
    private static final String REGEX = "[_A-Za-z0-9-#~&+^\\]\\[,\\s:$@.!]*";
    private static final String STR_REGEX = "[_A-Za-z0-9~#+^\\]\\[,\\s:$-@.]*";
    private static final String CONTROL_REGEX = "[_A-Za-z0-9-~#\\s+^,\\]\\[:$@.!]*";
    private static final String JAVASCRIPT_REGEX = "^[_A-Za-z]*+[_A-Za-z0-9(),]*";

    public RequestWrapper(HttpServletRequest servletRequest) {
        super(servletRequest);
    }

    public String[] getParameterValues(String parameter) {
        String[] values = super.getParameterValues(parameter);
        if (values == null) {
            return null;
        }
        if (parameter.equalsIgnoreCase("script")) {
            return values;
        }
        int count = values.length;
        String[] encodedValues = new String[count];
        for (int i = 0; i < count; ++i) {
            String value = values[i];
            value = this.validateParameter(parameter, value);
            encodedValues[i] = this.cleanXSS(value);
        }
        return encodedValues;
    }

    public String getParameter(String parameter) {
        String value = super.getParameter(parameter);
        if (value == null) {
            return null;
        }
        if (parameter.equalsIgnoreCase("script")) {
            return value;
        }
        value = this.validateParameter(parameter, value);
        return this.cleanXSS(value);
    }

    public String validateParameter(String parameter, String value) {
        try {
            Pattern pat;
            Matcher matcher;
            if (parameter.equalsIgnoreCase("OS.QueryWidth")) {
                if (null != value && value.length() > 0) {
                    Integer.parseInt(value);
                }
            } else if (parameter.equalsIgnoreCase("OS.ResultsPerPage")) {
                if (null != value && value.length() > 0) {
                    Integer.parseInt(value);
                }
            } else if (parameter.equalsIgnoreCase("OS.MultiSelect") || parameter.equalsIgnoreCase("OS.SearchSubContainers") || parameter.equalsIgnoreCase("OS.SearchOnStartup") || parameter.equalsIgnoreCase("OS.ShowSubClasses")) {
                if (null != value && value.length() > 0 && !value.equalsIgnoreCase("true") && !value.equalsIgnoreCase("false")) {
                    value = EMPTY_STRING;
                }
            } else if (parameter.equalsIgnoreCase("taskId") || parameter.equalsIgnoreCase("bookId") || parameter.equalsIgnoreCase("nextState")) {
                Pattern pat2 = Pattern.compile(STR_REGEX);
                Matcher matcher2 = pat2.matcher(value);
                if (!matcher2.matches()) {
                    value = EMPTY_STRING;
                }
            } else if (parameter.equalsIgnoreCase("OS.CallBack")) {
                Pattern pat3 = Pattern.compile(JAVASCRIPT_REGEX);
                Matcher matcher3 = pat3.matcher(value);
                if (!matcher3.matches()) {
                    value = EMPTY_STRING;
                }
            } else if (parameter.equalsIgnoreCase("OS.Control")) {
                Pattern pat4 = Pattern.compile(CONTROL_REGEX);
                Matcher matcher4 = pat4.matcher(value);
                if (!matcher4.matches()) {
                    value = EMPTY_STRING;
                }
            } else if (parameter.equalsIgnoreCase("OS.AuthName")) {
                Pattern pat5 = Pattern.compile(AUTH_REGEX);
                Matcher matcher5 = pat5.matcher(value);
                if (!matcher5.matches()) {
                    value = EMPTY_STRING;
                }
            } else if ((parameter.equalsIgnoreCase("merge") || parameter.equalsIgnoreCase("OS.InitialContext")) && !(matcher = (pat = Pattern.compile(REGEX)).matcher(value)).matches()) {
                value = EMPTY_STRING;
            }
        }
        catch (NumberFormatException e) {
            value = EMPTY_STRING;
        }
        return value;
    }

    public String getHeader(String name) {
        String value = super.getHeader(name);
        if (value == null) {
            return null;
        }
        return this.cleanXSS(value);
    }

    public String cleanXSSMultiPart(String param) {
        if (param == null) {
            return null;
        }
        return this.cleanXSS(param);
    }

    private String cleanXSS(String value) {
        value = value.replaceAll("[a-zA-Z0-9_]+(?i)console.log\\([ -~]*\\)", EMPTY_STRING);
        value = value.replaceAll("[a-zA-Z0-9_]+(?i).concat\\([ -~]*\\)", EMPTY_STRING);
        value = value.replaceAll("[a-zA-Z0-9_]+(?i).slice\\([ -~]*\\)", EMPTY_STRING);
        value = value.replaceAll("[a-zA-Z0-9_]+(?i).substring\\([ -~]*\\)", EMPTY_STRING);
        value = value.replaceAll("[a-zA-Z0-9_]+(?i).substr\\([ -~]*\\)", EMPTY_STRING);
        value = value.replaceAll("[a-zA-Z0-9_]+(?i).split\\([ -~]*\\)", EMPTY_STRING);
        value = value.replaceAll("[a-zA-Z0-9_]+(?i).replace\\([ -~]*\\)", EMPTY_STRING);
        value = value.replaceAll("[a-zA-Z0-9_]+(?i).replaceAll\\([ -~]*\\)", EMPTY_STRING);
        value = value.replaceAll("([\\s]+|[,]+|[;]+)(?:(?i)var(?:([\\s]+[a-zA-Z0-9_]+[ -~]*;)))", EMPTY_STRING);
        value = value.replaceAll("eval\\((.*)\\);?", EMPTY_STRING);
        value = value.replaceAll("[\\\"\\']?[\\s]*(?i)javascript:(.*)[\\\"\\']?", "\"\"");
        value = value.replaceAll("<(?i)script(\\s*)>", EMPTY_STRING);
        value = value.replaceAll("</(?i)script(\\s*)>", EMPTY_STRING);
        value = value.replaceAll("alert\\((.*)\\);?", EMPTY_STRING);
        value = value.replaceAll("prompt\\((.*)\\)?", EMPTY_STRING);
        value = value.replaceAll("confirm\\((.*)\\)?", EMPTY_STRING);
        value = value.replaceAll("%3C(?i)SCRIPT(\\s*)%3E", EMPTY_STRING);
        value = value.replaceAll("%3C/(?i)SCRIPT(\\s*)%3E", EMPTY_STRING);
        value = value.replaceAll("&lt;(?i)script(\\s*)&gt;", EMPTY_STRING);
        value = value.replaceAll("&lt;/(?i)script(\\s*)&gt;", EMPTY_STRING);
        value = value.replaceAll("<(?i)script>", EMPTY_STRING);
        value = value.replaceAll("</(?i)script>", EMPTY_STRING);
        value = value.replaceAll("<(\\s*)(?i)script>", EMPTY_STRING);
        value = value.replaceAll("<(?i)script(\\s*)>", EMPTY_STRING);
        value = value.replaceAll("</(?i)script(\\s*)>", EMPTY_STRING);
        value = value.replaceAll("&lt;(\\s*)(?i)script&gt;", EMPTY_STRING);
        value = value.replaceAll("&lt;(?i)script(\\s*)&gt;", EMPTY_STRING);
        value = value.replaceAll("&lt;/(?i)script(\\s*)&gt;", EMPTY_STRING);
        value = value.replaceAll("%3C(\\s*)(?i)script%3E", EMPTY_STRING);
        value = value.replaceAll("%3C(?i)script(\\s*)%3E", EMPTY_STRING);
        value = value.replaceAll("%3C/(?i)script(\\s*)%3E", EMPTY_STRING);
        value = value.replaceAll("&lt;(?i)script&gt;", EMPTY_STRING);
        value = value.replaceAll("&lt;/(?i)script&gt;", EMPTY_STRING);
        value = value.replaceAll("%3C(?i)script%3E", EMPTY_STRING);
        value = value.replaceAll("%3C/(?i)script%3E", EMPTY_STRING);
        value = value.replaceAll("%3c%2f(\\s*)(?i)script(\\s*)%3e", EMPTY_STRING);
        value = value.replaceAll("%3c%2f(\\s*)(?i)SCRIPT(\\s*)%3e", EMPTY_STRING);
        value = value.replaceAll("%3c(\\s*)(?i)script(\\s*)%3e", EMPTY_STRING);
        value = value.replaceAll("%3c(\\s*)(?i)SCRIPT(\\s*)%3e", EMPTY_STRING);
        value = value.replaceAll("%3C%2F(\\s*)(?i)script(\\s*)%3E", EMPTY_STRING);
        value = value.replaceAll("%3c%2f(\\s*)(?i)SCRIPT(\\s*)%3E", EMPTY_STRING);
        value = value.replaceAll("%3C(\\s*)(?i)script(\\s*)%3E", EMPTY_STRING);
        value = value.replaceAll("%3C(\\s*)(?i)SCRIPT(\\s*)%3E", EMPTY_STRING);
        value = value.replaceAll("alert%28(.*)%29;?", EMPTY_STRING);
        value = value.replaceAll("prompt%28(.*)%29?", EMPTY_STRING);
        value = value.replaceAll("confirm%28(.*)%29?", EMPTY_STRING);
        value = value.replaceAll("alert%28(.*)%29?", EMPTY_STRING);
        value = value.replaceAll("prompt%28(.*)%29;?", EMPTY_STRING);
        value = value.replaceAll("confirm%28(.*)%29?", EMPTY_STRING);
        value = value.replaceAll("alert%2528(.*)%2529;?", EMPTY_STRING);
        value = value.replaceAll("prompt%2528(.*)%2529?", EMPTY_STRING);
        value = value.replaceAll("confirm%2528(.*)%2529?", EMPTY_STRING);
        value = value.replaceAll("\\s*=\\s*prompt\\s*[,;]*\\s*", EMPTY_STRING);
        value = value.replaceAll("\\s*=\\s*confirm\\s*[,;]*\\s*", EMPTY_STRING);
        value = value.replaceAll("\\s*=\\s*eval\\s*[,;]*\\s*", EMPTY_STRING);
        value = value.replaceAll("\\s*=\\s*alert\\s*[,;]*\\s*", EMPTY_STRING);
        value = value.replaceAll("\\s*=\\s*window\\s*[,;]*\\s*", EMPTY_STRING);
        value = value.replaceAll("\\s*=\\s*document\\s*[,;]*\\s*", EMPTY_STRING);
        value = value.replaceAll("%253c%252f(\\s*)(?i)script(\\s*)%253e", EMPTY_STRING);
        value = value.replaceAll("%253c%252f(\\s*)(?i)SCRIPT(\\s*)%253e", EMPTY_STRING);
        value = value.replaceAll("%253c(\\s*)(?i)script(\\s*)%253e", EMPTY_STRING);
        value = value.replaceAll("%253c(\\s*)(?i)SCRIPT(\\s*)%253e", EMPTY_STRING);
        value = value.replaceAll("%253C%252F(\\s*)(?i)script(\\s*)%253E", EMPTY_STRING);
        value = value.replaceAll("%253c%252f(\\s*)(?i)SCRIPT(\\s*)%253E", EMPTY_STRING);
        value = value.replaceAll("%253C(\\s*)(?i)script(\\s*)%253E", EMPTY_STRING);
        value = value.replaceAll("%253C(\\s*)(?i)SCRIPT(\\s*)%253E", EMPTY_STRING);
        value = value.replaceAll("<(\\s*)(?i)script(.*)>", EMPTY_STRING);
        value = value.replaceAll("&lt;(\\s*)(?i)script(.*)&gt;", EMPTY_STRING);
        value = value.replaceAll("%253C(\\s*)(?i)script(.*)%253E", EMPTY_STRING);
        value = value.replaceAll("%3C(\\s*)(?i)script(.*)%3E", EMPTY_STRING);
        value = value.replaceAll("alert[(\\+*)*(\\s*)(%20*)]*\\((.*)\\);?", EMPTY_STRING);
        Pattern scriptPattern = Pattern.compile("src[ ]*[\r\n]*=[ ]*[\r\n]*\\'(.*?)\\'", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("src[ ]*[\r\n]*=[ ]*[\r\n]*\\\"(.*?)\\\"", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\'(.*?)\\'", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*\\\"(.*?)\\\"", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("src[\r\n]*=[\r\n]*(%22|%27)(.*?)(%22|%27)", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("src(.*?)[ \t\r\n %20]*(=|%3D|%3d|&#61;)[ \t\r\n %20]*('|\"|&#34;|&#39;|%27|%22)*(http|ftp)(.*?)", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("iframe", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("<script(.*?)>", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("eval\\((.*?)\\)", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("expression\\((.*?)\\)", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("javascript[ ]*:", 2);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("vbscript[ ]*:", 2);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("document\\.[^(<(?=\\/))|(\\/(?=>))|\"|'|>|:|;|,|\\s][a-zA-Z]*");
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("window\\.[^(<(?=\\/))|(\\/(?=>))|\"|'|>|:|;|,|\\s][a-zA-Z]*");
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("(<|%3C|%3c)(\\s)*object(.*)data", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("(<|%3C|%3c)(\\s)*img(\\s)*/(\\s)*src(\\s)*=(\\s)*.*", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("(<|%3C|%3c)(\\s)*img(\\s)*.*", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("onload[ ]*[\r\n]*=", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("onclick[ ]*[\r\n]*=", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        scriptPattern = Pattern.compile("onerror[ ]*[\r\n]*=", 42);
        value = scriptPattern.matcher(value).replaceAll(EMPTY_STRING);
        return value;
    }
}

