/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.ldap;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.AuditLog;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Locale;
import java.util.Properties;
import java.util.StringTokenizer;
import javax.naming.NamingException;
import javax.naming.ldap.Control;
import javax.naming.ldap.InitialLdapContext;

public class JndiLdapUtil {
    public static final String LDAP_SERVER_EDIR_SEMANTICS_OID = "2.16.840.1.113719.1.513.4.5";
    private static final String DEF_CLEARPORT = ":389";
    private static final String DEF_SSLPORT = ":636";
    private static final String KEYSTORE_SYSTEM = "system";
    private static final String KEYSTORE_IMANAGER = "imanager";
    private String[] ctxCreateKeystorePriorityArr = null;

    public InitialLdapContext createJNDILDAPContext(String userLdapName, String userPassword, String userLdapAccessDomain, String defClearPort, String defSSLPort, boolean trySSL, Properties additionalProps, Locale userLocale) throws PluginException {
        String portedAccessDomain;
        InitialLdapContext dirCtx = null;
        Properties ldapProperties = new Properties();
        Control eDirSemanticsControl = JndiLdapUtil.createSimpleControl(LDAP_SERVER_EDIR_SEMANTICS_OID);
        Control[] controls = null;
        if (eDirSemanticsControl != null) {
            controls = new Control[]{eDirSemanticsControl};
        }
        boolean usingSSL = false;
        if (trySSL) {
            if (this.ctxCreateKeystorePriorityArr == null) {
                SystemConfig sc = new SystemConfig();
                String keyStorePriority = sc.getSetting("Security.KeyStore.Priority", "system, imanager");
                this.ctxCreateKeystorePriorityArr = this.parseKeystorePriority(keyStorePriority);
            }
            if (this.ctxCreateKeystorePriorityArr.length > 0) {
                usingSSL = true;
            } else {
                usingSSL = false;
                D.log("Forcing clear text - no SSL - because KeyStore priority specified as empty");
            }
        }
        if (userLdapAccessDomain.toLowerCase().indexOf("ldap") >= 0 && userLdapAccessDomain.substring("ldap://".length()).indexOf(58) > 0) {
            portedAccessDomain = userLdapAccessDomain;
        } else if (userLdapAccessDomain.toLowerCase().indexOf("ldap") < 0 && userLdapAccessDomain.indexOf(58) >= 0 && !usingSSL) {
            portedAccessDomain = "ldap://" + userLdapAccessDomain;
        } else if (usingSSL) {
            String SSLportToUse;
            String string = SSLportToUse = defSSLPort == null ? DEF_SSLPORT : ":" + defSSLPort;
            portedAccessDomain = userLdapAccessDomain.toLowerCase().indexOf("ldap") >= 0 ? userLdapAccessDomain + SSLportToUse : "ldaps://" + userLdapAccessDomain + SSLportToUse;
        } else {
            String ClearportToUse = defClearPort == null ? DEF_CLEARPORT : ":" + defClearPort;
            portedAccessDomain = userLdapAccessDomain.toLowerCase().indexOf("ldap") >= 0 ? userLdapAccessDomain + ClearportToUse : "ldap://" + userLdapAccessDomain + ClearportToUse;
        }
        ldapProperties.put("java.naming.factory.initial", "com.sun.jndi.ldap.LdapCtxFactory");
        ldapProperties.put("java.naming.provider.url", portedAccessDomain);
        ldapProperties.put("java.naming.security.authentication", "simple");
        if (userLdapName != null) {
            ldapProperties.put("java.naming.security.principal", userLdapName);
        }
        if (userPassword != null) {
            ldapProperties.put("java.naming.security.credentials", userPassword);
        }
        ldapProperties.put("java.naming.ldap.version", "3");
        if (usingSSL) {
            ldapProperties.put("java.naming.security.protocol", "ssl");
        }
        if (additionalProps != null) {
            Enumeration<?> propNameEnum = additionalProps.propertyNames();
            while (propNameEnum.hasMoreElements()) {
                Object tKeyObj = propNameEnum.nextElement();
                if (tKeyObj instanceof String) {
                    String addPropKey = (String)tKeyObj;
                    String addPropVal = additionalProps.getProperty(addPropKey);
                    Object oldPropValue = ldapProperties.setProperty(addPropKey, addPropVal);
                    if (oldPropValue == null) continue;
                    String warnMsg1 = "WARNING: former property value for \"" + addPropKey + "\" has been replaced";
                    String warnMsg2 = "   old value: \"" + oldPropValue.toString() + "\"  replaced with new value\"" + addPropVal + "\"";
                    D.log(warnMsg1, 1);
                    D.log(warnMsg2, 1);
                    continue;
                }
                D.log("Compromised Properties object: " + tKeyObj.toString(), 1);
            }
        }
        int kpidx = 0;
        boolean contextCreated = false;
        while (!contextCreated) {
            if (usingSSL) {
                if (this.ctxCreateKeystorePriorityArr[kpidx].equals(KEYSTORE_SYSTEM)) {
                    ldapProperties.remove("java.naming.ldap.factory.socket");
                } else if (this.ctxCreateKeystorePriorityArr[kpidx].equals(KEYSTORE_IMANAGER)) {
                    ldapProperties.put("java.naming.ldap.factory.socket", "com.novell.emframe.fw.security.SSLSocketFactory_IM");
                }
            }
            try {
                dirCtx = new InitialLdapContext(ldapProperties, controls);
                contextCreated = true;
                dirCtx.setRequestControls(controls);
                if (usingSSL) {
                    this.ctxCreateKeystorePriorityArr = this.resetKeystorePriority(kpidx);
                }
            }
            catch (NamingException ne) {
                String errMsg;
                if (usingSSL) {
                    if (kpidx >= this.ctxCreateKeystorePriorityArr.length - 1) {
                        String displayLdapName = userLdapName != null ? userLdapName : "anonymous";
                        AuditLog.logFailedSSLConnection(displayLdapName, portedAccessDomain);
                        errMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.JNDICreateSSLLDAP", userLocale);
                        errMsg = errMsg + " " + ne.getExplanation();
                        throw new PluginException(null, errMsg, ne);
                    }
                }
                errMsg = eMFrameUtils.getLocalizedString("FwResources", "AuthenticateFailed.JNDICreateClearLDAP", userLocale);
                D.log(errMsg, 1);
                throw new PluginException(null, errMsg + ne.getExplanation(), ne);
            }
            ++kpidx;
        }
        return dirCtx;
    }

    public static Control createSimpleControl(String oid) {
        Control ctrl = null;
        Class[] strArgClass = new Class[]{String.class};
        Object[] strargArray = new Object[]{oid};
        try {
            Class<?> ctrlDefinition;
            try {
                ctrlDefinition = Class.forName("javax.naming.ldap.BasicControl");
            }
            catch (ClassNotFoundException e) {
                ctrlDefinition = Class.forName("com.sun.jndi.ldap.BasicControl");
            }
            Constructor<?> strArgConstructor = ctrlDefinition.getConstructor(strArgClass);
            ctrl = (Control)strArgConstructor.newInstance(strargArray);
        }
        catch (Exception e) {
            D.log("Unable to create eDirectory Semantics LDAP control.");
        }
        return ctrl;
    }

    private String[] parseKeystorePriority(String inkeystorePriority) {
        ArrayList<String> tkeyList = new ArrayList<String>();
        StringTokenizer st = new StringTokenizer(inkeystorePriority, ", \t\n\r\f");
        while (st.hasMoreTokens()) {
            String keystoreType = st.nextToken();
            if (keystoreType.equalsIgnoreCase(KEYSTORE_SYSTEM)) {
                tkeyList.add(KEYSTORE_SYSTEM);
                continue;
            }
            if (!keystoreType.equalsIgnoreCase(KEYSTORE_IMANAGER)) continue;
            tkeyList.add(KEYSTORE_IMANAGER);
        }
        String[] keystoreArr = new String[tkeyList.size()];
        keystoreArr = tkeyList.toArray(keystoreArr);
        return keystoreArr;
    }

    private String[] resetKeystorePriority(int bestIdx) {
        String[] newKeystorePriorityArr = new String[this.ctxCreateKeystorePriorityArr.length];
        newKeystorePriorityArr[0] = this.ctxCreateKeystorePriorityArr[bestIdx];
        int newi = 1;
        for (int curi = 0; curi < this.ctxCreateKeystorePriorityArr.length; ++curi) {
            if (curi == bestIdx) continue;
            newKeystorePriorityArr[newi] = this.ctxCreateKeystorePriorityArr[curi];
            ++newi;
        }
        return newKeystorePriorityArr;
    }
}

