/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.ldap;

import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthBrokerAuthenticator;
import com.novell.emframe.dev.AuthBrokerException;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.ManagementServiceSet;
import com.novell.emframe.dev.TaskContext;

public class NovellLdapAuthenticator
extends AuthBrokerAuthenticator {
    @Override
    public Object login(String name, String password, String accessDomain, ManagementServiceSet manageSS) throws AuthBrokerException {
        return null;
    }

    @Override
    public void logout(Object apiObject) {
    }

    public static String convertNdapNameToLdap(String name, TaskContext context) {
        if (name == null) {
            return name;
        }
        Object ndsNamespaceApiObj = context.getAuthenticationBroker().getAPIObject("NDSNamespace");
        if (ndsNamespaceApiObj == null) {
            D.assrt(false, "NovellLdapAuthenticator::Passing name as typed by user since ndsNamespaceApiObj is null.");
            return name;
        }
        ObjectEntry rootOe = (ObjectEntry)ndsNamespaceApiObj;
        NDSNamespace ns = (NDSNamespace)rootOe.getNamespace();
        try {
            ObjectEntry oe = ns.getObjectEntry(rootOe, name);
            String ldapName = ns.getFullyTypedName(oe);
            char[] ldapNameArray = ldapName.toCharArray();
            for (int len = 0; len < ldapNameArray.length; ++len) {
                if (ldapNameArray[len] == '.') {
                    ldapNameArray[len] = 44;
                    continue;
                }
                if (ldapNameArray[len] != '\\' || len >= ldapNameArray.length - 1 || ldapNameArray[len + 1] != '.') continue;
                ++len;
            }
            String newldapNameArray = new String(ldapNameArray);
            return newldapNameArray;
        }
        catch (Exception e) {
            D.log("NovellLdapAuthenticator::Passing name as typed by because of exception getting fully typed name.");
            D.log(e);
            return name;
        }
    }
}

