/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.servlet;

import com.novell.emframe.authDev.AuthDevUtils;
import com.novell.emframe.authDev.iMgrAuthenticatorImpl;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.Task;
import com.novell.emframe.dev.config.SystemConfig;
import com.novell.emframe.fw.DebugLogging;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.authenticator.AuthLoader;
import com.novell.emframe.fw.authenticator.FwAuthUtils;
import com.novell.emframe.fw.config.SystemConfigManager;
import com.novell.emframe.fw.servlet.FwRequest;
import com.novell.emframe.fw.servlet.InterfaceCfg;
import com.novell.emframe.fw.util.FwTaskUtils;
import com.novell.emframe.fw.util.ModuleGet;
import com.novell.nps.ServiceSyncLock;
import com.novell.nps.WebappUtil;
import com.novell.webaccess.common.Browser;
import com.novell.webaccess.common.I18NLocale;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.Locale;
import java.util.PropertyResourceBundle;
import java.util.Vector;
import javax.servlet.RequestDispatcher;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class AuthenticatorServlet
extends HttpServlet {
    private static final long serialVersionUID = 1L;
    private static final String COOKIE_IMANAGER_DEVICE_TYPE = "iManagerDeviceType";
    public static final String AUT_SRV_BWSR_I18NLOCALE = "BROWSER_I18NLocale";
    public static final String AUT_SRV_BWSR_MJRVER = "Browser.mjrVer";
    public static final String AUT_SRV_BWSR_MNRVER = "Browser.mnrVer";
    public static final String AUT_SRV_BWSR_NAME = "Browser.name";
    public static final String AUT_SRV_BWSR_NAME_UNDERSCORES = "Browser_name";
    public static final String AUT_SRV_BWSR_OS = "Browser.os";
    public static final String AUT_SRV_BWSR_ID = "Browser.id";
    public static final String AUT_SRV_BWSR_CHARSET = "Browser.charset";
    public static String THIS_SERVLET = "THIS_SERVLET";
    static Hashtable sm_threadMap = new Hashtable();
    static Locale m_svrLocale = Locale.getDefault();
    protected SystemConfig m_config = null;
    protected PropertyResourceBundle m_msgResources = null;
    protected String m_sAuth = null;
    private int m_respId;

    public void init() throws ServletException {
        WebappUtil.init((HttpServlet)this);
        this.m_config = new SystemConfig();
        this.initSettings();
    }

    public void destroy() {
        super.destroy();
    }

    private void initSettings() {
        if (this.m_config != null) {
            String sDescriptorUrl = SystemConfigManager.getSingleSetting(null, "ModuleDownloadDescriptorURL");
            if (null != sDescriptorUrl && sDescriptorUrl.length() > 0) {
                ModuleGet.setDescriptorUrl(sDescriptorUrl);
            }
            ModuleGet.startAsyncDownloadOfModuleDescriptor();
            AuthLoader.init(this.m_config);
            this.m_sAuth = this.m_config.getSetting("Authenticator");
            InterfaceCfg.getInstance().load();
        }
    }

    protected void handleJSLogService(HttpServletRequest req, HttpServletResponse resp) {
        String logMsg = req.getParameter("logMsg");
        if (logMsg != null) {
            DebugLogging.log(req);
        }
        try {
            resp.getWriter().print("success");
            resp.flushBuffer();
        }
        catch (IOException e) {
            D.log(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void service(HttpServletRequest originalReq, HttpServletResponse res) throws ServletException, IOException {
        if (originalReq.getServletPath().endsWith("/jslogservice")) {
            this.handleJSLogService(originalReq, res);
            return;
        }
        int respId = ++this.m_respId;
        D.log(">>>" + respId + "-------------------------------------------------------------------------");
        originalReq.setCharacterEncoding("utf-8");
        this.outputQueryString(originalReq);
        this.validateRequest(originalReq);
        ServiceSyncLock lock = null;
        FwRequest req = null;
        try {
            req = new FwRequest(originalReq, res);
            req.setAttribute("fw_respId", Integer.toString(respId));
            sm_threadMap.put(Thread.currentThread(), req);
            FwAttr.initFwSessionAttributes(req.getSession());
            FwAttr.setFwRequestAttribute(THIS_SERVLET, (Object)this, (HttpServletRequest)req);
            HttpSession session = this.getSession((HttpServletRequest)req);
            String sNeverTimeoutEnable = this.m_config.getSetting("NeverTimeoutEnable", "false");
            String sTimeoutInSeconds = this.m_config.getSetting("TimeoutInSeconds", "1800");
            if (sNeverTimeoutEnable.equals("true")) {
                session.setMaxInactiveInterval(-1);
            } else if (sNeverTimeoutEnable.equals("false")) {
                session.setMaxInactiveInterval(Integer.parseInt(sTimeoutInSeconds));
            }
            lock = (ServiceSyncLock)session.getAttribute("System.SessionLock");
            if (lock == null) {
                HttpSession httpSession = session;
                synchronized (httpSession) {
                    lock = (ServiceSyncLock)session.getAttribute("System.SessionLock");
                    if (lock == null) {
                        lock = new ServiceSyncLock();
                        session.setAttribute("System.SessionLock", (Object)lock);
                    }
                }
            }
            lock.lock();
            FwUtils.setRequestInSession((HttpServletRequest)req, session);
            boolean bResponseHandled = false;
            boolean bLoggedIn = false;
            this.setDeviceInterface((HttpServletRequest)req, res);
            if (AuthDevUtils.isLogoutRequest((HttpServletRequest)req)) {
                AuthenticatorServlet.logout(session, null);
                String[] postLogoutURL = this.m_config.getSettings("PostLogoutURL");
                if (postLogoutURL != null && postLogoutURL[0].equalsIgnoreCase("true")) {
                    res.sendRedirect(postLogoutURL[1]);
                    return;
                }
            }
            if (AuthDevUtils.isAntiCSRFLogoutRequest((HttpServletRequest)req)) {
                FwUtils.dispatchJsp("fw/AuthForm.jsp", (HttpServletRequest)req, res);
                String url = "portal";
                FwUtils.removeRequestFromSession(req.getSession());
                res.sendRedirect(url);
                return;
            }
            String sNPService = req.getParameter("NPService");
            if ("AuthenticationService".equals(sNPService)) {
                this.returnFakeAuthInfo((HttpServletRequest)req, res);
                return;
            }
            if (AuthenticatorServlet.isLoggedIn((HttpServletRequest)req)) {
                bLoggedIn = true;
            } else {
                bResponseHandled = false;
                String sUrl = req.getServletPath() + "?" + req.getQueryString();
                if (FwUtils.getTaskInstanceId((HttpServletRequest)req) != null) {
                    FwAttr.setFwSessionAttribute("AuthenticatorServlet.UrlAfterLogin", sUrl, req.getSession());
                }
                if (bLoggedIn = AuthenticatorServlet.login((HttpServletRequest)req, res)) {
                    String url = (String)FwAttr.getFwSessionAttribute("AuthenticatorServlet.UrlAfterLogin", req.getSession());
                    if (url != null) {
                        url = this.validateXss(url);
                        RequestDispatcher disp = req.getRequestDispatcher(url);
                        disp.forward((ServletRequest)req, (ServletResponse)res);
                        bResponseHandled = true;
                        FwAttr.removeFwSessionAttribute("AuthenticatorServlet.UrlAfterLogin", req.getSession());
                    }
                } else {
                    bResponseHandled = true;
                }
            }
            if (bLoggedIn && !bResponseHandled) {
                super.service((HttpServletRequest)req, res);
            }
        }
        catch (Throwable e) {
            D.log(e);
        }
        finally {
            sm_threadMap.remove(Thread.currentThread());
            FwUtils.removeRequestFromSession(req.getSession());
            lock.unlock();
            D.log("<<<" + respId + "-------------------------------------------------------------------------");
        }
    }

    private String validateXss(String value) {
        value = value.replaceAll("eval\\((.*)\\);?", "");
        value = value.replaceAll("[\\\"\\']?[\\s]*javascript:(.*)[\\\"\\']?", "\"\"");
        value = value.replaceAll("<(?i)script>", "");
        value = value.replaceAll("</(?i)script>", "");
        value = value.replaceAll("alert\\((.*)\\);?", "");
        value = value.replaceAll("%3C(?i)SCRIPT%3E", "");
        value = value.replaceAll("%3C/(?i)SCRIPT%3E", "");
        return value;
    }

    private void validateRequest(HttpServletRequest originalReq) {
        if (D.isDebugEnabled() && FwUtils.showDeveloperWarnings()) {
            String npservice = originalReq.getParameter("NPService");
            String taskId = originalReq.getParameter("taskId");
            String giid = originalReq.getParameter("GI_ID");
            String msg = "Request can only have one of the following parameters: taskId, GI_ID, or NPService.  These parameters mean the same thing and only one should be used (taskId).";
            if (npservice != null) {
                D.assrt(taskId == null && giid == null, msg);
            } else if (taskId != null) {
                D.assrt(npservice == null && giid == null, msg);
            } else if (giid != null) {
                D.assrt(taskId == null && npservice == null, msg);
            }
        }
    }

    private void returnFakeAuthInfo(HttpServletRequest req, HttpServletResponse res) throws ServletException, IOException {
        FwUtils.dispatchJsp("fw/AuthServiceSpoof.jsp", req, res);
    }

    public static boolean isLoggedIn(HttpServletRequest req) {
        iMgrAuthenticatorImpl[] aAuths = AuthenticatorServlet.getRequiredAuthenticators(req, true);
        for (int i = 0; i < aAuths.length; ++i) {
            if (aAuths[i].isAuthenticated(req)) continue;
            return false;
        }
        return true;
    }

    public static boolean login(HttpServletRequest req, HttpServletResponse resp) {
        iMgrAuthenticatorImpl[] aAuths = AuthenticatorServlet.getRequiredAuthenticators(req, true);
        for (int i = 0; i < aAuths.length; ++i) {
            if (aAuths[i].isAuthenticated(req) || aAuths[i].handleLogin(req, resp)) continue;
            return false;
        }
        return true;
    }

    public static void logout(HttpSession session, HashMap hashAuths) {
        if (hashAuths == null) {
            hashAuths = FwAuthUtils.getSessionAuthenticators(session);
        }
        if (hashAuths != null) {
            iMgrAuthenticatorImpl auth2 = null;
            for (iMgrAuthenticatorImpl auth2 : hashAuths.values()) {
                auth2.logout();
            }
            HashSet authNamesSet = new HashSet(hashAuths.keySet());
            for (String sAuthName : authNamesSet) {
                auth2 = (iMgrAuthenticatorImpl)hashAuths.remove(sAuthName);
                auth2.destroy();
            }
        }
        FwTaskUtils.clearAllTasks(session);
        FwAttr.clearFwSessionAttributesOnLogout(session);
    }

    protected HttpSession getSession(HttpServletRequest req) {
        HttpSession session = req.getSession(true);
        if (session.isNew() || session.getAttribute("LiveSession") == null) {
            I18NLocale i18nLocale = new I18NLocale(req);
            session.setAttribute(AUT_SRV_BWSR_I18NLOCALE, (Object)i18nLocale);
            String sUserAgent = req.getHeader("User-Agent");
            Browser browser = Browser.getInstance(req);
            FwAttr.setFwSessionAttribute("Browser", browser, session);
            session.setAttribute(AUT_SRV_BWSR_MJRVER, (Object)browser.getMajorVersion());
            session.setAttribute(AUT_SRV_BWSR_MNRVER, (Object)browser.getMinorVersion());
            session.setAttribute(AUT_SRV_BWSR_NAME, (Object)browser.getName());
            session.setAttribute(AUT_SRV_BWSR_NAME_UNDERSCORES, (Object)browser.getName());
            session.setAttribute(AUT_SRV_BWSR_OS, (Object)browser.getOS());
            session.setAttribute(AUT_SRV_BWSR_ID, (Object)sUserAgent);
            session.setAttribute(AUT_SRV_BWSR_CHARSET, (Object)"utf-8");
            SystemConfig sc = new SystemConfig();
            String timeoutString = sc.getSetting("System.Session.TimeoutSeconds");
            if (timeoutString != null) {
                int timeout = Integer.valueOf(timeoutString);
                session.setMaxInactiveInterval(timeout);
            }
            this.setLanguages(req);
            session.setAttribute("LiveSession", new Object());
        }
        return session;
    }

    protected void setLanguages(HttpServletRequest req) {
        Locale currentLocale;
        Vector<Locale> locales = new Vector<Locale>();
        String sLang = req.getParameter("Lang");
        if (sLang != null) {
            locales.add(FwUtils.instantiateLocale(sLang));
        }
        Cookie[] ckarray = req.getCookies();
        for (int i = 0; ckarray != null && i < ckarray.length; ++i) {
            if (!ckarray[i].getName().equals("language")) continue;
            locales.add(FwUtils.instantiateLocale(ckarray[i].getValue()));
        }
        Enumeration myenum = req.getLocales();
        while (myenum.hasMoreElements()) {
            Locale newLocale = (Locale)myenum.nextElement();
            locales.add(newLocale);
        }
        Locale[] newLocales = new Locale[locales.size()];
        newLocales = locales.toArray(newLocales);
        HttpSession session = req.getSession();
        FwUtils.setLocales(session, newLocales);
        String sLocs = this.convertLocalesToISOString(newLocales);
        if (sLocs != null) {
            session.setAttribute("BROWSER_LOCALES_STRING", (Object)sLocs);
        }
        if ((currentLocale = newLocales[0]) != null) {
            String lang = currentLocale.getLanguage();
            if ("zh".equals(lang)) {
                lang = currentLocale.toString();
            }
            session.setAttribute("ClientLocale", (Object)lang);
        }
    }

    protected String convertLocalesToISOString(Locale[] locales) {
        StringBuffer sbLocales = new StringBuffer();
        for (int i = 0; i < locales.length; ++i) {
            sbLocales.append(locales[i].getLanguage());
            String country = locales[i].getCountry();
            if (country != null) {
                sbLocales.append('-');
                sbLocales.append(country);
            }
            if (i > 0) {
                sbLocales.append(';');
                float priority = 1 - i / locales.length;
                DecimalFormat formatter = new DecimalFormat("0.0");
                String priorityString = formatter.format(priority);
                sbLocales.append(priorityString);
            }
            if (i >= locales.length - 1) continue;
            sbLocales.append(',');
        }
        return sbLocales.toString();
    }

    private void setDeviceInterface(HttpServletRequest req, HttpServletResponse resp) {
        HttpSession session = req.getSession();
        String sInterface = req.getParameter("DeviceType");
        if (sInterface != null && sInterface.length() > 0) {
            session.setAttribute("DEVICE_TYPE", (Object)sInterface);
            session.setAttribute("DeviceType", (Object)sInterface);
            resp.addCookie(new Cookie(COOKIE_IMANAGER_DEVICE_TYPE, sInterface));
        } else {
            sInterface = (String)session.getAttribute("DeviceType");
            Cookie[] aCookies = req.getCookies();
            for (int i = 0; aCookies != null && i < aCookies.length; ++i) {
                Cookie cookie = aCookies[i];
                if (!cookie.getName().equals(COOKIE_IMANAGER_DEVICE_TYPE)) continue;
                sInterface = cookie.getValue();
                session.setAttribute("DEVICE_TYPE", (Object)sInterface);
                session.setAttribute("DeviceType", (Object)sInterface);
            }
            if (sInterface == null) {
                sInterface = InterfaceCfg.getInstance().getInterface(req);
                session.setAttribute("DEVICE_TYPE", (Object)sInterface);
                session.setAttribute("DeviceType", (Object)sInterface);
            }
        }
    }

    public static HttpServletRequest currentRequest() {
        return (HttpServletRequest)sm_threadMap.get(Thread.currentThread());
    }

    public static iMgrAuthenticatorImpl[] getRequiredAuthenticators(HttpServletRequest req, boolean bDefault) {
        iMgrAuthenticatorImpl[] aAuths = AuthLoader.getRequiredAuthenticators(req);
        if (aAuths == null | aAuths.length == 0 && bDefault) {
            iMgrAuthenticatorImpl auth = FwAuthUtils.getDefaultAuthenticator(req);
            aAuths = new iMgrAuthenticatorImpl[]{auth};
        }
        return aAuths;
    }

    public void log(String s, Throwable throwable) {
        super.log(s, throwable);
        System.out.println(s);
    }

    public void log(String s) {
        super.log(s);
        System.out.println(s);
    }

    private void outputQueryString(HttpServletRequest req) {
        try {
            String sQuery;
            if (D.isDebugEnabled() && ((sQuery = req.getParameter("Task.sQuery")) == null || !sQuery.equalsIgnoreCase("false"))) {
                D.log(Task.buildQueryString(req, false));
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }
}

