/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.servlet;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.FwAttr;
import com.novell.emframe.fw.FwUtils;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.servlet.AuthenticatorServlet;
import com.novell.emframe.fw.servlet.UserAgent;
import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import org.jdom.Document;
import org.jdom.Element;

public class InterfaceCfg {
    private String m_sDefaultInterface = "default";
    private String m_sDefaultContentType = "text/html";
    private Vector m_vUserAgent = new Vector();
    private Hashtable m_hAcceptToInterface = new Hashtable();
    private Hashtable m_hInterfacesByDeviceName = new Hashtable();
    private Hashtable m_hContentTypesByDeviceName = new Hashtable();
    private Hashtable m_hResCache = new Hashtable();
    private static InterfaceCfg sm_singleton;

    private InterfaceCfg() {
    }

    public static InterfaceCfg getInstance() {
        if (sm_singleton == null) {
            sm_singleton = new InterfaceCfg();
        }
        return sm_singleton;
    }

    private void reset() {
        if (this.m_hAcceptToInterface != null) {
            this.m_hAcceptToInterface.clear();
        }
        if (this.m_hContentTypesByDeviceName != null) {
            this.m_hContentTypesByDeviceName.clear();
        }
        if (this.m_hInterfacesByDeviceName != null) {
            this.m_hInterfacesByDeviceName.clear();
        }
        if (this.m_vUserAgent != null) {
            this.m_vUserAgent.removeAllElements();
        }
    }

    public void load() {
        this.reset();
        try {
            FileInputStream fis = new FileInputStream(eMFrameUtils.getRealPath("WEB-INF" + File.separator + "DeviceReg.xml"));
            Document doc = iManager.getSaxBuilder().build((InputStream)fis);
            for (Element deviceElement : doc.getRootElement().getChildren()) {
                String deviceName = deviceElement.getAttributeValue("id");
                String contentType = deviceElement.getAttributeValue("contentType");
                this.m_hContentTypesByDeviceName.put(deviceName, contentType);
                Iterator iterUserAgents = deviceElement.getChildren("User-Agent").iterator();
                while (iterUserAgents.hasNext()) {
                    String userAgent = ((Element)iterUserAgents.next()).getTextTrim();
                    if (userAgent == null) continue;
                    UserAgent ua = new UserAgent(userAgent, deviceName, "false");
                    this.m_vUserAgent.add(ua);
                }
                Iterator iterAccepts = deviceElement.getChildren("Accept").iterator();
                while (iterAccepts.hasNext()) {
                    String accept = ((Element)iterAccepts.next()).getTextTrim();
                    if (accept == null) continue;
                    this.m_hAcceptToInterface.put(accept, deviceName);
                }
            }
        }
        catch (Throwable t) {
            D.log(t);
        }
    }

    private String getCachedResource(String sModNFile) {
        return (String)this.m_hResCache.get(sModNFile);
    }

    private void setCachedResource(String sModNFile, String sRes) {
        this.m_hResCache.put(sModNFile, sRes);
    }

    public static String getInterfaceUrl(HttpServletRequest req, String sModNFile) {
        String sPath = null;
        InterfaceCfg dvInt = InterfaceCfg.getInstance();
        sPath = dvInt.getCachedResource(sModNFile);
        if (sPath != null) {
            return sPath;
        }
        String sMod = InterfaceCfg.getModuleFromFullName(sModNFile);
        String sRes = InterfaceCfg.getResourceFromFullName(sModNFile);
        StringBuffer sbPath = new StringBuffer(75);
        sbPath.append("/portal/modules/");
        sbPath.append(sMod).append("/skins/default/devices/");
        int iPathLen = sbPath.length();
        if (dvInt != null) {
            sbPath.append(FwUtils.getDeviceType(req.getSession()) + '/' + sRes);
        } else {
            sbPath.append("/default/" + sRes);
        }
        sPath = sbPath.toString();
        boolean bExists = dvInt.resourceExists(sPath, req);
        if (!bExists && !sRes.equals("default")) {
            sbPath.setLength(iPathLen);
            sbPath.append("default/" + sRes);
            sPath = sbPath.toString();
            if (dvInt.resourceExists(sPath, req)) {
                bExists = true;
            }
        }
        dvInt.setCachedResource(sModNFile, sPath);
        return sPath;
    }

    private boolean resourceExists(String sRes, HttpServletRequest req) {
        HttpServlet srv = (HttpServlet)FwAttr.getFwRequestAttribute(AuthenticatorServlet.THIS_SERVLET, req);
        String sRoot = srv.getServletContext().getRealPath("/");
        String sPath = sRoot + sRes;
        File f = new File(sPath);
        return f.isFile();
    }

    private static String getModuleFromFullName(String fullName) {
        if (fullName == null) {
            return null;
        }
        String module = null;
        int index = fullName.indexOf(47);
        if (index == -1 && (index = fullName.indexOf(46)) == -1) {
            return null;
        }
        try {
            module = fullName.substring(0, index);
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return module;
    }

    private static String getResourceFromFullName(String fullName) {
        if (fullName == null) {
            return null;
        }
        String page = null;
        int index = fullName.indexOf(47);
        if (index == -1 && (index = fullName.indexOf(46)) == -1) {
            return null;
        }
        try {
            page = fullName.substring(index + 1);
        }
        catch (StringIndexOutOfBoundsException e) {
            e.printStackTrace();
        }
        return page;
    }

    public String getInterface(HttpServletRequest req) {
        String sInterface;
        UserAgent ua;
        if (this.m_vUserAgent != null && (ua = this.getUserAgent(req)) != null) {
            return ua.getInterface();
        }
        String sAcceptType = this.getPreferredAcceptType(req);
        if (sAcceptType != null && this.m_hAcceptToInterface != null && (sInterface = (String)this.m_hAcceptToInterface.get(sAcceptType)) != null) {
            return sInterface;
        }
        return this.m_sDefaultInterface;
    }

    public String getPreferredAcceptType(HttpServletRequest req) {
        String sToken = null;
        String sAccept = req.getHeader("Accept");
        if (this.m_hAcceptToInterface != null && sAccept != null) {
            String sInterface = null;
            StringTokenizer st = new StringTokenizer(sAccept, ", ");
            while (st.hasMoreTokens()) {
                int iIdx;
                sToken = st.nextToken();
                sInterface = (String)this.m_hAcceptToInterface.get(sToken);
                if (sInterface == null && (iIdx = sToken.indexOf(";")) != -1) {
                    sToken = sToken.substring(0, iIdx);
                    sInterface = (String)this.m_hAcceptToInterface.get(sToken);
                }
                if (sInterface == null) continue;
            }
        }
        if (sToken != null) {
            return sToken;
        }
        return sAccept;
    }

    public UserAgent getUserAgent(String sUserAgent) {
        UserAgent ua = null;
        int iSize = this.m_vUserAgent.size();
        for (int i = 0; i < iSize; ++i) {
            ua = (UserAgent)this.m_vUserAgent.elementAt(i);
            if (!this.findPattern(ua.getId(), sUserAgent)) continue;
            return ua;
        }
        return null;
    }

    public UserAgent getUserAgent(HttpServletRequest req) {
        return this.getUserAgent(req.getHeader("User-Agent"));
    }

    public String getContentType(String sInterface) {
        String sContentType = null;
        if (this.m_hContentTypesByDeviceName != null && (sContentType = (String)this.m_hContentTypesByDeviceName.get(sInterface)) != null) {
            return sContentType;
        }
        return this.m_sDefaultContentType;
    }

    private boolean findPattern(String sPattern, String sText) {
        int iTextPos = 0;
        if (sPattern.equals("*")) {
            return true;
        }
        StringTokenizer st = new StringTokenizer(sPattern, "*", true);
        String sToken = null;
        while (st.hasMoreTokens()) {
            int iNextPos;
            sToken = st.nextToken();
            if (sToken.equals("*")) {
                if (!st.hasMoreTokens()) {
                    return true;
                }
                sToken = st.nextToken();
                iNextPos = sText.indexOf(sToken, iTextPos);
                if (iNextPos >= 0) {
                    iTextPos = iNextPos + sToken.length();
                    continue;
                }
                return false;
            }
            iNextPos = sText.indexOf(sToken, iTextPos);
            if (!st.hasMoreTokens()) {
                iTextPos = iNextPos + sToken.length();
                if (iTextPos == sText.length()) continue;
                return false;
            }
            if (iNextPos != iTextPos) {
                return false;
            }
            iTextPos = iNextPos + sToken.length();
        }
        return true;
    }
}

