/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.studio;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.fw.FwTaskContext;
import com.novell.emframe.fw.studio.StudioPluginInfo;
import com.novell.webaccess.common.I18NLocale;
import java.text.Collator;
import java.util.Comparator;
import java.util.Hashtable;
import java.util.Locale;

public class PluginDisplayNameComparator
implements Comparator {
    public static final int ORDER_MIN = 0;
    public static final int ORDER_MAX = 1000;
    public static final int ORDER_DEFAULT = 500;
    public static final int BASE_DEFAULT = 300;
    Collator m_collator;
    boolean m_useOrder;
    MContext m_context;
    static Hashtable s_collators = new Hashtable();

    public PluginDisplayNameComparator(MContext context) {
        this.m_context = context;
        D.assrt(context != null, "Context cannot be null");
        this.init(this.m_context.getLocale());
    }

    public PluginDisplayNameComparator(Locale l) {
        this.m_context = new RequestlessContext();
        ((RequestlessContext)this.m_context).setLocale(l);
        this.init(l);
    }

    public void init(Locale l) {
        this.m_useOrder = true;
        this.m_collator = (Collator)s_collators.get(l);
        if (this.m_collator == null) {
            this.m_collator = Collator.getInstance(l);
            s_collators.put(l, this.m_collator);
        }
        if (this.m_collator == null) {
            this.m_collator = Collator.getInstance();
        }
    }

    public int compare(Object o1, Object o2) {
        int compare = 0;
        if (compare == 0) {
            String name1 = "";
            String name2 = "";
            try {
                name1 = ((StudioPluginInfo)o1).getDisplayName();
                name2 = ((StudioPluginInfo)o2).getDisplayName();
            }
            catch (Exception e) {
                D.log(e);
            }
            compare = this.m_collator.compare(name1, name2);
        }
        return compare;
    }

    public static final int parseInt(String s, int defaultNumber) {
        if (s == null) {
            return defaultNumber;
        }
        try {
            int i = Integer.parseInt(s);
            i = Math.max(i, 0);
            i = Math.min(i, 1000);
            return i;
        }
        catch (Exception e) {
            return defaultNumber;
        }
    }

    class RequestlessContext
    extends FwTaskContext {
        RequestlessContext() {
        }

        public void setLocale(Locale locale) {
            this.m_i18nLocale = new I18NLocale(locale);
        }

        @Override
        public Locale getLocale() {
            return this.m_i18nLocale.getLocale();
        }
    }
}

