/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.studio;

import com.novell.admin.common.exceptions.SPIException;
import com.novell.admin.ns.AttributeDefinition;
import com.novell.admin.ns.nds.NDSNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.AuthenticationBroker;
import com.novell.emframe.dev.D;
import com.novell.emframe.dev.MContext;
import com.novell.emframe.dev.PageException;
import com.novell.emframe.dev.PluginException;
import com.novell.emframe.dev.eMFrameUtils;
import com.novell.emframe.fw.CustomNpmFile;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.studio.ExtensionFilter;
import com.novell.emframe.fw.studio.PageData;
import com.novell.emframe.fw.util.iManagerJDOMFactory;
import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.util.ArrayList;
import java.util.GregorianCalendar;
import java.util.Iterator;
import java.util.List;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.JDOMException;
import org.jdom.input.JDOMFactory;
import org.jdom.input.SAXBuilder;
import org.jdom.output.XMLOutputter;

public class TemplateBuilderUtils {
    private static final String convertToString(long val) {
        return (val < 10L ? "0" : "") + val;
    }

    public static final String getDatePostfix() {
        GregorianCalendar calendar = new GregorianCalendar();
        StringBuffer sb = new StringBuffer("_");
        sb.append(TemplateBuilderUtils.convertToString(calendar.get(1)));
        sb.append(TemplateBuilderUtils.convertToString(calendar.get(2) + 1));
        sb.append(TemplateBuilderUtils.convertToString(calendar.get(5)) + "_");
        sb.append(TemplateBuilderUtils.convertToString(calendar.get(11)));
        sb.append(TemplateBuilderUtils.convertToString(calendar.get(12)));
        sb.append(TemplateBuilderUtils.convertToString(calendar.get(13)));
        return sb.toString();
    }

    public static void validateContainment(String strRbsCollection, String strObject, String strObjectType, MContext context) throws PluginException {
        if (strObject == null || strObject.length() == 0) {
            String strHeader = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.Error", context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.MustEnterTaskName", context);
            throw new PageException(strHeader, strBody);
        }
        if (strRbsCollection == null || strRbsCollection.length() == 0) {
            String strHeader = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.Error", context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.MustEnterRbsCollectionName", context);
            throw new PageException(strHeader, strBody);
        }
        D.assrt(strObjectType != null && strObjectType.length() > 0, "NO Object Type Name");
        AuthenticationBroker broker = context.getAuthenticationBroker();
        ObjectEntry treeOE = (ObjectEntry)broker.getAPIObject("NDSNamespace");
        NDSNamespace namespace = (NDSNamespace)treeOE.getNamespace();
        ObjectEntry oeContainer = null;
        try {
            oeContainer = namespace.getObjectEntry(treeOE, strRbsCollection);
            context.addToHistory(oeContainer);
            if (!oeContainer.getObjectType().getName().equals("rbsCollection2")) {
                throw new Exception();
            }
        }
        catch (SPIException e) {
            String strHeader = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.Error", context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.RbsCollectionDoesNotExist", context);
            throw new PageException(strHeader, strBody);
        }
        catch (Exception e) {
            String strHeader = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.Error", context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.RbsCollectionDoesNotExist", context);
            throw new PageException(strHeader, strBody);
        }
        boolean doesExist = false;
        try {
            ObjectEntry module = namespace.getObjectEntry(treeOE, "custom." + strRbsCollection);
            doesExist = namespace.doesExist(module, strObject);
        }
        catch (SPIException e) {
            doesExist = false;
        }
        if (doesExist) {
            Object[] args = new Object[]{strObject};
            String strHeader = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.Error", context);
            String strBody = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.AlreadyExists", context);
            strBody = eMFrameUtils.formatMessage(strBody, args);
            throw new PageException(strHeader, strBody);
        }
    }

    static final boolean doesSupportDevice(Document uihandlerDoc, String deviceName) {
        List list = uihandlerDoc.getRootElement().getChildren("supported-device-type");
        for (int k = 0; k < list.size(); ++k) {
            Element element = (Element)list.get(k);
            if (!element.getTextTrim().equals(deviceName)) continue;
            return true;
        }
        return false;
    }

    static final Element combineElements(Element primary, Element secondary) {
        Element resultElement = (Element)primary.clone();
        List params = secondary.getChildren("param");
        for (Element secondaryParam : params) {
            String paramName = secondaryParam.getAttributeValue("name");
            Element primaryParam = TemplateBuilderUtils.findParam(primary, paramName);
            if (primaryParam != null) {
                List attributes = secondaryParam.getAttributes();
                for (Attribute xmlAttribute : attributes) {
                    String name = xmlAttribute.getName();
                    String value = xmlAttribute.getValue();
                    if (primaryParam.getAttributeValue(name) != null && primaryParam.getAttributeValue(name).length() != 0) continue;
                    primaryParam.setAttribute(name, value);
                }
                continue;
            }
            primary.addContent((Element)secondaryParam.clone());
        }
        return primary;
    }

    public static Element combineElements(Element primary, String secondaryStr) {
        Element secondary = null;
        try {
            secondary = iManager.getSaxBuilder().build((Reader)new StringReader(secondaryStr)).getRootElement();
        }
        catch (Exception e) {
            D.log(e);
        }
        Element resultElement = TemplateBuilderUtils.combineElements(primary, secondary);
        return resultElement;
    }

    static final String getXmlOptionsString(Document uihandlerDoc, AttributeDefinition attributeDefinition, boolean required, Element controlXml, MContext context) {
        String newXml = TemplateBuilderUtils.getXmlOptionsString(uihandlerDoc, attributeDefinition, required, context);
        Element resultElement = TemplateBuilderUtils.combineElements(controlXml, newXml);
        try {
            ByteArrayOutputStream targetStream = new ByteArrayOutputStream();
            XMLOutputter outputter = new XMLOutputter();
            outputter.setEncoding("UTF-8");
            outputter.output(resultElement, (OutputStream)targetStream);
            return targetStream.toString("UTF-8");
        }
        catch (IOException e) {
            D.log(e);
            return "";
        }
    }

    private static Element findParam(Element root, String paramName) {
        List params = root.getChildren("param");
        for (Element paramElement : params) {
            if (!paramElement.getAttributeValue("name").equals(paramName)) continue;
            return paramElement;
        }
        return null;
    }

    static final String getXmlOptionsString(Document uihandlerDoc, AttributeDefinition attribute, boolean required, MContext context) {
        StringBuffer options = new StringBuffer();
        options.append("<control>");
        Element root = uihandlerDoc.getRootElement();
        String displayName = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.ReadOnly", context);
        if (attribute.isReadOnly()) {
            options.append("<param name=\"readOnly\" displayName=\"" + displayName + "\" type=\"boolean\" changeable=\"false\" helpTextKey=\"Studio.params.readonly\" resourceFile=\"FwResources\" displayNameKey=\"TaskBuilder.ReadOnly\"><value>true</value></param>");
        } else if (root.getChild("read-only-enabled") != null) {
            options.append("<param name=\"readOnly\" displayName=\"" + displayName + "\" type=\"boolean\" changeable=\"true\" helpTextKey=\"Studio.params.readonly\" resourceFile=\"FwResources\" displayNameKey=\"TaskBuilder.ReadOnly\"><value>false</value></param>");
        }
        displayName = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.SingleValued", context);
        if (attribute.isSingleValued()) {
            options.append("<param name=\"singleValued\" displayName=\"" + displayName + "\" type=\"boolean\" changeable=\"false\" helpTextKey=\"Studio.params.singleValued\" resourceFile=\"FwResources\" displayNameKey=\"TaskBuilder.SingleValued\"><value>true</value></param>");
        } else if (root.getChild("single-valued-enabled") != null) {
            options.append("<param name=\"singleValued\" displayName=\"" + displayName + "\" type=\"boolean\" changeable=\"true\" helpTextKey=\"Studio.params.singleValued\" resourceFile=\"FwResources\" displayNameKey=\"TaskBuilder.SingleValued\"><value>false</value></param>");
        } else {
            options.append("<param name=\"singleValued\" displayName=\"" + displayName + "\" type=\"boolean\" changeable=\"false\" helpTextKey=\"Studio.params.singleValued\" resourceFile=\"FwResources\" displayNameKey=\"TaskBuilder.SingleValued\"><value>false</value></param>");
        }
        displayName = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.Mandatory", context);
        options.append("<param name=\"mandatory\" displayName=\"" + displayName + "\" type=\"boolean\" changeable=\"" + !required + "\" helpTextKey=\"Studio.params.mandatory\" resourceFile=\"FwResources\" displayNameKey=\"TaskBuilder.Mandatory\"><value>" + required + "</value></param>");
        displayName = eMFrameUtils.getLocalizedString("FwResources", "TaskBuilder.customLabel", context);
        options.append("<param name=\"customLabel\" displayName=\"" + displayName + "\" type=\"string\" changeable=\"true\" helpTextKey=\"Studio.params.customLabel\" resourceFile=\"FwResources\" displayNameKey=\"TaskBuilder.customLabel\"><value></value></param>");
        List list = root.getChildren("param");
        for (Element element : list) {
            String name = element.getChildTextTrim("name");
            displayName = eMFrameUtils.getDisplayName(element, context);
            String type = element.getChildTextTrim("param-type");
            String displayNameKey = element.getChildTextTrim("display-name-key");
            String requiredParam = element.getChildTextTrim("required");
            if (requiredParam == null) {
                requiredParam = "false";
            }
            String helpKey = element.getChildTextTrim("help-text-key");
            String resourceFile = element.getChildTextTrim("resource-properties-file");
            String initialValue = "";
            Element initialValueElement = element.getChild("initial-value");
            if (initialValueElement != null) {
                initialValue = "<value>" + initialValueElement.getTextTrim() + "</value>";
            }
            options.append("<param name=\"" + name + "\" type=\"" + type + "\" displayName=\"" + displayName + "\" changeable=\"true\" required=\"" + requiredParam + "\" helpTextKey=\"" + helpKey + "\" resourceFile=\"" + resourceFile + "\" displayNameKey=\"" + displayNameKey + "\">" + initialValue + "</param>");
        }
        options.append("</control>");
        return options.toString();
    }

    public static final Element newElement(String name, String text) {
        Element ret = new Element(name);
        ret.setText(text);
        return ret;
    }

    public static Document createXmlForDeleteTask(String objectTypeName, String version) {
        Element task = new Element("task");
        Element module = CustomNpmFile.makeModuleElement(version);
        task.addContent(TemplateBuilderUtils.newElement("id", "MyTaskId"));
        task.addContent(TemplateBuilderUtils.newElement("version", "2.0.0"));
        task.addContent(TemplateBuilderUtils.newElement("required-version", "2.0.0"));
        task.addContent(TemplateBuilderUtils.newElement("class-name", "java:com.novell.emframe.fw.DeleteObjectTask"));
        task.addContent(TemplateBuilderUtils.newElement("merge-template", "fw.DelObject"));
        task.addContent(TemplateBuilderUtils.newElement("error-template", "dev.GenFatal"));
        task.addContent(TemplateBuilderUtils.newElement("description", ""));
        task.addContent(TemplateBuilderUtils.newElement("resource-properties-file", "FwResources"));
        task.addContent(TemplateBuilderUtils.newElement("display-name-key", "TempateBuilder.TempTaskName"));
        task.addContent(TemplateBuilderUtils.newElement("role-assignment", ""));
        task.addContent(TemplateBuilderUtils.newElement("object-type-name", objectTypeName));
        Element rights = new Element("rights-assignment");
        rights.addContent(TemplateBuilderUtils.newElement("attribute-name", "[Entry Rights]"));
        rights.addContent(TemplateBuilderUtils.newElement("privilege", "Browse"));
        rights.addContent(TemplateBuilderUtils.newElement("privilege", "Delete"));
        task.addContent(rights);
        Element param1 = new Element("url-param");
        param1.addContent(TemplateBuilderUtils.newElement("param-key", "objectTypeName"));
        param1.addContent(TemplateBuilderUtils.newElement("param-value", objectTypeName));
        task.addContent(param1);
        Element root = new Element("install");
        root.addContent(module);
        root.addContent(task);
        return new Document(root);
    }

    static String outputNPM(Document document, MContext context, File templateFile, String client, boolean isPage) throws IOException, JDOMException {
        Element dstElement;
        CustomNpmFile npm = new CustomNpmFile(context);
        if (templateFile != null) {
            String name = "currentwebapp/portal/modules/custom/skins/default/devices/" + client + "/" + templateFile.getName();
            BufferedInputStream sourceStream = new BufferedInputStream(new FileInputStream(templateFile));
            npm.addNpmEntry(name, sourceStream);
            sourceStream.close();
        }
        if (isPage) {
            dstElement = (Element)document.getRootElement().clone();
            npm.addPluginXml(dstElement);
        } else {
            dstElement = (Element)document.getRootElement().clone();
            npm.addInstallXml(dstElement);
        }
        npm.writeFile();
        return npm.getNextVersion().toString();
    }

    public static void removePluginXmlFromDirectory(File directory, String pluginId) throws IOException, JDOMException {
        if (!directory.exists() || !directory.isDirectory()) {
            return;
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                TemplateBuilderUtils.removePluginXmlFromDirectory(files[i], pluginId);
                continue;
            }
            TemplateBuilderUtils.removePluginXmlFromFile(files[i], pluginId);
        }
    }

    public static void removePluginXmlFromFile(File file, String pluginId) {
        if (file == null || !file.exists()) {
            return;
        }
        try {
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));
            SAXBuilder saxBuilder = new SAXBuilder(false);
            saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document pluginsDoc = saxBuilder.build((InputStream)inStream);
            inStream.close();
            String moduleName = "";
            Element root = pluginsDoc.getRootElement();
            List list = root.getChildren();
            Iterator iterator = list.iterator();
            while (iterator.hasNext()) {
                String id;
                Element element = (Element)iterator.next();
                String type = element.getName();
                if ("module".equals(type)) {
                    moduleName = element.getChildTextTrim("id");
                }
                if (("task".equals(type) || "page".equals(type) || "private-page".equals(type)) && (id = element.getChildTextTrim("id")) != null) {
                    if (id.equals(pluginId)) {
                        iterator.remove();
                    } else if (!id.startsWith(moduleName + ".") && id.indexOf(".") == -1 && (id = moduleName + "." + id).equals(pluginId)) {
                        iterator.remove();
                    }
                }
                if (!"object-creator".equals(type) || (id = element.getChildText("id")) == null || !id.equals(pluginId)) continue;
                iterator.remove();
            }
            XMLOutputter outputter = new XMLOutputter("   ", true);
            outputter.setTrimAllWhite(true);
            BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(file));
            outputter.output(pluginsDoc, (OutputStream)outStream);
            outStream.close();
        }
        catch (Throwable e) {
            D.log(e);
        }
    }

    public static boolean hasPropertyPagePluginRights(File directory, String pluginId, String userCN) throws IOException, JDOMException {
        boolean ret = false;
        if (!directory.exists() || !directory.isDirectory()) {
            return ret;
        }
        File[] files = directory.listFiles();
        for (int i = 0; i < files.length; ++i) {
            if (files[i].isDirectory()) {
                TemplateBuilderUtils.hasPropertyPagePluginRights(files[i], pluginId, userCN);
                continue;
            }
            ret = TemplateBuilderUtils.hasPropertPageRights(files[i], pluginId, userCN);
        }
        return ret;
    }

    public static boolean hasPropertPageRights(File file, String pluginId, String userCN) {
        boolean ret = false;
        if (file == null || !file.exists()) {
            return ret;
        }
        try {
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(file));
            SAXBuilder saxBuilder = new SAXBuilder(false);
            saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            Document pluginsDoc = saxBuilder.build((InputStream)inStream);
            inStream.close();
            Element root = pluginsDoc.getRootElement();
            List list = root.getChildren();
            for (Element element : list) {
                String user;
                String id;
                String type = element.getName();
                if (!"page".equals(type) && !"private-page".equals(type) || (id = element.getChildTextTrim("id")) == null || !id.equals(pluginId) || (user = element.getChildTextTrim("created-by")) == null || !user.equals(userCN)) continue;
                return true;
            }
        }
        catch (Exception e) {
            D.log(e);
        }
        return ret;
    }

    public static void addPluginXml(File customXmlFile, Element element) throws IOException, JDOMException {
        Document pluginsDoc = null;
        if (customXmlFile.exists()) {
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(customXmlFile));
            SAXBuilder saxBuilder = new SAXBuilder(false);
            saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            pluginsDoc = saxBuilder.build((InputStream)inStream);
            inStream.close();
        } else {
            pluginsDoc = new Document(new Element("plugins"));
        }
        Element root = pluginsDoc.getRootElement();
        root.addContent(element);
        XMLOutputter outputter = new XMLOutputter("   ", true);
        outputter.setTrimAllWhite(true);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(customXmlFile));
        outputter.output(pluginsDoc, (OutputStream)outStream);
        outStream.close();
    }

    public static void addInstallXml(File customXmlFile, Element element, String version) throws IOException, JDOMException {
        Document pluginsDoc = null;
        if (customXmlFile.exists()) {
            BufferedInputStream inStream = new BufferedInputStream(new FileInputStream(customXmlFile));
            SAXBuilder saxBuilder = new SAXBuilder(false);
            saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
            saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
            saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
            pluginsDoc = saxBuilder.build((InputStream)inStream);
            inStream.close();
        } else {
            pluginsDoc = new Document(new Element("install"));
        }
        Element root = pluginsDoc.getRootElement();
        Element module = root.getChild("module");
        if (module == null) {
            module = CustomNpmFile.makeModuleElement(version);
            root.addContent(module);
        } else {
            Element versionElement = module.getChild("version");
            if (versionElement == null) {
                module.addContent(TemplateBuilderUtils.newElement("version", version));
            } else {
                versionElement.setText(version);
            }
        }
        root.addContent(element);
        XMLOutputter outputter = new XMLOutputter("   ", true);
        outputter.setTrimAllWhite(true);
        BufferedOutputStream outStream = new BufferedOutputStream(new FileOutputStream(customXmlFile));
        outputter.output(pluginsDoc, (OutputStream)outStream);
        outStream.close();
    }

    public static String format(String pattern, String arg1) {
        return eMFrameUtils.formatMessage(pattern, new String[]{arg1});
    }

    public static String format(String pattern, String arg1, String arg2) {
        return eMFrameUtils.formatMessage(pattern, new String[]{arg1, arg2});
    }

    public static String format(String pattern, String arg1, String arg2, String arg3) {
        return eMFrameUtils.formatMessage(pattern, new String[]{arg1, arg2, arg3});
    }

    public static ArrayList discoverPages(MContext context) {
        ArrayList<PageData> pageList = new ArrayList<PageData>();
        String xmlDirPath = iManager.getAbsModulesPath() + "/custom/plugins";
        File directory = new File(xmlDirPath);
        File[] files = directory.listFiles(new ExtensionFilter(".xml"));
        SAXBuilder saxBuilder = new SAXBuilder(false);
        saxBuilder.setFeature("http://xml.org/sax/features/external-general-entities", false);
        saxBuilder.setFeature("http://xml.org/sax/features/external-parameter-entities", false);
        saxBuilder.setFeature("http://apache.org/xml/features/disallow-doctype-decl", true);
        saxBuilder.setFactory((JDOMFactory)iManagerJDOMFactory.getInstance());
        Document doc = null;
        if (files != null) {
            for (int i = 0; i < files.length; ++i) {
                try {
                    doc = saxBuilder.build(files[i]);
                }
                catch (Exception e) {
                    D.log(e);
                    continue;
                }
                Element root = doc.getRootElement();
                List list = root.getChildren();
                Iterator iterator = list.iterator();
                while (iterator.hasNext()) {
                    PageData pageData = new PageData();
                    pageData.setFileName(files[i].getAbsolutePath());
                    Element pageRoot = (Element)iterator.next();
                    String strType = pageRoot.getName();
                    if (!strType.equals("private-page") && !strType.equals("page")) continue;
                    Element chapter = pageRoot.getChild("chapter");
                    pageData.setPageDisplayName(eMFrameUtils.getDisplayName(pageRoot, context));
                    pageData.setPageId(pageRoot.getChildTextTrim("id"));
                    pageData.setChapterDisplayName(chapter.getChildTextTrim("display-name-key"));
                    pageData.setMergeTemplate(pageRoot.getChildTextTrim("merge-template"));
                    pageList.add(pageData);
                }
            }
        }
        return pageList;
    }
}

