/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.uihandlers;

import com.novell.emframe.dev.UiHandler;
import java.io.PrintWriter;
import java.util.Enumeration;
import java.util.Properties;

public class MVStringEditorUiHandler
extends UiHandler {
    private static final String[] m_hexSharedCode = new String[]{"iman:mvedScripts mode=\"mvsel\"", "iman:validateNumberScripts"};
    private static final String[] m_sharedCode = new String[]{"iman:mvedScripts", "iman:validateNumberScripts"};
    private static final String[] m_dnHeaderCode = new String[]{"iman:mvedScripts", "iman:validateNumberScripts", "iman:osScripts"};
    private String m_typeFilter = null;

    @Override
    public String[] getSharedHeaderCode() {
        String syntax = this.context.getSyntaxName();
        if (syntax.equals("Distinguished Name") || syntax.equals("LDAP:DN")) {
            return m_dnHeaderCode;
        }
        if (syntax.equals("Octet String") || syntax.equals("LDAP:Octet String")) {
            return m_hexSharedCode;
        }
        return m_sharedCode;
    }

    @Override
    public String getNotificationName() {
        if (this.context.getSyntaxName().equals("Case Ignore List") && !this.context.isSingleValued()) {
            return "uih_multivaluedCIList";
        }
        return "uih_mvStringEditor";
    }

    @Override
    public String getActionHandlerName() {
        return null;
    }

    @Override
    public void printUiCode(PrintWriter pw, String indent) {
        Properties attributes = new Properties();
        attributes.put("name", "_" + this.context.getEncodedAttributeName());
        String syntaxName = this.context.getSyntaxName();
        String regExp = this.getParameterValue("regularExpression");
        if (regExp != null && regExp.length() > 0) {
            attributes.put("regExpression", regExp);
            attributes.put("regExpressionMsg", this.getParameterValue("regularExpressionErrorMsg"));
        } else {
            attributes.put("regExpression", ".*");
            attributes.put("regExpressionMsg", "Error! Invalid characters used");
        }
        if (this.context.isForceReadOnly()) {
            attributes.put("readonly", "true");
        } else {
            String upperbound = this.getParameterValue("upperbound");
            String lowerbound = this.getParameterValue("lowerbound");
            if (this.context.isSized()) {
                if (upperbound == null || upperbound.length() == 0) {
                    upperbound = "" + this.context.getUpperBound();
                }
                if (lowerbound == null || lowerbound.length() == 0) {
                    lowerbound = "" + this.context.getLowerBound();
                }
            }
            if (upperbound != null || lowerbound != null) {
                if (upperbound == null) {
                    upperbound = "999999";
                }
                if (lowerbound == null) {
                    lowerbound = "-999999";
                }
                if (this.context.getSyntaxName().equals("Integer 64")) {
                    upperbound = "123456789";
                    lowerbound = "987654321";
                }
                if (syntaxName.equals("Counter") || syntaxName.equals("Integer") || syntaxName.equals("Integer 64") || syntaxName.equals("Interval") || syntaxName.equals("LDAP:Counter") || syntaxName.equals("LDAP:Integer")) {
                    attributes.put("numbersOnly", "true");
                    attributes.put("lowerBound", "" + lowerbound);
                    attributes.put("upperBound", "" + upperbound);
                } else {
                    attributes.put("minLength", "" + lowerbound);
                    attributes.put("maxLength", "" + upperbound);
                }
            }
            if (syntaxName.equals("Case Ignore String") || syntaxName.equals("LDAP:Case Ignore String")) {
                attributes.put("ignoreCase", "true");
            } else if (syntaxName.equals("Distinguished Name") || syntaxName.equals("LDAP:DN")) {
                String typeFilter = this.m_typeFilter;
                if (typeFilter == null) {
                    typeFilter = this.getParameterValue("objectTypeFilter");
                }
                if (typeFilter == null) {
                    attributes.put("objectTypeName", "*");
                } else {
                    attributes.put("objectTypeName", typeFilter);
                }
            } else if (syntaxName.equals("Octet String") || syntaxName.equals("LDAP:Octet String")) {
                attributes.put("hex", "true");
            }
            attributes.put("enforceUnique", "true");
            attributes.put("readonly", "${!" + this.context.geteDasRights() + "}");
        }
        String inputFieldSize = this.getParameterValue("fieldSize");
        if (inputFieldSize != null) {
            attributes.put("width", inputFieldSize);
        }
        pw.println(indent + "<x:set var=\"MVStringEditor_xmlNodeSet\" select=\"" + this.context.getxPathSet() + "\" scope=\"request\"/>");
        if (syntaxName.equals("Case Ignore List") && !this.context.isSingleValued()) {
            pw.println(indent + "<iman:include page=\"fw/MVCIListEditor.jsp\"/>");
        } else {
            pw.print(indent + "<iman:mved");
            Enumeration<Object> myenum = attributes.keys();
            while (myenum.hasMoreElements()) {
                String key = (String)myenum.nextElement();
                pw.print(" " + key + "=\"" + attributes.getProperty(key) + "\"");
            }
            pw.println(indent + "/>");
            if (syntaxName.equals("Integer 64")) {
                this.addInteger64DateCode(pw, indent);
            }
        }
    }

    protected void addInteger64DateCode(PrintWriter pw, String indent) {
        pw.print("</TD>");
        pw.print("<TD>");
        pw.print("<table cell spacing=\"0\" cellpadding=\"0\" border=\"0\" bgcolor=\"#ffffff\" align =\"left\"> ");
        pw.print("<tbody>");
        pw.print("<TR>");
        pw.print("<TD>");
        pw.print("<iman:calendar onLoadCallback=\"getExpTime\" name=\"expTimeWidgetForCreate\" returnCallback=\"returnExpTimeForCreate\"/>");
        pw.print("</td>");
        pw.print("</tr>");
        pw.print("</tbody>");
        pw.print("</table>");
        pw.print("</TD>");
        pw.print("<TR>");
        pw.print("<TD>");
        pw.print("<input type=\"hidden\" id=\"hiddenAttributeName\" name=\"hiddenAttributeName\" value=\"mvid__" + this.context.getEncodedAttributeName() + "\" ></input>");
        pw.print("<input type=\"checkbox\" id=\"isDateId\" onclick=\"onPerform('jj')\"/>");
        pw.print("<label for =\"checkBoxLabel\">Interpret as date</label>");
        pw.print("<div id=\"integer64InterpretorId\" style=\"visibility:hidden\"> <br>");
        pw.print("&nbsp;&nbsp;&nbsp;<%= c.string(\"Date.Day\") %>: <input type=\"text\" name=\"petDay\" id=\"petDay\" size=\"2\" maxlength=\"2\">&nbsp;");
        pw.print(" <%= c.string(\"Date.Month\") %>: <select name=petMonth id=\"petMonth\" size=\"1\" style=\"width:130px\">);");
        pw.print("<option value=12></option>");
        pw.print("     <option value=0><%= c.string(\"Date.Month.0\") %>");
        pw.print("     <option value=1><%= c.string(\"Date.Month.1\") %>");
        pw.print("<option value=2><%= c.string(\"Date.Month.2\") %>");
        pw.print("<option value=3><%= c.string(\"Date.Month.3\") %>");
        pw.print("<option value=4><%= c.string(\"Date.Month.4\") %>");
        pw.print("<option value=5><%= c.string(\"Date.Month.5\") %>");
        pw.print("<option value=6><%= c.string(\"Date.Month.6\") %>");
        pw.print("<option value=7><%= c.string(\"Date.Month.7\") %>");
        pw.print("<option value=8><%= c.string(\"Date.Month.8\") %>");
        pw.print("<option value=9><%= c.string(\"Date.Month.9\") %>");
        pw.print("<option value=10><%= c.string(\"Date.Month.10\") %>");
        pw.print("<option value=11><%= c.string(\"Date.Month.11\") %>");
        pw.print(" </select>&nbsp;");
        pw.print("<%= c.string(\"Date.Year\") %>: <input type=text name=petYear id=\"petYear\" size=\"4\" maxlength=\"4\">");
        pw.print("<%= c.string(\"Date.Time\") %>: <select name=petHour id=\"petHour\">");
        pw.print("   <option value=00>00</option>");
        pw.print("   <option value=01>01</option>");
        pw.print("   <option value=02>02</option>");
        pw.print("   <option value=03>03</option>");
        pw.print("   <option value=04>04</option>");
        pw.print("   <option value=05>05</option>");
        pw.print("   <option value=06>06</option>");
        pw.print("   <option value=07>07</option>");
        pw.print("   <option value=08>08</option>");
        pw.print("   <option value=09>09</option>");
        pw.print("   <option value=10>10</option>");
        pw.print("   <option value=11>11</option>");
        pw.print("   <option value=12>12</option>");
        pw.print("   <option value=13>13</option>");
        pw.print("   <option value=14>14</option>");
        pw.print("   <option value=15>15</option>");
        pw.print("   <option value=16>16</option>");
        pw.print("   <option value=17>17</option>");
        pw.print("   <option value=18>18</option>");
        pw.print("  <option value=19>19</option>");
        pw.print("<option value=20>20</option>");
        pw.print("<option value=21>21</option>");
        pw.print("   <option value=22>22</option>");
        pw.print("   <option value=23>23</option>");
        pw.print("</select>:<input type=text name=petMinute id=\"petMinute\" size=2 maxlength=2>&nbsp;");
        pw.print("<iman:calendar onLoadCallback=\"getExpTime\" name=\"expTimeWidget\" returnCallback=\"returnExpTime\"/>");
        pw.print("<button type=\"button\" id=\"timeIn100NanoSecondsInterval\" onclick=\"shootAjaxQuery()\">Apply</button>");
        pw.print("</div>");
        pw.print("</td>");
        pw.print("</TR>");
    }

    @Override
    public void printUiCode(PrintWriter pw, String indent, int i) {
        Properties attributes = new Properties();
        attributes.put("name", "_" + this.context.getEncodedAttributeName());
        String syntaxName = this.context.getSyntaxName();
        String regExp = this.getParameterValue("regularExpression");
        if (regExp != null && regExp.length() > 0) {
            attributes.put("regExpression", regExp);
            attributes.put("regExpressionMsg", this.getParameterValue("regularExpressionErrorMsg"));
        } else {
            attributes.put("regExpression", ".*");
            attributes.put("regExpressionMsg", "Error! Invalid characters used");
        }
        if (this.context.isForceReadOnly()) {
            attributes.put("readonly", "true");
        } else {
            String upperbound = this.getParameterValue("upperbound");
            String lowerbound = this.getParameterValue("lowerbound");
            if (this.context.isSized()) {
                if (upperbound == null || upperbound.length() == 0) {
                    upperbound = "" + this.context.getUpperBound();
                }
                if (lowerbound == null || lowerbound.length() == 0) {
                    lowerbound = "" + this.context.getLowerBound();
                }
            }
            if (upperbound != null || lowerbound != null) {
                if (upperbound == null) {
                    upperbound = "999999";
                }
                if (lowerbound == null) {
                    lowerbound = "-999999";
                }
                if (syntaxName.equals("Counter") || syntaxName.equals("Integer") || syntaxName.equals("Interval") || syntaxName.equals("LDAP:Counter") || syntaxName.equals("LDAP:Integer")) {
                    attributes.put("numbersOnly", "true");
                    attributes.put("lowerBound", "" + lowerbound);
                    attributes.put("upperBound", "" + upperbound);
                } else {
                    attributes.put("minLength", "" + lowerbound);
                    attributes.put("maxLength", "" + upperbound);
                }
            }
            if (syntaxName.equals("Case Ignore String") || syntaxName.equals("LDAP:Case Ignore String")) {
                attributes.put("ignoreCase", "true");
            } else if (syntaxName.equals("Distinguished Name") || syntaxName.equals("LDAP:DN")) {
                String typeFilter = this.m_typeFilter;
                if (typeFilter == null) {
                    typeFilter = this.getParameterValue("objectTypeFilter");
                }
                if (typeFilter == null) {
                    attributes.put("objectTypeName", "*");
                } else {
                    attributes.put("objectTypeName", typeFilter);
                }
            } else if (syntaxName.equals("Octet String") || syntaxName.equals("LDAP:Octet String")) {
                attributes.put("hex", "true");
            }
            attributes.put("enforceUnique", "true");
            attributes.put("readonly", "${!" + this.context.geteDasRights() + "}");
        }
        String inputFieldSize = this.getParameterValue("fieldSize");
        if (inputFieldSize != null) {
            attributes.put("width", inputFieldSize);
        }
        pw.println(indent + "<x:set var=\"MVStringEditor_xmlNodeSet\" select=\"" + this.context.getxPathSet() + "\" scope=\"request\"/>");
        if (syntaxName.equals("Case Ignore List") && !this.context.isSingleValued()) {
            pw.println(indent + "<jsp:include page=\"/portal/modules/fw/skins/default/devices/default/MVCIListEditor.jsp\">");
            pw.println(indent + "<jsp:param name=\"attributeName" + i + "\" value=\"" + this.context.getAttributeName() + "\" />");
            pw.println(indent + "</jsp:include>");
        } else {
            pw.print(indent + "<iman:mved");
            Enumeration<Object> myenum = attributes.keys();
            while (myenum.hasMoreElements()) {
                String key = (String)myenum.nextElement();
                pw.print(" " + key + "=\"" + attributes.getProperty(key) + "\"");
            }
            pw.println(indent + "/>");
        }
    }

    @Override
    public void printScript(PrintWriter pw, String indent) {
        super.printScript(pw, indent);
        if (this.context.getSyntaxName().equals("Integer 64")) {
            pw.println(indent + "<SCRIPT>");
            pw.println(" /*callback function for calendar widget*/");
            pw.println("  function getExpTime()");
            pw.println(" {");
            pw.println("var form = document.form;");
            pw.println("    return new Date();");
            pw.println("}");
            pw.println("/*callback function for calendar widget*/  ");
            pw.println("function returnExpTime(date)");
            pw.println(" {");
            pw.println("      var form = document.form;");
            pw.println("form.petDay.value = date.getDate();");
            pw.println("form.petMonth.options[date.getMonth()+1].selected = true;");
            pw.println("form.petYear.value = date.getFullYear();");
            pw.println("form.petHour.options[date.getHours()].selected = true;");
            pw.println("form.petMinute.value = date.getMinutes();");
            pw.println("if(form.petMinute.value.length == 1)");
            pw.println("      {");
            pw.println("form.petMinute.value = \"0\"+form.petMinute.value;");
            pw.println("      }");
            pw.println("}");
            pw.println("function onPerform(xyz)");
            pw.println("{");
            pw.println("var chckObj = document.getElementById('isDateId');");
            pw.println("\t  if(chckObj.checked)");
            pw.println("\t  {");
            pw.println("var attrName=document.getElementById('hiddenAttributeName').value.trim();");
            pw.println("var intValue=parseInt(document.getElementById(attrName).value.trim());");
            pw.println("\t\tif(intValue>9223372036854775808 || intValue< -9223372036854775808 || isNaN(intValue))");
            pw.println("\t\t  {");
            pw.println("alert(\"Please enter a number in the range -9223372036854775807 to 9223372036854775807\");");
            pw.println("hiddenAttributeName.focus();");
            pw.println("return false;");
            pw.println("\t\t  }\t");
            pw.println("populateDateAndTimeFields();");
            pw.println("document.getElementById(attrName).disabled=true;");
            pw.println("document.getElementById('integer64InterpretorId').style.visibility='visible';");
            pw.println("\t  }");
            pw.println("\telse{");
            pw.println("var attrName=document.getElementById('hiddenAttributeName').value.trim();");
            pw.println("document.getElementById('integer64InterpretorId').style.visibility='hidden';");
            pw.println("document.getElementById(attrName).disabled=false;");
            pw.println("\t\t}");
            pw.println("}");
            pw.println("function populateDateAndTimeFields(){");
            pw.println("var xmlhttp;");
            pw.println("if (window.XMLHttpRequest)");
            pw.println("{");
            pw.println("// code for IE7+, Firefox, Chrome, Opera, Safari");
            pw.println("xmlhttp=new XMLHttpRequest();");
            pw.println("\t\t}");
            pw.println("else");
            pw.println("{\t       // code for IE6, IE5");
            pw.println("xmlhttp=new ActiveXObject(\"Microsoft.XMLHTTP\");");
            pw.println("\t }");
            pw.println("xmlhttp.onreadystatechange=function()");
            pw.println(" {");
            pw.println("if (xmlhttp.readyState==4 && xmlhttp.status==200)");
            pw.println("{");
            pw.println("var responseFromServer=xmlhttp.responseText;");
            pw.println(" if(responseFromServer!='')");
            pw.println("\t\t     {");
            pw.println("var arrayValues=responseFromServer.split(\":\");");
            pw.println("document.getElementById('petDay').value=arrayValues[0];");
            pw.println("document.getElementById('petMonth').value=arrayValues[1];");
            pw.println("document.getElementById('petYear').value=arrayValues[2];");
            pw.println("document.getElementById('petHour').value=arrayValues[3];");
            pw.println("document.getElementById('petMinute').value=arrayValues[4];");
            pw.println("}");
            pw.println(" }");
            pw.println("}");
            pw.println(" var attrName=document.getElementById('hiddenAttributeName').value.trim();");
            pw.println("var intger64TextBoxValue=document.getElementById(attrName).value;");
            pw.println("\txmlhttp.open(\"GET\",\"integer64validator?int64Value=\"+intger64TextBoxValue+\"&populateDateAndTime=TRUE\",true)");
            pw.println("\txmlhttp.send();");
            pw.println("}");
            pw.println("function shootAjaxQuery(){");
            pw.println("var petDayValue=parseInt(document.getElementById('petDay').value.trim());");
            pw.println("if( isNaN(document.getElementById('petDay').value)|| petDayValue<0 || petDayValue>31)");
            pw.println("{");
            pw.println("alert(\"Invalid date\");");
            pw.println("petDay.focus();");
            pw.println("return false;");
            pw.println("\t\t} ");
            pw.println("if( isNaN(document.getElementById('petYear').value))");
            pw.println("\t{");
            pw.println("alert(\"Invalid year\");");
            pw.println("petYear.focus();");
            pw.println("return false;");
            pw.println("}");
            pw.println("var petMinValue=parseInt(document.getElementById('petMinute').value.trim());");
            pw.println("if( isNaN(document.getElementById('petMinute').value)||petMinValue>60 || petMinValue<0)");
            pw.println("\t{");
            pw.println("alert(\"Invalid Minute\");");
            pw.println("petMinute.focus();");
            pw.println("return false;");
            pw.println("\t\t} ");
            pw.println("var varPetDay=document.getElementById('petDay').value;");
            pw.println("var varPetMonth=document.getElementById('petMonth').value;");
            pw.println("var varPetYear=document.getElementById('petYear').value;");
            pw.println("var varPetHour=document.getElementById('petHour').value;");
            pw.println("var varPetMinute=document.getElementById('petMinute').value;");
            pw.println("var finalValue= varPetDay.concat(\":\",varPetMonth,\":\",varPetYear,\":\",varPetHour,\":\",varPetMinute);");
            pw.println("\t\tvar xmlhttp;");
            pw.println("if (window.XMLHttpRequest)");
            pw.println("{");
            pw.println("// code for IE7+, Firefox, Chrome, Opera, Safari");
            pw.println("xmlhttp=new XMLHttpRequest();");
            pw.println("}");
            pw.println("else");
            pw.println("{\t       // code for IE6, IE5");
            pw.println("\t  xmlhttp=new ActiveXObject(\"Microsoft.XMLHTTP\");");
            pw.println("\t\t }");
            pw.println("    \t\t\txmlhttp.onreadystatechange=function()");
            pw.println("{");
            pw.println("if (xmlhttp.readyState==4 && xmlhttp.status==200)");
            pw.println("{");
            pw.println(" var attrName=document.getElementById('hiddenAttributeName').value.trim();");
            pw.println("var selectedIndex=document.getElementById(attrName).selectedIndex;");
            pw.println("var responseFromServer=xmlhttp.responseText;");
            pw.println("responseFromServer=responseFromServer.trim();");
            pw.println("var mvse=window.mv_" + this.context.getEncodedAttributeName() + ";");
            pw.println("var i = mvse.m_sel.selectedIndex;");
            pw.println("mvse.m_sel[mvse.m_sel.selectedIndex] = new Option(responseFromServer,responseFromServer);");
            pw.println("mvse.m_sel.selectedIndex = i; ");
            pw.println("mvse.m_isEditing = false;");
            pw.println("mvselOnChange(mvse); ");
            pw.println("}");
            pw.println(" }");
            pw.println("xmlhttp.open(\"GET\",\"integer64validator?dateAndTimeValue=\"+finalValue,true);");
            pw.println("xmlhttp.send();");
            pw.println("\t}");
            pw.println("/*callback function for calendar widget*/  ");
            pw.println("function returnExpTimeForCreate(date)");
            pw.println(" {");
            pw.println("var varPetDay=date.getDate().toString();");
            pw.println("var varPetMonth=date.getMonth().toString();");
            pw.println("var varPetYear=date.getFullYear().toString();");
            pw.println("var varPetHour=date.getHours().toString();");
            pw.println("var varPetMinute=date.getMinutes().toString();");
            pw.println("var finalValue= varPetDay.concat(\":\",varPetMonth,\":\",varPetYear,\":\",varPetHour,\":\",varPetMinute);");
            pw.println("\t\tvar xmlhttp;");
            pw.println("if (window.XMLHttpRequest)");
            pw.println("{");
            pw.println("// code for IE7+, Firefox, Chrome, Opera, Safari");
            pw.println("xmlhttp=new XMLHttpRequest();");
            pw.println("}");
            pw.println("else");
            pw.println("{\t       // code for IE6, IE5");
            pw.println("\t  xmlhttp=new ActiveXObject(\"Microsoft.XMLHTTP\");");
            pw.println("\t\t }");
            pw.println("    \t\t\txmlhttp.onreadystatechange=function()");
            pw.println("{");
            pw.println("if (xmlhttp.readyState==4 && xmlhttp.status==200)");
            pw.println("{");
            pw.println(" var attrName=document.getElementById('hiddenAttributeName').value.trim();");
            pw.println("var selectedIndex=document.getElementById(attrName).selectedIndex;");
            pw.println("var responseFromServer=xmlhttp.responseText;");
            pw.println("responseFromServer=responseFromServer.trim();");
            pw.println("mvselAdd(window.mv_" + this.context.getEncodedAttributeName() + ",responseFromServer);");
            pw.println("}");
            pw.println(" }");
            pw.println("xmlhttp.open(\"GET\",\"integer64validator?dateAndTimeValue=\"+finalValue,true);");
            pw.println("xmlhttp.send();");
            pw.println("\t}");
            pw.println(indent + "</SCRIPT>");
        }
    }

    public void setTypeFilter(String filter) {
        this.m_typeFilter = filter;
    }
}

