/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.util;

import com.novell.emframe.dev.D;
import com.novell.emframe.dev.DataHandler;
import com.novell.emframe.dev.GlobalRegistry;
import com.novell.emframe.dev.Plugin;
import com.novell.emframe.dev.RegistryHandler;
import com.novell.emframe.dev.eMFrameUtils;
import java.util.Hashtable;
import org.jdom.Document;

public class Loader {
    public static Hashtable liveHandlers = new Hashtable();
    public static Hashtable liveRegistryHandlers = new Hashtable();

    public static DataHandler getAttributeHandler(String attributeName, boolean reuse) {
        Document doc = GlobalRegistry.getAttributeHandlerDoc(attributeName);
        if (doc != null) {
            String javaClass = eMFrameUtils.getClassName(doc);
            String id = doc.getRootElement().getChild("id").getTextTrim();
            Object obj = Loader.getInstance(id, javaClass, doc, reuse);
            return (DataHandler)obj;
        }
        return null;
    }

    public static DataHandler getSyntaxHandler(String syntaxName, boolean reuse) {
        Document doc = GlobalRegistry.getSyntaxHandlerDoc(syntaxName);
        if (doc != null) {
            String javaClass = eMFrameUtils.getClassName(doc);
            String id = doc.getRootElement().getChild("id").getTextTrim();
            Object obj = Loader.getInstance(id, javaClass, doc, reuse);
            return (DataHandler)obj;
        }
        return null;
    }

    public static DataHandler getHandlerById(String handlerId, boolean reuse) {
        Document doc = GlobalRegistry.getPluginDocument(handlerId);
        if (doc != null) {
            String javaClass = eMFrameUtils.getClassName(doc);
            String id = doc.getRootElement().getChild("id").getTextTrim();
            Object obj = Loader.getInstance(id, javaClass, doc, reuse);
            return (DataHandler)obj;
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static Object getInstance(String handlerId, String javaClass, Document doc, boolean reuse) {
        Object handler = null;
        Hashtable hashtable = liveHandlers;
        synchronized (hashtable) {
            if (reuse) {
                handler = liveHandlers.get(handlerId);
            }
            if (handler == null) {
                try {
                    Class<?> objClass = Class.forName(javaClass);
                    handler = objClass.newInstance();
                    ((Plugin)handler).init(null, doc);
                    liveHandlers.put(handlerId, handler);
                }
                catch (Throwable t) {
                    D.log(t);
                }
            }
        }
        return handler;
    }

    public static Object getRegistryHandlerInstance(Document doc) {
        RegistryHandler handler = null;
        String javaClass = eMFrameUtils.getClassName(doc);
        String id = doc.getRootElement().getChild("id").getTextTrim();
        handler = (RegistryHandler)liveRegistryHandlers.get(id);
        if (handler != null) {
            D.log("Loader::Using cached handler for " + id);
        }
        if (handler == null) {
            try {
                D.log("Loader::Creating new registry handler for " + id);
                Class<?> objClass = Class.forName(javaClass);
                handler = objClass.newInstance();
                ((Plugin)handler).init(null, doc);
                liveRegistryHandlers.put(id, handler);
            }
            catch (Throwable t) {
                D.log(t);
            }
        }
        return handler;
    }
}

