/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.util;

import com.novell.emframe.fw.util.TarException;
import java.io.File;

public class TarEntry {
    static final int TARHDR = 512;
    static final int TARNAM = 0;
    static final int TARMOD = 100;
    static final int TAROWN = 108;
    static final int TARGRP = 116;
    static final int TARSIZ = 124;
    static final int TARTIM = 136;
    static final int TARCRC = 148;
    static final int TARLNK = 156;
    static final int TARLNM = 157;
    static final int USTTYP = 156;
    static final int USTIND = 257;
    static final int USTVER = 263;
    static final int USTOWN = 265;
    static final int USTGRP = 297;
    static final int USTDMJ = 329;
    static final int USTDMI = 337;
    static final int USTPRE = 345;
    static final String USTPMA = "ustar";
    static final String USTGMA = "ustar  ";
    private byte[] header;
    private String name;
    private int mode;
    private int uid;
    private int gid;
    private long size;
    private long mtime;
    private int chksum;
    private byte typeflag;
    private String linkname;
    private String magic;
    private boolean ustar = false;
    private int version;
    private String uname;
    private String gname;
    private int devmajor;
    private int devminor;

    private String parseName(int offset, int length) {
        String name = "";
        while (this.header[offset] != 0 && name.length() < length) {
            name = name + (char)this.header[offset++];
        }
        return name;
    }

    private String parseFileName() {
        String prefix = this.parseName(345, 155);
        if (prefix.length() > 0) {
            prefix = prefix + File.separator;
        }
        String name = prefix + this.parseName(0, 100);
        return name;
    }

    public TarEntry(byte[] header) throws TarException {
        this.header = header;
        this.name = this.parseFileName();
        this.size = Long.valueOf(new String(header, 124, 11), 8);
    }

    public TarEntry(TarEntry e) {
    }

    public int getChecksum() {
        return this.chksum;
    }

    public void setChecksum(int chksum) {
        this.chksum = chksum;
    }

    public int getDevmajor() {
        return this.devmajor;
    }

    public void setDevmajor(int devmajor) {
        this.devmajor = devmajor;
    }

    public int getDevminor() {
        return this.devminor;
    }

    public void setDevminor(int devminor) {
        this.devminor = devminor;
    }

    public int getGid() {
        return this.gid;
    }

    public void setGid(int gid) {
        this.gid = gid;
    }

    public String getGname() {
        return this.gname;
    }

    public void setGname(String gname) {
        this.gname = gname;
    }

    public String getLinkname() {
        return this.linkname;
    }

    public void setLinkname(String linkname) {
        this.linkname = linkname;
    }

    public String getMagic() {
        return this.magic;
    }

    public void setMagic(String magic) {
        this.magic = magic;
    }

    public int getMode() {
        return this.mode;
    }

    public void setMode(int mode) {
        this.mode = mode;
    }

    public long getMtime() {
        return this.mtime;
    }

    public void setMtime(long mtime) {
        this.mtime = mtime;
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public long getSize() {
        return this.size;
    }

    public long getBlocks() {
        long blocks = this.size / 512L + (long)(this.size % 512L > 0L ? 1 : 0);
        return blocks;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public byte getTypeflag() {
        return this.typeflag;
    }

    public void setTypeflag(byte typeflag) {
        this.typeflag = typeflag;
    }

    public int getUid() {
        return this.uid;
    }

    public void setUid(int uid) {
        this.uid = uid;
    }

    public String getUname() {
        return this.uname;
    }

    public void setUname(String uname) {
        this.uname = uname;
    }

    public int getVersion() {
        return this.version;
    }

    public void setVersion(int version) {
        this.version = version;
    }
}

