/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.util;

import com.novell.emframe.dev.D;
import java.awt.AWTEvent;
import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Graphics;
import java.awt.PrintJob;
import java.awt.Rectangle;
import java.awt.SystemColor;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.OutputStream;
import java.io.PrintStream;
import javax.swing.JButton;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextArea;
import javax.swing.JTextField;

public class WindowOut {
    static WindowOutTraceWindow window;

    public static void init() {
        if (window == null) {
            window = new WindowOutTraceWindow();
            window.setVisible(true);
            WindowPrintStream stream = new WindowPrintStream(new WindowOutputStream());
            System.setOut(stream);
            System.setErr(stream);
        }
    }

    public static void destroy() {
        if (window != null) {
            window.dispose();
            window = null;
        }
    }

    public static void write(String s) {
        WindowOutTraceWindow.write(s);
    }

    public static void writeNoReturn(String s) {
        WindowOutTraceWindow.writeNoReturn(s);
    }

    static class WindowOutputStream
    extends OutputStream {
        WindowOutputStream() {
        }

        @Override
        public void write(int b) {
            byte c = (byte)b;
            byte[] cs = new byte[]{c};
            WindowOutTraceWindow.writeNoReturn(new String(cs));
        }

        @Override
        public void write(byte[] bytes) {
            WindowOutTraceWindow.writeNoReturn(new String(bytes));
        }
    }

    static class WindowPrintStream
    extends PrintStream {
        public WindowPrintStream(OutputStream out) {
            super(out);
        }

        public void w(String s) {
            WindowOutTraceWindow.writeNoReturn(s);
        }

        public void wr(String s) {
            WindowOutTraceWindow.write(s);
        }

        @Override
        public void write(int b) {
            byte c = (byte)b;
            byte[] cs = new byte[]{c};
            this.w(new String(cs));
        }

        @Override
        public void write(byte[] buf) {
            this.w(new String(buf));
        }

        @Override
        public void print(boolean b) {
            this.w(String.valueOf(b));
        }

        @Override
        public void print(char c) {
            this.w(String.valueOf(c));
        }

        @Override
        public void print(int i) {
            this.w(String.valueOf(i));
        }

        @Override
        public void print(float f) {
            this.w(String.valueOf(f));
        }

        @Override
        public void print(double d) {
            this.w(String.valueOf(d));
        }

        @Override
        public void print(char[] s) {
            this.w(String.valueOf(s));
        }

        @Override
        public void print(String s) {
            this.w(String.valueOf(s));
        }

        @Override
        public void print(Object obj) {
            this.w(obj.toString());
        }

        @Override
        public void println() {
            this.wr("");
        }

        @Override
        public void println(boolean x) {
            this.wr(String.valueOf(x));
        }

        @Override
        public void println(char x) {
            this.wr(String.valueOf(x));
        }

        @Override
        public void println(int x) {
            this.wr(String.valueOf(x));
        }

        @Override
        public void println(long x) {
            this.wr(String.valueOf(x));
        }

        @Override
        public void println(float x) {
            this.wr(String.valueOf(x));
        }

        @Override
        public void println(double x) {
            this.wr(String.valueOf(x));
        }

        @Override
        public void println(char[] x) {
            this.wr(String.valueOf(x));
        }

        @Override
        public void println(String x) {
            this.wr(String.valueOf(x));
        }

        @Override
        public void println(Object x) {
            this.wr(x.toString());
        }
    }

    static class WindowOutTraceWindow
    extends JFrame {
        private static final long serialVersionUID = 1L;
        private static JTextArea text = new JTextArea(10, 10);
        private int windowPosX = -1;
        private int windowPosY = -1;

        public WindowOutTraceWindow() {
            super("Output");
            JButton printButton = new JButton("Print...");
            JButton saveButton = new JButton("Save");
            JButton clearButton = new JButton("Clear");
            JButton findButton = new JButton("Find");
            final JTextField findText = new JTextField(10);
            JButton closeButton = new JButton("Close");
            JLabel findLabel = new JLabel("Find:");
            JPanel buttonPanel = new JPanel();
            buttonPanel.setBackground(SystemColor.control);
            buttonPanel.add(findLabel);
            buttonPanel.add(findText);
            buttonPanel.add(findButton);
            buttonPanel.add(saveButton);
            buttonPanel.add(clearButton);
            buttonPanel.add(printButton);
            buttonPanel.add(closeButton);
            this.getContentPane().setLayout(new BorderLayout());
            this.getContentPane().add("Center", new JScrollPane(text));
            this.getContentPane().add("South", buttonPanel);
            this.setSize(500, 300);
            this.setFont(new Font("Dialog", 0, 12));
            this.enableEvents(64L);
            findButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    int pos;
                    String t;
                    int index;
                    String toFind = findText.getText();
                    if (toFind != null && toFind.length() > 0 && (index = (t = text.getText()).indexOf(toFind, pos = text.getCaretPosition())) != -1) {
                        text.select(index, index + toFind.length());
                    }
                }
            });
            clearButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    text.setText("");
                }
            });
            saveButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    String startDir = "/";
                    JFileChooser fileChooser = new JFileChooser(startDir);
                    int retVal = fileChooser.showSaveDialog(WindowOutTraceWindow.this);
                    if (retVal == 0) {
                        File file = fileChooser.getSelectedFile();
                        if (file == null) {
                            D.log("File returned is null");
                        } else {
                            try {
                                FileWriter out = new FileWriter(file);
                                out.write(text.getText());
                                out.close();
                            }
                            catch (IOException ex) {
                                D.log("Could not write file " + file.getName());
                            }
                        }
                    }
                }
            });
            closeButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    WindowOutTraceWindow.this.dispose();
                    window = null;
                }
            });
            printButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent e) {
                    PrintJob pjob = WindowOutTraceWindow.this.getToolkit().getPrintJob(WindowOutTraceWindow.this, "Debug", null);
                    Dimension pageSize = pjob.getPageDimension();
                    pageSize.height += 200;
                    Graphics pg = pjob.getGraphics();
                    String buffer = text.getText();
                    String line = "";
                    Font font = new Font("Dialog", 0, 18);
                    Font numFont = new Font("Dialog", 1, 18);
                    FontMetrics metrics = WindowOutTraceWindow.this.getFontMetrics(font);
                    int maxDescent = metrics.getMaxDescent();
                    int lineHeight = metrics.getHeight();
                    int begLineIndex = 0;
                    int endLineIndex = 0;
                    int y = 0;
                    int pageNo = 1;
                    int topMargin = 100;
                    int margin = 25;
                    int lineThickness = 5;
                    if (pg != null) {
                        pg.setFont(font);
                        endLineIndex = buffer.indexOf("\n", begLineIndex);
                        while (endLineIndex != -1) {
                            if ((y += lineHeight) + lineHeight > pageSize.height) {
                                pg.setFont(numFont);
                                pg.drawLine(margin, pageSize.height + lineHeight + topMargin - lineThickness, pageSize.width - margin + 300, pageSize.height + lineHeight + topMargin);
                                pg.drawString("Page: " + pageNo, margin, pageSize.height + lineHeight * 2 + topMargin);
                                pg.setFont(font);
                                pg.dispose();
                                pg = pjob.getGraphics();
                                pg.setFont(font);
                                y = 0;
                                ++pageNo;
                            }
                            line = buffer.substring(begLineIndex, endLineIndex);
                            begLineIndex = endLineIndex + 1;
                            line = line.replace('\t', ' ');
                            line = line.replace('\r', ' ');
                            line = line.replace('\n', ' ');
                            pg.drawString(line, margin, y - maxDescent + topMargin);
                            endLineIndex = buffer.indexOf("\n", begLineIndex);
                        }
                        pg.setFont(numFont);
                        pg.drawLine(margin, pageSize.height + lineHeight + topMargin - lineThickness, pageSize.width - margin + 300, pageSize.height + lineHeight + topMargin);
                        pg.drawString("Page: " + pageNo, margin, pageSize.height + lineHeight * 2 + topMargin);
                        pg.dispose();
                        pjob.end();
                    }
                }
            });
        }

        public static void write(String outString) {
            text.append(outString + "\n");
            text.scrollRectToVisible(new Rectangle(0, text.getHeight() - 1, 1, text.getHeight()));
        }

        public static void writeNoReturn(String outString) {
            text.append(outString);
            text.scrollRectToVisible(new Rectangle(0, text.getHeight() - 1, 1, text.getHeight()));
        }

        @Override
        protected void processEvent(AWTEvent event) {
            if (event.getID() == 201) {
                this.dispose();
                window = null;
            }
            super.processEvent(event);
        }

        @Override
        public void setVisible(boolean visible) {
            super.setVisible(visible);
            this.setLocation(20, 20);
        }
    }
}

