/*
 * Decompiled with CFR 0.152.
 */
package com.novell.emframe.fw.util;

import com.novell.admin.ns.AdminNamespace;
import com.novell.application.console.snapin.ObjectEntry;
import com.novell.emframe.dev.TaskContext;
import com.novell.emframe.fw.RBSUtil;
import com.novell.emframe.fw.iManager;
import com.novell.emframe.fw.util.RBSObjectInstaller;
import com.novell.emframe.fw.xmlinfos.ModuleClassObject;
import com.novell.emframe.fw.xmlinfos.XMLFileReader;
import com.novell.rbs.RBSAssociation;
import com.novell.rbs.RBSObjectCreator;
import com.novell.rbs.RBSRole;
import com.novell.rbs.RBSSchemaVerifier;
import org.jdom.Document;

public class eMFrameComponentInstall {
    private AdminNamespace m_ns;
    private ObjectEntry treeOE;
    private TaskContext context = null;

    public eMFrameComponentInstall(ObjectEntry tOE, TaskContext cntxt) {
        this.treeOE = tOE;
        this.context = cntxt;
        this.m_ns = this.treeOE.getAdminNamespace();
    }

    public void extendSchema() throws Exception {
        RBSSchemaVerifier rbsVerifier = new RBSSchemaVerifier(this.treeOE);
        if (!rbsVerifier.isSchemaValid()) {
            rbsVerifier.extendSchema();
        }
    }

    public void createRBSCollection(String collectionContext, String collectionName, String versionNumber) throws Exception {
        RBSObjectCreator createObject = new RBSObjectCreator(this.treeOE);
        createObject.createRBSCollection(collectionContext, collectionName, versionNumber);
        try {
            this.context.addToHistory(this.m_ns.getObjectEntry(RBSUtil.concatStr(this.m_ns, collectionName, collectionContext)));
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void installPlugin(String rbsCollectionContext, String[] absoluteFilePaths, Document doc, String dynamicGroupSearchType) throws Exception {
        this.installPlugin(rbsCollectionContext, absoluteFilePaths, dynamicGroupSearchType, doc, false);
    }

    public void installPlugin(String rbsCollectionContext, String[] absoluteFilePaths, String dynamicGroupSearchType, Document doc, boolean reinstallModule) throws Exception {
        String authName = "eDir";
        if (this.m_ns.isSupported("NVDS")) {
            authName = "NVDS";
        }
        if (absoluteFilePaths != null) {
            for (int i = 0; i < absoluteFilePaths.length; ++i) {
                ModuleClassObject moduleClassObject = null;
                XMLFileReader xmlFileReader = new XMLFileReader(this.m_ns);
                moduleClassObject = xmlFileReader.readFile(absoluteFilePaths[i], authName);
                RBSObjectInstaller installer = new RBSObjectInstaller(this.treeOE, moduleClassObject);
                installer.install(rbsCollectionContext, dynamicGroupSearchType, reinstallModule);
            }
        }
        if (doc != null) {
            ModuleClassObject moduleClassObject = null;
            XMLFileReader xmlFileReader = new XMLFileReader(this.m_ns);
            moduleClassObject = xmlFileReader.readFile(doc, authName);
            RBSObjectInstaller installer = new RBSObjectInstaller(this.treeOE, moduleClassObject);
            installer.install(rbsCollectionContext, dynamicGroupSearchType, reinstallModule);
        }
    }

    public String associateMemeberWithRoles(ObjectEntry memberOE, RBSRole[] rbsRoles, ObjectEntry scopeOE, boolean isInheritable, boolean setRights, String dynamicGroupSearchType) {
        String strException = null;
        boolean thisEnabled = iManager.isThisEnabled();
        try {
            for (int i = 0; i < rbsRoles.length; ++i) {
                ObjectEntry roleOE = rbsRoles[i].getObjectEntry();
                boolean selfProvisioning = com.novell.rbs.RBSUtil.getSelfProvisioningFromParameters((ObjectEntry)roleOE, null);
                if (selfProvisioning && (!thisEnabled || !memberOE.getObjectType().isContainer())) continue;
                RBSAssociation rbsAssociation = new RBSAssociation(memberOE, rbsRoles[i], scopeOE, -1L, Boolean.toString(isInheritable), setRights);
                rbsRoles[i].addMembers(new RBSAssociation[]{rbsAssociation}, dynamicGroupSearchType);
                rbsRoles[i].update();
            }
        }
        catch (Exception e) {
            strException = e.toString();
        }
        return strException;
    }
}

